/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authentication.helper;

import com.sas.net.crypto.SealedString;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public class PasswordBasedEncryptor
implements InitializingBean {
    private static final String DEFAULT_KEY_DERIVATION_ALGORITHM = "PBKDF2WithHmacSHA256";
    private static final Integer DEFAULT_KEY_DERIVATION_ITERATIONS = 10000;
    private static final String DEFAULT_CIPHER_TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final Integer DEFAULT_KEY_SIZE = 128;
    private static final Integer DEFAULT_INITIALIZATION_VECTOR_SIZE = 16;
    private static final String ENCRYPTION_ALGORITHM_AES = "AES";
    private static final int SAS_PBE_SIZE = 16;
    private static final byte[] SAS_PBE_V1 = new byte[]{-71, -80, 22, -67, 17, -4, -85, -23, 101, -17, 75, -49, -114, 64, -1, -82};
    private SealedString _password;
    private String _salt;
    private String _cipherTransformation;
    private String _prngAlgorithm;
    private String _keyDerivationAlgorithm;
    private Integer _iterationCount;
    private Integer _keySize;
    private Integer _initializationVectorSize;
    private SecureRandom _prng;
    private Key _key;

    public void setPassword(String password) {
        this._password = StringUtils.hasLength((String)password) ? new SealedString(password) : null;
    }

    public String getPassword() {
        return this._password != null ? this._password.toString() : null;
    }

    public void setPasswordAsChars(char[] password) {
        this._password = StringUtils.hasLength((CharSequence)CharBuffer.wrap(password)) ? new SealedString(password) : null;
    }

    public char[] getPasswordAsChars() {
        return this._password != null ? this._password.getCharacters() : null;
    }

    public void setSalt(String salt) {
        this._salt = salt;
    }

    public String getSalt() {
        return this._salt;
    }

    public void setRandomNumberGeneratorAlgorithm(String prgnAlgorithm) {
        this._prngAlgorithm = prgnAlgorithm;
    }

    public String getRandomNumberGeneratorAlgorithm() {
        return this._prngAlgorithm;
    }

    public void setKeyDerivationAlgorithm(String keyDerivationAlgorithm) {
        this._keyDerivationAlgorithm = keyDerivationAlgorithm;
    }

    public String getKeyDerivationAlgorithm() {
        return this._keyDerivationAlgorithm;
    }

    public void setIterationCount(int iterationCount) {
        this._iterationCount = iterationCount;
    }

    public int getIterationCount() {
        return this._iterationCount != null ? this._iterationCount : 0;
    }

    public void setKeySize(int keySize) {
        this._keySize = keySize;
    }

    public int getKeySize() {
        return this._keySize != null ? this._keySize : 0;
    }

    public void setCipherTransformation(String cipherTransformation) {
        this._cipherTransformation = cipherTransformation;
    }

    public String getCipherTransformation() {
        return this._cipherTransformation;
    }

    public void setInitializationVectorSize(int initializationVectorSize) {
        this._initializationVectorSize = initializationVectorSize;
    }

    public int getInitializationVectorySize() {
        return this._initializationVectorSize != null ? this._initializationVectorSize : 0;
    }

    public void afterPropertiesSet() throws Exception {
        if (this._prng == null) {
            this._prng = this.getRandomNumberGenerator();
        }
        if (this._key == null) {
            this._key = this.deriveKey();
        }
    }

    public byte[] encrypt(byte[] clearText) throws GeneralSecurityException {
        return this.encrypt(clearText, 0, clearText.length);
    }

    public byte[] encrypt(byte[] clearText, int offset, int length) throws GeneralSecurityException {
        if (this._prng == null || this._key == null) {
            throw new IllegalStateException("afterPropertiesSet() must be called before encrypt().");
        }
        String transformation = this.getCipherTransformationInternal();
        Cipher cipher = Cipher.getInstance(transformation);
        int ivSize = this.getInitializationVectorSizeInternal();
        byte[] ivBytes = this.getRandomBytes(ivSize);
        IvParameterSpec parameter = new IvParameterSpec(ivBytes);
        cipher.init(1, this._key, parameter);
        byte[] cipherText = cipher.doFinal(clearText, offset, length);
        int cipherTextLength = cipherText != null ? cipherText.length : 0;
        byte[] ivAndCipherText = new byte[16 + ivSize + cipherTextLength];
        System.arraycopy(SAS_PBE_V1, 0, ivAndCipherText, 0, 16);
        System.arraycopy(ivBytes, 0, ivAndCipherText, 16, ivSize);
        if (cipherTextLength > 0) {
            System.arraycopy(cipherText, 0, ivAndCipherText, 16 + ivSize, cipherTextLength);
        }
        return ivAndCipherText;
    }

    public byte[] decrypt(byte[] cipherText) throws GeneralSecurityException {
        return this.decrypt(cipherText, 0, cipherText.length);
    }

    public byte[] decrypt(byte[] cipherText, int offset, int length) throws GeneralSecurityException {
        if (this._prng == null || this._key == null) {
            throw new IllegalStateException("afterPropertiesSet() must be called before decrypt().");
        }
        int ivSize = this.getInitializationVectorSizeInternal();
        if (length < ivSize + 16) {
            throw new IllegalArgumentException("The cipher text is not long enough.");
        }
        byte[] pbe = new byte[16];
        System.arraycopy(cipherText, offset, pbe, 0, 16);
        if (!Arrays.equals(SAS_PBE_V1, pbe)) {
            throw new IllegalArgumentException("The cipher text is invalid or was encrypted with an unsupported encryptor version.");
        }
        String transformation = this.getCipherTransformationInternal();
        Cipher cipher = Cipher.getInstance(transformation);
        IvParameterSpec parameter = new IvParameterSpec(cipherText, offset + 16, ivSize);
        cipher.init(2, this._key, parameter);
        return cipher.doFinal(cipherText, offset + 16 + ivSize, length - 16 - ivSize);
    }

    private SecureRandom getRandomNumberGenerator() throws NoSuchAlgorithmException {
        String prngAlgorithm = this.getRandomNumberGeneratorAlgorithmInternal();
        return prngAlgorithm != null ? SecureRandom.getInstance(prngAlgorithm) : new SecureRandom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Key deriveKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (this._password == null) {
            throw new IllegalArgumentException("the key derivation password must not be null or empty");
        }
        char[] passwordChars = this._password.getCharacters();
        try {
            byte[] saltBytes = this._salt != null ? this._salt.getBytes(StandardCharsets.UTF_8) : PasswordBasedEncryptor.getBytes(passwordChars);
            int interationCount = this.getIterationCountInternal();
            int keySize = this.getKeySizeInternal();
            String keyDerivationAlgorithm = this.getKeyDerivationAlgorithmInternal();
            PBEKeySpec pbeKeySpec = new PBEKeySpec(passwordChars, saltBytes, interationCount, keySize);
            SecretKey derivedKey = SecretKeyFactory.getInstance(keyDerivationAlgorithm).generateSecret(pbeKeySpec);
            byte[] derivedKeyMaterial = derivedKey.getEncoded();
            SecretKeySpec secretKeySpec = new SecretKeySpec(derivedKeyMaterial, ENCRYPTION_ALGORITHM_AES);
            return secretKeySpec;
        }
        finally {
            Arrays.fill(passwordChars, '\u0000');
        }
    }

    private byte[] getRandomBytes(int count) {
        byte[] bytes = new byte[count];
        this._prng.nextBytes(bytes);
        return bytes;
    }

    private int getIterationCountInternal() {
        if (this._iterationCount == null) {
            String key = PasswordBasedEncryptor.class.getName() + ".keyDerivationIterations";
            return Integer.parseInt(System.getProperty(key, DEFAULT_KEY_DERIVATION_ITERATIONS.toString()));
        }
        return this._iterationCount;
    }

    private int getKeySizeInternal() {
        if (this._keySize == null) {
            String key = PasswordBasedEncryptor.class.getName() + ".keySize";
            return Integer.parseInt(System.getProperty(key, DEFAULT_KEY_SIZE.toString()));
        }
        return this._keySize;
    }

    private int getInitializationVectorSizeInternal() {
        if (this._initializationVectorSize == null) {
            String key = PasswordBasedEncryptor.class.getName() + ".initializationVectorSize";
            return Integer.parseInt(System.getProperty(key, DEFAULT_INITIALIZATION_VECTOR_SIZE.toString()));
        }
        return this._initializationVectorSize;
    }

    private String getRandomNumberGeneratorAlgorithmInternal() {
        if (this._prngAlgorithm == null) {
            String key = PasswordBasedEncryptor.class.getName() + ".prngAlgorithm";
            return System.getProperty(key);
        }
        return this._prngAlgorithm;
    }

    private String getKeyDerivationAlgorithmInternal() {
        if (this._keyDerivationAlgorithm == null) {
            String key = PasswordBasedEncryptor.class.getName() + ".keyDerivationAlgorithm";
            return System.getProperty(key, DEFAULT_KEY_DERIVATION_ALGORITHM);
        }
        return this._keyDerivationAlgorithm;
    }

    private String getCipherTransformationInternal() {
        if (this._cipherTransformation == null) {
            String key = PasswordBasedEncryptor.class.getName() + ".transformation";
            return System.getProperty(key, DEFAULT_CIPHER_TRANSFORMATION);
        }
        return this._cipherTransformation;
    }

    private static byte[] getBytes(char[] chars) {
        ByteBuffer bb = StandardCharsets.UTF_8.encode(CharBuffer.wrap(chars));
        int bbL = bb.remaining();
        byte[] b = new byte[bbL];
        bb.get(b);
        bb.clear();
        bb.put(new byte[bbL]);
        return b;
    }
}

