/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authentication.helper;

import com.sas.svcs.authentication.client.LoginPreservingAuthenticationToken;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.cas.authentication.CasAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class LoginHelper {
    private static final Logger logger = LogManager.getLogger(LoginHelper.class);

    public static String getCurrentLogin() {
        return LoginHelper.getLoginForContext(SecurityContextHolder.getContext());
    }

    public static String getLoginForContext(SecurityContext securityContext) {
        return LoginHelper.getLoginForAuthentication(securityContext.getAuthentication());
    }

    public static String getLoginForAuthentication(Authentication authentication) {
        if (null == authentication) {
            logger.debug("Null authentication, returning null");
            return null;
        }
        String userid = authentication.getName();
        if (authentication instanceof CasAuthenticationToken) {
            logger.debug("Found CasAuthenticationToken for login");
            CasAuthenticationToken token = (CasAuthenticationToken)authentication;
            userid = token.getAssertion().getPrincipal().getName();
        } else if (authentication instanceof LoginPreservingAuthenticationToken) {
            logger.debug("Found LoginPreservingAuthenticationToken for login");
            LoginPreservingAuthenticationToken token = (LoginPreservingAuthenticationToken)authentication;
            userid = token.getLoginId();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Found login '" + userid + "'");
        }
        return userid;
    }
}

