/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.authentication.helper;

import com.sas.framework.commons.holders.SessionHolder;
import com.sas.services.user.SimpleUserIdentity;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.util.Encryption;
import com.sas.svcs.authentication.client.AuthenticationException;
import com.sas.svcs.authentication.helper.CachedCredentials;
import com.sas.svcs.authentication.helper.CredentialCacheManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CredentialCacheManagerImpl
implements CredentialCacheManager {
    private static final Logger logger = LogManager.getLogger(CredentialCacheManagerImpl.class);
    public static final String PRINCIPAL = "principal";
    public static final String CREDENTIAL = "credential";
    public static final String DOMAIN = "domain";
    public static final String PRIMARY = "primary";
    public static final String STICKY = "sticky";
    public static final String RESOLVED_USER = "resolvedUserName";
    private final Map<String, String> credentialCache;

    public static UserIdentityInterface fromMap(Map<String, String> map) {
        String resolvedUsername;
        String primary = map.get(PRIMARY);
        SimpleUserIdentity identity = null;
        identity = null != primary ? new SimpleUserIdentity(map.get(PRINCIPAL), map.get(CREDENTIAL), map.get(DOMAIN), Boolean.parseBoolean(primary)) : new SimpleUserIdentity(map.get(PRINCIPAL), map.get(CREDENTIAL), map.get(DOMAIN));
        String sticky = map.get(STICKY);
        if (null != sticky) {
            identity.setSticky(Boolean.parseBoolean(sticky));
        }
        if (null != (resolvedUsername = map.get(RESOLVED_USER))) {
            identity.setResolvedUserName(resolvedUsername);
        }
        return identity;
    }

    public static Set<UserIdentityInterface> fromMap(Set<Map<String, String>> maps) {
        HashSet<UserIdentityInterface> set = new HashSet<UserIdentityInterface>(maps.size());
        for (Map<String, String> map : maps) {
            set.add(CredentialCacheManagerImpl.fromMap(map));
        }
        return set;
    }

    public static Map<String, String> toMap(UserIdentityInterface uii) {
        HashMap<String, String> map = new HashMap<String, String>(6);
        map.put(PRINCIPAL, uii.getPrincipal().toString());
        map.put(CREDENTIAL, uii.getCredential().toString());
        map.put(DOMAIN, uii.getDomain());
        map.put(PRIMARY, Boolean.toString(uii.isPrimary()));
        map.put(RESOLVED_USER, uii.getResolvedUserName());
        if (uii instanceof SimpleUserIdentity) {
            map.put(STICKY, Boolean.toString(((SimpleUserIdentity)uii).isSticky()));
        }
        return map;
    }

    public static Set<Map<String, String>> toMap(Set<UserIdentityInterface> uiis) {
        HashSet<Map<String, String>> set = new HashSet<Map<String, String>>(uiis.size());
        for (UserIdentityInterface uii : uiis) {
            set.add(CredentialCacheManagerImpl.toMap(uii));
        }
        return set;
    }

    public static Set<Map<String, String>> decrypt(String encrypted) throws IOException {
        String decryptedBytesAsHex = Encryption.decrypt((String)encrypted);
        byte[] bytes = Encryption.convertHexStringToByteArray((String)decryptedBytesAsHex);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object obj = null;
        try {
            obj = ois.readObject();
        }
        catch (ClassNotFoundException e) {
            logger.error("Unexpected error deserializing cached identities", (Throwable)e);
            throw new RuntimeException(e);
        }
        ois.close();
        return (Set)obj;
    }

    public static Set<UserIdentityInterface> fromEncryptedString(String encrypted) throws IOException {
        Set<Map<String, String>> maps = CredentialCacheManagerImpl.decrypt(encrypted);
        return CredentialCacheManagerImpl.fromMap(maps);
    }

    public static String encrypt(Set<Map<String, String>> set) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(set);
        oos.close();
        String encrypted = Encryption.encrypt((String)Encryption.convertByteArrayToHexString((byte[])baos.toByteArray()));
        baos.close();
        return encrypted;
    }

    public static String toEncryptedString(Set<UserIdentityInterface> uiis) throws IOException {
        Set<Map<String, String>> set = CredentialCacheManagerImpl.toMap(uiis);
        return CredentialCacheManagerImpl.encrypt(set);
    }

    public CredentialCacheManagerImpl(Map<String, String> credentialCache) {
        this.credentialCache = credentialCache;
    }

    protected String getUnencryptedKey() throws AuthenticationException {
        String session = SessionHolder.get();
        if (null == session) {
            logger.error("No session found in SessionHolder. Have security filters processed this request?");
            throw new AuthenticationException("No global session identifier found for the current request");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Returning unencrypted key " + session);
        }
        return session;
    }

    private String getKey() throws AuthenticationException {
        return Encryption.encrypt((String)this.getUnencryptedKey());
    }

    @Override
    public CachedCredentials getCurrent() throws AuthenticationException {
        String encrypted;
        String key = this.getKey();
        if (logger.isDebugEnabled()) {
            logger.debug("Fetching from distributed cache with key " + key);
        }
        if (null == (encrypted = this.credentialCache.get(key))) {
            if (logger.isDebugEnabled()) {
                logger.debug("Found no encrypted identities for key " + key);
            }
            return new CachedCredentials(key);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Found encrypted identities " + encrypted + " for key " + key + " in distributed cache");
        }
        try {
            Set<UserIdentityInterface> credentials = CredentialCacheManagerImpl.fromEncryptedString(encrypted);
            if (logger.isDebugEnabled()) {
                logger.debug("Found identities after unencrypting for key " + key);
            }
            return new CachedCredentials(key, credentials);
        }
        catch (IOException e) {
            logger.error("Error deserializing encrypted identities", (Throwable)e);
            throw new AuthenticationException("Error deserializing encrypted identities", (Throwable)e);
        }
    }

    @Override
    public void makeCurrent(CachedCredentials credentials) throws AuthenticationException {
        String key = credentials.getKey();
        if (null == key) {
            key = this.getKey();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Making credentials with size " + credentials.getKey() + " current in distributed cache");
        }
        try {
            String encrypted = CredentialCacheManagerImpl.toEncryptedString(credentials.getCredentials());
            this.credentialCache.put(key, encrypted);
            if (logger.isDebugEnabled()) {
                logger.debug("Added encrypted credentials " + encrypted + " for key " + key);
            }
        }
        catch (IOException e) {
            logger.error("Error serializing encrypted identities", (Throwable)e);
            throw new AuthenticationException("Error serializing encrypted identities", (Throwable)e);
        }
    }
}

