/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.security.login.weblogic;

import com.sas.services.connection.Credential;
import com.sas.services.connection.PasswordCredential;
import com.sas.services.security.login.LoginPropertyConstants;
import com.sas.services.security.login.OMIServerPrincipal;
import com.sas.services.security.login.PFSCredential;
import com.sas.services.security.login.PFSPrincipal;
import com.sas.services.security.login.TrustedLoginModule;
import com.sas.services.security.login.weblogic.WLGroupPrincipal;
import com.sas.services.security.login.weblogic.WLPrincipal;
import com.sas.services.security.login.weblogic.WLRolePrincipal;
import com.sas.services.security.login.weblogic.WLServerPrincipal;
import java.io.IOException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public class WLTrustedLoginModuleImpl
extends TrustedLoginModule {
    Subject _subject;
    boolean _succeeded;
    private String _aliasDomain;
    private boolean _addDomain;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this._aliasDomain = (String)options.get("aliasdomain");
        this._defaultRepository = (String)options.get("repository");
        this._addDomain = false;
        String addDomainString = (String)options.get("domainQualifyUid");
        if (addDomainString != null && addDomainString.equalsIgnoreCase(LoginPropertyConstants.PROPERTYVALUE_TRUE)) {
            this._addDomain = true;
        }
        this._subject = subject;
    }

    public boolean login() throws LoginException {
        return this.doLogin();
    }

    protected boolean doLogin() throws LoginException {
        boolean result = this.setupAuthParams();
        if (!result) {
            return false;
        }
        result = this.setupConnectionResources();
        if (!result) {
            return false;
        }
        if (this._debug) {
            this.doDebugOutput("TrustedLoginModule: Request to authenticate " + this._username);
        }
        if (this._username.indexOf("!*(generatedpassworddomain)*!") > -1) {
            this._genUser = this._username;
            this._genPass = this._password;
            this._password = null;
            this._username = this._username.substring(0, this._username.indexOf("!*(generatedpassworddomain)*!") - 1);
            result = this.attemptConnection(this._genUser, this._genPass);
            this.closeTrust();
            if (!result) {
                return false;
            }
        } else {
            this._password = null;
            result = this.generatePassword();
            if (!result) {
                return false;
            }
            result = this.attemptConnection(this._genUser, this._genPass);
            this.closeTrust();
            if (!result) {
                return false;
            }
        }
        this.getUserInfo();
        this.closeCx();
        this._succeeded = true;
        return true;
    }

    protected boolean setupAuthParams() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("Name")};
        try {
            this._callbackHandler.handle(callbacks);
            this._username = ((NameCallback)callbacks[0]).getName();
            this._password = null;
        }
        catch (IOException ioex) {
            return false;
        }
        catch (UnsupportedCallbackException ucex) {
            this.doDebugOutput("Callbacks threw an UnsupportedCallbackException.");
            return false;
        }
        if (this._username == null) {
            if (this._debug) {
                this.doDebugOutput(this.getRBString("SASLoginModule.nulluser.msg.txt"));
            }
            return false;
        }
        if (this._username.startsWith("[@")) {
            int index = this._username.indexOf(93);
            if (index > -1) {
                this._domain = this._username.substring(2, index);
                this._username = this._username.substring(index + 1);
            } else {
                this._domain = this._defaultDomain;
            }
        } else {
            this._domain = this._defaultDomain;
        }
        if (this._debug && this._username != null) {
            this.doDebugOutput("[SasLoginModule] user to authenticate: " + this._username);
        }
        if (this._domain != null && !this._domain.equalsIgnoreCase(this._defaultDomain) && !this._domain.equalsIgnoreCase(this._aliasDomain)) {
            if (this._debug) {
                Object[] arguments = new Object[]{this._domain, this._defaultDomain};
                this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.wrongdomain.msg.fmt.txt"), arguments));
                if (this._aliasDomain != null) {
                    arguments = new Object[]{this._aliasDomain};
                    this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.wrongdomainalias.msg.fmt.txt"), arguments));
                }
            }
            return false;
        }
        if (this._addDomain && this._username.indexOf("\\") == -1 && this._username.indexOf("@") == -1) {
            this._username = this._username + '@' + this._domain;
        }
        PasswordCredential cred = new PasswordCredential(this._username, this._password);
        this.setCredential((Credential)cred);
        return true;
    }

    public boolean commit() throws LoginException {
        Object[] arguments;
        Object wlp;
        if (!this._succeeded) {
            return false;
        }
        for (PFSPrincipal p : this._principals) {
            Object[] arguments2;
            String printString;
            if (this._subject.getPrincipals().contains(p)) continue;
            if (p instanceof OMIServerPrincipal) {
                WLServerPrincipal wlsp = new WLServerPrincipal((OMIServerPrincipal)p);
                wlsp.setIsValidated(true);
                if (this.isDebug()) {
                    printString = ((Object)((Object)wlsp)).getClass().getName() + " : " + wlsp.getName();
                    arguments2 = new Object[]{printString};
                    this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.addingprincipal.msg.fmt.txt"), arguments2));
                }
                if (this._subject.getPrincipals().contains((Object)wlsp)) continue;
                this._subject.getPrincipals().add((Principal)((Object)wlsp));
                continue;
            }
            wlp = new WLPrincipal(p.getName());
            wlp.setIsValidated(true);
            if (this.isDebug()) {
                printString = wlp.getClass().getName() + " : " + wlp.getName();
                arguments2 = new Object[]{printString};
                this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.addingprincipal.msg.fmt.txt"), arguments2));
            }
            if (this._subject.getPrincipals().contains(wlp)) continue;
            this._subject.getPrincipals().add((Principal)wlp);
        }
        for (PFSPrincipal p : this._groups) {
            wlp = new WLGroupPrincipal(p.getName());
            wlp.setIsValidated(true);
            wlp.setHost(p.getHost());
            wlp.setPort(p.getPort());
            wlp.setDomain(p.getDomain());
            if (this.isDebug()) {
                arguments = new Object[]{wlp.getName()};
                this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.addinggroup.msg.fmt.txt"), arguments));
            }
            if (this._subject.getPrincipals().contains(wlp)) continue;
            this._subject.getPrincipals().add((Principal)wlp);
        }
        for (PFSPrincipal p : this._roles) {
            wlp = new WLRolePrincipal(p.getName());
            wlp.setIsValidated(true);
            wlp.setDomain(p.getDomain());
            if (this.isDebug()) {
                arguments = new Object[]{((WLRolePrincipal)((Object)wlp)).toString()};
                this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.addingrole.msg.fmt.txt"), arguments));
            }
            if (this._subject.getPrincipals().contains(wlp)) continue;
            this._subject.getPrincipals().add((Principal)wlp);
        }
        this.addDefaultCredential();
        for (PFSCredential pc : this._credentials) {
            if (this.isDebug()) {
                Object[] arguments3 = new Object[]{pc.getUserId(), pc.getDomain()};
                this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.addcred.msg.fmt.txt"), arguments3));
            }
            if (this._subject.getPrivateCredentials().contains(pc)) continue;
            this._subject.getPrivateCredentials().add(pc);
        }
        return true;
    }
}

