/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.security.login.weblogic;

import com.sas.services.security.login.OMILoginModule;
import com.sas.services.security.login.OMIServerPrincipal;
import com.sas.services.security.login.PFSCredential;
import com.sas.services.security.login.PFSPrincipal;
import com.sas.services.security.login.weblogic.WLGroupPrincipal;
import com.sas.services.security.login.weblogic.WLPrincipal;
import com.sas.services.security.login.weblogic.WLRolePrincipal;
import com.sas.services.security.login.weblogic.WLServerPrincipal;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;

public final class WLOMILoginModuleImpl
extends OMILoginModule {
    Subject _subject;
    boolean _succeeded;
    boolean _debug;
    boolean isIdentityAssertion;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this._debug = false;
        String debugString = (String)options.get("debug");
        if (debugString != null && debugString.equalsIgnoreCase("true")) {
            this._debug = true;
        }
        this.isIdentityAssertion = "true".equalsIgnoreCase((String)options.get("IdentityAssertion"));
        this._subject = subject;
    }

    public boolean login() throws LoginException {
        this._succeeded = super.login();
        return this._succeeded;
    }

    public boolean commit() throws LoginException {
        Object[] arguments;
        Object wlp;
        Iterator<Principal> princIt = this._subject.getPrincipals().iterator();
        if (!this._succeeded) {
            return false;
        }
        for (PFSPrincipal p : this._principals) {
            Object[] arguments2;
            String prinString;
            if (this._subject.getPrincipals().contains(p)) continue;
            if (p instanceof OMIServerPrincipal) {
                WLServerPrincipal wlsp = new WLServerPrincipal((OMIServerPrincipal)p);
                if (this._debug) {
                    prinString = ((Object)((Object)wlsp)).getClass().getName() + " : " + wlsp.getName();
                    arguments2 = new Object[]{prinString};
                    this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.addingprincipal.msg.fmt.txt"), arguments2));
                }
                this._subject.getPrincipals().add((Principal)p);
                continue;
            }
            wlp = new WLPrincipal(p.getName());
            wlp.setIsValidated(true);
            wlp.setDomain(p.getDomain());
            if (this._debug) {
                prinString = wlp.getClass().getName() + " : " + wlp.getName();
                arguments2 = new Object[]{prinString};
                this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.addingprincipal.msg.fmt.txt"), arguments2));
            }
            this._subject.getPrincipals().add((Principal)wlp);
        }
        for (PFSPrincipal p : this._groups) {
            wlp = new WLGroupPrincipal(p.getName());
            wlp.setIsValidated(true);
            wlp.setHost(p.getHost());
            wlp.setPort(p.getPort());
            wlp.setDomain(p.getDomain());
            if (this._debug) {
                arguments = new Object[]{((WLGroupPrincipal)((Object)wlp)).toString()};
                this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.addinggroup.msg.fmt.txt"), arguments));
            }
            this._subject.getPrincipals().add((Principal)wlp);
        }
        for (PFSPrincipal p : this._roles) {
            wlp = new WLRolePrincipal(p.getName());
            wlp.setIsValidated(true);
            wlp.setHost(p.getHost());
            wlp.setPort(p.getPort());
            wlp.setDomain(p.getDomain());
            if (this._debug) {
                arguments = new Object[]{((WLRolePrincipal)((Object)wlp)).toString()};
                this.doDebugOutput(MessageFormat.format(this.getRBString("SASLoginModule.addingrole.msg.fmt.txt"), arguments));
            }
            this._subject.getPrincipals().add((Principal)wlp);
        }
        if (this._credentials.size() > 0) {
            for (PFSCredential pc : this._credentials) {
                if (this._subject.getPrivateCredentials().contains(pc)) continue;
                this._subject.getPrivateCredentials().add(pc);
            }
        }
        if (this.isDebug()) {
            this.doDebugOutput("The Subject contains these principals:");
            for (Principal p : this._subject.getPrincipals()) {
                this.doDebugOutput(p.getClass().getName() + "  : " + p.getName());
            }
        }
        return true;
    }
}

