/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.security.login.weblogic;

import com.sas.services.security.login.weblogic.WLOMIAuthenticatorMBean;
import com.sas.services.security.login.weblogic.WLOMIPrincipalValidatorImpl;
import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import weblogic.management.security.ProviderMBean;
import weblogic.security.spi.AuthenticationProviderV2;
import weblogic.security.spi.IdentityAsserterV2;
import weblogic.security.spi.PrincipalValidator;
import weblogic.security.spi.SecurityServices;

public class WLOMIAuthenticationProviderImpl
implements AuthenticationProviderV2 {
    private String description;
    private AppConfigurationEntry.LoginModuleControlFlag controlFlag;
    private String host;
    private String port;
    private String domain;
    private String debug;
    private String encrypt;
    private String aliasdomain;
    private String trusteduser;
    private String trustedpw;

    public AppConfigurationEntry getLoginModuleConfiguration() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("host", this.host);
        options.put("port", this.port);
        options.put("domain", this.domain);
        options.put("debug", this.debug);
        options.put("encrypt", this.encrypt);
        options.put("aliasdomain", this.aliasdomain);
        options.put("trusteduser", this.trusteduser);
        options.put("trustedpw", this.trustedpw);
        return new AppConfigurationEntry("com.sas.services.security.login.weblogic.WLOMILoginModuleImpl", this.controlFlag, options);
    }

    public AppConfigurationEntry getAssertionModuleConfiguration() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("host", this.host);
        options.put("port", this.port);
        options.put("domain", this.domain);
        options.put("debug", this.debug);
        return new AppConfigurationEntry("com.sas.services.security.login.weblogic.WLOMILoginModuleImpl", this.controlFlag, options);
    }

    public PrincipalValidator getPrincipalValidator() {
        return new WLOMIPrincipalValidatorImpl();
    }

    public IdentityAsserterV2 getIdentityAsserter() {
        return null;
    }

    public void initialize(ProviderMBean mbean, SecurityServices services) {
        WLOMIAuthenticatorMBean myMBean = (WLOMIAuthenticatorMBean)mbean;
        this.description = myMBean.getDescription() + "\n" + myMBean.getVersion();
        String flag = myMBean.getControlFlag();
        if (flag.equalsIgnoreCase("REQUIRED")) {
            this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        } else if (flag.equalsIgnoreCase("OPTIONAL")) {
            this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        } else if (flag.equalsIgnoreCase("REQUISITE")) {
            this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        } else if (flag.equalsIgnoreCase("SUFFICIENT")) {
            this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        } else {
            throw new IllegalArgumentException("invalid flag value" + flag);
        }
        try {
            this.description = myMBean.getDescription();
            this.host = myMBean.getHost();
            this.port = myMBean.getPort();
            this.domain = myMBean.getDomain();
            this.debug = myMBean.getDebug();
            this.encrypt = myMBean.getEncrypt();
            this.aliasdomain = myMBean.getAliasDomain();
            this.trusteduser = myMBean.getTrustedUser();
            this.trustedpw = myMBean.getTrustedPassword();
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void shutdown() {
    }
}

