/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.util.impl;

import com.sas.iom.SASMDX.ISession;
import com.sas.iquery.dataservices.DataServicesException;
import com.sas.iquery.dataservices.IQDataServices;
import com.sas.iquery.dataservices.IQDataServicesFactory;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionCancelQueryListener;
import com.sas.iquery.execution.ConnectionResources;
import com.sas.iquery.execution.ConnectionUtil;
import com.sas.iquery.execution.OLAPConnectionResource;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.CancelQuerySupport;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.RequiredDataSources;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.metadata.expr.OLAPResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.olap.TimeExpressionMeasure;
import com.sas.iquery.metadata.physical.CalculatedMember;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.NamedSet;
import com.sas.iquery.metadata.physical.Server;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.strategies.sas.oma.olap.util.IQMetadataInterface;
import com.sas.iquery.strategies.sas.oma.olap.util.ISessionCacheContainer;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import com.sas.storage.olap.sasmdx.Metadata;
import com.sas.storage.olap.sasmdx.OLAPDataSet;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OLAPUtilities {
    private static final Logger _logger = LogManager.getLogger(OLAPUtilities.class);
    private static final Level ERROR_LEVEL = Level.ERROR;

    public static void findDuplicateLabels(DataSelection model, List<Reason> reasons) throws MetadataException, GenerationException {
        List<DataItem> dataItems;
        String label;
        HashMap multiMap = new HashMap();
        for (DataItem dataItem : model.getResultItems()) {
            if (!dataItem.getStructure().equals(StructureOfDataItem.STRUCTURE_MEASURE)) continue;
            label = dataItem.getLabel();
            if (multiMap.containsKey(label)) {
                dataItems = (List)multiMap.get(label);
                dataItems.add(dataItem);
                continue;
            }
            dataItems = new ArrayList();
            ((ArrayList)dataItems).add(dataItem);
            multiMap.put(label, dataItems);
        }
        for (Map.Entry entry : multiMap.entrySet()) {
            label = (String)entry.getKey();
            dataItems = (ArrayList)entry.getValue();
            if (((ArrayList)dataItems).size() <= 1) continue;
            for (int i = 1; i < ((ArrayList)dataItems).size(); ++i) {
                String expressionName1 = OLAPUtilities.getExpressionName((DataItem)((ArrayList)dataItems).get(0), model.getComputationalLocale());
                ExpressionInterface expression1 = ((DataItem)((ArrayList)dataItems).get(0)).getExpression();
                String expressionName2 = OLAPUtilities.getExpressionName((DataItem)((ArrayList)dataItems).get(i), model.getComputationalLocale());
                ExpressionInterface expression2 = ((DataItem)((ArrayList)dataItems).get(i)).getExpression();
                Reason reason = OLAPUtilities.setReasonStringForDuplicateLabel(expression1, expression2, expressionName1, label, expressionName2, model);
                reasons.add(reason);
            }
        }
    }

    public static AxisInterface[] getAxisDefinition(OLAPDataSetInterface model) {
        AxisInterface[] axes;
        block2: {
            axes = null;
            try {
                ResultSetMetadataInterface rsm = model.getResultSetMetadata();
                axes = rsm.getAxes(0, -1);
            }
            catch (OLAPException e) {
                if (!_logger.isEnabled(ERROR_LEVEL)) break block2;
                _logger.error(e.getLocalizedMessage());
            }
        }
        return axes;
    }

    public static TupleElementInterface[] getTupleElements(AxisInterface[] axes, TupleElementInterface[] tupleElements, String cubeName, MetadataInterface olapMeta, BusinessQuery businessQuery) {
        TupleElementInterface[] tupleElems;
        block50: {
            ArrayList<TupleElementInterface> tupleElementMembers = new ArrayList<TupleElementInterface>();
            Filter filter = new Filter();
            filter.setCubeName(cubeName);
            tupleElems = null;
            try {
                block10: for (AxisInterface axisInterface : axes) {
                    int axisNum = axisInterface.getAxisNumber();
                    String[] dimNames = axisInterface.getDimensionNames();
                    if (axisNum != -1) {
                        TupleInterface[] tuplesA;
                        int counter = 0;
                        for (int i = 0; i < tupleElements.length; ++i) {
                            if (tupleElements[i].getTuple().getAxis().getAxisNumber() != axisNum) continue;
                            if (!tupleElements[i].isContextual() && tupleElements[i].getType() != TupleElementType.MEASURE) {
                                tupleElementMembers.add(tupleElements[i]);
                            }
                            ++counter;
                        }
                        if (counter == 0) {
                            String[] uniqueLevelNames = axisInterface.getUniqueLevelNames();
                            for (int i = 0; i < uniqueLevelNames.length; ++i) {
                                TupleInterface[] tuples = axisInterface.getTuples(-12, -18);
                                TupleElementInterface[] elements = OLAPUtil.getTupleElementsForLevel((int)i, (TupleInterface[])tuples, (boolean)false, (int)-1);
                                for (int j = 0; j < elements.length; ++j) {
                                    if (elements[j].isContextual() || elements[j].getType() == TupleElementType.MEASURE) continue;
                                    tupleElementMembers.add(elements[j]);
                                }
                            }
                            continue;
                        }
                        int lastElementIndex = tupleElements.length - 1;
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("Last element " + tupleElements[lastElementIndex]);
                        }
                        if (tupleElements[lastElementIndex].getTuple().getAxis().getAxisNumber() != axisNum) continue;
                        int minCoord = tupleElements[lastElementIndex].getMinimumCoordinate();
                        int maxCoord = tupleElements[lastElementIndex].getMaximumCoordinate();
                        for (TupleInterface element : tuplesA = axisInterface.getTuples(minCoord, maxCoord - minCoord + 1)) {
                            TupleElementInterface[] elements;
                            for (TupleElementInterface element2 : elements = element.getElements(tupleElements[lastElementIndex].getTupleElementIndex() + 1, -1)) {
                                if (element2.isContextual() || element2.getType() == TupleElementType.MEASURE) continue;
                                tupleElementMembers.add(element2);
                                if (!_logger.isDebugEnabled()) continue;
                                _logger.debug("Adding " + element2);
                            }
                        }
                        continue;
                    }
                    TupleInterface[] tuples = axisInterface.getTuples(-12, -18);
                    if (tuples.length <= 0) continue;
                    TupleElementInterface[] te = tuples[0].getElements(0, -1);
                    for (int m = 0; m < te.length; ++m) {
                        MemberInterface[] members;
                        block48: {
                            filter.reset();
                            Metadata.clearCache((Object)olapMeta.getConnection(), (int)0);
                            filter.setCubeName(cubeName);
                            filter.setUniqueMemberName(te[m].getName());
                            members = null;
                            try {
                                members = olapMeta.getMembers(filter, 0, 1);
                            }
                            catch (OLAPException oe) {
                                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("OLAPUtilitiesOLAPExceptionGetMember.txt", new Object[0]);
                                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, formatter.toString(), oe.getLocalizedMessage());
                                members = null;
                                MDXGenerationUtil.applyDebugStatement(filter.toString(), OLAPUtilities.class);
                                if (!_logger.isEnabled(ERROR_LEVEL)) break block48;
                                _logger.error(msF.toString(), (Throwable)oe);
                            }
                        }
                        if (members != null && members.length > 0) {
                            tupleElementMembers.add(te[m]);
                            continue;
                        }
                        filter.setDimensionName(dimNames[m]);
                        DimensionInterface[] dimensions = olapMeta.getDimensions(filter);
                        if (dimensions.length > 0 && dimensions[0].getType() == 2) continue block10;
                        ArrayList<DataItem> resultItemsInBusinessQuery = new ArrayList<DataItem>();
                        resultItemsInBusinessQuery.addAll(businessQuery.getResultItems(Role.BACKGROUND));
                        resultItemsInBusinessQuery.addAll(businessQuery.getResultItems(Role.HIDDEN));
                        Iterator iterItems = resultItemsInBusinessQuery.iterator();
                        String dimNameString = dimNames[m];
                        DataItem dataItem = null;
                        while (iterItems.hasNext()) {
                            String memberLabel;
                            block49: {
                                dataItem = (DataItem)iterItems.next();
                                ExpressionInterface expressionOfDataItem = dataItem.getExpression();
                                memberLabel = null;
                                if (expressionOfDataItem instanceof Hierarchy) {
                                    Hierarchy hierarchyOfDataItem = (Hierarchy)expressionOfDataItem;
                                    memberLabel = hierarchyOfDataItem.getDimensionName();
                                } else if (expressionOfDataItem instanceof CalculatedMember) {
                                    CalculatedMember calcMem = (CalculatedMember)expressionOfDataItem;
                                    memberLabel = calcMem.getDimensionName();
                                } else if (expressionOfDataItem instanceof NamedSet) {
                                    NamedSet namedSet = (NamedSet)expressionOfDataItem;
                                    try {
                                        memberLabel = namedSet.getOwningHierarchy().getDimensionName();
                                    }
                                    catch (MetadataException e) {
                                        if (!_logger.isEnabled(ERROR_LEVEL)) break block49;
                                        _logger.error(e.getLocalizedMessage() + " " + cubeName);
                                    }
                                } else if (expressionOfDataItem instanceof OLAPResourceAwareStringExpression) {
                                    OLAPResourceAwareStringExpression olapRase = (OLAPResourceAwareStringExpression)expressionOfDataItem;
                                    memberLabel = olapRase.getDimName();
                                } else if (expressionOfDataItem instanceof ResourceAwareStringExpression) {
                                    ResourceAwareStringExpression resourceExp = (ResourceAwareStringExpression)expressionOfDataItem;
                                    List<BusinessModelResource> resources = resourceExp.getResources(BusinessModelResource.class, 65535);
                                    for (BusinessModelResource bmaResource : resources) {
                                        if (bmaResource instanceof Dimension) {
                                            Dimension physDimension = (Dimension)bmaResource;
                                            memberLabel = BusinessQueryOLAPUtil.getPhysDimensionName(physDimension);
                                        } else if (bmaResource instanceof Hierarchy) {
                                            Hierarchy physHierarchy = (Hierarchy)bmaResource;
                                            memberLabel = BusinessQueryOLAPUtil.getPhysHierarchyName(physHierarchy);
                                        } else if (bmaResource instanceof CalculatedMember) {
                                            CalculatedMember calcMem = (CalculatedMember)bmaResource;
                                            memberLabel = calcMem.getDimensionName();
                                        } else if (expressionOfDataItem instanceof NamedSet) {
                                            NamedSet namedSet = (NamedSet)expressionOfDataItem;
                                            try {
                                                memberLabel = namedSet.getOwningHierarchy().getHierarchyName();
                                            }
                                            catch (MetadataException e) {
                                                if (_logger.isEnabled(ERROR_LEVEL)) {
                                                    _logger.error(e.getLocalizedMessage() + " " + cubeName);
                                                }
                                            }
                                        } else if (bmaResource instanceof com.sas.iquery.metadata.physical.Level) {
                                            com.sas.iquery.metadata.physical.Level physLevel = (com.sas.iquery.metadata.physical.Level)bmaResource;
                                            memberLabel = BusinessQueryOLAPUtil.getPhysLevelName(physLevel);
                                        } else {
                                            memberLabel = BusinessQueryOLAPUtil.getDimensionName(dataItem.getBusinessModel(), dataItem);
                                        }
                                        if (memberLabel == null || !memberLabel.equalsIgnoreCase(dimNameString)) continue;
                                    }
                                }
                                break block49;
                                {
                                    break;
                                }
                            }
                            if (memberLabel == null || !memberLabel.equalsIgnoreCase(dimNameString)) continue;
                            break;
                        }
                        if (dataItem.getStructure().equals(StructureOfDataItem.STRUCTURE_MEASURE)) continue;
                        IQDataServices iqDataServices = IQDataServicesFactory.newService();
                        List<TupleElementInterface> membersOfDataItem = iqDataServices.getMembers(dataItem, -999);
                        int len = membersOfDataItem.size();
                        for (int j = 0; j < len; ++j) {
                            tupleElementMembers.add(membersOfDataItem.get(j));
                        }
                    }
                }
                tupleElems = tupleElementMembers.toArray(new TupleElementInterface[tupleElementMembers.size()]);
                for (AxisInterface axisInterface : tupleElems) {
                    if (!_logger.isDebugEnabled()) continue;
                    _logger.debug("  before Adding to dimlist: " + axisInterface);
                }
            }
            catch (OLAPException e) {
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(e.getLocalizedMessage() + " " + cubeName);
                }
            }
            catch (DataServicesException ee) {
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(ee.getLocalizedMessage() + " " + cubeName);
                }
            }
            catch (MetadataException eee) {
                if (!_logger.isEnabled(ERROR_LEVEL)) break block50;
                _logger.error(eee.getLocalizedMessage() + " " + cubeName);
            }
        }
        return tupleElems;
    }

    public static String getCubeNameFromOLAPModel(Object model) throws MetadataException, OLAPException {
        String cubeName = null;
        if (model instanceof BusinessQueryProviderInterface) {
            BusinessQuery bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            if (bq.getResultItems().size() == 0) {
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(bq.getID());
                }
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ShowDetail.ShowDetailNullException.Message.txt", new Object[0]);
                throw new IllegalStateException(formatter.toString());
            }
            try {
                cubeName = OLAPConnectionInfoUtil.getCubeName(bq.getBusinessModel());
            }
            catch (GenerationException ge) {
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(model.toString() + ge.getLocalizedMessage());
                }
                IllegalStateException ise = new IllegalStateException(ge.getLocalizedMessage());
                throw ise;
            }
        } else if (model instanceof OLAPDataSet) {
            cubeName = ((OLAPDataSet)model).getCubeName();
        } else {
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(model.toString());
            }
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ShowDetail.ShowDetailBadModelException.Message.txt", new Object[0]);
            throw new IllegalStateException(formatter.toString());
        }
        return cubeName;
    }

    private static Reason setReasonStringForDuplicateLabel(Object expression, Object expressionsecond, String nameOfExpressionFirst, String label, String nameOfExpressionSecond, DataSelection model) {
        String expressionValue = "Unknown type";
        if (expression != null) {
            expressionValue = expression instanceof ResourceAwareStringExpression ? IQMetadataResourceBundle.getStringResource("OLAPDuplicateLabelCustomizedDataItem.txt") : (expression instanceof FractionOfTotalExpression ? IQMetadataResourceBundle.getStringResource("OLAPDuplicateLabelPOTDataItem.txt") : (expression instanceof TimeExpressionMeasure ? IQMetadataResourceBundle.getStringResource("OLAPDuplicateLabelTimeMeasureDataItem.txt") : IQMetadataResourceBundle.getStringResource("OLAPDuplicateLabelDataItem.txt")));
        }
        String expressionValue2 = "Unknown type";
        if (expressionsecond != null) {
            expressionValue2 = expressionsecond instanceof ResourceAwareStringExpression ? IQMetadataResourceBundle.getStringResource("OLAPDuplicateLabelCustomizedDataItem.txt") : (expressionsecond instanceof FractionOfTotalExpression ? IQMetadataResourceBundle.getStringResource("OLAPDuplicateLabelPOTDataItem.txt") : (expressionsecond instanceof TimeExpressionMeasure ? IQMetadataResourceBundle.getStringResource("OLAPDuplicateLabelTimeMeasureDataItem.txt") : IQMetadataResourceBundle.getStringResource("OLAPDuplicateLabelDataItem.txt")));
        }
        MessageFormatter val = IQMetadataResourceBundle.getMessageFormatter("OLAPDuplicateLabel.fmt.txt", nameOfExpressionFirst, label, expressionValue, nameOfExpressionSecond, expressionValue2, MDXGenerationUtil.NEWLINE);
        Reason reason = new Reason((Object)model, 2, 240, val);
        return reason;
    }

    private static String getExpressionName(DataItem dataItem, Locale locale) throws GenerationException, MetadataException {
        ExpressionInterface expression = dataItem.getExpression();
        if (expression instanceof Dimension) {
            return BusinessQueryOLAPUtil.getDimensionName(dataItem.getBusinessModel(), dataItem);
        }
        if (expression instanceof FractionOfTotalExpression) {
            FractionOfTotalExpression tm = (FractionOfTotalExpression)expression;
            return tm.toString();
        }
        if (expression instanceof TimeExpressionMeasure) {
            TimeExpressionMeasure tm = (TimeExpressionMeasure)expression;
            return tm.getFunction();
        }
        if (expression instanceof Hierarchy) {
            String hierarchy = BusinessQueryOLAPUtil.getHierarchyName(dataItem.getBusinessModel(), dataItem, locale);
            return hierarchy;
        }
        if (expression instanceof com.sas.iquery.metadata.physical.Level) {
            return MDXGenerationUtil.getLevelExpression((com.sas.iquery.metadata.physical.Level)expression);
        }
        if (expression instanceof Measure) {
            return MDXGenerationUtil.getMeasureExpression((Measure)expression);
        }
        if (expression instanceof ResourceAwareStringExpression) {
            ResourceAwareStringExpression resourceExp = (ResourceAwareStringExpression)expression;
            WeakHashMap<BusinessModelResource, String> resourceToMDXMap = new WeakHashMap<BusinessModelResource, String>();
            for (BusinessModelResource bmaResource : resourceExp.getResources(BusinessModelResource.class, 65535)) {
                String hierName;
                Hierarchy hier;
                if (bmaResource instanceof DataItem) {
                    DataItem di = (DataItem)bmaResource;
                    resourceToMDXMap.put(di, OLAPUtilities.getExpressionName(di, locale));
                    continue;
                }
                if (bmaResource instanceof Dimension) {
                    Dimension physDimension = (Dimension)bmaResource;
                    String dimName = BusinessQueryOLAPUtil.getPhysDimensionName(physDimension);
                    resourceToMDXMap.put(physDimension, dimName);
                    continue;
                }
                if (bmaResource instanceof Hierarchy) {
                    Hierarchy physHierarchy = (Hierarchy)bmaResource;
                    String hierName2 = BusinessQueryOLAPUtil.getPhysHierarchyName(physHierarchy);
                    resourceToMDXMap.put(physHierarchy, hierName2);
                    continue;
                }
                if (bmaResource instanceof NamedSet) {
                    NamedSet namedSet = (NamedSet)bmaResource;
                    try {
                        hier = namedSet.getOwningHierarchy();
                        hierName = hier.getHierarchyName();
                        resourceToMDXMap.put(hier, hierName);
                    }
                    catch (MetadataException e) {
                        if (!_logger.isEnabled(ERROR_LEVEL)) continue;
                        _logger.error(e.getLocalizedMessage());
                    }
                    continue;
                }
                if (bmaResource instanceof CalculatedMember) {
                    CalculatedMember calcMember = (CalculatedMember)bmaResource;
                    try {
                        hier = calcMember.getOwningHierarchy();
                        hierName = hier.getHierarchyName();
                        resourceToMDXMap.put(hier, hierName);
                    }
                    catch (MetadataException e) {
                        if (!_logger.isEnabled(ERROR_LEVEL)) continue;
                        _logger.error(e.getLocalizedMessage());
                    }
                    continue;
                }
                if (bmaResource instanceof com.sas.iquery.metadata.physical.Level) {
                    com.sas.iquery.metadata.physical.Level physLevel = (com.sas.iquery.metadata.physical.Level)bmaResource;
                    String levelName = BusinessQueryOLAPUtil.getPhysLevelName(physLevel);
                    resourceToMDXMap.put(physLevel, levelName);
                    continue;
                }
                if (!(bmaResource instanceof Measure)) continue;
                Measure physMeasure = (Measure)bmaResource;
                String measureName = BusinessQueryOLAPUtil.getPhysMeasureName(physMeasure);
                resourceToMDXMap.put(physMeasure, measureName);
            }
            String resourceMDX = resourceExp.getText(resourceToMDXMap);
            return "( " + resourceMDX + " )";
        }
        return "";
    }

    public static DataSourceCube findDataSourceCube(BusinessModel businessModel) throws MetadataException {
        List<DataSourceCube> cubes = businessModel.getObjects(true, DataSourceCube.class);
        if (cubes == null || cubes.size() == 0 || cubes.get(0) == null) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("OLAPConnectionInfoUtilBadSource.txt", new Object[0]);
            ConnectionUtil.LoggerErrorWithObjects(_logger, message, businessModel);
            throw new MetadataException(message);
        }
        DataSourceCube dataCube = cubes.get(0);
        List<Reason> reasonsForCube = dataCube.getReasonsUnusable();
        if (reasonsForCube.size() > 0) {
            MessageFormatter baseMessage = IQDataServicesResourceBundle.getMessageFormatter("OLAPConnectionInfoUtilBadSource.txt", new Object[0]);
            MessageFormatter reasonListFormatter = Reason.getMessageFormatter(baseMessage, reasonsForCube, false);
            throw new MetadataException(reasonListFormatter, reasonsForCube);
        }
        if (!dataCube.isOLAPCubeBuilt()) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("OLAPConnectionInfoUtilBadCube.fmt.txt", dataCube.getLabel());
            throw new MetadataException(message);
        }
        return dataCube;
    }

    public static String findCubeName(DataSourceCube dataCube) throws MetadataException {
        String cubeName = null;
        try {
            cubeName = dataCube.getCubeName();
        }
        catch (MetadataException e) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("DataServices.MetadataException.Message.txt", new Object[0]);
            ConnectionUtil.LoggerErrorWithObjects(_logger, message, dataCube);
            throw new MetadataException(message, (Throwable)e);
        }
        if (cubeName == null) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("MDXGenerationUtilNoCube.txt", new Object[0]);
            ConnectionUtil.LoggerErrorWithObjects(_logger, message, dataCube);
            throw new MetadataException(message);
        }
        return cubeName;
    }

    public static BusinessModel findBusinessModel(MetadataInterface metaI, BusinessQuery businessQuery, DataItem dataItem) throws MetadataException {
        BusinessModel businessModel = null;
        if (metaI instanceof IQMetadataInterface) {
            businessModel = ((IQMetadataInterface)metaI).getRelatedBusinessModel();
        }
        if (businessModel == null && businessQuery != null) {
            businessModel = businessQuery.getBusinessModel();
        }
        if (businessModel == null && dataItem != null) {
            businessModel = dataItem.getBusinessModel();
        }
        if (businessModel == null) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("OLAPConnectionInfoUtilNoModel.txt", new Object[0]);
            ConnectionUtil.LoggerErrorWithObjects(_logger, message, metaI, businessQuery, dataItem);
            throw new MetadataException(message);
        }
        return businessModel;
    }

    public static DataSelection findDataSelection(BusinessQuery businessQuery, BusinessModel businessModel) throws MetadataException {
        BusinessModel baseModel;
        DataSelection dataSelection = null;
        if (businessQuery instanceof DataSelection) {
            dataSelection = (DataSelection)businessQuery;
        }
        if (dataSelection == null && businessModel instanceof DataSelection) {
            dataSelection = (DataSelection)businessModel;
        }
        if (dataSelection == null) {
            List<BusinessQuery> businessQueries;
            try {
                businessQueries = businessModel.getQueries();
            }
            catch (MetadataException e) {
                MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("DataServices.MetadataException.Message.txt", new Object[0]);
                ConnectionUtil.LoggerErrorWithObjects(_logger, message, businessModel, e);
                throw new MetadataException(message, (Throwable)e);
            }
            for (BusinessQuery businessQuery1 : businessQueries) {
                if (!(businessQuery1 instanceof DataSelection)) continue;
                dataSelection = (DataSelection)businessQuery1;
                break;
            }
        }
        if (dataSelection == null && (baseModel = businessModel.getBaseModel()) instanceof DataSelection) {
            dataSelection = (DataSelection)baseModel;
        }
        return dataSelection;
    }

    public static SoftwareServer findSoftwareServer(DataSourceCube dataCube) throws MetadataException {
        Server server = dataCube.getServer();
        if (server == null) {
            MessageFormatter msF = IQDataServicesResourceBundle.getMessageFormatter("MDXGenerationCantGetServer.fmt.txt", dataCube);
            ConnectionUtil.LoggerErrorWithObjects(_logger, msF, dataCube);
            throw new MetadataException(msF);
        }
        SoftwareServer softwareServer = null;
        if (server != null && server instanceof SoftwareServer) {
            softwareServer = (SoftwareServer)server;
        }
        return softwareServer;
    }

    public static LogicalServerInterface findLogicalServerInterface(SoftwareServer softwareServer) throws MetadataException {
        LogicalServerInterface logicalServer = null;
        try {
            logicalServer = softwareServer.getLogicalServerInterface();
        }
        catch (MetadataException e) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("OLAPStrategyMetadataExceptionGetServer.txt", new Object[0]);
            ConnectionUtil.LoggerErrorWithObjects(_logger, message, softwareServer, e);
            throw new MetadataException(message, (Throwable)e);
        }
        if (logicalServer == null) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("OLAPConnectionInfoUtilNullServer.txt", new Object[0]);
            ConnectionUtil.LoggerErrorWithObjects(_logger, message, softwareServer);
            throw new MetadataException(message);
        }
        try {
            if (!OLAPConnectionInfoUtil.isOLAPServer(logicalServer)) {
                MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("OLAPConnectionInfoUtilBadServerObj.txt", new Object[0]);
                ConnectionUtil.LoggerErrorWithObjects(_logger, message, softwareServer, logicalServer);
                throw new MetadataException(message);
            }
        }
        catch (RemoteException e) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("OLAPConnectionInfoUtilBadServerObj.txt", new Object[0]);
            ConnectionUtil.LoggerErrorWithObjects(_logger, message, softwareServer, logicalServer);
            throw new MetadataException(message, (Throwable)e);
        }
        catch (ServiceException e) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("OLAPConnectionInfoUtilBadServerObj.txt", new Object[0]);
            ConnectionUtil.LoggerErrorWithObjects(_logger, message, softwareServer, logicalServer);
            throw new MetadataException(message, (Throwable)e);
        }
        return logicalServer;
    }

    public static DataSelection createDataSelection(BusinessModel businessModel, DataItem dataItem) throws MetadataException {
        DataSelection dataSelection = DataSelectionFactory.newDataSelection(businessModel);
        if (dataSelection == null) {
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("OLAPConnectionInfoUtilBadDataSource.txt", new Object[0]);
            ConnectionUtil.LoggerErrorWithObjects(_logger, message, businessModel, dataItem);
            throw new MetadataException(message);
        }
        dataSelection.setLabel("1");
        if (dataItem != null) {
            DataItemReference dataItemReference = dataSelection.newDataItemReference(dataItem);
            dataSelection.addBusinessItem(dataItemReference);
            dataSelection.addResultItem(dataItemReference, Role.COLUMN);
        }
        RequiredDataSources rds = dataSelection.newRequiredDataSources();
        rds.setDataSources(new ArrayList());
        dataSelection.addBusinessRule(rds);
        return dataSelection;
    }

    public static MetadataInterface getMetadataInterface(OLAPConnectionResource olapConnection, String cacheKey, DataSelection dataSelection, ConnectionInterface connection, Cube cube, Locale connectionLocale) throws ExecutionException, GenerationException, MetadataException {
        IQMetadataInterface metaI = null;
        ISessionCacheContainer container = olapConnection.getISessionContainerFromCache(cacheKey);
        if (container != null) {
            ISession iSession = container.getISession();
            try {
                metaI = ConnectionResources.newIQMetadata(iSession, connectionLocale);
            }
            catch (OLAPException e) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("DataServices.ErrorGettingMembers.Message.txt", new Object[0]);
                ConnectionUtil.LoggerErrorWithObjects(_logger, formatter.toString(), new Object[]{dataSelection, connection, iSession, e});
                throw new ExecutionException(formatter, (Throwable)e);
            }
        } else {
            ConnectionCancelQueryListener postConnectionListener = new ConnectionCancelQueryListener(dataSelection, true, connection);
            CancelQuerySupport.registerQueryListener(dataSelection, postConnectionListener, connection);
            ConnectionUtil.LoggerDebugConnectionObtained(_logger, OLAPUtilities.class, connection);
            String constructor = "DEFAULT_CONSTRUCTOR_BEHAVIOR";
            metaI = olapConnection.createMetadataInterface(dataSelection, constructor, cube, true, true, null);
        }
        if (!(metaI instanceof IQMetadataInterface)) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("OLAPStrategyNoMetadataI.txt", new Object[0]);
            ConnectionUtil.LoggerErrorWithObjects(_logger, formatter.toString(), dataSelection, metaI);
            throw new ExecutionException(formatter);
        }
        return metaI;
    }

    @Nonnull
    public static OLAPConnectionResource findOlapConnectionResource(ConnectionInterface pfsConnection) throws ExecutionException {
        if (!(pfsConnection instanceof OLAPConnectionResource)) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("OLAPConnectionInfoUtilBadDataSource.txt", new Object[0]);
            ConnectionUtil.LoggerErrorWithObjects(_logger, formatter.toString(), pfsConnection);
            throw new ExecutionException(formatter);
        }
        return (OLAPConnectionResource)pfsConnection;
    }
}

