/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.util.impl;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.util.LocalizableToStringInterface;
import java.text.MessageFormat;
import java.util.Locale;

public class ArrayMessageFormatter
extends MessageFormatter {
    public static final QuoteStyle QUOTESTYLE_NONE = QuoteStyle.NONE;
    public static final QuoteStyle QUOTESTYLE_NUMBER = QuoteStyle.NUMBER;
    public static final QuoteStyle QUOTESTYLE_SINGLECHAR = QuoteStyle.SINGLECHAR;
    public static final QuoteStyle QUOTESTYLE_TEXT = QuoteStyle.TEXT;
    public static final ListStyle LISTSTYLE_LONG = ListStyle.LONG;
    public static final ListStyle LISTSTYLE_SHORT = ListStyle.SHORT;
    public static final ListStyle LISTSTYLE_ONEPERLINE = ListStyle.ONEPERLINE;
    public static final ListStyle LISTSTYLE_NONE = ListStyle.NONE;
    private QuoteStyle _quoteStyle = QUOTESTYLE_NONE;
    private ListStyle _listStyle = LISTSTYLE_ONEPERLINE;
    private Object _one = null;
    private Object _two = null;
    private Object _first = null;
    private Object _next = null;
    private Object _last = null;
    private int _argCount = 0;

    public ArrayMessageFormatter(Object ... objects) {
        super(objects);
        this._argCount = objects != null ? objects.length : 0;
    }

    public ArrayMessageFormatter(Object[] objects, QuoteStyle quoteStyle) {
        this(objects);
        this._quoteStyle = quoteStyle;
    }

    public ArrayMessageFormatter(QuoteStyle quoteStyle, Object[] objects) {
        this(objects);
        this._quoteStyle = quoteStyle;
    }

    public ArrayMessageFormatter(ListStyle listStyle, Object ... objects) {
        this(objects);
        this._listStyle = listStyle;
    }

    public ArrayMessageFormatter(ListStyle listStyle, Object[] objects, QuoteStyle quoteStyle) {
        this(listStyle, objects);
        this._quoteStyle = quoteStyle;
    }

    public ArrayMessageFormatter(ListStyle listStyle, QuoteStyle quoteStyle, Object ... objects) {
        this(listStyle, objects);
        this._quoteStyle = quoteStyle;
    }

    @Override
    protected String getTemplate(Locale locale) {
        if (locale == null) {
            locale = LocaleUtilities.getDefaultViewerLocale();
        }
        String messageTemplate = "";
        if (this._argCount > 0) {
            String quoteStylePatt = this.getQuoteStylePattern(locale);
            String oneItemPatt = this.getOneItemPattern(locale);
            String twoItemPatt = this.getTwoItemPattern(locale);
            String firstItemPatt = this.getFirstItemPattern(locale);
            String nextItemPatt = this.getNextItemPattern(locale);
            String lastItemPatt = this.getLastItemPattern(locale);
            String pattern = null;
            Object[] arguments = new Object[this._argCount];
            if (this._argCount == 1 && oneItemPatt != null) {
                pattern = oneItemPatt;
                arguments[0] = MessageFormat.format(quoteStylePatt, "{0}");
            } else if (this._argCount == 2 && twoItemPatt != null) {
                pattern = twoItemPatt;
                arguments[0] = MessageFormat.format(quoteStylePatt, "{0}");
                arguments[1] = MessageFormat.format(quoteStylePatt, "{1}");
            } else {
                for (int i = 0; i < this._argCount; ++i) {
                    String nextPlaceholder = "{" + i + "}";
                    pattern = i == 0 ? MessageFormat.format(firstItemPatt, nextPlaceholder) : (i + 1 == this._argCount ? MessageFormat.format(lastItemPatt, pattern, nextPlaceholder) : MessageFormat.format(nextItemPatt, pattern, nextPlaceholder));
                    arguments[i] = MessageFormat.format(quoteStylePatt, nextPlaceholder);
                }
            }
            messageTemplate = MessageFormat.format(pattern, arguments);
        }
        return messageTemplate;
    }

    private String getOneItemPattern(Locale locale) {
        String oneItemPatt = null;
        if (this._one instanceof LocalizableToStringInterface) {
            oneItemPatt = ((LocalizableToStringInterface)this._one).toString(locale);
        } else if (this._one != null) {
            oneItemPatt = this._one.toString();
        } else {
            switch (this._listStyle) {
                case NONE: {
                    oneItemPatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.NONE.OnlyOneValue.fmt.txt", locale);
                    break;
                }
                case LONG: {
                    oneItemPatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.LONG.OnlyOneValue.fmt.txt", locale);
                    break;
                }
                case SHORT: {
                    oneItemPatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.SHORT.OnlyOneValue.fmt.txt", locale);
                    break;
                }
                default: {
                    oneItemPatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.ONEPERLINE.OnlyOneValue.fmt.txt", locale);
                }
            }
        }
        return oneItemPatt;
    }

    private String getTwoItemPattern(Locale locale) {
        String twoItemPatt = null;
        if (this._two instanceof LocalizableToStringInterface) {
            twoItemPatt = ((LocalizableToStringInterface)this._two).toString(locale);
        } else if (this._two != null) {
            twoItemPatt = this._two.toString();
        } else {
            switch (this._listStyle) {
                case NONE: {
                    twoItemPatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.NONE.OnlyTwoValues.fmt.txt", locale);
                    break;
                }
                case LONG: {
                    twoItemPatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.LONG.OnlyTwoValues.fmt.txt", locale);
                    break;
                }
                case SHORT: {
                    twoItemPatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.SHORT.OnlyTwoValues.fmt.txt", locale);
                    break;
                }
                default: {
                    twoItemPatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.ONEPERLINE.OnlyTwoValues.fmt.txt", locale);
                }
            }
        }
        return twoItemPatt;
    }

    private String getFirstItemPattern(Locale locale) {
        String firstItemPatt = null;
        if (this._first instanceof LocalizableToStringInterface) {
            firstItemPatt = ((LocalizableToStringInterface)this._first).toString(locale);
        } else if (this._first != null) {
            firstItemPatt = this._first.toString();
        } else {
            switch (this._listStyle) {
                case NONE: {
                    firstItemPatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.NONE.AddFirstValue.fmt.txt", locale);
                    break;
                }
                case LONG: {
                    firstItemPatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.LONG.AddFirstValue.fmt.txt", locale);
                    break;
                }
                case SHORT: {
                    firstItemPatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.SHORT.AddFirstValue.fmt.txt", locale);
                    break;
                }
                default: {
                    firstItemPatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.ONEPERLINE.AddFirstValue.fmt.txt", locale);
                }
            }
        }
        return firstItemPatt;
    }

    private String getNextItemPattern(Locale locale) {
        String nextItemPatt = null;
        if (this._next instanceof LocalizableToStringInterface) {
            nextItemPatt = ((LocalizableToStringInterface)this._next).toString(locale);
        } else if (this._next != null) {
            nextItemPatt = this._next.toString();
        } else {
            switch (this._listStyle) {
                case NONE: {
                    nextItemPatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.NONE.AddAnotherValue.fmt.txt", locale);
                    break;
                }
                case LONG: {
                    nextItemPatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.LONG.AddAnotherValue.fmt.txt", locale);
                    break;
                }
                case SHORT: {
                    nextItemPatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.SHORT.AddAnotherValue.fmt.txt", locale);
                    break;
                }
                default: {
                    nextItemPatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.ONEPERLINE.AddAnotherValue.fmt.txt", locale);
                }
            }
        }
        return nextItemPatt;
    }

    private String getLastItemPattern(Locale locale) {
        String lastItemPatt = null;
        if (this._last instanceof LocalizableToStringInterface) {
            lastItemPatt = ((LocalizableToStringInterface)this._last).toString(locale);
        } else if (this._last != null) {
            lastItemPatt = this._last.toString();
        } else {
            switch (this._listStyle) {
                case NONE: {
                    lastItemPatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.NONE.AddLastValue.fmt.txt", locale);
                    break;
                }
                case LONG: {
                    lastItemPatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.LONG.AddLastValue.fmt.txt", locale);
                    break;
                }
                case SHORT: {
                    lastItemPatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.SHORT.AddLastValue.fmt.txt", locale);
                    break;
                }
                default: {
                    lastItemPatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.ONEPERLINE.AddLastValue.fmt.txt", locale);
                }
            }
        }
        return lastItemPatt;
    }

    private String getQuoteStylePattern(Locale locale) {
        String quoteStylePatt = null;
        switch (this._quoteStyle) {
            case SINGLECHAR: {
                quoteStylePatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.QuotedStyle.SINGLECHAR.fmt.txt", locale);
                break;
            }
            case TEXT: {
                quoteStylePatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.QuotedStyle.TEXT.fmt.txt", locale);
                break;
            }
            case NUMBER: {
                quoteStylePatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.QuotedStyle.NUMBER.fmt.txt", locale);
                break;
            }
            default: {
                quoteStylePatt = IQMetadataResourceBundle.getStringResource("ArrayMessageFormatter.QuotedStyle.NONE.fmt.txt", locale);
            }
        }
        quoteStylePatt = quoteStylePatt.replaceAll("'", "''");
        return quoteStylePatt;
    }

    @Override
    public String getMessageInfo() {
        String def = "Array Size: " + this._argCount + ", quoteStyle: " + (Object)((Object)this._quoteStyle) + ", listStyle: " + (Object)((Object)this._listStyle) + ", one: " + this._one + ", two: " + this._two + ", first: " + this._first + ", next: " + this._next + ", last: " + this._last + ", generated template: [" + this.getTemplate(null) + "]";
        return def;
    }

    public ListStyle getListStyle() {
        return this._listStyle;
    }

    public void setListStyle(ListStyle listStyle) {
        this._listStyle = listStyle;
    }

    public QuoteStyle getQuoteStyle() {
        return this._quoteStyle;
    }

    public void setQuoteStyle(QuoteStyle quoteStyle) {
        this._quoteStyle = quoteStyle;
    }

    public static enum ListStyle {
        LONG,
        SHORT,
        ONEPERLINE,
        NONE;

    }

    public static enum QuoteStyle {
        NONE,
        NUMBER,
        SINGLECHAR,
        TEXT;

    }
}

