/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.util;

import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.util.impl.MessageFormatter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import org.apache.logging.log4j.Logger;

public final class Preconditions {
    public static <T> T ensureNonNull(T reference) {
        if (reference == null) {
            String msg = IQMetadataResourceBundle.getStringResource("Preconditions.NullObj.txt");
            throw new IQueryServicesIllegalArgumentException(msg);
        }
        return reference;
    }

    public static <T> T ensureNonNull(T reference, Logger logger) {
        if (reference == null) {
            String msg = IQMetadataResourceBundle.getStringResource("Preconditions.NullObj.txt");
            logger.error(msg);
            throw new IQueryServicesIllegalArgumentException(msg);
        }
        return reference;
    }

    public static <T> T ensureNonNull(T reference, String parameterName) {
        if (reference == null) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("Preconditions.NullObj2.fmt.txt", parameterName);
            throw new IQueryServicesIllegalArgumentException(msg);
        }
        return reference;
    }

    public static <T> T ensureNonNullWithMessage(T reference, String key, Object ... args) {
        if (reference == null) {
            MessageFormatter msg = null;
            msg = key != null && !key.isEmpty() ? IQMetadataResourceBundle.getMessageFormatter(key, args) : IQMetadataResourceBundle.getMessageFormatter("Preconditions.NullObj2.fmt.txt", args);
            throw new IQueryServicesIllegalArgumentException(msg);
        }
        return reference;
    }

    public static <T> T ensureNonNull(T reference, String parameterName, Logger logger) {
        if (reference == null) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("Preconditions.NullObj2.fmt.txt", parameterName);
            logger.error((Object)msg);
            throw new IQueryServicesIllegalArgumentException(msg);
        }
        return reference;
    }

    public static <T> void ensureNonNullElements(@NonNull List<? extends T> values) {
        for (T o : values) {
            if (o != null) continue;
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("Preconditions.NullElement.txt", new Object[0]);
            throw new IQueryServicesIllegalArgumentException(msg);
        }
    }

    public static <T> void ensureNonNullElements(@NonNull List<? extends T> values, String listName) {
        for (T o : values) {
            if (o == null) {
                MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("Preconditions.NullElement2.fmt.txt", listName);
                throw new IQueryServicesIllegalArgumentException(msg);
            }
            System.out.println(o);
        }
    }

    public static <T> void ensureNonNullElements(@NonNull List<? extends T> values, String listName, @NonNull Logger logger) {
        for (T o : values) {
            if (o == null) {
                MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("Preconditions.NullElement2.fmt.txt", listName);
                logger.error((Object)msg);
                throw new IQueryServicesIllegalArgumentException(msg);
            }
            System.out.println(o);
        }
    }

    public static <T> void ensureNonNullTypedElements(@NonNull List<? extends T> values, @NonNull Class<T> type) {
        for (T o : values) {
            if (type.isInstance(o)) continue;
            if (o == null) {
                MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("Preconditions.NullElement.txt", new Object[0]);
                throw new IQueryServicesIllegalArgumentException(msg);
            }
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("Preconditions.InvalidTypeForElement.fmt.txt", type.getName(), o.getClass().getName());
            throw new IQueryServicesIllegalArgumentException(msg);
        }
    }

    public static <T> void ensureNonNullTypedElements(@NonNull List<? extends T> values, @NonNull Class<T> type, @NonNull Logger logger) {
        for (T o : values) {
            if (type.isInstance(o)) continue;
            if (o == null) {
                String msg = IQMetadataResourceBundle.getStringResource("Preconditions.NullElement.txt");
                logger.error(msg);
                throw new IQueryServicesIllegalArgumentException(msg);
            }
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("Preconditions.InvalidTypeForElement.fmt.txt", type.getName(), o.getClass().getName());
            logger.error((Object)msg);
            throw new IQueryServicesIllegalArgumentException(msg);
        }
    }

    public static <T> void ensureNonNullTypedElements(@NonNull List<? extends T> values, @NonNull Class<T> type, @NonNull String listName) {
        for (T o : values) {
            if (type.isInstance(o)) continue;
            if (o == null) {
                MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("Preconditions.NullElement2.fmt.txt", listName);
                throw new IQueryServicesIllegalArgumentException(msg);
            }
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("Preconditions.InvalidTypeForElement2.fmt.txt", listName, type.getName(), o.getClass().getName());
            throw new IQueryServicesIllegalArgumentException(msg);
        }
    }

    public static <T> void ensureNonNullTypedElements(@NonNull List<? extends T> values, @NonNull Class<T> type, @NonNull String listName, @NonNull Logger logger) {
        for (T o : values) {
            if (type.isInstance(o)) continue;
            if (o == null) {
                MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("Preconditions.NullElement2.fmt.txt", listName);
                logger.error((Object)msg);
                throw new IQueryServicesIllegalArgumentException(msg);
            }
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("Preconditions.InvalidTypeForElement2.fmt.txt", listName, type.getName(), o.getClass().getName());
            logger.error((Object)msg);
            throw new IQueryServicesIllegalArgumentException(msg);
        }
    }

    public static void checkExpression(boolean expression) {
        if (!expression) {
            String msg = IQMetadataResourceBundle.getStringResource("Preconditions.Expression.txt");
            throw new IQueryServicesIllegalArgumentException(msg);
        }
    }

    public static void checkExpression(boolean expression, String parameterName) {
        if (!expression) {
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("Preconditions.Expression2.fmt.txt", parameterName);
            throw new IQueryServicesIllegalArgumentException(msg);
        }
    }
}

