/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.util;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.impl.InformationMapImpl2;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.session.SessionContextInterface;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@SASScope
public class PersistenceUtilities {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final int EXISTENCE_RC_OBJ_EXISTS_NO_READMETADATA = -1;
    public static final int EXISTENCE_RC_NO_OBJ_EXISTS = 0;
    public static final int EXISTENCE_RC_OBJ_EXISTS = 1;
    public static final int EXISTENCE_RC_MULTIPLE_OBJS_EXIST = 2;

    public static void exportMap(InformationMap map, int spacesPerIndentation, OutputStream outputStream) throws MetadataException, IOException {
        if (map == null) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("PersistenceUtilities.NullArgInformationMap.txt", new Object[0]));
        }
        if (outputStream == null) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("PersistenceUtilities.NullArgOutputStream.txt", new Object[0]));
        }
        String mapString = PersistenceUtilities.getMapText(map, spacesPerIndentation);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, DEFAULT_ENCODING));
        writer.write(mapString);
        ((Writer)writer).flush();
    }

    public static void exportMap(InformationMap map, int spacesPerIndentation, StringBuffer buf) throws MetadataException {
        if (map == null) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("PersistenceUtilities.NullArgInformationMap.txt", new Object[0]));
        }
        if (buf == null) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("PersistenceUtilities.NullArgStringBuffer.txt", new Object[0]));
        }
        String mapText = PersistenceUtilities.getMapText(map, spacesPerIndentation);
        buf.append(mapText);
    }

    public static String getMapText(InformationMap map, int spacesPerIndentation) throws MetadataException {
        Element bogusParent = IQModelImplUtilities.newDocumentWithElementName("BogusElement");
        if (map instanceof InformationMapImpl2) {
            ((InformationMapImpl2)map).loadAllLocalizableProperties();
        }
        Element element = map.write(bogusParent);
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version='1.0' encoding='UTF-8'?>");
        if (spacesPerIndentation != 0) {
            buf.append('\n');
        }
        buf.append(IQModelImplUtilities.toPrettyString(element, spacesPerIndentation));
        String exportedXml = buf.toString();
        return exportedXml;
    }

    public static InformationMap importMap(String xmlText, SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, String reposName) throws MetadataException, IOException {
        InformationMapImpl2.FactoryResultsImpl results = InformationMapImpl2.readInNewMap(xmlText, service, session, true, false, Collections.EMPTY_LIST, false, null);
        return results.getMap();
    }

    public static InformationMap importMap(InputStream inputStream, SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, String reposName) throws MetadataException, IOException {
        Document doc = IQModelImplUtilities.newDocument(inputStream);
        Element documentElement = doc.getDocumentElement();
        InformationMapImpl2 newMap = InformationMapImpl2.readInNewMap(documentElement, new HashMap(), service, session);
        return newMap;
    }

    public static List<Element> getQueryElementsWithin(Element element) throws MetadataException {
        if (element == null) {
            MessageFormatter formatter = IQMetadataResourceBundle.getMessageFormatter("PersistenceUtilities.AllArgumentsMustBeSpecified.txt", new Object[0]);
            throw new IQueryServicesIllegalArgumentException(formatter);
        }
        ArrayList<Element> out = new ArrayList<Element>();
        if (PersistenceUtilities.isRecognizedAsIQQueryElement(element)) {
            out.add(element);
        }
        NodeList elements = element.getElementsByTagName("DataSelection");
        for (int i = 0; i < elements.getLength(); ++i) {
            Element e = (Element)elements.item(i);
            if (!PersistenceUtilities.isRecognizedAsIQQueryElement(e)) continue;
            out.add(e);
        }
        return out;
    }

    public static List<String> getReferencesToInfoMapsForQueryElement(Element queryElement) throws MetadataException {
        if (queryElement == null) {
            MessageFormatter formatter = IQMetadataResourceBundle.getMessageFormatter("PersistenceUtilities.AllArgumentsMustBeSpecified.txt", new Object[0]);
            throw new IQueryServicesIllegalArgumentException(formatter);
        }
        ArrayList<String> out = new ArrayList<String>(1);
        String mapPath = PersistenceUtilities.getMapPath(queryElement);
        if (mapPath != null) {
            out.add(mapPath);
        }
        return out;
    }

    private static String getMapPath(Element queryElement) {
        String mapPath = null;
        Element mapLocationElement = PersistenceUtilities.getElementWithMapLocation(queryElement);
        if (mapLocationElement != null && (mapPath = IQModelImplUtilities.getAttr(mapLocationElement, "location")) == null) {
            mapPath = IQModelImplUtilities.getAttr(mapLocationElement, "absolutePathLocation");
        }
        return mapPath;
    }

    private static Element getElementWithMapLocation(Element queryElement) {
        Element out = null;
        if (PersistenceUtilities.isRecognizedAsIQQueryElement(queryElement)) {
            Element extResources92 = IQModelImplUtilities.getSpecificKidElement(queryElement, "ExternalResources");
            if (extResources92 != null) {
                out = IQModelImplUtilities.getSpecificKidElement(extResources92, "InformationMap");
            } else {
                Element refdBusinessModelsElement = IQModelImplUtilities.getSpecificKidElement(queryElement, "ReferencedBusinessModels");
                if (refdBusinessModelsElement != null) {
                    out = IQModelImplUtilities.getSpecificKidElement(refdBusinessModelsElement, "BusinessModelReferenceInformation");
                }
            }
        }
        return out;
    }

    private static boolean isRecognizedAsIQQueryElement(Element element) {
        String elementName;
        boolean recognized = false;
        if (element != null && "DataSelection".equals(elementName = element.getTagName()) && IQModelImplUtilities.getAttr(element, "nextDefaultID") != null) {
            recognized = true;
        }
        return recognized;
    }

    public static void replaceReferencesToInfoMap(String oldPath, String newPath, Element queryElement) throws MetadataException {
        if (oldPath == null || newPath == null || queryElement == null) {
            MessageFormatter formatter = IQMetadataResourceBundle.getMessageFormatter("PersistenceUtilities.AllArgumentsMustBeSpecified.txt", new Object[0]);
            throw new IQueryServicesIllegalArgumentException(formatter);
        }
        if (!(oldPath.startsWith("SBIP://") && newPath.startsWith("SBIP://") || oldPath.startsWith("/") && newPath.startsWith("/"))) {
            Object[] args = new Object[]{oldPath, newPath};
            MessageFormatter formatter = IQMetadataResourceBundle.getMessageFormatter("PersistenceUtilities.ReplacementPathNotSameFormat.fmt.txt", args);
            throw new IQueryServicesIllegalArgumentException(formatter);
        }
        Element mapLocationElement = PersistenceUtilities.getElementWithMapLocation(queryElement);
        if (mapLocationElement != null) {
            String oldLocation = IQModelImplUtilities.getAttr(mapLocationElement, "location");
            if (oldLocation != null) {
                if (IQModelImplUtilities.same(oldLocation, oldPath)) {
                    IQModelImplUtilities.setAttr(mapLocationElement, "location", newPath);
                }
            } else {
                oldLocation = IQModelImplUtilities.getAttr(mapLocationElement, "absolutePathLocation");
                if (oldLocation != null && IQModelImplUtilities.same(oldLocation, oldPath)) {
                    IQModelImplUtilities.setAttr(mapLocationElement, "absolutePathLocation", newPath);
                }
            }
        }
    }

    public static void replaceReferencesToInfoMap(String oldPath, PathUrl newPath, Element queryElement) throws MetadataException {
        if (oldPath == null || newPath == null || queryElement == null) {
            MessageFormatter formatter = IQMetadataResourceBundle.getMessageFormatter("PersistenceUtilities.AllArgumentsMustBeSpecified.txt", new Object[0]);
            throw new IQueryServicesIllegalArgumentException(formatter);
        }
        if (oldPath.startsWith("/")) {
            String path = newPath.getAbsolutePath();
            PersistenceUtilities.replaceReferencesToInfoMap(oldPath, path, queryElement);
        } else if (oldPath.startsWith("SBIP://")) {
            String path = newPath.toString();
            PersistenceUtilities.replaceReferencesToInfoMap(oldPath, path, queryElement);
        }
    }

    public static int checkExistence(String path, SessionContextInterface session) throws MetadataException {
        int rc;
        block12: {
            if (path == null || session == null) {
                MessageFormatter formatter = IQMetadataResourceBundle.getMessageFormatter("PersistenceUtilities.AllArgumentsMustBeSpecified.txt", new Object[0]);
                throw new IQueryServicesIllegalArgumentException(formatter);
            }
            try {
                rc = 1;
                if (path.startsWith("SBIP://")) {
                    IQModelImplUtilities.pathUrlToMetadataInterface(session, new PathUrl(path), true);
                    break block12;
                }
                if (path.startsWith("/")) {
                    MetadataServerInterface msi = IQModelImplUtilities.getMetadataServerAuthenticatedWith(session);
                    IQModelImplUtilities.absolutePathToMetadataInterface(session, path, (ServerInterface)msi, true);
                    break block12;
                }
                Object[] args = new Object[]{path};
                MessageFormatter formatter = IQMetadataResourceBundle.getMessageFormatter("PersistenceUtilities.PathNotRecognized.fmt.txt", args);
                throw new IQueryServicesIllegalArgumentException(formatter);
            }
            catch (MetadataException e) {
                Reason reason;
                rc = 0;
                List<Reason> reasons = e.getReasons();
                Reason reason2 = reason = reasons.isEmpty() ? null : reasons.get(0);
                if (reason != null) {
                    if (reason.getReason() == 9) {
                        int subreason = reason.getSubReason();
                        if (subreason == 215) {
                            rc = -1;
                        } else if (subreason == 217) {
                            rc = 2;
                        }
                    }
                }
                throw e;
            }
            catch (ServiceException e) {
                throw new MetadataException(e);
            }
            catch (RemoteException e) {
                throw new MetadataException(e);
            }
        }
        return rc;
    }

    public static boolean isUnresolved(BusinessItem item, boolean recursive) {
        boolean isUnresolved = true;
        if (item != null) {
            isUnresolved = item.isUnresolved();
            if (recursive && !isUnresolved) {
                List<BusinessModelResource> resources = item instanceof AbstractModelItem ? ((AbstractModelItem)((Object)item)).getResources(BusinessModelResource.class, 65535, true) : item.getResources(BusinessModelResource.class, 65535);
                Iterator<BusinessModelResource> it = resources.iterator();
                while (it.hasNext() && !isUnresolved) {
                    BusinessModelResource bmRes = it.next();
                    isUnresolved = bmRes.isUnresolved();
                }
            }
        }
        return isUnresolved;
    }

    public static Set<BusinessModelResource> getUnresolvedBusinessResource(BusinessModel dm) {
        HashSet<BusinessModelResource> unresolvedObjs = new HashSet<BusinessModelResource>();
        if (dm != null) {
            for (BusinessModel parentModel = dm.getParentBusinessModel(); parentModel != null; parentModel = parentModel.getParentBusinessModel()) {
                unresolvedObjs.addAll(parentModel.getUnresolvedResources());
            }
            unresolvedObjs.addAll(dm.getUnresolvedResources());
        }
        return unresolvedObjs;
    }

    public static Set<BusinessItem> getUnusableBusinessItems(BusinessModel dm, boolean recursive) {
        HashSet<BusinessItem> unusableBi = new HashSet<BusinessItem>();
        if (dm != null) {
            List<BusinessItem> allBusinessItems = dm.getObjects(false, BusinessItem.class);
            for (BusinessItem biObject : allBusinessItems) {
                if (!PersistenceUtilities.isUnresolved(biObject, recursive)) continue;
                unusableBi.add(biObject);
            }
        }
        return unusableBi;
    }
}

