/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.util;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.services.ServiceException;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.Locale;
import net.jcip.annotations.Immutable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
@Immutable
public final class LocaleUtilities {
    private static final Logger _logger = LogManager.getLogger(LocaleUtilities.class);

    private LocaleUtilities() {
    }

    public static Locale SetDefaultViewerLocale(SessionContextInterface session, Locale newLocale) throws MetadataException {
        UserContextInterface userContext;
        if (session == null) {
            throw new MetadataException(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnNoSessionContextFoundForGetLocale.txt"));
        }
        try {
            userContext = session.getUserContext();
        }
        catch (IllegalStateException e) {
            throw new MetadataException(e);
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        if (userContext == null) {
            throw new MetadataException(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnNoUserContextFoundForSetLocale.txt"));
        }
        Locale oldLocale = LocaleUtilities.getDefaultViewerLocale(session);
        try {
            userContext.setLocale(newLocale);
        }
        catch (ServiceException e) {
            throw new MetadataException(e);
        }
        catch (RemoteException e) {
            throw new MetadataException(e);
        }
        return oldLocale;
    }

    public static Locale getDefaultViewerLocale(BusinessModel businessModel) {
        Locale locale = null;
        if (businessModel == null) {
            _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnNoBusinessModelFoundForGetLocale.txt"));
        } else {
            SessionContextInterface session = businessModel.getSession();
            locale = LocaleUtilities._getDefaultViewerLocale(session);
            if (locale == null) {
                locale = businessModel.getComputationalLocale();
            }
        }
        if (locale == null) {
            _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnVisualLocaleWillBeDefaultJavaVMLocale.txt"));
            locale = LocaleUtilities.getDefaultViewerLocale();
        }
        return locale;
    }

    public static Locale getDefaultViewerLocale(SessionContextInterface session) {
        Locale locale = LocaleUtilities._getDefaultViewerLocale(session);
        if (locale == null) {
            _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnVisualLocaleWillBeDefaultJavaVMLocale.txt"));
            locale = LocaleUtilities.getDefaultViewerLocale();
        }
        return locale;
    }

    public static Locale getDefaultViewerLocale(UserContextInterface userContext) {
        Locale locale = LocaleUtilities._getDefaultViewerLocale(userContext);
        if (locale == null) {
            _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnVisualLocaleWillBeDefaultJavaVMLocale.txt"));
            locale = LocaleUtilities.getDefaultViewerLocale();
        }
        return locale;
    }

    private static Locale _getDefaultViewerLocale(SessionContextInterface session) {
        Locale locale = null;
        if (session == null) {
            _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnNoSessionContextFoundForGetLocale.txt"));
        } else {
            try {
                UserContextInterface userContext = session.getUserContext();
                locale = LocaleUtilities._getDefaultViewerLocale(userContext);
            }
            catch (IllegalStateException e) {
                _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnSessionGetUserContextError.txt"), (Throwable)e);
            }
            catch (RemoteException e) {
                _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnSessionGetUserContextError.txt"), (Throwable)e);
            }
        }
        return locale;
    }

    private static Locale _getDefaultViewerLocale(UserContextInterface userContext) {
        Locale locale = null;
        if (userContext == null) {
            _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnNoUserContextFoundForGetLocale.txt"));
        } else {
            try {
                locale = userContext.getLocale();
            }
            catch (ServiceException e) {
                _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnUserContextGetLocaleError.txt="), (Throwable)e);
            }
            catch (RemoteException e) {
                _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnUserContextGetLocaleError.txt="), (Throwable)e);
            }
            catch (IllegalStateException e) {
                _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnUserContextGetLocaleError.txt="), (Throwable)e);
            }
        }
        return locale;
    }

    public static Locale getDefaultViewerLocale() {
        Locale locale = Locale.getDefault();
        return locale;
    }

    public static Locale getDefaultComputationalLocale() {
        Locale locale = Locale.getDefault();
        return locale;
    }

    public static Locale getDefaultComputationalLocale(BusinessModel businessModel) {
        Locale locale = null;
        if (businessModel == null) {
            _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnNoBusinessModelFoundForGetLocale.txt"));
        } else {
            locale = businessModel.getComputationalLocale();
            if (locale == null) {
                SessionContextInterface session = businessModel.getSession();
                locale = LocaleUtilities._getDefaultComputationalLocale(session);
            }
        }
        if (locale == null) {
            _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnComputationalLocaleWillBeDefaultJavaVMLocale.txt"));
            locale = LocaleUtilities.getDefaultComputationalLocale();
        }
        return locale;
    }

    public static Locale getDefaultComputationalLocale(SessionContextInterface session) {
        Locale locale = LocaleUtilities._getDefaultComputationalLocale(session);
        if (locale == null) {
            _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnComputationalLocaleWillBeDefaultJavaVMLocale.txt"));
            locale = LocaleUtilities.getDefaultComputationalLocale();
        }
        return locale;
    }

    private static Locale _getDefaultComputationalLocale(SessionContextInterface session) {
        Locale locale = null;
        if (session == null) {
            _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnNoSessionContextFoundForGetLocale.txt"));
        } else {
            try {
                UserContextInterface userContext = session.getUserContext();
                locale = LocaleUtilities._getDefaultComputationalLocale(userContext);
            }
            catch (IllegalStateException e) {
                _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnSessionGetUserContextError.txt"), (Throwable)e);
            }
            catch (RemoteException e) {
                _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnSessionGetUserContextError.txt"), (Throwable)e);
            }
        }
        return locale;
    }

    public static Locale getDefaultComputationalLocale(UserContextInterface userContext) {
        Locale locale = LocaleUtilities._getDefaultViewerLocale(userContext);
        if (locale == null) {
            _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnVisualLocaleWillBeDefaultJavaVMLocale.txt"));
            locale = LocaleUtilities.getDefaultViewerLocale();
        }
        return locale;
    }

    private static Locale _getDefaultComputationalLocale(UserContextInterface userContext) {
        Locale locale = null;
        if (userContext == null) {
            _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnNoUserContextFoundForGetLocale.txt"));
        } else {
            try {
                locale = userContext.getLocale();
            }
            catch (ServiceException e) {
                _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnUserContextGetLocaleError.txt="), (Throwable)e);
            }
            catch (RemoteException e) {
                _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnUserContextGetLocaleError.txt="), (Throwable)e);
            }
            catch (IllegalStateException e) {
                _logger.warn(IQMetadataResourceBundle.getStringResource("LocaleUtilities.WarnUserContextGetLocaleError.txt="), (Throwable)e);
            }
        }
        return locale;
    }

    public static Locale getDefaultPersistenceLocale() {
        return Locale.getDefault();
    }
}

