/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.util;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.CompoundFilter;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceRelationalQuery;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.ExplicitJoinPathSupport;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.JoinType;
import com.sas.iquery.metadata.business.JoinTypeList;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.RootDataItem;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.SetOperationDataSelection;
import com.sas.iquery.metadata.business.SetOperationType;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.MultipleConditionalExpression;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.util.DataSelectionUtilities;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class FilterOptimizer {
    private static final Logger _logger = LogManager.getLogger((String)"FilterOptimizer.class");
    private InformationMap _informationMap;
    private List _subjectItems;
    private Map<FilterItem, Object> _filterToValueMap;
    private List<FilterItem> _negatedFilters;
    private boolean _isSetOpInline;
    private boolean _isOptimizeEquivalentFilters;
    private int _filterIDIndex;
    private List _createdObjects;
    private int _maximumTableReferences = Integer.MAX_VALUE;
    private boolean _isJoinWidened;

    public FilterOptimizer(InformationMap informationMap, List subjectItems) {
        this._informationMap = informationMap;
        this._subjectItems = subjectItems;
        this._filterToValueMap = new HashMap<FilterItem, Object>();
        this._negatedFilters = new ArrayList<FilterItem>();
        this._isSetOpInline = true;
        this._isOptimizeEquivalentFilters = true;
        this._filterIDIndex = 0;
        this._createdObjects = new ArrayList();
        this._isJoinWidened = false;
    }

    public FilterItem createFilter(DataSelection selection, boolean isNegated) throws MetadataException {
        FilterItem returnItem = this._informationMap.newFilterItem();
        this._informationMap.addBusinessItem(returnItem);
        this._createdObjects.add(returnItem);
        StringExpression stringExpression = new StringExpression();
        stringExpression.setText("" + this._filterIDIndex++);
        returnItem.setExpression(stringExpression);
        this._filterToValueMap.put(returnItem, selection);
        if (isNegated) {
            this._negatedFilters.add(returnItem);
        }
        return returnItem;
    }

    public FilterItem createFilter(String tableName, String libraryName, boolean isNegated) throws MetadataException {
        return this.createFilter(tableName, libraryName, null, isNegated);
    }

    public FilterItem createFilter(String tableName, String libraryName, List columnNames, boolean isNegated) throws MetadataException {
        FilterItem returnItem = this._informationMap.newFilterItem();
        this._informationMap.addBusinessItem(returnItem);
        this._createdObjects.add(returnItem);
        StringExpression stringExpression = new StringExpression();
        stringExpression.setText("" + this._filterIDIndex++);
        returnItem.setExpression(stringExpression);
        List newDataItems = DataSelectionUtilities.getDataItemsForPhysicalTable(tableName, libraryName, columnNames, this._subjectItems, this._createdObjects);
        this._filterToValueMap.put(returnItem, newDataItems);
        if (isNegated) {
            this._negatedFilters.add(returnItem);
        }
        return returnItem;
    }

    public FilterItem createFilter(String tableName, String libraryName, List columnNames, boolean isNegated, List alternateSubjectItems) throws MetadataException {
        FilterItem returnItem = this._informationMap.newFilterItem();
        this._informationMap.addBusinessItem(returnItem);
        this._createdObjects.add(returnItem);
        StringExpression stringExpression = new StringExpression();
        stringExpression.setText("" + this._filterIDIndex++);
        returnItem.setExpression(stringExpression);
        List newAlternateDataItems = DataSelectionUtilities.getDataItemsForPhysicalTable(tableName, libraryName, columnNames, alternateSubjectItems, this._createdObjects);
        DataSelection mappingSelection = DataSelectionFactory.newDataSelection(this._informationMap);
        this._createdObjects.add(mappingSelection);
        mappingSelection.addResultItems(this._subjectItems, Role.COLUMN);
        mappingSelection.addResultItems(newAlternateDataItems, Role.HIDDEN);
        for (DataItem item : this._subjectItems) {
            item.setUsage(DataItemActionType.USAGE_DETAIL);
        }
        DataSourceRelationalQuery unjoindDataSource = this._informationMap.newDataSourceRelationalQuery(mappingSelection);
        this._informationMap.addDataSource(unjoindDataSource);
        this._createdObjects.add(unjoindDataSource);
        unjoindDataSource.setLabel("MapToSubject");
        DataSelection mappedSelection = DataSelectionFactory.newDataSelection(this._informationMap);
        this._createdObjects.add(mappedSelection);
        List<Column> columns = unjoindDataSource.getColumns();
        for (Column column : columns) {
            RootDataItem itemFromSelection = this._informationMap.newDataItem();
            itemFromSelection.setExpression(column);
            String id = column.getSasName();
            itemFromSelection.setLabel(id);
            this._informationMap.addBusinessItem(itemFromSelection);
            this._createdObjects.add(itemFromSelection);
            for (DataItem item : this._subjectItems) {
                String rsId = item.getResultSetID();
                if (!rsId.equalsIgnoreCase(id)) continue;
                DataItemReference businessItem = mappedSelection.newDataItemReference(itemFromSelection);
                mappedSelection.addBusinessItem(businessItem);
                mappedSelection.addResultItem(businessItem, Role.COLUMN);
            }
        }
        ArrayList<QualifiedColumn> keyColumns = new ArrayList<QualifiedColumn>();
        for (DataItem keyItem : this._subjectItems) {
            QualifiedColumn column = DataSelectionUtilities.getColumnFromItem(keyItem);
            keyColumns.add(column);
        }
        DataSourceTable subjectTable = (DataSourceTable)((Column)keyColumns.get(0)).getOwningTable();
        Join join = DataSelectionUtilities.addNewJoin(unjoindDataSource, keyColumns, subjectTable, JoinType.INNER);
        join.setAllowedTypes(JoinTypeList.ALL_JOIN_TYPES);
        this._createdObjects.add(join);
        List<DataItem> newDataItems = mappedSelection.getResultItems(Role.COLUMN);
        this._filterToValueMap.put(returnItem, newDataItems);
        if (isNegated) {
            this._negatedFilters.add(returnItem);
        }
        return returnItem;
    }

    public boolean isFilterBeingOptimized(FilterItem item) {
        return this._filterToValueMap.containsKey(item);
    }

    public boolean isJoinWidening() {
        return this._isJoinWidened;
    }

    public void setJoinWidening(boolean widenJoin) {
        this._isJoinWidened = widenJoin;
    }

    public boolean isSetOperationInline() {
        return this._isSetOpInline;
    }

    public void setSetOperationInline(boolean isSetOpInline) {
        this._isSetOpInline = isSetOpInline;
    }

    public int getMaximumTableReferences() {
        return this._maximumTableReferences;
    }

    public void setMaximumTableReferences(int maximumTableReferences) {
        this._maximumTableReferences = maximumTableReferences;
    }

    public void close() throws MetadataException {
        for (Object object : this._createdObjects) {
            if (object instanceof DataSource) {
                this._informationMap.removeDataSource((DataSource)object);
                continue;
            }
            if (object instanceof Join) {
                this._informationMap.removeBusinessRule((Join)object);
                continue;
            }
            if (object instanceof BusinessItem) {
                this._informationMap.removeBusinessItem((BusinessItem)object);
                continue;
            }
            if (object instanceof DataSelection) {
                ((DataSelection)object).dispose();
                continue;
            }
            if (!(object instanceof FilterOptimizer)) continue;
            ((FilterOptimizer)object).close();
        }
    }

    public DataSelection addFilterAndExportFilterItem(DataSelection inputSelection, List filters, String scoreColName) throws MetadataException {
        DataSelection outSelection = null;
        if (inputSelection == null) {
            outSelection = DataSelectionFactory.newDataSelection(this._informationMap);
            outSelection.setQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES, true);
            this._addEquivalentResultItems(outSelection, this._subjectItems, Role.COLUMN);
        } else {
            outSelection = inputSelection;
        }
        if (!outSelection.isValid()) {
            MetadataException me = this._constructExceptionWithReasons(outSelection);
            throw me;
        }
        if (outSelection instanceof SetOperationDataSelection) {
            outSelection = DataSelectionUtilities.createDataSourceRelationalQuery(outSelection, this._createdObjects);
            outSelection.setQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES, true);
            this._joinSubjectWithDSRQ(outSelection);
        }
        if (filters == null || filters.size() < 1) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("FilterOptimizer.invalid.inputFilter.txt", new Object[0]));
        }
        FilterItem filter = (FilterItem)filters.get(0);
        List<DataItem> filterItems = filter.getDataItems(0);
        if (filterItems == null || filterItems.size() < 1) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("FilterOptimizer.invalid.exportFilter.txt", new Object[0]));
        }
        DataItem di1 = filterItems.get(0);
        List<QualifiedColumn> qualifiedColumns = di1.getResources(QualifiedColumn.class, 65535);
        if (qualifiedColumns.isEmpty()) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("FilterOptimizer.filterDataItem.noQualColumn.txt", new Object[0]));
        }
        DataSourceTable scoringDST = qualifiedColumns.get(0).getDataSource();
        for (FilterItem clientsFilter : filters) {
            DataSelection innerQuery = DataSelectionFactory.newDataSelection(this._informationMap);
            this._createdObjects.add(innerQuery);
            FilterItem modelFilter = DataSelectionUtilities.copyFilter(innerQuery, clientsFilter);
            innerQuery.addDataSource(scoringDST);
            innerQuery.addBusinessItem(modelFilter);
            List<FilterItem> modelFilters = innerQuery.getFilters();
            modelFilters.add(modelFilter);
            innerQuery.setFilters(modelFilters);
            innerQuery.setQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES, true);
            if (this._subjectItems == null || this._subjectItems.size() < 1) {
                throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("FilterOptimizer.invalid.subjectList.txt", new Object[0]));
            }
            for (DataItem subjItem : this._subjectItems) {
                DataItem dataItem = DataSelectionUtilities.getNearlyEquivalentDataItem(innerQuery, subjItem);
                this._createdObjects.add(dataItem);
                dataItem.setResultSetID(subjItem.getResultSetID());
                dataItem.setFormat(subjItem.getFormat());
                dataItem.setFormattingForced(subjItem.isFormattingForced());
                dataItem.setUsage(DataItemActionType.USAGE_DETAIL);
                innerQuery.addResultItem(dataItem, Role.COLUMN);
            }
            List<Column> scoringColumns = scoringDST.getColumns();
            for (QualifiedColumn qualifiedColumn : scoringColumns) {
                if (!scoreColName.equalsIgnoreCase(qualifiedColumn.getSasName())) continue;
                RootDataItem innerScore = innerQuery.newDataItem();
                innerScore.setExpression(qualifiedColumn);
                innerScore.setLabel(qualifiedColumn.getLabel());
                innerScore.setResultSetID(qualifiedColumn.getSasName());
                innerScore.setFormat(qualifiedColumn.getSasFormat());
                innerScore.setUsage(DataItemActionType.USAGE_DETAIL);
                innerQuery.addBusinessItem(innerScore);
                innerQuery.addResultItem(innerScore, Role.COLUMN);
                break;
            }
            DataSourceRelationalQuery dsrq = outSelection.newDataSourceRelationalQuery(innerQuery);
            outSelection.addDataSource(dsrq);
            this._createdObjects.add(dsrq);
            List<Column> list = dsrq.getColumns();
            for (Column dsrqCol : list) {
                if (!this._isaScoreCol(dsrqCol, scoreColName)) continue;
                RootDataItem outerScore = outSelection.newDataItem();
                outerScore.setExpression(dsrqCol);
                outerScore.setFormat(dsrqCol.getSasFormat());
                outerScore.setUsage(DataItemActionType.USAGE_DETAIL);
                outerScore.setLabel(dsrqCol.getLabel());
                outSelection.addBusinessItem(outerScore);
                outSelection.addResultItem(outerScore, Role.COLUMN);
                this._createdObjects.add(outerScore);
            }
            ArrayList<QualifiedColumn> subjectKeyColumns = new ArrayList<QualifiedColumn>();
            for (DataItem item : this._subjectItems) {
                subjectKeyColumns.add(DataSelectionUtilities.getColumnFromItem(item));
            }
            DataItem keyItem = (DataItem)this._subjectItems.get(0);
            QualifiedColumn qc1 = DataSelectionUtilities.getColumnFromItem(keyItem);
            DataSourceTable subjectTable = qc1.getDataSource();
            Join join = DataSelectionUtilities.addNewJoin(dsrq, subjectKeyColumns, subjectTable, JoinType.INNER);
            this._createdObjects.add(join);
            join.setAllowedTypes(JoinTypeList.ALL_JOIN_TYPES);
            RootDataItem dataItem = outSelection.newDataItem();
            this._createdObjects.add(dataItem);
            outSelection.addBusinessItem(dataItem);
            QualifiedColumn qc = (QualifiedColumn)dsrq.getColumns().get(0);
            dataItem.setExpression(qc);
            dataItem.setFormat(qc.getSasFormat());
            dataItem.setUsage(DataItemActionType.USAGE_DETAIL);
            dataItem.setLabel(qc.getLabel());
            outSelection.addResultItem(dataItem, Role.HIDDEN);
        }
        return outSelection;
    }

    private void _joinSubjectWithDSRQ(DataSelection outSelection) throws MetadataException {
        ArrayList<QualifiedColumn> keyColumns = new ArrayList<QualifiedColumn>();
        for (DataItem keyItem : this._subjectItems) {
            QualifiedColumn column = DataSelectionUtilities.getColumnFromItem(keyItem);
            keyColumns.add(column);
        }
        DataSourceTable subjectTable = (DataSourceTable)((Column)keyColumns.get(0)).getOwningTable();
        List<DataSource> dataSources = outSelection.getEffectiveDataSources();
        DataSourceRelationalQuery dsrq = null;
        for (DataSource dataSource : dataSources) {
            if (!(dataSource instanceof DataSourceRelationalQuery)) continue;
            dsrq = (DataSourceRelationalQuery)dataSource;
            Join join = DataSelectionUtilities.addNewJoin(dsrq, keyColumns, subjectTable, JoinType.INNER);
            join.setAllowedTypes(JoinTypeList.ALL_JOIN_TYPES);
            this._createdObjects.add(join);
            break;
        }
    }

    private boolean _isaScoreCol(Column column, String scoreColName) throws MetadataException {
        boolean isaScoreCol = false;
        if (column.getSasName().equalsIgnoreCase(scoreColName)) {
            isaScoreCol = true;
        }
        return isaScoreCol;
    }

    public DataSelection optimizeFilters(DataSelection selection) throws MetadataException {
        List<SelectedItem> origSelectedItems = selection.getSelectedItems();
        if (this.isJoinWidening()) {
            for (SelectedItem selectedItem : origSelectedItems) {
                boolean compareTables;
                DataItem item = selectedItem.getItem();
                int index = this._indexOfSimilarItem(this._subjectItems, item, compareTables = true);
                if (index != -1) continue;
                selection.removeSelectedItem(selectedItem);
            }
        }
        DataSelection returnSelection = this.optimizeFilters(selection, true);
        if (this.isJoinWidening()) {
            returnSelection = this._widenSelection(returnSelection, origSelectedItems);
        }
        return returnSelection;
    }

    public DataSelection optimizeFilters(DataSelection selection, boolean removeOldSelectionFromaMap) throws MetadataException {
        DataSelection returnSelection = selection;
        List<SelectedItem> selectedItems = selection.getSelectedItems();
        DataItem keyItem = (DataItem)this._subjectItems.get(0);
        DataSourceTable subjectTable = DataSelectionUtilities.getDataSourceFromItem(keyItem);
        List level = this._getLevel(selection, subjectTable);
        List resultSetIDs = this._getResultSetIDs(selection);
        if (this._filterToValueMap.size() > 0) {
            List<FilterItem> filters = selection.getFilters();
            if (filters.size() > 1) {
                MultipleConditionalExpression mce = new MultipleConditionalExpression();
                mce.setRelationType(ConditionalRelationType.AND);
                mce.setIsNegated(false);
                for (FilterItem filterItem : filters) {
                    mce.addExpression(filterItem.getExpression());
                }
            }
            if (filters.size() == 1) {
                FilterItem object = filters.get(0);
                if (!(object instanceof CompoundFilter)) {
                    CompoundFilter tempFilter = this._informationMap.newCompoundFilter();
                    this._informationMap.addBusinessItem(tempFilter);
                    this._createdObjects.add(tempFilter);
                    tempFilter.setLeftFilter(object);
                    object = tempFilter;
                }
                CompoundFilter compoundFilter = (CompoundFilter)object;
                selection.setFilters(Collections.emptyList());
                ConditionalRelationType type = compoundFilter.getRelationType();
                if (type == ConditionalRelationType.OR) {
                    returnSelection = this._optimizeOR(compoundFilter, selection, this._subjectItems, level, subjectTable, this._filterToValueMap, new ArrayList());
                } else {
                    ArrayList simpleAndFilters = new ArrayList();
                    this._getSimpleANDFilters(simpleAndFilters, compoundFilter);
                    int numberOfNegatedAndFilters = this._getNumberOfNegatedANDFilters(simpleAndFilters);
                    ArrayList innerUnionForExcept = new ArrayList();
                    returnSelection = this._optimizeAND(compoundFilter, selection, this._subjectItems, level, subjectTable, this._filterToValueMap, innerUnionForExcept, numberOfNegatedAndFilters);
                }
            } else if (selection instanceof SetOperationDataSelection) {
                SetOperationDataSelection setOp = (SetOperationDataSelection)selection;
                boolean childrenChanged = false;
                List<DataSelection> children = setOp.getDataSelections();
                ListIterator<DataSelection> it = children.listIterator();
                while (it.hasNext()) {
                    DataSelection childSelection = it.next();
                    FilterOptimizer optimizer = new FilterOptimizer(this._informationMap, this._subjectItems);
                    this._createdObjects.add(optimizer);
                    optimizer.setFilterToValueMap(this._filterToValueMap);
                    optimizer.setNegatedFilters(this._negatedFilters);
                    DataSelection optimizedSelection = optimizer.optimizeFilters(childSelection);
                    if (optimizedSelection == childSelection) continue;
                    it.remove();
                    it.add(optimizedSelection);
                    childrenChanged = true;
                }
                if (childrenChanged) {
                    setOp.setDataSelections(children);
                }
            }
        }
        if ((returnSelection = this._checkForTableReferenceLimit(returnSelection)) != selection) {
            this._createdObjects.add(selection);
        }
        this._fixResultSetIDs(returnSelection, resultSetIDs, selectedItems);
        return returnSelection;
    }

    public boolean narrowJoins(DataSelection ds) throws MetadataException {
        boolean succeeded = false;
        if (ds instanceof ExplicitJoinPathSupport) {
            for (SelectedItem selectedItem : ds.getSelectedItems()) {
                selectedItem.setJoinBehavior(3);
            }
            ArrayList<Join> newJoins = new ArrayList<Join>();
            try {
                List<Join> joins = ds.getEffectiveJoinPath();
                for (Join join : joins) {
                    Join newJoin = (Join)join.clone();
                    JoinTypeList types = JoinTypeList.ALL_JOIN_TYPES;
                    newJoin.setAllowedTypes(types);
                    newJoin.setType(JoinType.INNER);
                    newJoins.add(newJoin);
                    this._createdObjects.add(newJoin);
                }
                ExplicitJoinPathSupport joinPathSupport = (ExplicitJoinPathSupport)((Object)ds);
                joinPathSupport.setExplicitJoinPath(newJoins);
                succeeded = true;
            }
            catch (CloneNotSupportedException ce) {
                _logger.error("Unable to clone a new join object because it is unsupported.", (Throwable)ce);
            }
        } else {
            _logger.debug("The input data selection is not an instance of ExplicitJoinPathSupport and its joins cannot be narrowed, " + ds.getClass().getName());
        }
        return succeeded;
    }

    private DataSelection _widenSelection(DataSelection selection, List originalSelectedItems) throws MetadataException {
        DataSelection outerSelection = null;
        if (!(selection instanceof SetOperationDataSelection) && selection.getEffectiveJoinPath().isEmpty()) {
            outerSelection = selection;
        } else {
            outerSelection = DataSelectionUtilities.createDataSourceRelationalQuery(selection, this._createdObjects);
            outerSelection.setQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES, true);
            this._joinSubjectWithDSRQ(outerSelection);
        }
        int subjectIndex = this._fixWidenedSelection(originalSelectedItems, outerSelection);
        List<SelectedItem> newSelectedItems = outerSelection.getSelectedItems(Role.COLUMN);
        SelectedItem subjectItem = newSelectedItems.get(subjectIndex);
        subjectItem.setJoinBehavior(4);
        String label = subjectItem.getItem().getLabel();
        if (label == null) {
            label = ".";
        } else if (!label.startsWith(".")) {
            label = "." + label;
        }
        subjectItem.getItem().setLabel(label);
        return outerSelection;
    }

    private int _fixWidenedSelection(List originalSelectedItems, DataSelection outerSelection) throws MetadataException {
        int subjectIndex = 0;
        ArrayList<SelectedItem> originalSelectedItemsOnColumn = new ArrayList<SelectedItem>();
        ArrayList<String> originalSelectionRSIDs = new ArrayList<String>();
        for (SelectedItem selectedItem : originalSelectedItems) {
            DataItem item = selectedItem.getItem();
            if (selectedItem.getRole() != Role.COLUMN) continue;
            originalSelectionRSIDs.add(item.getResultSetID());
            originalSelectedItemsOnColumn.add(selectedItem);
        }
        ArrayList<String> outerSelectionRSIDs = new ArrayList<String>();
        List<SelectedItem> outerSelectedItems = outerSelection.getSelectedItems();
        for (SelectedItem selectedItem : outerSelectedItems) {
            DataItem item = selectedItem.getItem();
            outerSelectionRSIDs.add(item.getResultSetID());
        }
        outerSelection.removeResultItems(outerSelection.getResultItems(Role.COLUMN));
        int index = 0;
        for (SelectedItem selectedItem : originalSelectedItemsOnColumn) {
            DataItem originalSelectedItemOnColumn = selectedItem.getItem();
            String originalSelectedItemOnColumnRSID = originalSelectedItemOnColumn.getResultSetID();
            if (outerSelectionRSIDs.contains(originalSelectedItemOnColumnRSID)) {
                SelectedItem subjectItem = this._getItemByResultSetID(outerSelectedItems, originalSelectedItemOnColumnRSID);
                outerSelection.insertSelectedItemAt(subjectItem, index);
                subjectIndex = index;
            } else {
                SelectedItem newItem = this._copySelectedItem(outerSelection, selectedItem, originalSelectedItemOnColumnRSID);
                outerSelection.insertSelectedItemAt(newItem, index);
            }
            ++index;
        }
        this._modifyItemUsageIfMeasurePresent(outerSelection);
        return subjectIndex;
    }

    private void _modifyItemUsageIfMeasurePresent(DataSelection outerSelection) throws MetadataException {
        if (this._isMeasurePresent(outerSelection)) {
            List<SelectedItem> selectedItems = outerSelection.getSelectedItems();
            for (SelectedItem selectedItem : selectedItems) {
                DataItem dataItem = selectedItem.getItem();
                if (dataItem.getUsage() != DataItemActionType.USAGE_DETAIL || !dataItem.isActionSupported(DataItemActionType.USAGE_CATEGORY)) continue;
                dataItem.setUsage(DataItemActionType.USAGE_CATEGORY);
            }
        }
    }

    private boolean _isMeasurePresent(DataSelection outerSelection) {
        boolean isMeasurePresent = false;
        List<SelectedItem> selectedItems = outerSelection.getSelectedItems();
        for (SelectedItem selectedItem : selectedItems) {
            DataItem dataItem = selectedItem.getItem();
            if (dataItem.getUsage() != DataItemActionType.USAGE_AGGREGATE) continue;
            isMeasurePresent = true;
            break;
        }
        return isMeasurePresent;
    }

    private SelectedItem _getItemByResultSetID(List outerSelectedItems, String originalSelectedItemOnColumnRSID) {
        SelectedItem item = null;
        for (SelectedItem outerItem : outerSelectedItems) {
            String outerRSID = outerItem.getItem().getResultSetID();
            if (!outerRSID.equalsIgnoreCase(originalSelectedItemOnColumnRSID)) continue;
            item = outerItem;
            break;
        }
        return item;
    }

    private SelectedItem _copySelectedItem(DataSelection outerSelection, SelectedItem selectedItem, String resultSetId) throws MetadataException {
        DataItem item = selectedItem.getItem();
        DataItem baseItem = DataSelectionUtilities.getBaseItem(item);
        DataItemReference dir = outerSelection.newDataItemReference(baseItem);
        outerSelection.addBusinessItem(dir);
        Role role = selectedItem.getRole();
        dir.setResultSetID(resultSetId);
        dir.setUsage(item.getUsage());
        dir.setFormat(item.getFormat());
        if (item.getUsage() == DataItemActionType.USAGE_AGGREGATE) {
            Function aggrType = item.getAggregationType();
            if (aggrType != null && !dir.isAggregationTypeSupported(aggrType)) {
                dir.setAggregationTypeSupported(aggrType, true);
            }
            dir.setAggregationType(aggrType);
        }
        SelectedItem newSelectedItem = new SelectedItem(dir, role);
        return newSelectedItem;
    }

    private DataSelection _optimizeOR(CompoundFilter filter, DataSelection parentSelection, List subjectItems, List level, DataSourceTable subjectTable, Map filterToValueMap, List unionChildSelections) throws MetadataException {
        DataSelection returnSelection = parentSelection;
        if (this._isAnyChildInHashMap(filter, filterToValueMap)) {
            ArrayList simpleFilters = new ArrayList();
            ArrayList subqueryFilters = new ArrayList();
            ArrayList nestedFilters = new ArrayList();
            this._splitFilters(filter, subqueryFilters, simpleFilters, nestedFilters, filterToValueMap);
            ArrayList negatedSubqueryFilters = new ArrayList();
            this._splitSubqueryFilters(subqueryFilters, negatedSubqueryFilters);
            SetOperationDataSelection setOp = null;
            boolean firstSetOpSelectionRequiresFilter = false;
            if (parentSelection instanceof SetOperationDataSelection) {
                SetOperationDataSelection parentSetOp = (SetOperationDataSelection)parentSelection;
                if (parentSetOp.getSetOperation() != SetOperationType.UNION) {
                    throw new IQueryServicesRuntimeException(IQMetadataResourceBundle.getStringResource("FilterOptimizerUnionOnly.txt"));
                }
                setOp = parentSetOp;
                if (simpleFilters.size() > 0) {
                    DataSelection contextSelectionForLeveling = this._getContextSelection(parentSelection, unionChildSelections);
                    DataSelection simpleSelection = this._createLevedSelection(contextSelectionForLeveling, subjectItems, level, unionChildSelections, subjectItems);
                    this._orFiltersToSelection(simpleFilters, simpleSelection);
                }
            } else {
                setOp = DataSelectionFactory.getInstance().newSetOperationDataSelection(this._informationMap);
                this._copyQueryProperties(parentSelection, setOp);
                this._createdObjects.add(setOp);
                setOp.setQueryProperty(BusinessQueryProperty.INLINE_SETOPERATIONDATASELECTION, this._isSetOpInline);
                setOp.setSetOperation(SetOperationType.UNION);
                this._levelSelection(null, parentSelection, level, subjectItems);
                unionChildSelections.add(parentSelection);
                this._orFiltersToSelection(simpleFilters, parentSelection);
                firstSetOpSelectionRequiresFilter = true;
            }
            for (FilterItem subQueryFilter : subqueryFilters) {
                Object value = this._getFilterValue(filterToValueMap, subQueryFilter);
                if (value instanceof DataSelection) {
                    DataSelection selection = (DataSelection)value;
                    this._copyQueryProperties(parentSelection, setOp, unionChildSelections);
                    if (selection instanceof SetOperationDataSelection) {
                        SetOperationDataSelection valueSetOp = (SetOperationDataSelection)selection;
                        if (valueSetOp.getSetOperation().equals(SetOperationType.UNION)) {
                            for (DataSelection childSelection : valueSetOp.getDataSelections()) {
                                unionChildSelections.add(childSelection);
                                this._levelSelection(parentSelection, childSelection, level, subjectItems);
                            }
                            continue;
                        }
                        if (selection instanceof SetOperationDataSelection && (((SetOperationDataSelection)selection).getSetOperation() == SetOperationType.EXCEPT || ((SetOperationDataSelection)selection).getSetOperation() == SetOperationType.INTERSECT)) {
                            selection = DataSelectionUtilities.createDataSourceRelationalQuery(selection, this._createdObjects);
                            this._joinSubjectWithDSRQ(selection);
                        } else {
                            selection = DataSelectionUtilities.createDataSourceRelationalQuery(selection);
                            this._createdObjects.add(selection);
                        }
                        this._copyQueryProperties(parentSelection, selection, unionChildSelections);
                        unionChildSelections.add(selection);
                        this._levelSelection(parentSelection, selection, level, subjectItems);
                        continue;
                    }
                    unionChildSelections.add(selection);
                    this._levelSelection(parentSelection, selection, level, subjectItems);
                    continue;
                }
                if (!(value instanceof List)) continue;
                List dataItems = (List)value;
                DataSelection contextSelectionForLeveling = this._getContextSelection(parentSelection, unionChildSelections);
                this._createLevedSelection(contextSelectionForLeveling, dataItems, level, unionChildSelections, subjectItems);
            }
            for (CompoundFilter nestedFilter : nestedFilters) {
                if (nestedFilter.getRelationType() == ConditionalRelationType.OR) {
                    returnSelection = this._optimizeOR(nestedFilter, setOp, subjectItems, level, subjectTable, filterToValueMap, unionChildSelections);
                    continue;
                }
                DataSelection nextQuery = DataSelectionFactory.newDataSelection(this._informationMap);
                this._copyQueryProperties(parentSelection, nextQuery, unionChildSelections);
                this._createdObjects.add(nextQuery);
                nextQuery.setQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES, true);
                List<DataItem> parentResultItems = parentSelection.getResultItems(Role.COLUMN);
                if (parentResultItems.size() == 0 && parentSelection instanceof SetOperationDataSelection && !unionChildSelections.isEmpty()) {
                    parentResultItems = ((DataSelection)unionChildSelections.get(0)).getResultItems(Role.COLUMN);
                }
                ArrayList<DataItem> resultItems = new ArrayList<DataItem>();
                Iterator<DataItem> resultIt = parentResultItems.iterator();
                while (resultIt.hasNext()) {
                    DataItem item = DataSelectionUtilities.getBaseItem(resultIt.next());
                    resultItems.add(item);
                }
                this._addResultItems(nextQuery, resultItems, Role.COLUMN);
                unionChildSelections.add(nextQuery);
                ArrayList simpleAndFilters = new ArrayList();
                this._getSimpleANDFilters(simpleAndFilters, nestedFilter);
                ArrayList innerUnionForExcept = new ArrayList();
                int numberOfNegatedAndFilters = this._getNumberOfNegatedANDFilters(simpleAndFilters);
                returnSelection = this._optimizeAND(nestedFilter, nextQuery, subjectItems, level, subjectTable, filterToValueMap, innerUnionForExcept, numberOfNegatedAndFilters);
                if (!(returnSelection instanceof SetOperationDataSelection)) continue;
                DataSelection temp = DataSelectionUtilities.createDataSourceRelationalQuery(returnSelection);
                int index = unionChildSelections.indexOf(nextQuery);
                unionChildSelections.set(index, temp);
            }
            if (negatedSubqueryFilters.size() > 0) {
                boolean formattedFlag = false;
                if (unionChildSelections.size() > 0) {
                    formattedFlag = ((DataSelection)unionChildSelections.get(0)).getQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA);
                }
                for (FilterItem negatedSubQueryFilter : negatedSubqueryFilters) {
                    Object value = this._getFilterValue(filterToValueMap, negatedSubQueryFilter);
                    DataSelection negatedSelection = this._unionValueToQuery(setOp, subjectItems, value, level, formattedFlag);
                    unionChildSelections.add(negatedSelection);
                }
            }
            if (firstSetOpSelectionRequiresFilter && ((DataSelection)unionChildSelections.get(0)).getFilters().size() == 0) {
                unionChildSelections.remove(0);
            }
            if (unionChildSelections.size() == 1) {
                returnSelection = (DataSelection)unionChildSelections.get(0);
            } else {
                setOp.setDataSelections(unionChildSelections);
                returnSelection = setOp;
            }
        } else {
            ArrayList<CompoundFilter> filters = new ArrayList<CompoundFilter>();
            filters.add(filter);
            if (returnSelection instanceof SetOperationDataSelection) {
                DataSelection selection = DataSelectionFactory.newDataSelection(this._informationMap);
                this._createdObjects.add(selection);
                this._copyQueryProperties(parentSelection, selection, unionChildSelections);
                this._addResultItems(selection, subjectItems, Role.COLUMN);
                unionChildSelections.add(selection);
                this._orFiltersToSelection(filters, selection);
                DataSelection firstSelection = parentSelection;
                if (parentSelection instanceof SetOperationDataSelection && !unionChildSelections.isEmpty()) {
                    firstSelection = (DataSelection)unionChildSelections.get(0);
                }
                this._levelSelection(firstSelection, selection, level, subjectItems);
            } else {
                this._orFiltersToSelection(filters, parentSelection);
            }
        }
        return returnSelection;
    }

    private DataSelection _getContextSelection(DataSelection parentSelection, List unionChildSelections) {
        DataSelection contextSelectionForLeveling = parentSelection;
        if (parentSelection instanceof SetOperationDataSelection && ((SetOperationDataSelection)parentSelection).getDataSelections().size() == 0) {
            contextSelectionForLeveling = (DataSelection)unionChildSelections.get(0);
        }
        return contextSelectionForLeveling;
    }

    private DataSelection _createLevedSelection(DataSelection parentSelection, List dataItems, List level, List unionChildSelections, List subjectItems) throws MetadataException {
        DataSelection selection = DataSelectionFactory.newDataSelection(this._informationMap);
        this._createdObjects.add(selection);
        this._copyQueryProperties(parentSelection, selection, unionChildSelections);
        List<DataItem> parentItems = parentSelection.getResultItems(Role.COLUMN);
        ArrayList<DataItem> baseParentItems = new ArrayList<DataItem>();
        Iterator<DataItem> it = parentItems.iterator();
        while (it.hasNext()) {
            baseParentItems.add(DataSelectionUtilities.getBaseItem(it.next()));
        }
        this._replaceSubjectKeys(dataItems, baseParentItems);
        this._addResultItems(selection, baseParentItems, Role.COLUMN);
        boolean selectionHasOuterJoin = false;
        List<SelectedItem> selectedItems = parentSelection.getSelectedItems();
        for (SelectedItem selectedItem : selectedItems) {
            int joinBehavior = selectedItem.getJoinBehavior();
            if (joinBehavior != 4) continue;
            selectionHasOuterJoin = true;
            break;
        }
        List<DataItem> resultItems = selection.getResultItems();
        if (selectionHasOuterJoin && !resultItems.isEmpty()) {
            DataItem firstSubjectItem = resultItems.get(0);
            firstSubjectItem.setLabel("." + firstSubjectItem.getLabel());
        }
        unionChildSelections.add(selection);
        this._levelSelection(parentSelection, selection, level, subjectItems);
        return selection;
    }

    private void _replaceSubjectKeys(List dataItems, List baseParentItems) throws MetadataException {
        ArrayList<DataItem> baseDataItems = new ArrayList<DataItem>();
        Iterator it = dataItems.iterator();
        while (it.hasNext()) {
            baseDataItems.add(DataSelectionUtilities.getBaseItem((DataItem)it.next()));
        }
        ListIterator<DataItem> baseParentIt = baseParentItems.listIterator();
        block3: while (baseParentIt.hasNext()) {
            DataItem parentItem = (DataItem)baseParentIt.next();
            ExpressionInterface parentExpr = null;
            try {
                parentExpr = DataSelectionUtilities.getColumnFromItem(parentItem);
            }
            catch (MetadataException e) {
                _logger.warn(e.getLocalizedMessage());
                parentExpr = parentItem.getExpression();
            }
            String parentResultText = this._getExpressionText(parentExpr);
            ListIterator baseDataItemIt = baseDataItems.listIterator();
            while (baseDataItemIt.hasNext()) {
                DataItem baseDataItem = (DataItem)baseDataItemIt.next();
                ExpressionInterface baseDataItemExpr = baseDataItem.getExpression();
                String baseDataItemText = this._getExpressionText(baseDataItemExpr);
                if (!baseDataItemText.equals(parentResultText)) continue;
                baseParentIt.set(baseDataItem);
                continue block3;
            }
        }
    }

    private DataSelection _unionValueToQuery(DataSelection parentSelection, List subjectItems, Object value, List level, boolean formattedFlag) throws MetadataException {
        SetOperationDataSelection exceptSetOp = DataSelectionFactory.getInstance().newSetOperationDataSelection(FilterOptimizer._getInformationMap(parentSelection));
        exceptSetOp.setQueryProperty(BusinessQueryProperty.INLINE_SETOPERATIONDATASELECTION, this._isSetOpInline);
        exceptSetOp.setSetOperation(SetOperationType.EXCEPT);
        this._copyQueryProperties(parentSelection, exceptSetOp);
        this._createdObjects.add(exceptSetOp);
        DataSelection allSubjectSelection = DataSelectionFactory.newDataSelection(FilterOptimizer._getInformationMap(parentSelection));
        this._copyQueryProperties(parentSelection, allSubjectSelection);
        allSubjectSelection.setQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA, formattedFlag);
        this._createdObjects.add(allSubjectSelection);
        this._addResultItems(allSubjectSelection, subjectItems, Role.COLUMN);
        this._levelSelection(parentSelection, allSubjectSelection, level, subjectItems);
        DataSelection negatedSelection = this._createSelectionForNegatedFilter(parentSelection, value);
        negatedSelection.setQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA, formattedFlag);
        ArrayList<DataSelection> exceptChildSelections = new ArrayList<DataSelection>();
        exceptChildSelections.add(allSubjectSelection);
        exceptChildSelections.add(negatedSelection);
        exceptSetOp.setDataSelections(exceptChildSelections);
        DataSelection returnSelection = DataSelectionUtilities.createDataSourceRelationalQuery(exceptSetOp);
        this._createdObjects.add(returnSelection);
        this._copyQueryProperties(parentSelection, returnSelection);
        returnSelection.setQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA, formattedFlag);
        return returnSelection;
    }

    private DataSelection _createSelectionForNegatedFilter(DataSelection parentSelection, Object value) throws MetadataException {
        DataSelection returnSelection = null;
        if (value instanceof DataSelection) {
            returnSelection = (DataSelection)value;
            if (returnSelection instanceof SetOperationDataSelection) {
                returnSelection = DataSelectionUtilities.createDataSourceRelationalQuery(returnSelection);
                this._createdObjects.add(returnSelection);
            }
            this._copyQueryProperties(parentSelection, returnSelection);
        } else {
            returnSelection = DataSelectionFactory.newDataSelection(this._informationMap);
            this._createdObjects.add(returnSelection);
            this._copyQueryProperties(parentSelection, returnSelection);
            List<DataItem> resultItems = parentSelection.getResultItems(Role.COLUMN);
            ArrayList<DataItem> baseResultItems = new ArrayList<DataItem>();
            for (DataItem item : resultItems) {
                DataItem baseItem = DataSelectionUtilities.getBaseItem(item);
                baseItem.setFormat(item.getFormat());
                baseResultItems.add(baseItem);
            }
            for (DataItem itemToFind : (List)value) {
                DataItem baseItemToFind = DataSelectionUtilities.getBaseItem(itemToFind);
                baseItemToFind.setFormat(itemToFind.getFormat());
                boolean compareTables = false;
                int index = this._indexOfSimilarItem(baseResultItems, baseItemToFind, compareTables);
                if (index > -1) {
                    baseResultItems.set(index, baseItemToFind);
                    continue;
                }
                baseResultItems.add(baseItemToFind);
            }
            this._addResultItems(returnSelection, baseResultItems, Role.COLUMN);
        }
        return returnSelection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int _indexOfSimilarItem(List items, DataItem itemToFind, boolean compareTables) throws MetadataException {
        int index = -1;
        DataItem baseItemToFind = DataSelectionUtilities.getBaseItem(itemToFind);
        String baseItemToFindColText = null;
        String baseItemToFindTableName = null;
        try {
            QualifiedColumn itemToFindQC = DataSelectionUtilities.getColumnFromItem(itemToFind);
            baseItemToFindColText = itemToFindQC.getSasName();
            if (compareTables) {
                Table owningTable = itemToFindQC.getOwningTable();
                baseItemToFindTableName = owningTable.getSasName();
            }
        }
        catch (MetadataException e) {
            _logger.warn(e.getLocalizedMessage());
            ExpressionInterface itemToFindExpr = baseItemToFind.getExpression();
            baseItemToFindColText = this._getExpressionText(itemToFindExpr);
        }
        boolean found = false;
        int pos = 0;
        for (DataItem baseColumnItem : items) {
            block16: {
                String baseColumnText = null;
                String baseTableName = null;
                try {
                    QualifiedColumn baseQC = DataSelectionUtilities.getColumnFromItem(baseColumnItem);
                    baseColumnText = baseQC.getSasName();
                    if (compareTables) {
                        Table owningTable = baseQC.getOwningTable();
                        baseTableName = owningTable.getSasName();
                    }
                }
                catch (MetadataException e) {
                    _logger.warn(e.getLocalizedMessage());
                    ExpressionInterface parentExpr = baseColumnItem.getExpression();
                    baseColumnText = this._getExpressionText(parentExpr);
                }
                if (baseItemToFindColText.equalsIgnoreCase(baseColumnText)) {
                    if (baseColumnItem.getUsage() != DataItemActionType.USAGE_AGGREGATE && baseItemToFind.getUsage() != DataItemActionType.USAGE_AGGREGATE) {
                        if (compareTables) {
                            if (baseTableName != null && baseItemToFindTableName != null && baseTableName.equals(baseItemToFindTableName)) {
                                found = true;
                                break;
                            }
                            break block16;
                        } else {
                            found = true;
                            break;
                        }
                    }
                    if (baseColumnItem.getUsage() == DataItemActionType.USAGE_AGGREGATE && baseItemToFind.getUsage() == DataItemActionType.USAGE_AGGREGATE && baseColumnItem.getAggregationType() == baseItemToFind.getAggregationType()) {
                        if (compareTables) {
                            if (baseTableName != null && baseItemToFindTableName != null && baseTableName.equals(baseItemToFindTableName)) {
                                found = true;
                                break;
                            }
                        } else {
                            found = true;
                            break;
                        }
                    }
                }
            }
            ++pos;
        }
        if (!found) return index;
        return pos;
    }

    private void _copyQueryProperties(DataSelection oldSelection, DataSelection newSelection) throws MetadataException {
        if (newSelection instanceof SetOperationDataSelection) {
            if (oldSelection instanceof SetOperationDataSelection) {
                boolean flag = oldSelection.getQueryProperty(BusinessQueryProperty.INLINE_SETOPERATIONDATASELECTION);
                newSelection.setQueryProperty(BusinessQueryProperty.INLINE_SETOPERATIONDATASELECTION, flag);
            } else {
                newSelection.setQueryProperty(BusinessQueryProperty.INLINE_SETOPERATIONDATASELECTION, true);
            }
        } else {
            boolean flag = oldSelection.getQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA);
            newSelection.setQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA, flag);
        }
    }

    private void _copyQueryProperties(DataSelection oldSelection, DataSelection newSelection, List unionChildSelections) throws MetadataException {
        if (newSelection instanceof SetOperationDataSelection) {
            if (oldSelection instanceof SetOperationDataSelection) {
                boolean flag = oldSelection.getQueryProperty(BusinessQueryProperty.INLINE_SETOPERATIONDATASELECTION);
                newSelection.setQueryProperty(BusinessQueryProperty.INLINE_SETOPERATIONDATASELECTION, flag);
            } else {
                newSelection.setQueryProperty(BusinessQueryProperty.INLINE_SETOPERATIONDATASELECTION, true);
            }
        } else if (oldSelection instanceof SetOperationDataSelection && ((SetOperationDataSelection)oldSelection).getDataSelections().size() == 0) {
            DataSelection childSelection = (DataSelection)unionChildSelections.get(0);
            boolean flag = childSelection.getQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA);
            newSelection.setQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA, flag);
        } else {
            boolean flag = oldSelection.getQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA);
            newSelection.setQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA, flag);
        }
    }

    private void _splitFilters(CompoundFilter filter, List subqueryFilters, List simpleFilters, List nestedFilters, Map filterToValueMap) throws MetadataException {
        FilterItem leftChild = filter.getLeftFilter();
        FilterItem rightChild = filter.getRightFilter();
        if (this._getFilterValue(filterToValueMap, leftChild) != null) {
            subqueryFilters.add(leftChild);
        } else if (leftChild instanceof CompoundFilter) {
            nestedFilters.add(leftChild);
        } else {
            simpleFilters.add(leftChild);
        }
        if (rightChild != null && this._getFilterValue(filterToValueMap, rightChild) != null) {
            subqueryFilters.add(rightChild);
        } else if (rightChild instanceof CompoundFilter) {
            nestedFilters.add(rightChild);
        } else if (rightChild != null) {
            simpleFilters.add(rightChild);
        }
    }

    private void _splitSubqueryFilters(List subqueryFilters, List negatedSubqueryFilters) {
        ListIterator it = subqueryFilters.listIterator();
        while (it.hasNext()) {
            FilterItem subQueryFilter = (FilterItem)it.next();
            if (!this._negatedFilters.contains(subQueryFilter)) continue;
            it.remove();
            negatedSubqueryFilters.add(subQueryFilter);
        }
    }

    private DataSelection _optimizeAND(CompoundFilter filter, DataSelection parentSelection, List subjectItems, List level, DataSourceTable subjectTable, Map filterToValueMap, List innerUnionForExcept, int numberOfNegatedAndFilters) throws MetadataException {
        DataSelection returnSelection = parentSelection;
        if (this._isAnyChildInHashMap(filter, filterToValueMap)) {
            ArrayList simpleFilters = new ArrayList();
            ArrayList subqueryFilters = new ArrayList();
            ArrayList nestedFilters = new ArrayList();
            this._splitFilters(filter, subqueryFilters, simpleFilters, nestedFilters, filterToValueMap);
            ArrayList negatedSubqueryFilters = new ArrayList();
            this._splitSubqueryFilters(subqueryFilters, negatedSubqueryFilters);
            if (parentSelection instanceof SetOperationDataSelection) {
                throw new IQueryServicesRuntimeException(IQMetadataResourceBundle.getStringResource("FilterOptimizerInvalidInputForAND.txt"));
            }
            List<FilterItem> filters = parentSelection.getFilters();
            filters.addAll(simpleFilters);
            this._setFilters(parentSelection, filters);
            for (FilterItem subQueryFilter : subqueryFilters) {
                Object value = this._getFilterValue(filterToValueMap, subQueryFilter);
                DataSelection newParentSelection = this._joinAndValueToQuery(parentSelection, subjectTable, subjectItems, value);
                if (newParentSelection == parentSelection) continue;
                parentSelection = newParentSelection;
                returnSelection = newParentSelection;
            }
            for (CompoundFilter nestedFilter : nestedFilters) {
                if (nestedFilter.getRelationType() == ConditionalRelationType.OR) {
                    if (this._isAnyChildInHashMap(nestedFilter, filterToValueMap)) {
                        DataSelection newParentSelection;
                        DataSelection nextQuery = DataSelectionFactory.newDataSelection(this._informationMap);
                        this._copyQueryProperties(parentSelection, nextQuery);
                        this._createdObjects.add(nextQuery);
                        this._addResultItems(nextQuery, subjectItems, Role.COLUMN);
                        DataSelection orChildSelection = this._optimizeOR(nestedFilter, nextQuery, subjectItems, level, subjectTable, filterToValueMap, new ArrayList());
                        parentSelection = newParentSelection = this._joinAndValueToQuery(parentSelection, subjectTable, subjectItems, orChildSelection);
                        returnSelection = newParentSelection;
                        continue;
                    }
                    List<FilterItem> parentFilters = parentSelection.getFilters();
                    parentFilters.add(nestedFilter);
                    this._setFilters(parentSelection, parentFilters);
                    continue;
                }
                returnSelection = this._optimizeAND(nestedFilter, parentSelection, subjectItems, level, subjectTable, filterToValueMap, innerUnionForExcept, numberOfNegatedAndFilters);
            }
            if (negatedSubqueryFilters.size() > 0) {
                DataSelection negatedSelection;
                SetOperationDataSelection setOp = null;
                ArrayList<DataSelection> unionChildSelections = new ArrayList<DataSelection>();
                if (!(returnSelection instanceof SetOperationDataSelection) || ((SetOperationDataSelection)returnSelection).getSetOperation() != SetOperationType.EXCEPT) {
                    setOp = DataSelectionFactory.getInstance().newSetOperationDataSelection(parentSelection);
                    this._createdObjects.add(setOp);
                    this._copyQueryProperties(parentSelection, setOp);
                    setOp.setQueryProperty(BusinessQueryProperty.INLINE_SETOPERATIONDATASELECTION, this._isSetOpInline);
                    setOp.setSetOperation(SetOperationType.EXCEPT);
                } else {
                    setOp = (SetOperationDataSelection)returnSelection;
                    if (setOp.getDataSelections().size() > 1) {
                        DataSelection exceptSelection = setOp.getDataSelections().get(1);
                        if (exceptSelection instanceof SetOperationDataSelection) {
                            SetOperationDataSelection tempSetOp = (SetOperationDataSelection)exceptSelection;
                            unionChildSelections = tempSetOp.getDataSelections();
                        } else {
                            unionChildSelections.add(exceptSelection);
                        }
                    }
                }
                for (FilterItem negatedSubQueryFilter : negatedSubqueryFilters) {
                    Object value = this._getFilterValue(filterToValueMap, negatedSubQueryFilter);
                    DataSelection negatedSelection2 = this._createSelectionForNegatedFilter(parentSelection, value);
                    unionChildSelections.add(negatedSelection2);
                }
                if (unionChildSelections.size() == 1) {
                    negatedSelection = (DataSelection)unionChildSelections.get(0);
                } else {
                    if (innerUnionForExcept.size() == 0) {
                        SetOperationDataSelection newUnionSetOp = DataSelectionFactory.getInstance().newSetOperationDataSelection(this._informationMap);
                        this._copyQueryProperties(parentSelection, newUnionSetOp);
                        this._createdObjects.add(newUnionSetOp);
                        newUnionSetOp.setQueryProperty(BusinessQueryProperty.INLINE_SETOPERATIONDATASELECTION, this._isSetOpInline);
                        newUnionSetOp.setSetOperation(SetOperationType.UNION);
                        innerUnionForExcept.add(newUnionSetOp);
                    }
                    SetOperationDataSelection unionSetOp = (SetOperationDataSelection)innerUnionForExcept.get(0);
                    unionSetOp.setDataSelections(unionChildSelections);
                    negatedSelection = unionSetOp;
                }
                List<DataSelection> exceptChildSelections = setOp.getDataSelections();
                if (exceptChildSelections.size() == 0) {
                    exceptChildSelections.add(parentSelection);
                } else if (exceptChildSelections.size() == 2) {
                    exceptChildSelections.remove(1);
                }
                if (negatedSelection instanceof SetOperationDataSelection) {
                    int unionSize = 0;
                    SetOperationDataSelection unionSetOp = null;
                    if (innerUnionForExcept.size() > 0) {
                        unionSetOp = (SetOperationDataSelection)innerUnionForExcept.get(0);
                        unionSize = unionSetOp.getDataSelections().size();
                    }
                    if (unionSize > 1 && unionSize == numberOfNegatedAndFilters) {
                        DataSelection temp = DataSelectionUtilities.createDataSourceRelationalQuery(negatedSelection);
                        exceptChildSelections.add(temp);
                    } else {
                        exceptChildSelections.add(negatedSelection);
                    }
                } else {
                    exceptChildSelections.add(negatedSelection);
                }
                setOp.setDataSelections(exceptChildSelections);
                returnSelection = setOp;
            }
        } else {
            List<FilterItem> filters = parentSelection.getFilters();
            filters.add(filter);
            this._setFilters(parentSelection, filters);
        }
        return returnSelection;
    }

    private int _getNumberOfNegatedANDFilters(List simpleAndFilters) {
        int returnCount = 0;
        for (FilterItem andFilter : simpleAndFilters) {
            if (!this._negatedFilters.contains(andFilter)) continue;
            ++returnCount;
        }
        return returnCount;
    }

    private void _getSimpleANDFilters(List andFilters, CompoundFilter filter) {
        ConditionalRelationType conditionType;
        FilterItem leftFilter = null;
        FilterItem rightFilter = null;
        leftFilter = filter.getLeftFilter();
        rightFilter = filter.getRightFilter();
        if (leftFilter instanceof CompoundFilter) {
            this._getSimpleANDFilters(andFilters, (CompoundFilter)leftFilter);
        } else if (leftFilter != null && (conditionType = filter.getRelationType()) != null && conditionType.equals(ConditionalRelationType.AND)) {
            andFilters.add(leftFilter);
        }
        if (rightFilter instanceof CompoundFilter) {
            this._getSimpleANDFilters(andFilters, (CompoundFilter)rightFilter);
        } else if (rightFilter != null && (conditionType = filter.getRelationType()) != null && conditionType.equals(ConditionalRelationType.AND)) {
            andFilters.add(rightFilter);
        }
    }

    private void _setFilters(DataSelection selection, List filters) throws MetadataException {
        ArrayList<FilterItem> equivalentFilters = new ArrayList<FilterItem>();
        for (FilterItem filterItem : filters) {
            FilterItem equivalentFilter = DataSelectionUtilities.getEquivalentFilterItem(selection, filterItem);
            equivalentFilters.add(equivalentFilter);
        }
        selection.setFilters(equivalentFilters);
    }

    private DataSelection _joinAndValueToQuery(DataSelection selection, DataSourceTable subjectTable, List subjectItems, Object value) throws MetadataException {
        DataSelection returnSelection = selection;
        if (this._isSubjectTableUnnecessary(selection, subjectTable, subjectItems, value)) {
            if (value instanceof DataSelection) {
                returnSelection = (DataSelection)value;
                this._copyQueryProperties(selection, returnSelection);
            } else {
                List<DataItem> resultItems = selection.getResultItems(Role.HIDDEN);
                selection.setResultItems(resultItems);
                this._addResultItems(selection, (List)value, Role.COLUMN);
            }
        } else if (value instanceof DataSelection) {
            DataSelection childSelection = (DataSelection)value;
            this._copyQueryProperties(selection, childSelection);
            InformationMap businessModel = FilterOptimizer._getInformationMap(selection);
            DataSourceRelationalQuery dsrq = businessModel.newDataSourceRelationalQuery(childSelection);
            businessModel.addDataSource(dsrq);
            this._createdObjects.add(dsrq);
            ArrayList<QualifiedColumn> subjectKeyColumns = new ArrayList<QualifiedColumn>();
            for (DataItem item : subjectItems) {
                subjectKeyColumns.add(DataSelectionUtilities.getColumnFromItem(item));
            }
            Join join = DataSelectionUtilities.addNewJoin(dsrq, subjectKeyColumns, subjectTable, JoinType.INNER);
            join.setAllowedTypes(JoinTypeList.ALL_JOIN_TYPES);
            this._createdObjects.add(join);
            RootDataItem dataItem = this._informationMap.newDataItem();
            this._informationMap.addBusinessItem(dataItem);
            this._createdObjects.add(dataItem);
            dataItem.setExpression(dsrq.getColumns().get(0));
            dataItem.setUsage(DataItemActionType.USAGE_DETAIL);
            selection.addResultItem(dataItem, Role.HIDDEN);
        } else if (value instanceof List) {
            DataItem dataItem = (DataItem)((List)value).get(0);
            selection.addResultItem(dataItem, Role.HIDDEN);
        }
        return returnSelection;
    }

    private boolean _isSubjectTableUnnecessary(DataSelection selection, DataSourceTable subjectTable, List subjectItems, Object value) throws MetadataException {
        boolean returnValue = false;
        List dataSources = this._getLevel(selection, subjectTable);
        if (!(value instanceof SetOperationDataSelection) && dataSources.size() == 0 && selection.getFilters().size() == 0 && selection.getEffectiveDataSources().size() == 1 && selection.getEffectiveDataSources().get(0) == subjectTable) {
            returnValue = true;
            List baseSubjectItemTables = this._getUnderlyingTables(subjectItems);
            List<DataItem> columnReturnItems = selection.getResultItems(Role.COLUMN);
            List<DataItem> subqueryReturnItems = null;
            subqueryReturnItems = value instanceof DataSelection ? ((DataSelection)value).getResultItems() : (List<DataItem>)value;
            boolean hasSameResultItems = this._isResultSetEquivalent(columnReturnItems, subqueryReturnItems);
            ListIterator<DataItem> it = columnReturnItems.listIterator();
            while (it.hasNext()) {
                DataItem returnItem = it.next();
                boolean found = false;
                ListIterator subjectIt = subjectItems.listIterator();
                while (subjectIt.hasNext()) {
                    DataItem subjectItem = (DataItem)subjectIt.next();
                    DataItem baseSubjectItem = DataSelectionUtilities.getBaseItem(subjectItem);
                    DataItem baseReturnItem = DataSelectionUtilities.getBaseItem(returnItem);
                    List baseReturnTables = this._getUnderlyingTables(baseReturnItem);
                    boolean returnItemHasSameTables = baseSubjectItemTables.containsAll(baseReturnTables);
                    if (baseReturnItem != baseSubjectItem && !returnItemHasSameTables || !hasSameResultItems) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                returnValue = false;
                break;
            }
        }
        return returnValue;
    }

    private boolean _isResultSetEquivalent(List columnReturnItems, List subqueryReturnItems) throws MetadataException {
        boolean returnValue = false;
        if (columnReturnItems.size() == subqueryReturnItems.size()) {
            returnValue = true;
            ArrayList<String> baseColumnTextExpressions = new ArrayList<String>();
            ArrayList<String> baseSubqueryTextExpressions = new ArrayList<String>();
            Iterator subIt = subqueryReturnItems.iterator();
            Iterator colIt = columnReturnItems.iterator();
            while (colIt.hasNext()) {
                DataItem baseColumnItem = DataSelectionUtilities.getBaseItem((DataItem)colIt.next());
                DataItem baseSubqueryItem = DataSelectionUtilities.getBaseItem((DataItem)subIt.next());
                ExpressionInterface parentExpr = baseColumnItem.getExpression();
                ExpressionInterface expressionInterface = baseSubqueryItem.getExpression();
                String baseColumnText = null;
                String baseSubqueryColumnText = null;
                try {
                    QualifiedColumn baseColumn = DataSelectionUtilities.getColumnFromItem(baseColumnItem);
                    baseColumnText = this._getExpressionText(baseColumn);
                }
                catch (MetadataException e) {
                    _logger.warn(e.getLocalizedMessage());
                    baseColumnText = this._getExpressionText(parentExpr);
                }
                try {
                    QualifiedColumn baseSubQueryColumn = DataSelectionUtilities.getColumnFromItem(baseSubqueryItem);
                    baseSubqueryColumnText = this._getExpressionText(baseSubQueryColumn);
                }
                catch (MetadataException e) {
                    _logger.warn(e.getLocalizedMessage());
                    baseSubqueryColumnText = this._getExpressionText(expressionInterface);
                }
                baseColumnTextExpressions.add(baseColumnText);
                baseSubqueryTextExpressions.add(baseSubqueryColumnText);
            }
            for (String columnExpr : baseColumnTextExpressions) {
                boolean found = false;
                for (String string : baseSubqueryTextExpressions) {
                    if (!columnExpr.equals(string)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                returnValue = false;
                break;
            }
        }
        return returnValue;
    }

    private String _getExpressionText(ExpressionInterface expr) throws MetadataException {
        String expressionText;
        if (expr instanceof QualifiedColumn) {
            QualifiedColumn qualColumn = (QualifiedColumn)expr;
            expressionText = qualColumn.getSasName();
        } else {
            expressionText = StringExpressionUtil.getInstance().getText(expr);
        }
        return expressionText;
    }

    private List _getUnderlyingTables(DataItem item) throws MetadataException {
        ArrayList<DataItem> items = new ArrayList<DataItem>();
        items.add(item);
        return this._getUnderlyingTables(items);
    }

    private List _getUnderlyingTables(List dataItems) throws MetadataException {
        ArrayList returnList = new ArrayList();
        for (DataItem item : dataItems) {
            DataItem baseItem = DataSelectionUtilities.getBaseItem(item);
            List<QualifiedColumn> baseColumns = baseItem.getResources(QualifiedColumn.class, 65535);
            for (QualifiedColumn baseColumn : baseColumns) {
                Utils.addButNoDuplicates(returnList, baseColumn.getDataSource());
            }
        }
        return returnList;
    }

    private void _orFiltersToSelection(List filters, DataSelection selection) throws MetadataException {
        List<FilterItem> previousFilters = selection.getFilters();
        if (previousFilters == null || previousFilters.size() == 0) {
            this._setFilters(selection, filters);
        } else {
            CompoundFilter oldFiltersCompoundFilter = this._convertListToCompoundFilter(this._informationMap, previousFilters);
            CompoundFilter newFiltersCompoundFilter = this._convertListToCompoundFilter(this._informationMap, filters);
            CompoundFilter compoundFilter = this._informationMap.newCompoundFilter();
            this._informationMap.addBusinessItem(compoundFilter);
            this._createdObjects.add(compoundFilter);
            compoundFilter.setRelationType(ConditionalRelationType.OR);
            compoundFilter.setLeftFilter(oldFiltersCompoundFilter);
            compoundFilter.setRightFilter(newFiltersCompoundFilter);
            ArrayList<CompoundFilter> newFilters = new ArrayList<CompoundFilter>();
            newFilters.add(compoundFilter);
            this._setFilters(selection, newFilters);
        }
    }

    private boolean _isAnyChildInHashMap(CompoundFilter filter, Map filterToValueMap) throws MetadataException {
        boolean returnValue = false;
        FilterItem leftChild = filter.getLeftFilter();
        FilterItem rightChild = filter.getRightFilter();
        if (leftChild != null && filterToValueMap.containsKey(leftChild)) {
            returnValue = true;
        }
        if (rightChild != null && filterToValueMap.containsKey(rightChild)) {
            returnValue = true;
        }
        if (!returnValue && leftChild != null && leftChild instanceof CompoundFilter) {
            returnValue = this._isAnyChildInHashMap((CompoundFilter)leftChild, filterToValueMap);
        }
        if (!returnValue && rightChild != null && rightChild instanceof CompoundFilter) {
            returnValue = this._isAnyChildInHashMap((CompoundFilter)rightChild, filterToValueMap);
        }
        if (!returnValue && this._isOptimizeEquivalentFilters && this._isEquivalentFilterInMap(filter, filterToValueMap)) {
            returnValue = true;
        }
        return returnValue;
    }

    private boolean _isEquivalentFilterInMap(CompoundFilter filter, Map filterToValueMap) throws MetadataException {
        boolean returnValue = false;
        FilterItem leftChild = filter.getLeftFilter();
        FilterItem rightChild = filter.getRightFilter();
        for (FilterItem item : filterToValueMap.keySet()) {
            if (!this._isEquivalentFilter(item, leftChild) && !this._isEquivalentFilter(item, rightChild)) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    private boolean _isEquivalentFilter(FilterItem filter1, FilterItem filter2) throws MetadataException {
        boolean returnValue = false;
        if (filter1 == filter2) {
            returnValue = true;
        } else if (this._isOptimizeEquivalentFilters && filter1 != null && filter2 != null && filter1.getExpression() instanceof StringExpression && filter2.getExpression() instanceof StringExpression) {
            StringExpression string1 = (StringExpression)filter1.getExpression();
            StringExpression string2 = (StringExpression)filter2.getExpression();
            if (string1.getText().equals(string2.getText())) {
                returnValue = true;
            }
        }
        return returnValue;
    }

    private Object _getFilterValue(Map<FilterItem, Object> filterToValueMap, FilterItem keyFilter) throws MetadataException {
        Object value = null;
        for (Map.Entry<FilterItem, Object> entry : filterToValueMap.entrySet()) {
            FilterItem item = entry.getKey();
            if (this._isOptimizeEquivalentFilters) {
                if (!this._isEquivalentFilter(keyFilter, item)) continue;
                value = entry.getValue();
                continue;
            }
            value = filterToValueMap.get(keyFilter);
        }
        return value;
    }

    private List _getLevel(DataSelection logicalSelection, DataSourceTable subjectTable) throws MetadataException {
        boolean isLevelProvided = !logicalSelection.getFilters().isEmpty();
        List<Object> allDataSources = new ArrayList();
        if (isLevelProvided) {
            allDataSources = logicalSelection.getEffectiveDataSources();
        }
        if (allDataSources.size() == 1 && allDataSources.contains(subjectTable)) {
            allDataSources.clear();
        }
        return allDataSources;
    }

    private static boolean _itemHasThisDataSource(DataItem item, DataSource dataSource) throws MetadataException {
        boolean referenceThisDataSource = false;
        boolean referenceOtherDataSource = false;
        List<QualifiedColumn> columns = item.getResources(QualifiedColumn.class, 65535);
        for (QualifiedColumn column : columns) {
            if (column.getDataSource() == dataSource) {
                referenceThisDataSource = true;
                continue;
            }
            referenceOtherDataSource = true;
            break;
        }
        return referenceThisDataSource && !referenceOtherDataSource;
    }

    private void _levelSelection(DataSelection parentSelection, DataSelection selection, List level, List subjectItems) throws MetadataException {
        if (parentSelection != null) {
            List<DataItem> parentResultItems = parentSelection.getResultItems(Role.COLUMN);
            List<DataItem> selectionResultItems = selection.getResultItems(Role.COLUMN);
            if (parentResultItems.size() != selectionResultItems.size()) {
                ListIterator<DataItem> parentListIt = parentResultItems.listIterator();
                block0: while (parentListIt.hasNext()) {
                    DataItem parentItem = parentListIt.next();
                    DataItem baseParentItem = DataSelectionUtilities.getBaseItem(parentItem);
                    ExpressionInterface parentExpr = baseParentItem.getExpression();
                    String parentResultText = this._getExpressionText(parentExpr);
                    ListIterator subjectIt = subjectItems.listIterator();
                    while (subjectIt.hasNext()) {
                        DataItem subjectItem = (DataItem)subjectIt.next();
                        DataItem baseSubjectItem = DataSelectionUtilities.getBaseItem(subjectItem);
                        ExpressionInterface subjectExpr = baseSubjectItem.getExpression();
                        String subjectText = this._getExpressionText(subjectExpr);
                        if (!subjectText.equals(parentResultText)) continue;
                        parentListIt.remove();
                        continue block0;
                    }
                }
                this._addEquivalentResultItems(selection, parentResultItems, Role.COLUMN);
            }
        }
        List<DataSource> dataSources = selection.getEffectiveDataSources();
        List<DataItem> items = this._informationMap.getObjects(true, DataItem.class);
        HashMap<DataSourceTable, DataItem> dataSourceToDataItemMap = new HashMap<DataSourceTable, DataItem>();
        block2: for (DataSourceTable dataSource : level) {
            for (DataItem item : items) {
                if (!FilterOptimizer._itemHasThisDataSource(item, dataSource)) continue;
                dataSourceToDataItemMap.put(dataSource, item);
                continue block2;
            }
        }
        for (Object source : level) {
            DataItem item;
            if (dataSources.contains(source) || (item = (DataItem)dataSourceToDataItemMap.get(source)) == null) continue;
            DataItemReference dir = this._informationMap.newDataItemReference(item);
            this._informationMap.addBusinessItem(dir);
            this._createdObjects.add(dir);
            if (item.isActionSupported(DataItemActionType.USAGE_DETAIL)) {
                dir.setUsage(DataItemActionType.USAGE_DETAIL);
            }
            selection.addResultItem(dir, Role.HIDDEN);
        }
    }

    private void _addResultItems(DataSelection selection, List dataItems, Role role) throws MetadataException {
        for (DataItem item : dataItems) {
            DataItemReference dir = this._informationMap.newDataItemReference(item);
            this._informationMap.addBusinessItem(dir);
            this._createdObjects.add(dir);
            if (item.isActionSupported(DataItemActionType.USAGE_DETAIL)) {
                dir.setUsage(DataItemActionType.USAGE_DETAIL);
            }
            if (!item.isCalculatedItem()) {
                QualifiedColumn qc = null;
                try {
                    qc = DataSelectionUtilities.getColumnFromItem(item);
                }
                catch (MetadataException e) {
                    _logger.warn(e.getLocalizedMessage());
                }
                if (role == Role.COLUMN && qc != null) {
                    String columnName = qc.getSasName();
                    dir.setResultSetID(columnName);
                }
            }
            selection.addResultItem(dir, role);
        }
    }

    private void _addEquivalentResultItems(DataSelection selection, List dataItems, Role role) throws MetadataException {
        for (DataItem item : dataItems) {
            DataItemReference dir;
            if (item instanceof DataItemReference) {
                while (item instanceof DataItemReference) {
                    item = ((DataItemReference)item).getBaseDataItem();
                }
                dir = this._informationMap.newDataItemReference(item);
                this._informationMap.addBusinessItem(dir);
                dir.setUsage(item.getUsage());
                dir.setFormat(item.getFormat());
                dir.setFormattingForced(item.isFormattingForced());
                DataItemActionType sortDirection = item.getSortDirection();
                if (sortDirection == null) {
                    sortDirection = DataItemActionType.SORT_NONE;
                }
                dir.setSortDirection(sortDirection);
                dir.setGroupFormatting(item.getGroupFormatting());
                dir.setSortFormatting(item.getSortFormatting());
            } else {
                dir = this._informationMap.newDataItemReference(item);
                this._informationMap.addBusinessItem(dir);
            }
            this._createdObjects.add(dir);
            if (item.isActionSupported(DataItemActionType.USAGE_DETAIL)) {
                dir.setUsage(DataItemActionType.USAGE_DETAIL);
            }
            QualifiedColumn qc = null;
            try {
                qc = DataSelectionUtilities.getColumnFromItem(item);
            }
            catch (MetadataException e) {
                _logger.warn(e.getLocalizedMessage());
            }
            if (role == Role.COLUMN && qc != null) {
                String columnName = qc.getSasName();
                dir.setResultSetID(columnName);
            }
            selection.addResultItem(dir, role);
        }
    }

    private void setFilterToValueMap(Map filterToValueMap) {
        this._filterToValueMap = filterToValueMap;
    }

    private void setNegatedFilters(List negatedFilters) {
        this._negatedFilters = negatedFilters;
    }

    static InformationMap _getInformationMap(BusinessModel businessModel) {
        InformationMap informationMap = null;
        if (businessModel instanceof InformationMap) {
            informationMap = (InformationMap)businessModel;
        } else {
            BusinessModel parent = businessModel.getParentBusinessModel();
            informationMap = FilterOptimizer._getInformationMap(parent);
        }
        return informationMap;
    }

    private CompoundFilter _convertListToCompoundFilter(InformationMap model, List originalFilters) throws MetadataException {
        CompoundFilter compoundFilter = model.newCompoundFilter();
        model.addBusinessItem(compoundFilter);
        this._createdObjects.add(compoundFilter);
        ArrayList filters = new ArrayList(originalFilters);
        if (filters.size() >= 1) {
            compoundFilter.setLeftFilter((FilterItem)filters.get(0));
            filters.remove(0);
        }
        if (filters.size() > 0) {
            compoundFilter.setRelationType(ConditionalRelationType.AND);
            compoundFilter.setRightFilter(this._convertListToCompoundFilter(model, filters));
        }
        return compoundFilter;
    }

    private DataSelection _checkForTableReferenceLimit(DataSelection ds) throws MetadataException {
        DataSelection returnDS = ds;
        int refCount = this._countReferences(ds);
        if (refCount > this._maximumTableReferences) {
            this._turnOnTempTableGeneration(ds);
        }
        return returnDS;
    }

    private void _turnOnTempTableGeneration(BusinessQuery businessQuery) throws MetadataException {
        if (businessQuery instanceof SetOperationDataSelection) {
            businessQuery.setQueryProperty(BusinessQueryProperty.INLINE_SETOPERATIONDATASELECTION, false);
            SetOperationDataSelection setOpDS = (SetOperationDataSelection)businessQuery;
            List<DataSelection> selections = setOpDS.getDataSelections();
            for (BusinessQuery businessQuery2 : selections) {
                this._turnOnTempTableGeneration(businessQuery2);
            }
        } else {
            List<DataSource> dataSources = businessQuery.getEffectiveDataSources();
            for (DataSource dataSource : dataSources) {
                if (!(dataSource instanceof DataSourceRelationalQuery)) continue;
                DataSourceRelationalQuery dataSourceRelationalQuery = (DataSourceRelationalQuery)dataSource;
                BusinessQuery internalQuery = dataSourceRelationalQuery.getBusinessQuery();
                this._turnOnTempTableGeneration(internalQuery);
            }
        }
    }

    private int _countReferences(BusinessQuery businessQuery) throws MetadataException {
        int refCount = 0;
        if (businessQuery instanceof SetOperationDataSelection) {
            SetOperationDataSelection setOpDS = (SetOperationDataSelection)businessQuery;
            List<DataSelection> selections = setOpDS.getDataSelections();
            for (DataSelection ds : selections) {
                refCount += this._countReferences(ds);
            }
        } else {
            List<DataSource> dataSources = businessQuery.getEffectiveDataSources();
            for (DataSource dataSource : dataSources) {
                if (dataSource instanceof DataSourceRelationalQuery) {
                    DataSourceRelationalQuery dsrq = (DataSourceRelationalQuery)dataSource;
                    BusinessQuery internalQuery = dsrq.getBusinessQuery();
                    refCount += this._countReferences(internalQuery);
                    continue;
                }
                ++refCount;
            }
        }
        return refCount;
    }

    private List _getResultSetIDs(DataSelection selection) throws MetadataException {
        ArrayList<String> returnValues = new ArrayList<String>();
        for (DataItem item : selection.getResultItems(Role.COLUMN)) {
            returnValues.add(item.getResultSetID());
        }
        return returnValues;
    }

    private void _fixResultSetIDs(DataSelection selection, List resultSetIDs, List selectedItems) throws MetadataException {
        if (selection instanceof SetOperationDataSelection) {
            Iterator<DataSelection> it = ((SetOperationDataSelection)selection).getDataSelections().iterator();
            while (it.hasNext()) {
                this._fixResultSetIDs(it.next(), resultSetIDs, selectedItems);
            }
        } else {
            Iterator resultIt = resultSetIDs.iterator();
            List<DataItem> selectionResultItems = selection.getResultItems(Role.COLUMN);
            for (DataItem item : selectionResultItems) {
                String id = (String)resultIt.next();
                item.setResultSetID(id);
            }
            for (SelectedItem baseItem : selectedItems) {
                List<SelectedItem> currentItems = selection.getSelectedItems();
                for (SelectedItem curItem : currentItems) {
                    if (!baseItem.getItem().getResultSetID().equalsIgnoreCase(curItem.getItem().getResultSetID()) || baseItem.getJoinBehavior() != 4) continue;
                    curItem.setJoinBehavior(4);
                }
            }
        }
    }

    private MetadataException _constructExceptionWithReasons(DataSelection selection) {
        MetadataException me = null;
        List<Reason> reasons = selection.getReasonsNotValid();
        if (!reasons.isEmpty()) {
            Locale viewerLocale = LocaleUtilities.getDefaultViewerLocale(selection);
            for (Reason reason : reasons) {
                _logger.error(reason.getReasonString(viewerLocale));
            }
            MessageFormatter baseMessage = IQMetadataResourceBundle.getMessageFormatter("FilterOptimizer.checkValid.invalidquery.txt", new Object[0]);
            MessageFormatter reasonListFormatter = Reason.getMessageFormatter(baseMessage, reasons, true);
            me = new MetadataException(reasonListFormatter, reasons);
        }
        return me;
    }
}

