/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.util;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceFactory;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Export;
import com.sas.iquery.metadata.business.ExportProperties;
import com.sas.iquery.metadata.business.ExportRule;
import com.sas.iquery.metadata.business.ExportType;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.InformationMapFactory;
import com.sas.iquery.metadata.business.impl.ExportMetadataFactory;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.session.SessionContextInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class ExportUtilities {
    private static final Logger _logger = LogManager.getLogger(ExportUtilities.class);

    public static Export newExport(BusinessModel businessModel, ExportType usage, ExportProperties ... properties) throws MetadataException {
        Export export = ExportUtilities.newExportObject(businessModel, usage, properties);
        ExportRule exportRule = ExportUtilities.newExportRuleObject(businessModel);
        exportRule.setExport(export);
        businessModel.addBusinessRule(exportRule);
        return export;
    }

    public static Export newExport(DataSelection selection, ExportType usage, ExportProperties ... properties) throws MetadataException {
        BusinessModel businessModel = selection.getBusinessModel();
        Export export = ExportUtilities.newExport(businessModel, usage, properties);
        return export;
    }

    public static Export newExport(String infoMapName, SessionContextInterface session, ExportType usage, ExportProperties ... properties) throws MetadataException {
        IntelligentQueryMetadataServiceInterface iqService = IntelligentQueryMetadataServiceFactory.newService();
        PathUrl mapURL = new PathUrl(infoMapName);
        InformationMap infoMap = InformationMapFactory.getInstance().newInformationMap(session, iqService, mapURL);
        return ExportUtilities.newExport(infoMap, usage, properties);
    }

    public static ExportRule newExportRuleObject(BusinessModel businessModel, ExportType usage, ExportProperties ... properties) throws MetadataException {
        ExportRule exportRule = ExportUtilities.newExportRuleObject(businessModel);
        Export export = ExportUtilities.newExportObject(businessModel, usage, properties);
        exportRule.setExport(export);
        return exportRule;
    }

    public static Export newExportObject(BusinessModel businessModel, ExportType usage, ExportProperties ... properties) throws MetadataException {
        boolean isOlap = businessModel.getStructure().isOLAP();
        Export export = isOlap ? ExportMetadataFactory.newExportOlap(businessModel, usage, properties) : ExportMetadataFactory.newExportRelational(businessModel, usage, properties);
        return export;
    }

    public static ExportRule newExportRuleObject(BusinessModel businessModel) {
        return ExportMetadataFactory.newExportRule(businessModel);
    }
}

