/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.util;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.Export;
import com.sas.iquery.metadata.business.ExportDataSource;
import com.sas.iquery.metadata.business.ExportHierarchyColumnDef;
import com.sas.iquery.metadata.business.ExportJoin;
import com.sas.iquery.metadata.business.ExportJoinColumnPair;
import com.sas.iquery.metadata.business.ExportSelectionMetadata;
import com.sas.iquery.metadata.business.ExportUploadMetadata;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.impl.ExportAbstract;
import com.sas.iquery.metadata.business.impl.ExportCubeDataDsBuilder;
import com.sas.iquery.metadata.business.impl.ExportCubeProcessor;
import com.sas.iquery.metadata.business.impl.ExportOlapImpl;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.metadata.remote.CalculatedMeasure;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Dimension;
import com.sas.metadata.remote.Hierarchy;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Measure;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExportInfoUtilities {
    private static final Logger _logger = LogManager.getLogger(ExportInfoUtilities.class);
    private static final Comparator<ExportDataSource> _exportDataSourceSorter = new Comparator<ExportDataSource>(){

        @Override
        public int compare(ExportDataSource o1, ExportDataSource o2) {
            return o1 != null && o1.getLabel() != null && o2 != null && o2.getLabel() != null ? o1.getLabel().compareTo(o2.getLabel()) : (o1 == null || o1.getLabel() == null ? -1 : 1);
        }
    };

    public static void getTableInfo(Export export, String lasrLibrefName, List<ExportDataSource> allTables, Map<ExportDataSource, List<QualifiedColumn>> tableColumns, Set<String> libnameStatements, Map<ExportDataSource, String> sourceTableNames, Map<ExportDataSource, String> lasrTableNames) throws MetadataException {
        ExportUploadMetadata uploadMetadata = export.getUploadMetadata();
        allTables.addAll(uploadMetadata.getUploadDataSourcesUsed());
        for (ExportDataSource exportDataSource : allTables) {
            String libdef = exportDataSource.getSASLibnameStatement(true);
            if (!libnameStatements.contains(libdef)) {
                libnameStatements.add(libdef);
            }
            String fqSourceTableName = exportDataSource.getSASTableNameFullyQualified();
            sourceTableNames.put(exportDataSource, fqSourceTableName);
            String tableName = exportDataSource.getSASTableNameShort();
            String fqLasrTableName = GenerationUtil.generateFullyQualifiedIdentifier(lasrLibrefName, tableName);
            lasrTableNames.put(exportDataSource, fqLasrTableName);
            if (!(exportDataSource.getUnderlyingObject() instanceof DataSourceTable)) continue;
            DataSourceTable dst = (DataSourceTable)exportDataSource.getUnderlyingObject();
            List<QualifiedColumn> qualifiedColumns = dst.getQualifiedColumns();
            tableColumns.put(exportDataSource, qualifiedColumns);
        }
    }

    public static List<ExportJoin> getUploadJoinsUsedBetween(Export export, ExportDataSource dataSource1, ExportDataSource dataSource2) throws MetadataException {
        ExportUploadMetadata uploadMetadata = export.getUploadMetadata();
        ArrayList<ExportJoin> joinsUsedBetween = new ArrayList<ExportJoin>();
        List<ExportJoin> uploadJoinsUsed = uploadMetadata.getUploadJoinsUsed();
        for (ExportJoin uploadJoin : uploadJoinsUsed) {
            ExportDataSource from = uploadJoin.getFromTable();
            ExportDataSource to = uploadJoin.getToTable();
            if ((!from.equals(dataSource1) || !to.equals(dataSource2)) && (!to.equals(dataSource1) || !from.equals(dataSource2))) continue;
            joinsUsedBetween.add(uploadJoin);
        }
        return joinsUsedBetween;
    }

    public static void getHierarchyInfo(Export export, List<String> allUniqueLevelNames, Map<String, String> mapUniqueLevelNamesToFormats, Map<String, QualifiedColumn> mapUniqueLevelNamesToColumns, Map<String, Map<String, Map<Integer, String>>> mapDimensionsToMemberLevels) throws MetadataException {
        List<ExportDataSource> exportDataSourcesUsed;
        DataSource underlyingObject;
        ArrayList<ExportHierarchyColumnDef> allHierarchyColumnDefs = new ArrayList<ExportHierarchyColumnDef>();
        ExportSelectionMetadata exportMetadata = export.getExportMetadata();
        if (exportMetadata.getStructureOfData().isOLAP() && (underlyingObject = (DataSource)(exportDataSourcesUsed = exportMetadata.getExportDataSourcesUsed()).get(0).getUnderlyingObject()) instanceof DataSourceCube) {
            DataSourceCube dataSourceCube = (DataSourceCube)underlyingObject;
            ExportCubeProcessor cubeProcessor = new ExportCubeProcessor(dataSourceCube);
            try {
                List<Dimension> dimensions;
                if (export instanceof ExportOlapImpl) {
                    ((ExportOlapImpl)export).setCubeProcessor(cubeProcessor);
                }
                if ((dimensions = cubeProcessor.getDimensions()) != null) {
                    for (Dimension dimension : dimensions) {
                        List<Hierarchy> hierarchies = cubeProcessor.getHierarchies(dimension);
                        for (Hierarchy hierarchy : hierarchies) {
                            List<ExportHierarchyColumnDef> hierarchyColumnDefs = cubeProcessor.getHierarchyColumnDefs(dimension, hierarchy);
                            if (hierarchyColumnDefs == null || hierarchyColumnDefs.isEmpty()) continue;
                            allHierarchyColumnDefs.addAll(hierarchyColumnDefs);
                        }
                    }
                }
                if (allHierarchyColumnDefs.size() > 0) {
                    boolean ignoreReachThruTable = ((ExportAbstract)export).getIgnoreReachThruTable();
                    boolean useReachThru = !ignoreReachThruTable && cubeProcessor.useReachThruTable(null);
                    ExportUploadMetadata uploadMetadata = export.getUploadMetadata();
                    List<ExportDataSource> allTables = uploadMetadata.getUploadDataSourcesUsed();
                    for (ExportHierarchyColumnDef exportHierarchyColumnDef : allHierarchyColumnDefs) {
                        int levMembersPos = exportHierarchyColumnDef.getPosition();
                        Level lev = exportHierarchyColumnDef.getLev();
                        Column col = exportHierarchyColumnDef.getCol();
                        String levelUniqueName = ExportInfoUtilities.getLevelUniqueName(lev);
                        String colSasFormat = ExportInfoUtilities.getSasFormat(col);
                        String levSasFormat = ExportInfoUtilities.getSasFormat(lev);
                        String formatToUse = levSasFormat.equals(colSasFormat) ? colSasFormat : levSasFormat;
                        ExportInfoUtilities.addToMap(mapUniqueLevelNamesToFormats, levelUniqueName, formatToUse);
                        ExportInfoUtilities.addToMap(mapDimensionsToMemberLevels, exportHierarchyColumnDef.getDim(), exportHierarchyColumnDef.getHier(), levMembersPos, levelUniqueName);
                        if (!allUniqueLevelNames.contains(levelUniqueName)) {
                            allUniqueLevelNames.add(levelUniqueName);
                        }
                        ExportInfoUtilities.addToMap(mapUniqueLevelNamesToColumns, levelUniqueName, col, cubeProcessor, allTables, useReachThru);
                    }
                }
            }
            catch (RemoteException e) {
                throw new MetadataException(e);
            }
            catch (MdException e) {
                throw new MetadataException(e);
            }
            finally {
                if (export instanceof ExportOlapImpl) {
                    ((ExportOlapImpl)export).setCubeProcessor(null);
                }
                cubeProcessor.close();
            }
        }
    }

    private static String getSasFormat(Level lev) {
        String levSasFormat;
        try {
            levSasFormat = lev.getSASFormat();
        }
        catch (RemoteException e) {
            levSasFormat = "";
        }
        return levSasFormat;
    }

    private static String getSasFormat(Column col) {
        String colSasFormat;
        try {
            colSasFormat = col.getSASFormat();
        }
        catch (RemoteException e) {
            colSasFormat = "";
        }
        return colSasFormat;
    }

    private static String getLevelUniqueName(Level lev) {
        String levelUniqueName;
        try {
            levelUniqueName = lev.getUniqueName();
        }
        catch (RemoteException e) {
            levelUniqueName = lev.toString();
        }
        return levelUniqueName;
    }

    public static void getMeasureInfo(Export export, List<String> allUniqueMeasureNames, Map<String, QualifiedColumn> mapUniqueMeasureNamesToColumns, Map<String, String> mapUniqueMeasureNamesToLabels, Map<String, String> mapUniqueMeasureNamesToDescriptions, Map<String, String> mapUniqueMeasureNamesToFormats, Map<String, String> mapUniqueMeasureNamesToAggregations) throws MetadataException {
        List<ExportDataSource> exportDataSourcesUsed;
        DataSource underlyingObject;
        ExportSelectionMetadata exportMetadata = export.getExportMetadata();
        if (exportMetadata.getStructureOfData().isOLAP() && (underlyingObject = (DataSource)(exportDataSourcesUsed = exportMetadata.getExportDataSourcesUsed()).get(0).getUnderlyingObject()) instanceof DataSourceCube) {
            DataSourceCube dataSourceCube = (DataSourceCube)underlyingObject;
            ExportCubeProcessor cubeProcessor = new ExportCubeProcessor(dataSourceCube);
            try {
                boolean ignoreReachThruTable;
                if (export instanceof ExportOlapImpl) {
                    ((ExportOlapImpl)export).setCubeProcessor(cubeProcessor);
                }
                boolean useReachThru = !(ignoreReachThruTable = ((ExportAbstract)export).getIgnoreReachThruTable()) && cubeProcessor.useReachThruTable(null);
                List<Measure> measures = cubeProcessor.getMeasures();
                if (measures != null && measures.size() > 0) {
                    ExportUploadMetadata uploadMetadata = export.getUploadMetadata();
                    List<ExportDataSource> allTables = uploadMetadata.getUploadDataSourcesUsed();
                    for (Measure measure : measures) {
                        List<Column> nuniqueColumns;
                        if (measure instanceof CalculatedMeasure || (nuniqueColumns = cubeProcessor.getNuniqueMeasureColumns(measure)) != null && nuniqueColumns.size() > 0) continue;
                        String columnDesc = measure.getDesc();
                        String columnLabel = measure.getName();
                        String uniqueMeasureName = measure.getUniqueName();
                        String aggregation = measure.getStatistic();
                        String formatToUse = measure.getSASFormat();
                        if (formatToUse == null || formatToUse.trim().isEmpty()) {
                            formatToUse = "";
                        }
                        ExportInfoUtilities.addToMap(mapUniqueMeasureNamesToLabels, uniqueMeasureName, columnLabel);
                        ExportInfoUtilities.addToMap(mapUniqueMeasureNamesToDescriptions, uniqueMeasureName, columnDesc);
                        ExportInfoUtilities.addToMap(mapUniqueMeasureNamesToAggregations, uniqueMeasureName, aggregation);
                        ExportInfoUtilities.addToMap(mapUniqueMeasureNamesToFormats, uniqueMeasureName, formatToUse);
                        if (!allUniqueMeasureNames.contains(uniqueMeasureName)) {
                            allUniqueMeasureNames.add(uniqueMeasureName);
                        }
                        Column sourceColumn = cubeProcessor.getMeasureSourceColumn(measure);
                        ExportInfoUtilities.addToMap(mapUniqueMeasureNamesToColumns, uniqueMeasureName, sourceColumn, cubeProcessor, allTables, useReachThru);
                    }
                }
            }
            catch (RemoteException e) {
                throw new MetadataException(e);
            }
            catch (MdException e) {
                throw new MetadataException(e);
            }
            finally {
                if (export instanceof ExportOlapImpl) {
                    ((ExportOlapImpl)export).setCubeProcessor(null);
                }
                cubeProcessor.close();
            }
        }
    }

    private static void addToMap(Map<String, QualifiedColumn> mapOwningObjectsToColumns, String owningObjectName, Column column, ExportCubeProcessor cubeProcessor, List<ExportDataSource> allTables, boolean useReachThru) throws MetadataException, RemoteException, MdException {
        if (column != null) {
            QualifiedColumn foundColumn = null;
            for (ExportDataSource exportDataSource : allTables) {
                DataSourceTable dst = (DataSourceTable)exportDataSource.getUnderlyingObject();
                List<QualifiedColumn> qualifiedColumns = dst.getQualifiedColumns();
                for (QualifiedColumn qualifiedColumn : qualifiedColumns) {
                    if (!ExportCubeDataDsBuilder.isMatch(qualifiedColumn, column, useReachThru)) continue;
                    foundColumn = qualifiedColumn;
                    ExportInfoUtilities.addToMap(mapOwningObjectsToColumns, owningObjectName, foundColumn);
                    break;
                }
                if (foundColumn == null) continue;
                break;
            }
        }
    }

    public static void getJoinInfo(Export export, Map<ExportDataSource, Map<QualifiedColumn, Set<ExportJoin>>> joinedTableColumns) throws MetadataException {
        ExportUploadMetadata uploadMetadata = export.getUploadMetadata();
        List<ExportJoin> joinsUsed = uploadMetadata.getUploadJoinsUsed();
        for (ExportJoin exportJoin : joinsUsed) {
            ExportDataSource fromTable = exportJoin.getFromTable();
            ExportDataSource toTable = exportJoin.getToTable();
            List<ExportJoinColumnPair> joinColumnPairs = exportJoin.getJoinColumnPairs();
            for (ExportJoinColumnPair pair : joinColumnPairs) {
                QualifiedColumn fromColumn = pair.getFromColumn();
                ExportInfoUtilities.addToMap(joinedTableColumns, fromColumn, fromTable, exportJoin);
                QualifiedColumn toColumn = pair.getToColumn();
                ExportInfoUtilities.addToMap(joinedTableColumns, toColumn, toTable, exportJoin);
            }
        }
    }

    private static void addToMap(Map<String, QualifiedColumn> mapUniqueLevelNamesToColumns, String uniqueOwnerKey, QualifiedColumn column) {
        QualifiedColumn oldOwnedQualifedColumn = mapUniqueLevelNamesToColumns.get(uniqueOwnerKey);
        if (oldOwnedQualifedColumn == null) {
            mapUniqueLevelNamesToColumns.put(uniqueOwnerKey, column);
        } else if (!oldOwnedQualifedColumn.equals(column)) {
            _logger.warn("***** " + uniqueOwnerKey + " reused with different column (old=[" + oldOwnedQualifedColumn.getIdentityString() + "],new=[" + column.getIdentityString() + "]) *****");
        }
    }

    private static void addToMap(Map<String, String> mapUniqueLevelNamesToFormats, String levelUniqueName, String formatToUse) {
        String levelsFormat = mapUniqueLevelNamesToFormats.get(levelUniqueName);
        if (levelsFormat == null) {
            mapUniqueLevelNamesToFormats.put(levelUniqueName, formatToUse);
        } else if (!levelsFormat.equals(formatToUse)) {
            _logger.warn("***** level reused with different format (old=" + levelsFormat + ",new=" + formatToUse + ") *****");
        }
    }

    private static void addToMap(String levelUniqueName, int levMembersPos, Map<Integer, String> mapHierarchyColumnOrderToUniqueLevels) {
        String oldLevelUniqueName = mapHierarchyColumnOrderToUniqueLevels.get(levMembersPos);
        if (oldLevelUniqueName == null) {
            mapHierarchyColumnOrderToUniqueLevels.put(levMembersPos, levelUniqueName);
        } else if (!levelUniqueName.equals(oldLevelUniqueName)) {
            _logger.warn("***** column position reused with different level (old=" + oldLevelUniqueName + ",new=" + levelUniqueName + ") *****");
        }
    }

    private static void addToMap(Map<String, Map<String, Map<Integer, String>>> mapDimensionsToMemberLevels, Dimension dim, Hierarchy hier, int levMembersPos, String levelUniqueName) {
        Map<String, Map<Integer, String>> mapHierarchiesToLevelColumns = ExportInfoUtilities.addToMap(mapDimensionsToMemberLevels, dim);
        Map<Integer, String> mapHierarchyColumnOrderToUniqueLevels = ExportInfoUtilities.addToMap(mapHierarchiesToLevelColumns, hier);
        ExportInfoUtilities.addToMap(levelUniqueName, levMembersPos, mapHierarchyColumnOrderToUniqueLevels);
    }

    private static Map<String, Map<Integer, String>> addToMap(Map<String, Map<String, Map<Integer, String>>> mapDimensionsToMemberLevels, Dimension dim) {
        String dimUniqueName = null;
        try {
            dimUniqueName = dim.getUniqueName();
        }
        catch (RemoteException e) {
            dimUniqueName = e.toString();
        }
        Map<String, Map<Integer, String>> mapHierarchiesToLevelColumns = mapDimensionsToMemberLevels.get(dimUniqueName);
        if (mapHierarchiesToLevelColumns == null) {
            mapHierarchiesToLevelColumns = new LinkedHashMap<String, Map<Integer, String>>();
            mapDimensionsToMemberLevels.put(dimUniqueName, mapHierarchiesToLevelColumns);
        }
        return mapHierarchiesToLevelColumns;
    }

    private static Map<Integer, String> addToMap(Map<String, Map<Integer, String>> mapHierarchiesToLevelColumns, Hierarchy hier) {
        String hierUniqueName = null;
        try {
            hierUniqueName = hier.getUniqueName();
        }
        catch (RemoteException e) {
            hierUniqueName = e.toString();
        }
        Map<Integer, String> mapHierarchyColumnOrderToUniqueLevels = mapHierarchiesToLevelColumns.get(hierUniqueName);
        if (mapHierarchyColumnOrderToUniqueLevels == null) {
            mapHierarchyColumnOrderToUniqueLevels = new LinkedHashMap<Integer, String>();
            mapHierarchiesToLevelColumns.put(hierUniqueName, mapHierarchyColumnOrderToUniqueLevels);
        }
        return mapHierarchyColumnOrderToUniqueLevels;
    }

    private static void addToMap(Map<ExportDataSource, Map<QualifiedColumn, Set<ExportJoin>>> keyColumns, QualifiedColumn keyColumn, ExportDataSource exportTable, ExportJoin exportJoin) {
        Set<ExportJoin> fromJoins;
        Map<QualifiedColumn, Set<ExportJoin>> fromKeyColumns = keyColumns.get(exportTable);
        if (fromKeyColumns == null) {
            fromKeyColumns = new LinkedHashMap<QualifiedColumn, Set<ExportJoin>>();
            keyColumns.put(exportTable, fromKeyColumns);
        }
        if ((fromJoins = fromKeyColumns.get(keyColumn)) == null) {
            fromJoins = new LinkedHashSet<ExportJoin>();
            fromKeyColumns.put(keyColumn, fromJoins);
        }
        fromJoins.add(exportJoin);
    }

    public static Comparator<ExportDataSource> getExportDataSourceSorter() {
        return _exportDataSourceSorter;
    }
}

