/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.util;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.expr.ExpressionUtil;

@SASScope
public class ColumnBasedDataItemRequest {
    private int _dbmsType;
    private int _dbmsLength;
    private String _columnLabel;
    private String _columnDesc;
    private String _sasName;
    private String _sasType;
    private int _sasLength;
    private String _sasFormat;
    private boolean _formattingForced;

    public ColumnBasedDataItemRequest() {
        this._dbmsType = 0;
        this._dbmsLength = 0;
        this._sasName = null;
        this._sasType = null;
        this._sasLength = 0;
        this._sasFormat = null;
        this._formattingForced = false;
        this._columnLabel = null;
        this._columnDesc = null;
    }

    public ColumnBasedDataItemRequest(int dbmsType, int dbmsLength, String columnLabel, String columnDesc, String sasName, String sasType, int sasLength, String sasFormat, boolean forcedFormatting) {
        this._dbmsType = dbmsType;
        this._dbmsLength = dbmsLength;
        this._columnLabel = columnLabel;
        this._columnDesc = columnDesc;
        this._sasName = sasName;
        this._sasType = sasType;
        this._sasLength = sasLength;
        this._sasFormat = sasFormat;
        this._formattingForced = forcedFormatting;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    int getDbmsType() {
        return this._dbmsType;
    }

    int getDbmsLength() {
        return this._dbmsLength;
    }

    String getColumnLabel() {
        return this._columnLabel;
    }

    String getColumnDesc() {
        return this._columnDesc;
    }

    String getSasName() {
        return this._sasName;
    }

    String getSasType() {
        return this._sasType;
    }

    int getSasLength() {
        return this._sasLength;
    }

    String getSasFormat() {
        return this._sasFormat;
    }

    boolean isFormattingForced() {
        return this._formattingForced;
    }

    int getExpressionType() {
        int outExprType = 0;
        int columnType = this.getDbmsType();
        if (columnType == 0) {
            String sasType = this.getSasType();
            if (sasType != null) {
                if (sasType.equals("C")) {
                    outExprType = 3;
                } else if (sasType.equals("N")) {
                    outExprType = 2;
                }
            }
        } else {
            outExprType = ExpressionUtil.getExprType(columnType);
        }
        return outExprType;
    }
}

