/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.util;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.entities.EntityInterface;
import com.sas.iom.SASMDX.ISession;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataretrieval.ConnectionConfiguration;
import com.sas.iquery.dataretrieval.QueryConnectorReturnCodeType;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionRecycler;
import com.sas.iquery.execution.ConnectionResources;
import com.sas.iquery.execution.ConnectionUtil;
import com.sas.iquery.execution.OLAPConnectionResource;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.LookThroughDataSelection;
import com.sas.iquery.metadata.business.Model;
import com.sas.iquery.metadata.business.QualifiedLevel;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.metadata.expr.OLAPResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.olap.TimeExpressionMeasure;
import com.sas.iquery.metadata.impl.AbstractExpression;
import com.sas.iquery.metadata.physical.CalculatedMember;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Level;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.NamedSet;
import com.sas.iquery.metadata.physical.OlapItem;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.metadata.physical.olap.AllLevel;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import com.sas.iquery.strategies.sas.oma.olap.util.IQMetadataInterface;
import com.sas.iquery.strategies.sas.oma.olap.util.IQOLAPDataSet;
import com.sas.iquery.strategies.sas.oma.olap.util.IQOLAPDataSetInterface;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPValues;
import com.sas.iquery.strategies.sas.oma.olapv2.PreFilterDLLGeneration;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.ROLAPNamesUtil;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.iquery.util.impl.OLAPServerUtilities;
import com.sas.iquery.util.impl.OLAPUtilities;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@SubjectToChange
public class BusinessQueryOLAPUtil {
    @SASScope
    private static final Logger _logger = LogManager.getLogger((String)"BusinessQueryOLAPUtil.class");
    @SASScope
    private static final Logger _perfCLogger = LogManager.getLogger((String)"com.sas.iquery.perf.Connections");
    protected static final String EXTENDED_ATTRIBUTE_IS_MEASURE = "SAS.IQ.IS_MEASURE";
    @SASScope
    protected static final String EXTENDED_ATTRIBUTE_DIMENSION_NAME = "SAS.IQ.DIMENSION_NAME";
    @SASScope
    protected static final String EXTENDED_ATTRIBUTE_DIMENSION_TYPE = "SAS.IQ.DIMENSION_TYPE";
    @SASScope
    public static final String EXTENDED_ATTRIBUTE_HIERARCHY_NAME = "SAS.IQ.HIERARCHY_NAME";

    public static List<Reason> getInvalidLabels(DataSelection ds) {
        ArrayList<Reason> reasons = new ArrayList<Reason>();
        if (ds.getStructure().equals(StructureOfData.OLAP)) {
            try {
                OLAPUtilities.findDuplicateLabels(ds, reasons);
            }
            catch (MetadataException e) {
                _logger.warn("Invalid Label: " + e.getLocalizedMessage(), (Throwable)e);
            }
            catch (GenerationException e) {
                _logger.warn("Invalid Label: " + e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return reasons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCubeRestrictions(DataSelection dataSelection) throws GenerationException {
        Preconditions.ensureNonNull(dataSelection, "dataSelection", _logger);
        String cubeRestrictions = "";
        if (dataSelection.getStructure().isOLAP()) {
            LogicalServerInterface logicalServer;
            String cubeName;
            DataSourceCube dataCube;
            try {
                dataCube = OLAPUtilities.findDataSourceCube(dataSelection);
                cubeName = OLAPUtilities.findCubeName(dataCube);
                SoftwareServer softwareServer = OLAPUtilities.findSoftwareServer(dataCube);
                logicalServer = OLAPUtilities.findLogicalServerInterface(softwareServer);
            }
            catch (MetadataException e) {
                throw new GenerationException(e);
            }
            Locale computationalLocale = LocaleUtilities.getDefaultComputationalLocale(dataSelection);
            String constructor = "DEFAULT_CONSTRUCTOR_BEHAVIOR";
            OLAPConnectionResource olapConnection = BusinessQueryOLAPUtil.newOLAPConnectionResource(dataSelection, logicalServer, computationalLocale);
            IQMetadataInterface metaInterface = null;
            try {
                metaInterface = olapConnection.createMetadataInterface(dataSelection, constructor, dataCube, true, true, null);
            }
            catch (ExecutionException e) {
                String message = IQDataServicesResourceBundle.getStringResource("MetadataProviderNoMetadata.txt");
                ConnectionUtil.LoggerErrorWithObjects(_logger, message, e, dataSelection, olapConnection);
                throw new GenerationException(e, message);
            }
            List<DataItem> resultItems = dataSelection.getResultItems();
            OLAPValues olapValues = null;
            try {
                olapValues = new OLAPValues(metaInterface, resultItems, dataSelection);
                if (olapValues != null) {
                    PreFilterDLLGeneration preFilterDLL = new PreFilterDLLGeneration();
                    preFilterDLL.setModel(dataSelection);
                    preFilterDLL.setOLAPValues(olapValues);
                    String cubeNameMdx = " [" + cubeName + "] ";
                    preFilterDLL.generateFullFilterMDX(cubeNameMdx);
                    cubeRestrictions = preFilterDLL.getPreFilterClause();
                }
            }
            finally {
                if (olapValues != null) {
                    olapValues.release();
                }
            }
        }
        MDXGenerationUtil.applyDebugStatement("Cube Restrictions: " + cubeRestrictions, BusinessQueryOLAPUtil.class);
        return cubeRestrictions;
    }

    public static String translateCubeString(String cubeName, String valueString, Locale inLocale, Locale outLocale, ConnectionInterface olapConnection) {
        String returnValue = valueString;
        ArrayList<StringExpression> memberList = new ArrayList<StringExpression>();
        StringExpression value = new StringExpression();
        value.setText(valueString);
        value.setExpressionType(3);
        memberList.add(value);
        List<StringExpression> tranMembers = IOMServerUtils.translateOLAPMembers(cubeName, memberList, inLocale, outLocale, olapConnection);
        if (!tranMembers.isEmpty()) {
            StringExpression newMemberName = tranMembers.get(0);
            try {
                returnValue = newMemberName.getText();
            }
            catch (MetadataException e) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
                return valueString;
            }
        }
        return returnValue;
    }

    @SASScope
    public static String buildOLAPExpression(DataItem dataItem, MetadataInterface metaI) throws GenerationException {
        String returnValue = "";
        try {
            ExpressionInterface expression = dataItem.getExpression();
            if (expression instanceof Dimension) {
                returnValue = BusinessQueryOLAPUtil.getDimensionExpression((Dimension)expression);
            } else if (expression instanceof CalculatedMember) {
                CalculatedMember calcMem = (CalculatedMember)expression;
                returnValue = BusinessQueryOLAPUtil.generateUniqueHierarchyName(calcMem);
            } else if (expression instanceof NamedSet) {
                NamedSet namedSet = (NamedSet)expression;
                try {
                    returnValue = BusinessQueryOLAPUtil.generateUniqueHierarchyName(namedSet);
                }
                catch (MetadataException e) {
                    _logger.error(e.getLocalizedMessage());
                }
            } else if (expression instanceof Hierarchy) {
                String startingLevelName = BusinessQueryOLAPUtil.getStartingLevel(dataItem);
                returnValue = BusinessQueryOLAPUtil.getHierarchyExpression((Hierarchy)expression, startingLevelName, metaI);
            } else if (expression instanceof Level) {
                returnValue = BusinessQueryOLAPUtil.getLevelExpression((Level)expression);
            } else if (expression instanceof Measure) {
                returnValue = BusinessQueryOLAPUtil.getMeasureExpression((Measure)expression);
            } else if (expression instanceof FractionOfTotalExpression) {
                _logger.warn(IQDataServicesResourceBundle.getStringResource("MDXGenerationFractionOfTotalExpression.txt"));
            } else if (expression instanceof ResourceAwareStringExpression) {
                ResourceAwareStringExpression resourceExp = (ResourceAwareStringExpression)expression;
                WeakHashMap<BusinessModelResource, String> resourceToMDXMap = new WeakHashMap<BusinessModelResource, String>();
                List<BusinessModelResource> resources = resourceExp.getResources(BusinessModelResource.class, 65535);
                for (BusinessModelResource bmaResource : resources) {
                    String hierName;
                    Hierarchy physHierarchy;
                    if (bmaResource instanceof DataItem) {
                        DataItem di = (DataItem)bmaResource;
                        String buildOLAPExpression = BusinessQueryOLAPUtil.buildOLAPExpression(di, metaI);
                        resourceToMDXMap.put(di, buildOLAPExpression);
                        continue;
                    }
                    if (bmaResource instanceof Dimension) {
                        Dimension physDimension = (Dimension)bmaResource;
                        String dimName = BusinessQueryOLAPUtil.getPhysDimensionName(physDimension);
                        resourceToMDXMap.put(physDimension, dimName);
                        continue;
                    }
                    if (bmaResource instanceof Hierarchy) {
                        Hierarchy physHierarchy2 = (Hierarchy)bmaResource;
                        String hierName2 = BusinessQueryOLAPUtil.getPhysHierarchyName(physHierarchy2);
                        resourceToMDXMap.put(physHierarchy2, hierName2);
                        continue;
                    }
                    if (bmaResource instanceof NamedSet) {
                        NamedSet namedSet = (NamedSet)bmaResource;
                        try {
                            physHierarchy = namedSet.getOwningHierarchy();
                            hierName = BusinessQueryOLAPUtil.getPhysHierarchyName(physHierarchy);
                            resourceToMDXMap.put(physHierarchy, hierName);
                        }
                        catch (MetadataException e) {
                            _logger.error(e.getLocalizedMessage());
                        }
                        continue;
                    }
                    if (bmaResource instanceof CalculatedMember) {
                        CalculatedMember calcMember = (CalculatedMember)bmaResource;
                        try {
                            physHierarchy = calcMember.getOwningHierarchy();
                            hierName = BusinessQueryOLAPUtil.getPhysHierarchyName(physHierarchy);
                            resourceToMDXMap.put(physHierarchy, hierName);
                        }
                        catch (MetadataException e) {
                            _logger.error(e.getLocalizedMessage());
                        }
                        continue;
                    }
                    if (bmaResource instanceof Level) {
                        Level physLevel = (Level)bmaResource;
                        String levelName = BusinessQueryOLAPUtil.getPhysLevelName(physLevel);
                        resourceToMDXMap.put(physLevel, levelName);
                        continue;
                    }
                    if (!(bmaResource instanceof Measure)) continue;
                    Measure physMeasure = (Measure)bmaResource;
                    String measureName = BusinessQueryOLAPUtil.getPhysMeasureName(physMeasure);
                    resourceToMDXMap.put(physMeasure, measureName);
                }
                returnValue = resourceExp.getText(resourceToMDXMap);
            }
        }
        catch (MetadataException e) {
            Object[] msgArgs2 = new Object[]{dataItem, e, IQMetadataResourceBundle.getMessageFormatter("BusinessqueryMetaExcepExpress.txt", new Object[0])};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            GenerationException ee = new GenerationException((MessageFormatter)msF, (Throwable)e);
            throw ee;
        }
        return returnValue;
    }

    public static void cleanUpNullRolesInQuery(BusinessQuery model) throws MetadataException {
        ArrayList<DataItem> unassigned = new ArrayList<DataItem>();
        ArrayList<DataItem> columns = new ArrayList<DataItem>();
        ArrayList<DataItem> rows = new ArrayList<DataItem>();
        ArrayList<DataItem> pages = new ArrayList<DataItem>();
        ArrayList<DataItem> backgrounds = new ArrayList<DataItem>();
        HashMap<String, Integer> dimensionCount = new HashMap<String, Integer>();
        HashMap<String, Role> dimensionLocation = new HashMap<String, Role>();
        for (DataItem resultItem : model.getResultItems()) {
            Role _role;
            BusinessModel businessModel = model.getBusinessModel();
            String dimensionName = BusinessQueryOLAPUtil.getHierarchyName(businessModel, resultItem, businessModel.getComputationalLocale());
            Integer count = (Integer)dimensionCount.get(dimensionName);
            if (count == null) {
                dimensionCount.put(dimensionName, 1);
            } else {
                int increment = count + 1;
                dimensionCount.put(dimensionName, increment);
            }
            if ((_role = model.getResultItemRole(resultItem)) != null) continue;
            unassigned.add(resultItem);
        }
        if (unassigned.size() == 0) {
            MDXGenerationUtil.applyDebugStatement("All dataItems contain a valid role...  no action taken", BusinessQueryOLAPUtil.class);
            return;
        }
        for (DataItem resultItem : unassigned) {
            String dimensionName = BusinessQueryOLAPUtil.getHierarchyName(model.getBusinessModel(), resultItem);
            StructureOfDataItem structure = resultItem.getStructure();
            int count1 = (Integer)dimensionCount.get(dimensionName);
            if (structure == StructureOfDataItem.STRUCTURE_MEASURE) {
                if (count1 > 1) {
                    Role role = (Role)dimensionLocation.get(dimensionName);
                    if (role == null || role == Role.COLUMN) {
                        columns.add(resultItem);
                        dimensionLocation.put(dimensionName, Role.COLUMN);
                        model.setResultItemRole(resultItem, Role.COLUMN);
                        continue;
                    }
                    if (role == Role.ROW) {
                        rows.add(resultItem);
                        dimensionLocation.put(dimensionName, Role.ROW);
                        model.setResultItemRole(resultItem, Role.ROW);
                        continue;
                    }
                    if (role != Role.PAGE) continue;
                    pages.add(resultItem);
                    dimensionLocation.put(dimensionName, Role.PAGE);
                    model.setResultItemRole(resultItem, Role.PAGE);
                    continue;
                }
                dimensionLocation.put(dimensionName, Role.BACKGROUND);
                backgrounds.add(resultItem);
                model.setResultItemRole(resultItem, Role.BACKGROUND);
                continue;
            }
            if (count1 != 1 && dimensionLocation.get(dimensionName) == null) continue;
            if (columns.size() <= rows.size()) {
                columns.add(resultItem);
                dimensionLocation.put(dimensionName, Role.COLUMN);
                model.setResultItemRole(resultItem, Role.COLUMN);
                continue;
            }
            rows.add(resultItem);
            dimensionLocation.put(dimensionName, Role.ROW);
            model.setResultItemRole(resultItem, Role.ROW);
        }
    }

    @SASScope
    public static Locale getConnectionLocale(DataSelection dataSelection) throws ExecutionException {
        if (!dataSelection.getStructure().isOLAP()) {
            String stringResource = IQDataServicesResourceBundle.getStringResource("ConnectionLocaleProvider.txt");
            throw new ExecutionException(stringResource);
        }
        Locale connectionLocale = LocaleUtilities.getDefaultComputationalLocale(dataSelection);
        return connectionLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DataItem> filterOutRaggedDataItems(List<DataItem> dataItems) throws MetadataException {
        IQMetadataInterface olapMeta;
        ArrayList<DataItem> returnList;
        block19: {
            returnList = new ArrayList<DataItem>();
            if (dataItems.size() == 0) {
                throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("BusinessQueryOLAPUtilRaggedEmptyDataItemList.txt", new Object[0]));
            }
            DataItem di2 = dataItems.get(0);
            if (di2 == null) {
                throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("BusinessQueryOLAPUtilRaggedNullDataItemList.txt", new Object[0]));
            }
            BusinessModel businessModel = OLAPUtilities.findBusinessModel(null, null, di2);
            DataSelection dataSelection = OLAPUtilities.findDataSelection(null, businessModel);
            boolean disposeDataSelection = false;
            if (dataSelection == null) {
                disposeDataSelection = true;
                dataSelection = OLAPUtilities.createDataSelection(businessModel, di2);
            }
            olapMeta = null;
            try {
                OLAPConnectionResource olapConnection;
                if (!dataSelection.getStructure().isOLAP()) {
                    MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("MetadataProviderNoValidModel.txt", new Object[0]);
                    ConnectionUtil.LoggerErrorWithObjects(_logger, message, businessModel, dataSelection);
                    throw new MetadataException(message);
                }
                DataSourceCube dsCube = OLAPUtilities.findDataSourceCube(businessModel);
                String cubeName = OLAPUtilities.findCubeName(dsCube);
                SoftwareServer softwareServer = OLAPUtilities.findSoftwareServer(dsCube);
                LogicalServerInterface logicalServer = OLAPUtilities.findLogicalServerInterface(softwareServer);
                Locale computationalLocale = LocaleUtilities.getDefaultComputationalLocale(dataSelection);
                try {
                    olapConnection = BusinessQueryOLAPUtil.newOLAPConnectionResource(dataSelection, logicalServer, computationalLocale);
                }
                catch (GenerationException e) {
                    throw new MetadataException(e);
                }
                String constructor = "DEFAULT_CONSTRUCTOR_BEHAVIOR";
                try {
                    olapMeta = olapConnection.createMetadataInterface(dataSelection, constructor, dsCube, true, true, null);
                }
                catch (ExecutionException e) {
                    MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("MetadataProviderNoMetadata.txt", new Object[0]);
                    ConnectionUtil.LoggerErrorWithObjects(_logger, message, e, businessModel, olapConnection);
                    throw new MetadataException(message, (Throwable)e);
                }
                catch (GenerationException e) {
                    MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("MetadataProviderNoMetadata.txt", new Object[0]);
                    ConnectionUtil.LoggerErrorWithObjects(_logger, message, e, businessModel, olapConnection);
                    throw new MetadataException(message, (Throwable)e);
                }
                String cubeType = dsCube.getCubeType();
                for (DataItem di2 : dataItems) {
                    if (di2.isCalculatedItem()) {
                        returnList.add(di2);
                        continue;
                    }
                    ExpressionInterface obj = di2.getExpression();
                    if (obj instanceof Hierarchy) {
                        Hierarchy hierarchyObj = (Hierarchy)obj;
                        String hierName = BusinessQueryOLAPUtil.getPhysHierarchyName(hierarchyObj);
                        try {
                            Filter filter = new Filter();
                            filter.setCubeName(cubeName);
                            filter.setUniqueHierarchyName(hierName);
                            HierarchyInterface[] hierarchies = olapMeta.getHierarchies(filter);
                            HierarchyInterface hierarchy = hierarchies[0];
                            int hierStruct = hierarchy.getStructure();
                            if (hierStruct == 2 || hierStruct == 3 && !cubeType.equalsIgnoreCase("ODCS")) continue;
                            returnList.add(di2);
                            continue;
                        }
                        catch (OLAPException oe) {
                            MessageFormatter messageFormatter = IQMetadataResourceBundle.getMessageFormatter("BusinessQueryOLAPNoConnection.txt", new Object[0]);
                            _logger.error(di2.getIdentityString());
                            _logger.error(messageFormatter.toString(), (Throwable)oe);
                            MetadataException me = new MetadataException(messageFormatter, (Throwable)oe);
                            throw me;
                        }
                    }
                    returnList.add(di2);
                }
                if (!disposeDataSelection) break block19;
            }
            catch (Throwable throwable) {
                if (disposeDataSelection) {
                    dataSelection.dispose();
                }
                if (olapMeta != null) {
                    BusinessQueryOLAPUtil.releaseMetadataInterface(olapMeta);
                }
                throw throwable;
            }
            dataSelection.dispose();
        }
        if (olapMeta != null) {
            BusinessQueryOLAPUtil.releaseMetadataInterface(olapMeta);
        }
        return returnList;
    }

    private static String gatherDimensionName(BusinessModel businessModel, DataItem dataItem, ConnectionInterface connection, Locale computationalLocale) throws MetadataException {
        ExpressionInterface expression = dataItem.getExpression();
        String returnValue = null;
        if (expression instanceof OLAPResourceAwareStringExpression) {
            OLAPResourceAwareStringExpression olapRASE = (OLAPResourceAwareStringExpression)expression;
            returnValue = olapRASE.getDimName();
        } else if (expression instanceof ResourceAwareStringExpression || dataItem.getStructure() == StructureOfDataItem.STRUCTURE_COLUMN) {
            String attributeValue = BusinessQueryOLAPUtil.getExtendedAtributeValue(dataItem, EXTENDED_ATTRIBUTE_DIMENSION_NAME);
            if (attributeValue != null) {
                returnValue = attributeValue;
            } else {
                _logger.debug("This is a non-OLAP data element being present into a OLAP type class for IQ." + dataItem.getIdentityString() + " " + expression.toString());
                if (dataItem.getStructure() == StructureOfDataItem.STRUCTURE_COLUMN) {
                    returnValue = ROLAPNamesUtil.getDimensionName(dataItem.getResultSetID());
                } else if (dataItem.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE) {
                    returnValue = IQMetadataResourceBundle.getStringResource("BusinessqueryOLAPMeasure.txt", computationalLocale);
                }
            }
        } else {
            MessageFormatter messageFormatter = IQMetadataResourceBundle.getMessageFormatter("BusinessQueryOLAPNoExpressionSet.txt", new Object[0]);
            _logger.error(expression.getClass().getCanonicalName() + " " + dataItem.getIdentityString());
            _logger.error(messageFormatter.toString());
            throw new MetadataException(messageFormatter);
        }
        return returnValue;
    }

    public static String getCubeName(BusinessModel businessModel, DataItem dataItem) throws MetadataException {
        OlapItem olapItem = BusinessQueryOLAPUtil.getOlapItem(dataItem);
        if (olapItem == null) {
            try {
                return OLAPConnectionInfoUtil.getCube(businessModel).getCubeName();
            }
            catch (GenerationException ge) {
                MessageFormatter message = IQMetadataResourceBundle.getMessageFormatter("BusinessQueryOLAPNoConnection.txt", new Object[0]);
                _logger.error(dataItem.getIdentityString());
                _logger.error(message.toString(), (Throwable)ge);
                MetadataException me = new MetadataException(message, (Throwable)ge);
                throw me;
            }
        }
        return olapItem.getCubeName();
    }

    private static String getDimensionExpression(Dimension dimension) {
        StringBuilder buildExpression = new StringBuilder();
        String defaultHierarchyName = null;
        try {
            List<Level> levels;
            Level topLevel;
            defaultHierarchyName = dimension.getDefaultHierarchy();
            List<Hierarchy> hierarchies = dimension.getHierarchies();
            Iterator<Hierarchy> iterator = hierarchies.iterator();
            Hierarchy hierarchy = null;
            while (iterator.hasNext()) {
                hierarchy = iterator.next();
                String uniqueName = hierarchy.getHierarchyUniqueName();
                if (defaultHierarchyName != null && !defaultHierarchyName.equalsIgnoreCase(uniqueName)) continue;
                break;
            }
            if ((topLevel = (levels = hierarchy.getLevels()).get(0)) instanceof AllLevel) {
                topLevel = levels.get(1);
            }
            String levelUniqueName = null;
            levelUniqueName = topLevel.getUniqueName();
            buildExpression.append(levelUniqueName).append(".MEMBERS");
        }
        catch (MetadataException e) {
            String message = IQDataServicesResourceBundle.getStringResource("MDXGenerationHierException.txt");
            _logger.warn(dimension.getIdentityString());
            _logger.warn(message, (Throwable)e);
            return null;
        }
        return buildExpression.toString();
    }

    public static String getDimensionName(BusinessModel businessModel, DataItem dataItem) throws MetadataException {
        return BusinessQueryOLAPUtil.getDimensionName(businessModel, dataItem, null);
    }

    @SASScope
    public static String getDimensionName(BusinessModel businessModel, DataItem dataItem, ConnectionInterface connection) throws MetadataException {
        String returnValue = null;
        ExpressionInterface obj = dataItem.getExpression();
        Locale computationalLocale = LocaleUtilities.getDefaultComputationalLocale(businessModel);
        if (obj instanceof OlapItem) {
            OlapItem olapItem = (OlapItem)obj;
            returnValue = olapItem.getDimensionName();
        } else if (obj instanceof FractionOfTotalExpression || obj instanceof TimeExpressionMeasure) {
            returnValue = MDXGenerationUtil.getLocalMeasure(businessModel, null);
            if (returnValue.substring(0, 1).equals("[")) {
                returnValue = returnValue.substring(1);
            }
            if (returnValue.substring(returnValue.length() - 1).equals("]")) {
                returnValue = returnValue.substring(0, returnValue.length() - 1);
            }
        } else {
            returnValue = BusinessQueryOLAPUtil.gatherDimensionName(businessModel, dataItem, connection, computationalLocale);
        }
        return returnValue;
    }

    public static int getDimensionType(BusinessModel businessModel, Object obj) throws MetadataException {
        int returnValue;
        if (obj instanceof Dimension || obj instanceof Hierarchy || obj instanceof Level || obj instanceof NamedSet || obj instanceof CalculatedMember) {
            returnValue = 3;
        } else if (obj instanceof Measure) {
            returnValue = 2;
        } else if (obj instanceof OLAPResourceAwareStringExpression) {
            OLAPResourceAwareStringExpression olapRASE = (OLAPResourceAwareStringExpression)obj;
            returnValue = olapRASE.getDimType();
        } else if (obj instanceof ResourceAwareStringExpression) {
            ResourceAwareStringExpression resourceExp = (ResourceAwareStringExpression)obj;
            List<BusinessModelResource> resources = resourceExp.getResources(BusinessModelResource.class, 65535);
            boolean isMeasure = false;
            for (BusinessModelResource bmaResource : resources) {
                if (bmaResource instanceof Measure) {
                    isMeasure = true;
                    break;
                }
                if (bmaResource instanceof OlapItem) {
                    isMeasure = ((OlapItem)((Object)bmaResource)).isInMeasureDimension();
                    break;
                }
                if (!(bmaResource instanceof DataItem)) continue;
                DataItem da = (DataItem)bmaResource;
                if (BusinessQueryOLAPUtil.getDimensionType(da, (Object)da.getExpression()) == 2) {
                    isMeasure = true;
                    break;
                }
                if (da.getUsage().equals(DataItemActionType.USAGE_AGGREGATE)) {
                    isMeasure = true;
                    break;
                }
                if (!da.containsUserTypedAggregation()) continue;
                isMeasure = true;
                break;
            }
            if (isMeasure) {
                returnValue = 2;
            } else {
                ExpressionInterface expr = (ExpressionInterface)obj;
                ServerProperties sp = businessModel.getServerProperties();
                if (sp != null) {
                    String text = StringExpressionUtil.getInstance().getText(expr, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, businessModel);
                    boolean hasEmbeddedAgg = sp.containsAggregateFunction(text);
                    returnValue = hasEmbeddedAgg ? 2 : 3;
                } else {
                    Object[] msgArgs2 = new Object[]{obj.toString(), "This is an unusual use of BusinessQueryOLAPUtil."};
                    ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                    _logger.error(obj.getClass().getCanonicalName());
                    _logger.error(msF.toString());
                    throw new MetadataException(msF);
                }
                _logger.debug("This is a non-OLAP data element being present into a OLAP type class for IQ." + obj.getClass().getCanonicalName());
            }
        } else {
            returnValue = 4;
        }
        return returnValue;
    }

    @SASScope
    public static int getDimensionType(DataItem dataItem, Object obj) throws MetadataException {
        int returnValue;
        if (obj instanceof OLAPResourceAwareStringExpression) {
            returnValue = BusinessQueryOLAPUtil.getDimensionType(dataItem.getBusinessModel(), obj);
        } else if (obj instanceof ResourceAwareStringExpression || dataItem.getStructure() == StructureOfDataItem.STRUCTURE_COLUMN) {
            String attributeValue = BusinessQueryOLAPUtil.getExtendedAtributeValue(dataItem, EXTENDED_ATTRIBUTE_DIMENSION_TYPE);
            if (attributeValue != null) {
                returnValue = Integer.parseInt(attributeValue);
            } else {
                returnValue = dataItem.getUsage() == DataItemActionType.USAGE_AGGREGATE ? 2 : 3;
                _logger.debug("This is a non-OLAP data element being present into a OLAP type class for IQ." + dataItem.getIdentityString() + " " + obj.toString());
            }
        } else {
            returnValue = BusinessQueryOLAPUtil.getDimensionType(dataItem.getBusinessModel(), obj);
        }
        return returnValue;
    }

    private static String getHierarchyExpression(Hierarchy hierarchy, String startingLevelName, MetadataInterface metaI) throws MetadataException {
        StringBuilder buildExpression = new StringBuilder();
        OLAPServerUtilities olapServerUtil = OLAPServerUtilities.getInstance();
        olapServerUtil.setMetadataInterace(metaI);
        String hierName = null;
        hierName = olapServerUtil.getHierarchyExpression(hierarchy, startingLevelName);
        if (hierName == null) {
            MessageFormatter messageFormatter = IQMetadataResourceBundle.getMessageFormatter("BusinessqueryOLAPNullHier.txt", new Object[0]);
            _logger.error(hierarchy.getIdentityString());
            _logger.error(messageFormatter.toString());
            throw new MetadataException(messageFormatter);
        }
        buildExpression.append(hierName).append(".MEMBERS");
        return buildExpression.toString();
    }

    public static String getHierarchyName(BusinessModel businessModel, DataItem dataItem) throws MetadataException {
        Locale computationalLocale = LocaleUtilities.getDefaultComputationalLocale(businessModel);
        return BusinessQueryOLAPUtil.getHierarchyName(businessModel, dataItem, computationalLocale);
    }

    public static String getHierarchyName(BusinessModel businessModel, DataItem dataItem, Locale locale) throws MetadataException {
        String returnValue = null;
        ExpressionInterface obj = dataItem.getExpression();
        if (obj instanceof Dimension) {
            returnValue = BusinessQueryOLAPUtil.generateUniqueHierarchName((Dimension)obj);
        } else if (obj instanceof Hierarchy) {
            returnValue = BusinessQueryOLAPUtil.generateUniqueHierarchyName((Hierarchy)obj);
        } else if (obj instanceof QualifiedLevel) {
            returnValue = BusinessQueryOLAPUtil.generateUniqueHierarchyName((QualifiedLevel)obj);
        } else if (obj instanceof NamedSet) {
            returnValue = BusinessQueryOLAPUtil.generateUniqueHierarchyName((NamedSet)obj);
        } else if (obj instanceof CalculatedMember) {
            returnValue = BusinessQueryOLAPUtil.generateUniqueHierarchyName((CalculatedMember)obj);
        } else if (obj instanceof Measure) {
            returnValue = BusinessQueryOLAPUtil.generateUniqueHierarchyName((Measure)obj);
        } else if (obj instanceof FractionOfTotalExpression) {
            returnValue = BusinessQueryOLAPUtil.generateMeasureHierarchyName(dataItem);
        } else if (obj instanceof TimeExpressionMeasure) {
            returnValue = BusinessQueryOLAPUtil.generateMeasureHierarchyName(dataItem);
        } else if (obj instanceof OLAPResourceAwareStringExpression) {
            returnValue = BusinessQueryOLAPUtil.generateUniqueHierarchyName(businessModel, locale, (OLAPResourceAwareStringExpression)obj);
        } else if (obj instanceof ResourceAwareStringExpression) {
            returnValue = BusinessQueryOLAPUtil.generateUniqueHierarchyName92(dataItem);
        }
        if (returnValue == null) {
            Object[] msgArgs2 = new Object[]{dataItem.getIdentityString(), IQMetadataResourceBundle.getStringResource("BusinessQueryOLAPInvalidROLAPItem.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            _logger.warn(msF.toString());
        }
        return returnValue;
    }

    public static String generateUniqueHierarchyName92(DataItem dataItem) {
        String returnValue = BusinessQueryOLAPUtil.getExtendedAtributeValue(dataItem, EXTENDED_ATTRIBUTE_HIERARCHY_NAME);
        return returnValue;
    }

    public static String generateMeasureHierarchyName(DataItem dataItem) {
        BusinessModel businessModel = dataItem.getBusinessModel();
        String returnValue = MDXGenerationUtil.getLocalMeasure(businessModel, null);
        return returnValue;
    }

    public static String generateUniqueHierarchyName(BusinessModel businessModel, Locale locale, OLAPResourceAwareStringExpression olapRASE) throws MetadataException {
        String returnValue = olapRASE.getHierName(locale, businessModel);
        return returnValue;
    }

    public static String generateUniqueHierarchyName(Measure measure) throws MetadataException {
        String returnValue = measure.getUniqueName();
        return returnValue;
    }

    public static String generateUniqueHierarchyName(CalculatedMember calculatedMember) throws MetadataException {
        String returnValue = calculatedMember.getUniqueName();
        return returnValue;
    }

    public static String generateUniqueHierarchyName(NamedSet namedSet) throws MetadataException {
        String returnValue = namedSet.getUniqueName();
        return returnValue;
    }

    public static String generateUniqueHierarchyName(QualifiedLevel qLevel) throws MetadataException {
        Hierarchy hierarchy = qLevel.getOwningHierarchy();
        String returnValue = BusinessQueryOLAPUtil.generateUniqueHierarchyName(hierarchy);
        return returnValue;
    }

    public static String generateUniqueHierarchyName(Hierarchy hierarchy) throws MetadataException {
        return hierarchy.getUniqueName();
    }

    public static QueryConnectorReturnCodeType cancelThread(SessionContextInterface sessionContext) {
        QueryConnectorReturnCodeType returnCodeType = QueryConnectorReturnCodeType.CANCEL_NO_OP;
        try {
            ConnectionRecycler connectionRecycler = ConnectionRecycler.getInstance(sessionContext);
            returnCodeType = connectionRecycler.closeThread(sessionContext);
        }
        catch (RemoteException e) {
            return QueryConnectorReturnCodeType.CANCEL_FAILURE;
        }
        return returnCodeType;
    }

    public static String generateUniqueHierarchName(Dimension dimension) throws MetadataException {
        String returnValue = dimension.getDimensionName();
        List<Hierarchy> hierarchies = dimension.getHierarchies();
        if (!hierarchies.isEmpty()) {
            Hierarchy defaultHierarchy = hierarchies.get(0);
            returnValue = BusinessQueryOLAPUtil.generateUniqueHierarchyName(defaultHierarchy);
        }
        return returnValue;
    }

    private static String getLevelExpression(Level level) {
        StringBuilder buildExpression = new StringBuilder();
        String levelUniqueName = null;
        try {
            levelUniqueName = level.getLevelUniqueName();
        }
        catch (MetadataException e) {
            String message = IQDataServicesResourceBundle.getStringResource("MDXGenerationLevelNameException.txt");
            _logger.warn(level.getIdentityString());
            _logger.warn(message, (Throwable)e);
            return null;
        }
        buildExpression.append(levelUniqueName).append(".MEMBERS");
        return buildExpression.toString();
    }

    private static String getMeasureExpression(Measure measure) {
        try {
            return measure.getUniqueName();
        }
        catch (MetadataException e) {
            String message = IQDataServicesResourceBundle.getStringResource("MDXGenerationMeasureLevelNameException.txt");
            _logger.warn(measure.getIdentityString());
            _logger.warn(message, (Throwable)e);
            return null;
        }
    }

    public static String getMeasureName(BusinessModel businessModel, DataItem dataItem) throws MetadataException {
        ExpressionInterface obj = dataItem.getExpression();
        if (obj instanceof OlapItem) {
            if (obj instanceof Measure) {
                Measure measure = (Measure)obj;
                return measure.getMeasureUniqueName();
            }
        } else if (obj instanceof ResourceAwareStringExpression) {
            StringBuilder label = new StringBuilder();
            label.append(MDXGenerationUtil.getLocalMeasure(businessModel, null)).append(".[").append("&_").append(dataItem.getLabel()).append("] ");
            return label.toString();
        }
        return null;
    }

    @Nonnull
    private static IQMetadataInterface getMetadata(DataSelection dataSelection) throws MetadataException, GenerationException, ExecutionException {
        String constructor = "DEFAULT_CONSTRUCTOR_BEHAVIOR";
        Locale computationalLocale = LocaleUtilities.getDefaultComputationalLocale(dataSelection);
        DataSourceCube dataCube = OLAPUtilities.findDataSourceCube(dataSelection);
        SoftwareServer softwareServer = OLAPUtilities.findSoftwareServer(dataCube);
        LogicalServerInterface logicalServer = OLAPUtilities.findLogicalServerInterface(softwareServer);
        OLAPConnectionResource olapConnection = BusinessQueryOLAPUtil.newOLAPConnectionResource(dataSelection, logicalServer, computationalLocale);
        IQMetadataInterface metadata = olapConnection.createMetadataInterface(dataSelection, constructor, dataCube, true, true, null);
        return metadata;
    }

    public static MetadataInterface getMetadataInterface(Object iqObject) throws ExecutionException {
        Preconditions.ensureNonNull(iqObject, "iqObject", _logger);
        IQMetadataInterface metadata = null;
        BusinessModel businessModel = null;
        boolean disposeDataSelection = false;
        Model dataSelection = null;
        try {
            if (iqObject instanceof BusinessQuery) {
                businessModel = OLAPUtilities.findBusinessModel(null, (BusinessQuery)iqObject, null);
                dataSelection = OLAPUtilities.findDataSelection((BusinessQuery)iqObject, businessModel);
            } else if (iqObject instanceof BusinessModel) {
                businessModel = (BusinessModel)iqObject;
                dataSelection = OLAPUtilities.findDataSelection(null, businessModel);
            } else {
                String message = IQDataServicesResourceBundle.getStringResource("MetadataProviderNoValidiqObject.txt");
                ConnectionUtil.LoggerErrorWithObjects(_logger, message, iqObject, iqObject.getClass().getName());
                throw new ExecutionException(message);
            }
            if (dataSelection == null) {
                disposeDataSelection = true;
                dataSelection = OLAPUtilities.createDataSelection(businessModel, null);
            }
            if (!dataSelection.getStructure().isOLAP()) {
                String message = IQDataServicesResourceBundle.getStringResource("MetadataProviderNoValidModel.txt");
                ConnectionUtil.LoggerErrorWithObjects(_logger, message, iqObject, businessModel, dataSelection);
                throw new ExecutionException(message);
            }
            try {
                metadata = BusinessQueryOLAPUtil.getMetadata((DataSelection)dataSelection);
            }
            catch (GenerationException e) {
                String message = IQDataServicesResourceBundle.getStringResource("MetadataProviderNoMetadata.txt");
                ConnectionUtil.LoggerErrorWithObjects(_logger, message, e, iqObject, businessModel, dataSelection);
                throw new ExecutionException(e, message);
            }
        }
        catch (MetadataException e) {
            throw new ExecutionException(e);
        }
        finally {
            if (disposeDataSelection) {
                dataSelection.dispose();
            }
        }
        return metadata;
    }

    private static IQOLAPDataSet createOlapDataSet(int contextType, DataSelection dataSelection) throws GenerationException, ExecutionException, MetadataException {
        String cacheKey;
        IQOLAPDataSet olapDataSet = null;
        Locale computationalLocale = LocaleUtilities.getDefaultComputationalLocale(dataSelection);
        DataSourceCube dataCube = OLAPUtilities.findDataSourceCube(dataSelection);
        SoftwareServer softwareServer = OLAPUtilities.findSoftwareServer(dataCube);
        LogicalServerInterface logicalServer = OLAPUtilities.findLogicalServerInterface(softwareServer);
        OLAPConnectionResource olapConnection = BusinessQueryOLAPUtil.newOLAPConnectionResource(dataSelection, logicalServer, computationalLocale);
        Locale connectionLocale = olapConnection.getConnectionLocale(dataSelection);
        ISession isession = olapConnection.getISession(dataSelection, "DEFAULT_CONSTRUCTOR_BEHAVIOR", connectionLocale);
        boolean isOk = false;
        try {
            olapDataSet = ConnectionResources.newOLAPDataSet(isession, contextType, null);
            if (dataSelection != null) {
                olapDataSet.setBusinesModel(dataSelection);
            }
            olapDataSet.setQueryStatement(null, null);
            olapDataSet.setLocale(computationalLocale);
            olapDataSet.setRelatedConnection(olapConnection);
            olapConnection.addOlapDataSet(isession, olapDataSet, connectionLocale);
            isOk = true;
        }
        catch (OLAPException e) {
            String message = IQDataServicesResourceBundle.getStringResource("MetadataProviderNoMetadata.txt");
            ConnectionUtil.LoggerErrorWithObjects(_logger, message, dataSelection, dataCube, logicalServer, computationalLocale, isession);
            throw new GenerationException(e, message);
        }
        finally {
            if (!isOk && olapDataSet != null) {
                ConnectionResources.close(olapDataSet);
            }
        }
        if (dataSelection instanceof LookThroughDataSelection && olapConnection.isFilterToBeApplied(cacheKey = MDXGenerationUtil.buildCacheKey(dataSelection, computationalLocale, "DEFAULT_CONSTRUCTOR_BEHAVIOR"))) {
            olapConnection.applyFilterStateOnCube((BusinessModel)dataSelection, cacheKey, olapDataSet, null);
        }
        return olapDataSet;
    }

    public static OLAPDataSetInterface getOLAPDataSet(Object iqObject) throws IQueryServicesException {
        return BusinessQueryOLAPUtil.getOLAPDataSet(iqObject, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OLAPDataSetInterface getOLAPDataSet(Object iqObject, int contextType) throws IQueryServicesException {
        if (iqObject == null) {
            String stringResource = IQDataServicesResourceBundle.getStringResource("MetadataProviderNullModel.txt");
            _logger.error(stringResource);
            throw new IQueryServicesException(stringResource);
        }
        boolean disposeOnExit = false;
        DataSelection dataSelection = null;
        if (iqObject instanceof DataSelection) {
            dataSelection = (DataSelection)iqObject;
        } else if (iqObject instanceof BusinessModel) {
            dataSelection = DataSelectionFactory.newDataSelection((BusinessModel)iqObject);
            disposeOnExit = true;
        } else if (iqObject instanceof BusinessQuery) {
            dataSelection = DataSelectionFactory.newDataSelection(((BusinessQuery)iqObject).getBusinessModel());
            disposeOnExit = true;
        }
        if (dataSelection == null) {
            String message = IQDataServicesResourceBundle.getStringResource("MetadataProviderNoValidiqObject.txt");
            _logger.error(iqObject.getClass().getCanonicalName() + " " + iqObject);
            _logger.error(message);
            throw new IQueryServicesException(message);
        }
        IQOLAPDataSet olapDataSet = null;
        try {
            if (!dataSelection.getStructure().isOLAP()) {
                String message = IQDataServicesResourceBundle.getStringResource("MetadataProviderNoValidModel.txt");
                _logger.error(dataSelection.getIdentityString());
                _logger.error(message);
                throw new IQueryServicesException(message);
            }
            olapDataSet = BusinessQueryOLAPUtil.createOlapDataSet(contextType, dataSelection);
            disposeOnExit = false;
        }
        finally {
            if (disposeOnExit) {
                dataSelection.dispose();
            }
        }
        return olapDataSet;
    }

    @SASScope
    public static OlapItem getOlapItem(DataItem dataItem) throws MetadataException {
        OlapItem returnValue = null;
        ExpressionInterface obj = dataItem.getExpression();
        if (obj instanceof OlapItem) {
            returnValue = (OlapItem)obj;
        } else if (obj instanceof ResourceAwareStringExpression) {
            Hierarchy hierarchy;
            ResourceAwareStringExpression resourceExp = (ResourceAwareStringExpression)obj;
            List<BusinessModelResource> resources = resourceExp.getResources(BusinessModelResource.class, 65535);
            if (resources.size() == 0 || resources.size() > 1) {
                return returnValue;
            }
            BusinessModelResource bmaResource = null;
            for (BusinessModelResource resource : resources) {
                if (!(resource instanceof DataItem) && !(resource instanceof Dimension) && !(resource instanceof Hierarchy) && !(resource instanceof Level) && !(resource instanceof NamedSet) && !(resource instanceof CalculatedMember) && !(resource instanceof Measure)) continue;
                bmaResource = resource;
                break;
            }
            if (bmaResource == null) {
                throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("BusinessQueryOLAPUtilNoOLAPResourcesFound.txt", new Object[0]));
            }
            if (bmaResource instanceof DataItem) {
                DataItem di = (DataItem)bmaResource;
                returnValue = BusinessQueryOLAPUtil.getOlapItem(di);
            } else if (bmaResource instanceof Dimension) {
                returnValue = (OlapItem)((Object)bmaResource);
            } else if (bmaResource instanceof Hierarchy) {
                returnValue = (OlapItem)((Object)bmaResource);
            } else if (bmaResource instanceof Level) {
                returnValue = (OlapItem)((Object)bmaResource);
            } else if (bmaResource instanceof Measure) {
                returnValue = (OlapItem)((Object)bmaResource);
            } else if (bmaResource instanceof NamedSet) {
                NamedSet namedSet = (NamedSet)bmaResource;
                hierarchy = namedSet.getOwningHierarchy();
                returnValue = hierarchy;
            } else if (bmaResource instanceof CalculatedMember) {
                CalculatedMember calcName = (CalculatedMember)bmaResource;
                hierarchy = calcName.getOwningHierarchy();
                returnValue = hierarchy;
            }
        }
        return returnValue;
    }

    public static String getPhysDimensionName(Dimension dimension) {
        String uniqueName = null;
        try {
            if (dimension != null && !dimension.isUnresolved()) {
                uniqueName = dimension.getUniqueName();
            }
        }
        catch (MetadataException e) {
            String message = IQMetadataResourceBundle.getStringResource("BusinessQueryOLAPNoDimensionName.txt");
            _logger.warn(dimension.getIdentityString());
            _logger.warn(message, (Throwable)e);
        }
        return uniqueName;
    }

    @SASScope
    public static String getPhysHierarchyName(Hierarchy hierarchy) {
        String uniqueName = null;
        try {
            if (hierarchy != null && !hierarchy.isUnresolved()) {
                uniqueName = BusinessQueryOLAPUtil.generateUniqueHierarchyName(hierarchy);
            }
        }
        catch (MetadataException e) {
            String message = IQMetadataResourceBundle.getStringResource("BusinessQueryOLAPUtilGetUniqueHierarchyNameFailure.txt");
            _logger.warn(hierarchy.getIdentityString());
            _logger.warn(message, (Throwable)e);
        }
        return uniqueName;
    }

    @SASScope
    public static String getPhysLevelName(Level level) {
        String uniqueName = null;
        try {
            if (level != null && !level.isUnresolved()) {
                uniqueName = level.getLevelUniqueName();
            }
        }
        catch (MetadataException e) {
            String message = IQMetadataResourceBundle.getStringResource("BusinessQueryOLAPUtilGetHierarchyLevelNameFailure.txt");
            _logger.warn(level.getIdentityString());
            _logger.warn(message, (Throwable)e);
        }
        return uniqueName;
    }

    @SASScope
    public static String getPhysMeasureName(Measure measure) {
        String uniqueName = null;
        try {
            if (measure != null && !measure.isUnresolved()) {
                uniqueName = BusinessQueryOLAPUtil.generateUniqueHierarchyName(measure);
            }
        }
        catch (MetadataException e) {
            String message = IQMetadataResourceBundle.getStringResource("BusinessQueryOLAPUtilGetMeasureLevelNameFailure.txt");
            _logger.warn(measure.getIdentityString());
            _logger.warn(message, (Throwable)e);
        }
        return uniqueName;
    }

    private static String getStartingLevel(DataItem dataItem) {
        try {
            return dataItem.getStartingLevelName();
        }
        catch (MetadataException e) {
            String message = IQMetadataResourceBundle.getStringResource("BusinessqueryOLAPMetadataExcStarting.txt");
            _logger.warn(dataItem.getIdentityString());
            _logger.warn(message, (Throwable)e);
            return null;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getUniqueNameWithHierarchyAllMember(DataItem dataItem) throws MetadataException {
        Object returnValue;
        boolean isMeasure;
        boolean isUsable = true;
        List<BusinessModelResource> resources = dataItem.getResources(BusinessModelResource.class, 65535);
        Iterator<BusinessModelResource> it = resources.iterator();
        while (it.hasNext() && isUsable) {
            List<Reason> reasons = it.next().getReasonsUnusable();
            if (reasons.size() <= 0) continue;
            isUsable = false;
            StringBuilder buffer = new StringBuilder();
            buffer.append(IQDataServicesResourceBundle.getStringResource("MDXGenerationNotValidReasons.txt")).append(MDXGenerationUtil.NEWLINE);
            _logger.warn(buffer.toString());
            Iterator<Reason> iterator = reasons.iterator();
            Locale viewerLocale = LocaleUtilities.getDefaultViewerLocale(dataItem.getBusinessModel());
            while (iterator.hasNext()) {
                Reason reason = iterator.next();
                String reasonString = reason.getReasonString(viewerLocale);
                _logger.warn(reasonString);
                buffer.append(reasonString);
                if (!iterator.hasNext()) continue;
                buffer.append(MDXGenerationUtil.NEWLINE);
            }
        }
        if (!isUsable) {
            return null;
        }
        ExpressionInterface expression = dataItem.getExpression();
        if (expression instanceof Measure) {
            return null;
        }
        if (expression instanceof OLAPResourceAwareStringExpression) {
            OLAPResourceAwareStringExpression olapRASE = (OLAPResourceAwareStringExpression)expression;
            return olapRASE.getAllMember();
        }
        if (!(expression instanceof ResourceAwareStringExpression) && dataItem.getStructure() != StructureOfDataItem.STRUCTURE_COLUMN) {
            return null;
        }
        String v92OlapIsMeasure = BusinessQueryOLAPUtil.getExtendedAtributeValue(dataItem, EXTENDED_ATTRIBUTE_IS_MEASURE);
        if (v92OlapIsMeasure != null && Boolean.valueOf(v92OlapIsMeasure).booleanValue()) {
            return null;
        }
        boolean bl = isMeasure = false;
        if (isMeasure) {
            return null;
        }
        String v92OlapDimensionName = BusinessQueryOLAPUtil.getExtendedAtributeValue(dataItem, EXTENDED_ATTRIBUTE_DIMENSION_NAME);
        if (v92OlapDimensionName == null) {
            String rsid = dataItem.getResultSetID();
            return ROLAPNamesUtil.getAllMemberUniqueName(rsid);
        }
        String v92OlapHierarchyName = BusinessQueryOLAPUtil.getExtendedAtributeValue(dataItem, EXTENDED_ATTRIBUTE_HIERARCHY_NAME);
        if (v92OlapHierarchyName == null) {
            returnValue = null;
        } else {
            Model dataSelection;
            boolean disposeDataSelection;
            block21: {
                String constructor = "DEFAULT_CONSTRUCTOR_BEHAVIOR";
                IQMetadataInterface olapMeta = null;
                disposeDataSelection = false;
                dataSelection = null;
                try {
                    MemberInterface topMember;
                    BusinessModel businessModel = null;
                    String cubeName = null;
                    businessModel = OLAPUtilities.findBusinessModel(null, null, dataItem);
                    dataSelection = OLAPUtilities.findDataSelection(null, businessModel);
                    if (dataSelection == null) {
                        disposeDataSelection = true;
                        dataSelection = OLAPUtilities.createDataSelection(businessModel, null);
                    }
                    if (!dataSelection.getStructure().isOLAP()) {
                        String message = IQDataServicesResourceBundle.getStringResource("MetadataProviderNoValidModel.txt");
                        ConnectionUtil.LoggerErrorWithObjects(_logger, message, dataItem, businessModel, dataSelection);
                        throw new ExecutionException(message);
                    }
                    Locale computationalLocale = LocaleUtilities.getDefaultComputationalLocale((BusinessModel)dataSelection);
                    DataSourceCube dataCube = OLAPUtilities.findDataSourceCube((BusinessModel)dataSelection);
                    cubeName = OLAPUtilities.findCubeName(dataCube);
                    SoftwareServer softwareServer = OLAPUtilities.findSoftwareServer(dataCube);
                    LogicalServerInterface logicalServer = OLAPUtilities.findLogicalServerInterface(softwareServer);
                    OLAPConnectionResource olapConnection = BusinessQueryOLAPUtil.newOLAPConnectionResource((DataSelection)dataSelection, logicalServer, computationalLocale);
                    olapMeta = olapConnection.createMetadataInterface((BusinessModel)dataSelection, constructor, dataCube, true, true, null);
                    Filter filter = new Filter();
                    filter.setCubeName(cubeName);
                    filter.setUniqueDimensionName(v92OlapDimensionName);
                    filter.setUniqueHierarchyName(v92OlapHierarchyName);
                    HierarchyInterface olapHierarchy = olapMeta.getHierarchy(filter);
                    returnValue = olapHierarchy == null ? null : ((topMember = olapHierarchy.getTopMember()) == null || topMember.getType() != 2 ? null : topMember.getUniqueName());
                    if (olapMeta == null) break block21;
                }
                catch (GenerationException e) {
                    try {
                        MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("MetadataProviderNoMetadata.txt", new Object[0]);
                        ConnectionUtil.LoggerErrorWithObjects(_logger, message, e, dataItem, dataSelection);
                        throw new MetadataException(message, (Throwable)e);
                        catch (ExecutionException e2) {
                            message = IQDataServicesResourceBundle.getMessageFormatter("OLAPStrategyNoMetadataI.txt", new Object[0]);
                            ConnectionUtil.LoggerErrorWithObjects(_logger, message, e2, dataItem, dataSelection);
                            MetadataException ee = new MetadataException(message, (Throwable)e2);
                            throw ee;
                        }
                        catch (OLAPException oe) {
                            MessageFormatter messageFormatter = IQMetadataResourceBundle.getMessageFormatter("BusinessQueryOLAPNoConnection.txt", new Object[0]);
                            _logger.error(dataItem.getIdentityString());
                            _logger.error(messageFormatter.toString(), (Throwable)oe);
                            MetadataException me = new MetadataException(messageFormatter, (Throwable)oe);
                            throw me;
                        }
                    }
                    catch (Throwable throwable) {
                        if (olapMeta != null) {
                            BusinessQueryOLAPUtil.releaseMetadataInterface(olapMeta);
                        }
                        if (dataSelection == null) throw throwable;
                        if (!disposeDataSelection) throw throwable;
                        dataSelection.dispose();
                        throw throwable;
                    }
                }
                BusinessQueryOLAPUtil.releaseMetadataInterface(olapMeta);
            }
            if (dataSelection != null && disposeDataSelection) {
                dataSelection.dispose();
            }
        }
        if (returnValue != null) return returnValue;
        Object[] msgArgs2 = new Object[]{expression.toString(), IQMetadataResourceBundle.getStringResource("BusinessQueryOLAPInvalidROLAPItem.txt")};
        ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
        _logger.error(msF.toString());
        return returnValue;
    }

    private static String getExtendedAtributeValue(DataItem item, String attributeName) {
        String returnValue;
        block5: {
            returnValue = null;
            MDXGenerationUtil.applyDebugStatement("Looking for attribute - " + attributeName, BusinessQueryOLAPUtil.class);
            MDXGenerationUtil.applyDebugStatement("    item = " + item.getIdentityString(), BusinessQueryOLAPUtil.class);
            try {
                EntityInterface entity = item.getExtendedAttributes();
                if (entity == null) break block5;
                Object attributeValue = null;
                try {
                    attributeValue = entity.getAttribute(attributeName);
                }
                catch (NoSuchElementException e) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
                if (attributeValue != null && attributeValue.toString().trim().length() > 0) {
                    returnValue = attributeValue.toString();
                    MDXGenerationUtil.applyDebugStatement("Found attribute - " + attributeName + ", value = " + returnValue, BusinessQueryOLAPUtil.class);
                }
            }
            catch (Exception e) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
                _logger.debug("Error getting extended attribute.", (Throwable)e);
            }
        }
        return returnValue;
    }

    public static boolean isInMeasureDimension(BusinessModel businessModel, DataItem dataItem) throws MetadataException {
        boolean returnValue = false;
        OlapItem olapItem = BusinessQueryOLAPUtil.getOlapItem(dataItem);
        ExpressionInterface expression = dataItem.getExpression();
        if (expression instanceof FractionOfTotalExpression || expression instanceof TimeExpressionMeasure) {
            returnValue = true;
        } else if (expression instanceof OLAPResourceAwareStringExpression) {
            OLAPResourceAwareStringExpression olapRASE = (OLAPResourceAwareStringExpression)expression;
            returnValue = olapRASE.isMeasure();
        } else if (expression instanceof ResourceAwareStringExpression || dataItem.getStructure() == StructureOfDataItem.STRUCTURE_COLUMN) {
            String attributeValue = BusinessQueryOLAPUtil.getExtendedAtributeValue(dataItem, EXTENDED_ATTRIBUTE_IS_MEASURE);
            if (attributeValue != null) {
                returnValue = Boolean.valueOf(attributeValue);
            } else {
                returnValue = dataItem.getUsage().equals(DataItemActionType.USAGE_AGGREGATE);
                _logger.debug("This is a non-OLAP data element being present into a OLAP type class for IQ." + dataItem.getIdentityString() + " " + expression.toString());
            }
        } else if (olapItem != null) {
            returnValue = olapItem.isInMeasureDimension();
        } else {
            _logger.warn("This is object type could not be identified" + expression.getExpressionType() + " " + dataItem.getIdentityString());
        }
        return returnValue;
    }

    private static OLAPConnectionResource newOLAPConnectionResource(DataSelection dataSelection, LogicalServerInterface logicalServer, Locale connectionLocale) throws GenerationException {
        RetrievalPolicy userSessionPolicy = new RetrievalPolicy();
        Locale connectLocale = connectionLocale;
        userSessionPolicy.setPolicyValue(0);
        ConnectionConfiguration connectionConfiguration = userSessionPolicy.getConnectionConfiguration();
        connectionConfiguration.setConnectionLifetime(1);
        Locale tempConnectionLocale = null;
        tempConnectionLocale = LocaleUtilities.getDefaultViewerLocale(dataSelection);
        if (tempConnectionLocale != null && !tempConnectionLocale.equals(connectionLocale)) {
            connectLocale = tempConnectionLocale;
        }
        OLAPConnectionResource olapConnection = OLAPConnectionInfoUtil.getOLAPConnectionResource(dataSelection, logicalServer, userSessionPolicy, connectLocale);
        return olapConnection;
    }

    public static void releaseMetadataInterface(MetadataInterface metadataInterface) {
        if (metadataInterface instanceof IQMetadataInterface) {
            IQMetadataInterface iqMetadataInterface = (IQMetadataInterface)metadataInterface;
            OLAPConnectionResource olapConnection = iqMetadataInterface.getRelatedConnection();
            if (olapConnection != null) {
                olapConnection.releaseMetadataInterfaceFromISession(iqMetadataInterface);
            }
        } else {
            _logger.warn(IQMetadataResourceBundle.getStringResource("BusinessqueryOLAPBadIQMetdataInterface.txt"));
        }
    }

    public static void releaseOLAPDataSet(OLAPDataSetInterface olapDataSet) {
        if (olapDataSet instanceof IQOLAPDataSetInterface) {
            IQOLAPDataSetInterface iqOLAPDataSet = (IQOLAPDataSetInterface)olapDataSet;
            OLAPConnectionResource olapConnection = iqOLAPDataSet.getRelatedConnection();
            if (olapConnection != null) {
                olapConnection.releaseOLAPDataSetFromISession(iqOLAPDataSet);
            }
        } else {
            _logger.warn(IQMetadataResourceBundle.getStringResource("BusinessqueryOLAPBadIQOLAPDataInterface.txt"));
        }
    }

    private static String getDimensionStringFromString(String inString) {
        String part = inString.substring(inString.indexOf("["));
        return part.substring(1, part.indexOf("]"));
    }

    @SASScope
    public static boolean shouldReplaceStringInFilter(Object whatToCompare, Object newObject) {
        boolean returnValue = false;
        if (newObject instanceof PhysicalResource && ((PhysicalResource)newObject).isUnresolved()) {
            _logger.warn(IQMetadataResourceBundle.getStringResource("BusinessqueryOLAPUnResolvedReplacement.txt"));
        } else {
            try {
                Hierarchy omah;
                String dimName;
                if (whatToCompare instanceof DataItem && newObject instanceof Hierarchy) {
                    ExpressionInterface hierarchyOfDataItem = ((DataItem)whatToCompare).getExpression();
                    if (hierarchyOfDataItem instanceof Hierarchy) {
                        Hierarchy omah2 = (Hierarchy)hierarchyOfDataItem;
                        String hierName = omah2.getHierarchyName();
                        if (hierName.equalsIgnoreCase(((Hierarchy)newObject).getHierarchyName())) {
                            returnValue = true;
                        }
                    } else if (hierarchyOfDataItem instanceof OLAPResourceAwareStringExpression) {
                        OLAPResourceAwareStringExpression olapE = (OLAPResourceAwareStringExpression)hierarchyOfDataItem;
                        Hierarchy omah3 = olapE.getHierarchy();
                        if (omah3 != null) {
                            String hierName = omah3.getHierarchyName();
                            if (hierName.equalsIgnoreCase(((Hierarchy)newObject).getHierarchyName())) {
                                returnValue = true;
                            }
                        } else {
                            _logger.warn(IQMetadataResourceBundle.getStringResource("BusinessqueryOLAPNoReplaceNull.txt"));
                        }
                    }
                } else if (whatToCompare instanceof Hierarchy && newObject instanceof Hierarchy) {
                    if (((Hierarchy)whatToCompare).getHierarchyName().equalsIgnoreCase(((Hierarchy)newObject).getHierarchyName())) {
                        returnValue = true;
                    }
                } else if (whatToCompare instanceof DataItem && newObject instanceof Dimension) {
                    OLAPResourceAwareStringExpression olapE;
                    String dimName2;
                    ExpressionInterface hierarchyOfDataItem = ((DataItem)whatToCompare).getExpression();
                    if (hierarchyOfDataItem instanceof Hierarchy) {
                        Hierarchy omah4 = (Hierarchy)hierarchyOfDataItem;
                        String dimName3 = omah4.getOwningDimension().getDimensionName();
                        if (dimName3.equalsIgnoreCase(((Dimension)newObject).getDimensionName())) {
                            returnValue = true;
                        }
                    } else if (hierarchyOfDataItem instanceof OLAPResourceAwareStringExpression && (dimName2 = (olapE = (OLAPResourceAwareStringExpression)hierarchyOfDataItem).getDimName()).equalsIgnoreCase(((Dimension)newObject).getDimensionName())) {
                        returnValue = true;
                    }
                } else if (whatToCompare instanceof Hierarchy && newObject instanceof Dimension && (dimName = (omah = (Hierarchy)whatToCompare).getOwningDimension().getDimensionName()).equalsIgnoreCase(((Dimension)newObject).getDimensionName())) {
                    returnValue = true;
                }
            }
            catch (MetadataException me) {
                _logger.warn(IQMetadataResourceBundle.getStringResource("BusinessqueryOLAPUndetermineReplacementString.txt"));
            }
        }
        return returnValue;
    }

    @SASScope
    public static void determineUnresolvedStateInDimensionString(String inString, List<Reason> reasons, Dimension dim, AbstractModelItem caller) {
        if (dim == null) {
            return;
        }
        try {
            if (!dim.getDimensionName().equalsIgnoreCase(BusinessQueryOLAPUtil.getDimensionStringFromString(inString))) {
                reasons.add(new Reason((Object)caller, 2, 5, "Expression has an unresolved dimension.", new Object[0]));
            }
        }
        catch (MetadataException me) {
            reasons.add(new Reason((Object)caller, 2, 5, me.getLocalizedMessage(), new Object[0]));
        }
    }

    @SASScope
    public static void replaceHierarchyInFilter(Object whatToReplace, ExpressionInterface whatToCompare, Object replacementObject) {
        ExpressionInterface hierarchyOfDataItem;
        if (whatToCompare instanceof DataItem && replacementObject instanceof PhysicalResource && !((PhysicalResource)replacementObject).isUnresolved() && (hierarchyOfDataItem = ((DataItem)whatToCompare).getExpression()) instanceof Hierarchy) {
            PhysicalResource phy = (PhysicalResource)replacementObject;
            MDXGenerationUtil.applyDebugStatement("Resource replacement has changed the physical resource " + phy.getIdentityString(), BusinessQueryOLAPUtil.class);
            BusinessQueryOLAPUtil.replaceHierarchyInString(whatToReplace, replacementObject);
        }
    }

    @SASScope
    public static ConstantExpression convertStringIntoExpression(String string) {
        ConstantExpression exp = new ConstantExpression();
        exp.setValue(string);
        exp.setExpressionType(3);
        return exp;
    }

    @SASScope
    public static void replaceHierarchyInString(Object itemToReplace, Object replacementObject) {
        if (itemToReplace instanceof AbstractExpression && replacementObject instanceof Hierarchy) {
            String conStr = null;
            Hierarchy replacmentHier = (Hierarchy)replacementObject;
            try {
                if (itemToReplace instanceof ConstantExpression) {
                    conStr = ((ConstantExpression)itemToReplace).getValue();
                } else if (itemToReplace instanceof StringExpression) {
                    conStr = ((StringExpression)itemToReplace).getText();
                }
                if (conStr != null) {
                    String hierString = replacmentHier.getHierarchyName();
                    String part = conStr;
                    int firstIndex = conStr.indexOf(".");
                    int thirdIndex = 0;
                    int secondIndex = 0;
                    if (firstIndex > 0) {
                        part = conStr.substring(firstIndex + 1);
                        secondIndex = conStr.indexOf(".", firstIndex + 1);
                    }
                    if (secondIndex > 0) {
                        thirdIndex = conStr.indexOf(".", secondIndex + 1);
                        part = conStr.substring(secondIndex + 1);
                    }
                    if (thirdIndex > 0) {
                        part = conStr.substring(thirdIndex + 1);
                        StringBuilder replacement = new StringBuilder();
                        replacement.append(replacmentHier.getAllMember()).append(".").append(part);
                        if (itemToReplace instanceof ConstantExpression) {
                            ((ConstantExpression)itemToReplace).setValue(replacement.toString());
                        } else if (itemToReplace instanceof StringExpression) {
                            ((StringExpression)itemToReplace).setText(replacement.toString());
                        }
                        MDXGenerationUtil.applyDebugStatement("Resource replacement has changed the hierarchy that is defined in this filter from " + part + " to " + replacement.toString(), BusinessQueryOLAPUtil.class);
                        return;
                    }
                    boolean modified = false;
                    for (Level level : replacmentHier.getLevels(false)) {
                        String levelName = level.getLevelName();
                        if (!part.substring(part.indexOf("[") + 1, part.indexOf("]")).equalsIgnoreCase(levelName)) continue;
                        StringBuilder replacement = new StringBuilder();
                        replacement.append("[").append(replacmentHier.getOwningDimension().toString()).append("].[").append(hierString).append("].").append(part);
                        if (itemToReplace instanceof ConstantExpression) {
                            ((ConstantExpression)itemToReplace).setValue(replacement.toString());
                        } else if (itemToReplace instanceof StringExpression) {
                            ((StringExpression)itemToReplace).setText(replacement.toString());
                        }
                        MDXGenerationUtil.applyDebugStatement("Resource replacement has changed the hierarchy that is defined in this filter from " + part + " to " + replacement.toString(), BusinessQueryOLAPUtil.class);
                        modified = true;
                        break;
                    }
                    if (!modified) {
                        _logger.warn(replacmentHier.getIdentityString() + " " + IQMetadataResourceBundle.getStringResource("BusinessqueryOLAPLevelNotReplacedNoLevels.txt"));
                    }
                }
            }
            catch (MetadataException me) {
                _logger.warn("String could not be replaced because hierarchy levels could not be aquired. " + me.getLocalizedMessage());
            }
        }
    }

    @SASScope
    public static boolean isPersistencePath(Object oldObject, Object newObject) {
        boolean persistence = false;
        try {
            if (oldObject instanceof Dimension && newObject instanceof Dimension) {
                if (((Dimension)oldObject).getDimensionName().equals(((Dimension)newObject).getDimensionName())) {
                    persistence = true;
                    MDXGenerationUtil.applyDebugStatement("This is a pass through replace using persistence not replacement", BusinessQueryOLAPUtil.class);
                }
            } else if (oldObject instanceof Hierarchy && newObject instanceof Hierarchy && ((Hierarchy)oldObject).getHierarchyName().equals(((Hierarchy)newObject).getHierarchyName())) {
                persistence = true;
                MDXGenerationUtil.applyDebugStatement("This is a pass through replace using persistence not replacement", BusinessQueryOLAPUtil.class);
            }
        }
        catch (MetadataException me) {
            _logger.warn(me.getLocalizedMessage());
        }
        return persistence;
    }

    @SASScope
    public static void replaceDimensionInString(Object itemToReplace, Object replacementObject) {
        if (itemToReplace instanceof AbstractExpression && replacementObject instanceof Dimension) {
            String conStr = null;
            Dimension replaceDim = (Dimension)replacementObject;
            try {
                if (itemToReplace instanceof ConstantExpression) {
                    conStr = ((ConstantExpression)itemToReplace).getValue();
                } else if (itemToReplace instanceof StringExpression) {
                    conStr = ((StringExpression)itemToReplace).getText();
                }
                if (conStr != null) {
                    String dimString = replaceDim.getDimensionName();
                    String part = conStr;
                    int firstIndex = conStr.indexOf(".");
                    if (firstIndex > 0) {
                        part = conStr.substring(firstIndex + 1);
                    }
                    StringBuilder replacement = new StringBuilder();
                    replacement.append("[").append(dimString).append("].").append(part);
                    if (itemToReplace instanceof ConstantExpression) {
                        ((ConstantExpression)itemToReplace).setValue(replacement.toString());
                    } else if (itemToReplace instanceof StringExpression) {
                        ((StringExpression)itemToReplace).setText(replacement.toString());
                    }
                    MDXGenerationUtil.applyDebugStatement("Resource replacement has changed the dimension that is defined in this filter from " + part + " to " + replacement.toString(), MDXGenerationUtil.class);
                }
            }
            catch (MetadataException me) {
                _logger.warn(replaceDim.getIdentityString() + " " + IQMetadataResourceBundle.getStringResource("BusinessqueryOLAPStringNotReplaced.txt") + me.getLocalizedMessage());
            }
        }
    }
}

