/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.report.xml.olap;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.strategies.sas.report.xml.olap.AbstractDataElement;
import com.sas.iquery.strategies.sas.report.xml.olap.LevelMembersList;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import java.util.Collection;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Member
extends AbstractDataElement {
    public static final String NODE_NAME = "Member";
    public static final String MEASURES_HIER_NODE_NAME = "Measures";
    private String _name = null;
    private String _label = null;
    private String _level = null;
    private String _dimension = null;
    private String _parentMember = null;
    private static final Logger _logger = LogManager.getLogger(Member.class);

    public String toString() {
        StringBuffer buffer = new StringBuffer(NODE_NAME);
        buffer.append(":");
        buffer.append(" name=");
        buffer.append(this.getName());
        buffer.append(", label=");
        buffer.append(this.getLabel());
        buffer.append(", level=");
        buffer.append(this.getLevel());
        buffer.append(", dimension=");
        buffer.append(this.getDimension());
        buffer.append(", parentMember=");
        buffer.append(this.getParentMember());
        return buffer.toString();
    }

    public String getDimension() {
        return this._dimension;
    }

    public String getLabel() {
        return this._label;
    }

    public String getLevel() {
        return this._level;
    }

    public String getName() {
        return this._name;
    }

    public void setDimension(String dimension) {
        this._dimension = dimension;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public void setLevel(String level) {
        this._level = level;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getParentMember() {
        return this._parentMember;
    }

    public void setParentMember(String parentMember) {
        this._parentMember = parentMember;
    }

    @Override
    public void read(Node domNode) {
        Map<String, String> attributeMap = AbstractDataElement.readNodeAttributes(domNode);
        this.setDimension(attributeMap.get("dimension"));
        this.setLabel(attributeMap.get("label"));
        this.setLevel(attributeMap.get("level"));
        this.setName(attributeMap.get("name"));
        this.setParentMember(attributeMap.get("parentMember"));
        if (_logger.isDebugEnabled()) {
            _logger.debug(this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Element element) throws ExecutionException {
        block17: {
            try {
                boolean elementWithSameNameExists;
                Document doc = element.getOwnerDocument();
                TupleElementInterface tupleElement = (TupleElementInterface)this._callingElement;
                String tupleElementName = tupleElement.getName();
                String tupleElementLabel = tupleElement.getLabel();
                String tupleElementUniqueLevelName = tupleElement.getUniqueLevelName();
                TupleInterface currentTuple = tupleElement.getTuple();
                DimensionInterface dimension = (DimensionInterface)this._membersMap.get(tupleElementUniqueLevelName);
                String tupleElementDimensionName = dimension.getName();
                if (_logger.isDebugEnabled()) {
                    _logger.debug("\tTupleElement Name .............: " + tupleElementName);
                    _logger.debug("\tTupleElement Label ............: " + tupleElementLabel);
                    _logger.debug("\tTupleElement Unique Level Name : " + tupleElementUniqueLevelName);
                    _logger.debug("\tTupleElement Dimension Name ...: " + tupleElementDimensionName);
                }
                element.setAttribute("dimension", tupleElementDimensionName);
                element.setAttribute("label", tupleElementLabel);
                element.setAttribute("name", tupleElementName);
                String uniqueLevelName = tupleElement.getUniqueLevelName();
                LevelMembersList<Element> levelMembers = (LevelMembersList<Element>)this._levelsMap.get(uniqueLevelName);
                if (levelMembers == null) {
                    levelMembers = new LevelMembersList<Element>(tupleElement.getTupleElementIndex());
                    this._levelsMap.put(uniqueLevelName, levelMembers);
                }
                levelMembers.addPassedTuple(currentTuple);
                levelMembers.checkResetCurrentPointer();
                String newElmName = element.getAttribute("name");
                int existingIndex = levelMembers.containsName(newElmName);
                boolean bl = elementWithSameNameExists = existingIndex != -1;
                if (!elementWithSameNameExists) {
                    levelMembers.insertRightOfCurrent(element);
                } else {
                    levelMembers.insertIfLeftAndUpdate(element, existingIndex);
                }
                if (tupleElementDimensionName.equals(MEASURES_HIER_NODE_NAME)) {
                    boolean isInList = false;
                    for (Object element2 : this._measureDocElements) {
                        Element docElement = (Element)element2;
                        String docElementName = docElement.getAttribute("name");
                        if (!docElementName.equals(tupleElementName)) continue;
                        isInList = true;
                    }
                    if (!isInList) {
                        Element measureDocElement = doc.createElement(NODE_NAME);
                        measureDocElement.setAttribute("dimension", tupleElementDimensionName);
                        measureDocElement.setAttribute("label", tupleElementLabel);
                        measureDocElement.setAttribute("name", tupleElementName);
                        this._measureDocElements.add(measureDocElement);
                    }
                }
                this._usedDimensionsSet.add(dimension);
                if (!this._usedLevelsSet.contains(tupleElement.getUniqueLevelName())) {
                    Collection collection = this._usedLevelsSet;
                    synchronized (collection) {
                        this._usedLevelsSet.add(tupleElement.getUniqueLevelName());
                    }
                }
                if (this._usedMembersSet.contains(tupleElement.getName())) break block17;
                Collection collection = this._usedMembersSet;
                synchronized (collection) {
                    this._usedMembersSet.add(tupleElement.getName());
                }
            }
            catch (OLAPException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(IQDataServicesResourceBundle.getStringResource("Member.write.OLAPException.txt"), (Throwable)e);
                }
                throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("Member.write.OLAPException.txt", new Object[0]), (Throwable)e);
            }
        }
    }
}

