/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.report.xml.olap;

import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.w3c.dom.Element;

public class LevelMembersList<E extends Element>
implements List<E> {
    private int _tupleElementIndex;
    private final ArrayList<E> _members = new ArrayList();
    private int _currentPointer = 0;
    private final HashSet<String> _memberNames = new HashSet();
    private final ArrayList<TupleInterface> _passedTuples = new ArrayList();

    public LevelMembersList(int tupleElementIndex) {
        this._tupleElementIndex = tupleElementIndex;
    }

    public ArrayList<E> getMembers() {
        return this._members;
    }

    public int containsName(String name) {
        if (!this._memberNames.contains(name)) {
            return -1;
        }
        int foundIndex = -1;
        ListIterator<E> membersIt = this._members.listIterator();
        while (membersIt.hasNext()) {
            Element existingElm = (Element)membersIt.next();
            String existingElmName = existingElm.getAttribute("name");
            if (!existingElmName.equals(name)) continue;
            foundIndex = membersIt.nextIndex() - 1;
            break;
        }
        return foundIndex;
    }

    public void insertRightOfCurrent(E element) {
        this._members.add(this._currentPointer, element);
        ++this._currentPointer;
        this._memberNames.add(element.getAttribute("name"));
    }

    public void checkResetCurrentPointer() throws OLAPException {
        if (this.haveElementNamesChangedLeftOf(this._tupleElementIndex)) {
            this._currentPointer = 0;
        }
    }

    private boolean haveElementNamesChangedLeftOf(int tupleElementIndex) throws OLAPException {
        if (this._passedTuples.size() < 2) {
            return false;
        }
        TupleInterface currentTuple = this._passedTuples.get(this._passedTuples.size() - 1);
        TupleInterface lastTuple = this._passedTuples.get(this._passedTuples.size() - 2);
        for (int idx = tupleElementIndex - 1; idx >= 0; --idx) {
            TupleElementInterface currentElement = currentTuple.getElement(idx);
            TupleElementInterface lastElement = lastTuple.getElement(idx);
            if (currentElement.getName().equals(lastElement.getName())) continue;
            return true;
        }
        return false;
    }

    public void addPassedTuple(TupleInterface tuple) {
        this._passedTuples.add(tuple);
    }

    public void insertIfLeftAndUpdate(E element, int position) {
        if (position >= this._currentPointer) {
            if (this._currentPointer < this.size()) {
                ++this._currentPointer;
            }
        } else {
            this.remove(position);
            this.insertRightOfCurrent(element);
        }
    }

    public String toString() {
        return this._members.toString();
    }

    @Override
    public int size() {
        return this._members.size();
    }

    @Override
    public boolean isEmpty() {
        return this._members.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this._members.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this._members.iterator();
    }

    @Override
    public Object[] toArray() {
        return this._members.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this._members.toArray(a);
    }

    @Override
    public boolean add(E o) {
        return this._members.add(o);
    }

    @Override
    public boolean remove(Object o) {
        return this._members.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this._members.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this._members.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this._members.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this._members.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this._members.retainAll(c);
    }

    @Override
    public void clear() {
        this._members.clear();
    }

    @Override
    public E get(int index) {
        return (E)((Element)this._members.get(index));
    }

    @Override
    public E set(int index, E element) {
        return (E)((Element)this._members.set(index, element));
    }

    @Override
    public void add(int index, E element) {
        this._members.add(index, element);
    }

    @Override
    public E remove(int index) {
        if (this._currentPointer == this._members.size()) {
            --this._currentPointer;
        }
        return (E)((Element)this._members.remove(index));
    }

    @Override
    public int indexOf(Object o) {
        return this._members.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this._members.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this._members.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this._members.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this._members.subList(fromIndex, toIndex);
    }
}

