/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.report.xml.olap;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.strategies.sas.report.xml.olap.AbstractDataElement;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.OLAPException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Level
extends AbstractDataElement {
    public static final String NODE_NAME = "Level";
    public static final String MEASURES_LEVEL_NODE_NAME = "MeasuresLevel";
    private int _depth = 0;
    private String _label = null;
    private String _name = null;
    private String _uniqueName;
    private static final Logger _logger = LogManager.getLogger(Level.class);

    public int getDepth() {
        return this._depth;
    }

    public String getLabel() {
        return this._label;
    }

    public String getName() {
        return this._name;
    }

    public void setDepth(int depth) {
        this._depth = depth;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    public void read(Node domNode) {
        Map<String, String> attributeMap = AbstractDataElement.readNodeAttributes(domNode);
        this.setDepth(Integer.valueOf(attributeMap.get("depth")));
        this.setLabel(attributeMap.get("label"));
        this.setName(attributeMap.get("name"));
    }

    public String toString() {
        StringBuffer output = new StringBuffer("Level : ");
        output.append("depth=\"");
        output.append(this.getDepth());
        output.append("\" label=\"");
        output.append(this.getLabel());
        output.append("\" name=\"");
        output.append(this.getName());
        output.append("\"\n");
        return output.toString();
    }

    @Override
    public void write(Element element) throws ExecutionException {
        try {
            LevelInterface level = (LevelInterface)this._callingElement;
            String levelUniqueName = level.getUniqueName();
            if (this._usedLevelsSet != null && !this._usedLevelsSet.contains(levelUniqueName)) {
                this._doWrite = false;
                return;
            }
            String levelName = level.getName();
            String levelLabel = level.getLabel();
            String levelDepth = Integer.toString(level.getDepth());
            String levelSASFormat = null;
            String levelType = null;
            if (_logger.isDebugEnabled()) {
                _logger.debug("\tLevel Unique Name: " + levelUniqueName);
                _logger.debug("\tLevel Name ......: " + levelName);
                _logger.debug("\tLevel Label .....: " + levelLabel);
                _logger.debug("\tLevel Depth .....: " + levelDepth);
                _logger.debug("\tLevel SASFormat .: " + levelSASFormat);
                _logger.debug("\tLevel Type ......: " + levelType);
            }
            element.setAttribute("name", levelName);
            element.setAttribute("label", levelLabel);
            element.setAttribute("depth", levelDepth);
        }
        catch (OLAPException e) {
            if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                _logger.error(IQDataServicesResourceBundle.getStringResource("Level.write.OLAPException.txt"), (Throwable)e);
            }
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("Level.write.OLAPException.txt", new Object[0]), (Throwable)e);
        }
    }

    public void setUniqueName(String uniqueName) {
        this._uniqueName = uniqueName;
    }

    public String getUniqueName() {
        return this._uniqueName;
    }
}

