/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.report.xml.olap;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.strategies.sas.report.xml.olap.AbstractDataElement;
import com.sas.iquery.strategies.sas.report.xml.olap.Hierarchy;
import com.sas.iquery.strategies.sas.report.xml.olap.LevelMembersList;
import com.sas.iquery.strategies.sas.report.xml.olap.Member;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.OLAPException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Dimension
extends AbstractDataElement {
    public static final String NODE_NAME = "Dimension";
    private String _name = null;
    private String _label = null;
    private Hierarchy _hierarchy = null;
    private static final Logger _logger = LogManager.getLogger(Dimension.class);

    public String toString() {
        StringBuffer buffer = new StringBuffer(NODE_NAME);
        buffer.append(":");
        buffer.append(" name=");
        buffer.append(this.getName());
        buffer.append(", label=");
        buffer.append(this.getLabel());
        buffer.append(", hierarchy=");
        buffer.append(this.getHierarchy());
        return buffer.toString();
    }

    public String getLabel() {
        return this._label;
    }

    public String getName() {
        return this._name;
    }

    public Hierarchy getHierarchy() {
        return this._hierarchy;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setHierarchy(Hierarchy hierarchy) {
        this._hierarchy = hierarchy;
    }

    @Override
    public void read(Node domNode) throws ExecutionException {
        Map<String, String> attributeMap = AbstractDataElement.readNodeAttributes(domNode);
        String label = attributeMap.get("label");
        this.setLabel(label);
        String name = attributeMap.get("name");
        this.setName(name);
        Hierarchy hierarchy = AbstractDataElement.readSubElement((Element)domNode, "Hierarchy", Hierarchy.class);
        List<Member> memberList = hierarchy.getMembers();
        String dimensionName = this.getName();
        for (Member member : memberList) {
            String memberDimension = member.getDimension();
            if (memberDimension != null) continue;
            member.setDimension(dimensionName);
        }
        this.setHierarchy(hierarchy);
    }

    @Override
    public void write(Element element) throws ExecutionException {
        try {
            HierarchyInterface[] hierarchies;
            DimensionInterface dimension = (DimensionInterface)this._callingElement;
            String dimensionUniqueName = dimension.getUniqueName();
            String dimensionName = dimension.getName();
            String dimensionLabel = dimension.getLabel();
            if (_logger.isDebugEnabled()) {
                _logger.debug("\tUniqueName: " + dimensionUniqueName);
                _logger.debug("\tName .....: " + dimensionName);
                _logger.debug("\tLabel ....: " + dimensionLabel);
            }
            element.setAttribute("name", dimensionName);
            element.setAttribute("label", dimensionLabel);
            for (HierarchyInterface hierarchyInterface : hierarchies = dimension.getHierarchies()) {
                boolean includeHierarchy = this.hasMembers(hierarchyInterface);
                if (!includeHierarchy) continue;
                AbstractDataElement.writeSubElement(element, "Hierarchy", Hierarchy.class, hierarchyInterface, this._olapDataSetInterface, this._usedDimensionsSet, this._usedLevelsSet, this._usedMembersSet, this._measureDocElements, this._membersMap, this._levelsMap);
            }
        }
        catch (OLAPException e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQDataServicesResourceBundle.getStringResource("Dimension.write.OLAPException.txt"), (Throwable)e);
            }
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("Dimension.write.OLAPException.txt", new Object[0]), (Throwable)e);
        }
    }

    private boolean hasMembers(HierarchyInterface hierarchy) throws OLAPException {
        LevelInterface[] levels;
        if (hierarchy.getName().equals("Measures")) {
            return true;
        }
        for (LevelInterface level : levels = hierarchy.getLevels()) {
            LevelMembersList membersList;
            String levelUniqueName = level.getUniqueName();
            if (!this._levelsMap.containsKey(levelUniqueName) || (membersList = (LevelMembersList)this._levelsMap.get(levelUniqueName)).isEmpty()) continue;
            return true;
        }
        return false;
    }
}

