/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.report.xml.olap;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.strategies.sas.report.xml.olap.LevelMembersList;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractDataElement {
    public static final String ATTRIBUTE_NAME_DEPTH = "depth";
    public static final String ATTRIBUTE_NAME_LABEL = "label";
    public static final String ATTRIBUTE_NAME_NAME = "name";
    public static final String ATTRIBUTE_NAME_TYPE = "type";
    public static final String ATTRIBUTE_NAME_DIMENSION = "dimension";
    public static final String ATTRIBUTE_NAME_DATAITEM = "dataitem";
    public static final String ATTRIBUTE_NAME_LEVEL = "level";
    public static final String ATTRIBUTE_NAME_VALUESCOUNT = "valuesCount";
    public static final String ATTRIBUTE_NAME_PARENTMEMBER = "parentMember";
    public static final String ATTRIBUTE_NAME_SASFORMAT = "SASFormat";
    protected OLAPDataSetInterface _olapDataSetInterface;
    protected Collection<DimensionInterface> _usedDimensionsSet;
    protected Collection<String> _usedLevelsSet;
    protected Collection<String> _usedMembersSet;
    protected Collection<Element> _measureDocElements;
    protected Map<String, DimensionInterface> _membersMap;
    protected Map<String, LevelMembersList<Element>> _levelsMap;
    protected Object _callingElement;
    protected boolean _doWrite = true;
    private static final Logger _logger = LogManager.getLogger(AbstractDataElement.class);

    public abstract void read(Node var1) throws ExecutionException;

    public abstract void write(Element var1) throws ExecutionException;

    protected boolean isWritable() {
        return this._doWrite;
    }

    protected void populate(OLAPDataSetInterface olapDataSetInterface, Object callingElement, Collection<DimensionInterface> usedDimensionsSet, Collection<String> usedLevelsSet, Collection<String> usedMembersSet, Collection<Element> measureDocElements, Map<String, DimensionInterface> membersMap, Map<String, LevelMembersList<Element>> levelsMap) {
        this._olapDataSetInterface = olapDataSetInterface;
        this._callingElement = callingElement;
        this._usedDimensionsSet = usedDimensionsSet;
        this._usedLevelsSet = usedLevelsSet;
        this._usedMembersSet = usedMembersSet;
        this._measureDocElements = measureDocElements;
        this._membersMap = membersMap;
        this._levelsMap = levelsMap;
    }

    public static <T extends AbstractDataElement> T readSubElement(Element element, String elementName, Class<T> elementClass) throws ExecutionException {
        AbstractDataElement dataElement = null;
        NodeList nodeList = element.getElementsByTagName(elementName);
        if (nodeList.getLength() > 0) {
            try {
                dataElement = (AbstractDataElement)elementClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("AbstractDataElement.readSubElement.InstantiationException.fmt.txt", elementName), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("AbstractDataElement.readSubElement.IllegalAccessException.fmt.txt", elementName), (Throwable)e);
            }
            dataElement.read(nodeList.item(0));
        }
        return (T)dataElement;
    }

    public static <T extends AbstractDataElement> T writeSubElement(Element element, String elementName, Class<T> elementClass, Object callingElement, OLAPDataSetInterface olapDataSetInterface, Collection<DimensionInterface> usedDimensionsSet, Collection<String> usedLevelsSet, Collection<String> usedMembersSet, Collection<Element> measureDocElements, Map<String, DimensionInterface> membersMap, Map<String, LevelMembersList<Element>> levelsMap) throws ExecutionException {
        AbstractDataElement dataElement = null;
        Document doc = element.getOwnerDocument();
        Element romElement = doc.createElement(elementName);
        try {
            dataElement = (AbstractDataElement)elementClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("AbstractDataElement.writeSubElement.InstantiationException.fmt.txt", elementName), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("AbstractDataElement.writeSubElement.IllegalAccessException.fmt.txt", elementName), (Throwable)e);
        }
        dataElement.populate(olapDataSetInterface, callingElement, usedDimensionsSet, usedLevelsSet, usedMembersSet, measureDocElements, membersMap, levelsMap);
        dataElement.write(romElement);
        if (dataElement.isWritable()) {
            element.appendChild(romElement);
        }
        return (T)dataElement;
    }

    public static <T extends AbstractDataElement> List<T> readSubElements(Element element, String elementName, Class<? extends T> elementClass) throws ExecutionException {
        ArrayList<AbstractDataElement> dataElements = new ArrayList<AbstractDataElement>();
        NodeList nodeList = element.getElementsByTagName(elementName);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            AbstractDataElement dataElement = null;
            try {
                dataElement = (AbstractDataElement)elementClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("AbstractDataElement.readSubElements.InstantiationException.fmt.txt", elementName), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("AbstractDataElement.readSubElements.IllegalAccessException.fmt.txt", elementName), (Throwable)e);
            }
            dataElement.read(nodeList.item(i));
            dataElements.add(dataElement);
        }
        return dataElements;
    }

    public static Map<String, String> readNodeAttributes(Node node) {
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            attributeMap.put(attribute.getNodeName(), attribute.getNodeValue());
        }
        return attributeMap;
    }

    public static String readNodeText(Node node) {
        String nodeText = null;
        Node subNode = node.getFirstChild();
        if (subNode.getNodeType() == 3) {
            nodeText = subNode.getNodeValue();
        } else {
            _logger.error("First child node wasn't a text node?");
        }
        return nodeText;
    }

    public static List<AbstractDataElement> readNestedSubElements(Element element, String elementName, Class<? extends AbstractDataElement> elementClass) throws ExecutionException {
        NodeList nodeList = element.getChildNodes();
        ArrayList<AbstractDataElement> dataElements = new ArrayList<AbstractDataElement>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getNodeName().equals(elementName)) continue;
            AbstractDataElement dataElement = null;
            try {
                dataElement = elementClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("AbstractDataElement.readNestedSubElements.InstantiationException.fmt.txt", elementName), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("AbstractDataElement.readNestedSubElements.IllegalAccessException.fmt.txt", elementName), (Throwable)e);
            }
            dataElement.read(nodeList.item(i));
            dataElements.add(dataElement);
        }
        return dataElements;
    }
}

