/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.report.xml;

import com.sas.iquery.strategies.sas.report.xml.EmbeddedData;
import com.sas.iquery.strategies.sas.report.xml.XMLResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XMLResultSetMetaData
implements ResultSetMetaData {
    protected XMLResultSet m_resultSet;
    protected EmbeddedData m_embeddedData;
    private static final Logger _logger = LogManager.getLogger(XMLResultSetMetaData.class);

    public XMLResultSetMetaData(XMLResultSet resultSet, EmbeddedData embeddedData) {
        this.m_resultSet = resultSet;
        this.m_embeddedData = embeddedData;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this._unsupportedOperationException();
        return "";
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        String returnValue = null;
        int type = this.getColumnType(column);
        if (type == 12) {
            returnValue = String.class.getName();
        } else if (type == 8) {
            returnValue = Double.class.getName();
        }
        return returnValue;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.m_resultSet.getColumnCount();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 10 * (column + 1);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.m_embeddedData.getColumnLabel(column - 1);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.m_embeddedData.getColumnName(column - 1);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        int returnType = 12;
        String strType = this.m_embeddedData.getColumnType(column - 1);
        if ("String".equalsIgnoreCase(strType)) {
            returnType = 12;
        } else if ("Numeric".equalsIgnoreCase(strType)) {
            returnType = 8;
        }
        return returnType;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        this._unsupportedOperationException();
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        this._unsupportedOperationException();
        return 0;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this._unsupportedOperationException();
        return "";
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this._unsupportedOperationException();
        return "";
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        this._unsupportedOperationException();
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        this._unsupportedOperationException();
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 1;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        this._unsupportedOperationException();
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    protected void _unsupportedOperationException() {
        try {
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            _logger.error("This method is not implemented in the embeddedData driver.", (Throwable)e);
            return;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }
}

