/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.report.xml;

import com.sas.entities.EntityInterface;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.intelligentquery.IntelligentQueryInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessGroup;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.BusinessQueryTotalLocationType;
import com.sas.iquery.metadata.business.BusinessQueryTotalModeType;
import com.sas.iquery.metadata.business.BusinessRule;
import com.sas.iquery.metadata.business.CascadeRuleSet;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.QueryWriteOption;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.TotalingType;
import com.sas.iquery.metadata.business.impl.DataSelectionImpl;
import com.sas.iquery.metadata.business.impl.EffectiveObjectsCache;
import com.sas.iquery.metadata.business.impl.EffectiveObjectsCacheSupport;
import com.sas.iquery.metadata.business.impl.JoinPathGeneratorImpl;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.strategies.sas.report.xml.EmbeddedData;
import com.sas.iquery.strategies.sas.report.xml.EmbeddedOLAPDataReadROM;
import com.sas.iquery.strategies.sas.report.xml.EmbeddedOLAPDataResultSet;
import com.sas.iquery.strategies.sas.report.xml.NumericDateTimesTabularResultSet;
import com.sas.iquery.strategies.sas.report.xml.UnformattedOlapDataSet;
import com.sas.iquery.strategies.sas.report.xml.XMLDataItem;
import com.sas.prompts.PromptValuesInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.util.ChainedException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLIntelligentQuery
implements BusinessQuery,
IntelligentQueryInterface,
EffectiveObjectsCacheSupport {
    InputStream _sourceXMLStream = null;
    String _id = null;
    private Element _embeddedDataElement = null;
    private EmbeddedData _embeddedData = null;
    private EmbeddedOLAPDataResultSet _embeddedOLAPData = null;
    private static final Logger _logger = LogManager.getLogger(XMLIntelligentQuery.class);

    public XMLIntelligentQuery() {
    }

    public XMLIntelligentQuery(BusinessQuery businessQuery, ResultSetInterface iqResultSet) throws DataRetrievalException {
        this.initialize(businessQuery, iqResultSet);
        String businessQueryID = businessQuery.getID();
        String embeddedID = this.getID();
        this.setID(businessQueryID);
    }

    @Override
    public void setActionSupported(BusinessQueryActionType arg0, boolean arg1) throws MetadataException {
    }

    @Override
    public boolean isActionSupported(BusinessQueryActionType arg0) {
        return false;
    }

    @Override
    public BusinessModel getBusinessModel() {
        return null;
    }

    @Override
    public List getChildren() {
        return new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FilterItem> getEffectiveFilters() {
        EffectiveObjectsCache effectiveObjectCache = new EffectiveObjectsCache();
        try {
            List<FilterItem> effectiveFilters = effectiveObjectCache.getEffectiveFilters(this);
            ArrayList<FilterItem> arrayList = new ArrayList<FilterItem>(effectiveFilters);
            return arrayList;
        }
        finally {
            effectiveObjectCache.clear();
        }
    }

    @Override
    public List<FilterItem> getEffectiveFilters(EffectiveObjectsCache effectiveObjectsCache) {
        return new ArrayList<FilterItem>();
    }

    @Override
    public <T extends BusinessRule> List<T> getEffectiveRules(Class<T> type) {
        return new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CascadeRuleSet getCascadeRuleSet() throws MetadataException {
        EffectiveObjectsCache effectiveObjectCache = new EffectiveObjectsCache();
        try {
            CascadeRuleSet cascadeRuleSet;
            CascadeRuleSet cascadeRuleSet2 = cascadeRuleSet = this.getCascadeRuleSet(effectiveObjectCache);
            return cascadeRuleSet2;
        }
        finally {
            effectiveObjectCache.clear();
        }
    }

    @Override
    public CascadeRuleSet getCascadeRuleSet(EffectiveObjectsCache effectiveObjectsCache) {
        return null;
    }

    @Override
    public List<DataItem> getEffectiveSortOrderPrecedence() {
        return new ArrayList<DataItem>();
    }

    public void setElement(Element embeddedDataElement) {
        this._embeddedDataElement = embeddedDataElement;
    }

    public Element getElement() {
        return this._embeddedDataElement;
    }

    public EmbeddedData getEmbeddedData() {
        return this._embeddedData;
    }

    public boolean isEmbeddedDataCreated() {
        boolean returnBool = false;
        if (this._embeddedData != null || this._embeddedOLAPData != null) {
            returnBool = true;
        }
        return returnBool;
    }

    public EmbeddedOLAPDataResultSet getEmbeddedOLAPData() {
        return this._embeddedOLAPData;
    }

    @Override
    public void setEmptyDataFormat(String arg0) {
    }

    @Override
    public String getEmptyDataFormat() {
        return null;
    }

    @Override
    public EntityInterface getEntity() {
        return null;
    }

    @Override
    public PromptValuesInterface getPromptValues() {
        EffectiveObjectsCache effectiveObjectsCache = new EffectiveObjectsCache();
        try {
            PromptValuesInterface promptValuesInterface = this.getPromptValues(effectiveObjectsCache);
            return promptValuesInterface;
        }
        finally {
            effectiveObjectsCache.clear();
        }
    }

    @Override
    public PromptValuesInterface getPromptValues(EffectiveObjectsCache effectiveObjectsCache) {
        return null;
    }

    @Override
    public void setFilters(List<? extends FilterItem> filters) {
    }

    @Override
    public List<FilterItem> getFilters() {
        return new ArrayList<FilterItem>();
    }

    @Override
    public void setID(String strID) {
        this._id = strID;
    }

    @Override
    public String getID() {
        return this._id;
    }

    @Override
    public StructureOfData getInputStructure() {
        boolean isOlap;
        StructureOfData structure = null;
        Element embeddedDataElement = this.getElement();
        structure = embeddedDataElement != null ? ((isOlap = EmbeddedOLAPDataReadROM.isValidEmbeddedDataElement(embeddedDataElement)) ? this.createOLAPStructure() : this.createRelationalStructure()) : (this._embeddedOLAPData != null ? this.createOLAPStructure() : this.createRelationalStructure());
        return structure;
    }

    @Override
    public List<PropertyChangeListener> getListeners() {
        return new ArrayList<PropertyChangeListener>();
    }

    @Override
    public BusinessQuery getParentQuery() {
        return null;
    }

    @Override
    public boolean isPersistable() {
        return false;
    }

    @Override
    public void setQueryProperty(BusinessQueryProperty arg0, boolean arg1) {
    }

    @Override
    public boolean isAxisValuesCoalesced() {
        return false;
    }

    @Override
    public boolean getQueryProperty(BusinessQueryProperty arg0) {
        return false;
    }

    @Override
    public List<Reason> getReasonsNotPersistable() {
        return new ArrayList<Reason>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Reason> getReasonsNotValid() {
        EffectiveObjectsCache effectiveObjectCache = new EffectiveObjectsCache();
        try {
            List<Reason> reasonsNotValid;
            List<Reason> list = reasonsNotValid = this.getReasonsNotValid(effectiveObjectCache);
            return list;
        }
        finally {
            effectiveObjectCache.clear();
        }
    }

    @Override
    public List<Reason> getReasonsNotValid(EffectiveObjectsCache effectiveObjectCache) {
        ArrayList<Reason> reasonList = new ArrayList<Reason>(1);
        if (this.getElement() == null && this.getEmbeddedData() == null && this.getEmbeddedOLAPData() == null) {
            Reason reason = new Reason(null, 2, 0, "XMLIntelligentQuery.ErrorInconsistentState.txt", new Object[0]);
            reasonList.add(reason);
        }
        return reasonList;
    }

    @Override
    public <T extends BusinessRule> List<T> getRelevantRules(Class<T> type) {
        return new ArrayList();
    }

    @Override
    public void setResultItemRole(DataItem arg0, Role arg1) throws MetadataException {
    }

    @Override
    public Role getResultItemRole(DataItem arg0) throws MetadataException {
        List<DataItem> resultItems = this.getResultItems();
        if (resultItems.contains(arg0)) {
            return Role.COLUMN;
        }
        return null;
    }

    @Override
    public void setResultItems(List<? extends DataItem> dataItems) throws MetadataException {
    }

    @Override
    public void setSelectedItems(List<? extends SelectedItem> newSelectedItems) throws MetadataException {
    }

    @Override
    public List<DataItem> getResultItems() {
        if (!this.isEmbeddedDataCreated()) {
            this.createEmbeddedData();
        }
        ArrayList<DataItem> resultItemsList = new ArrayList<DataItem>();
        if (this._embeddedData != null) {
            for (int i = 0; i < this._embeddedData.getColumnCount(); ++i) {
                XMLDataItem dataItem = new XMLDataItem(this._embeddedData.getColumn(i));
                resultItemsList.add(dataItem);
            }
        }
        return resultItemsList;
    }

    @Override
    public List<SelectedItem> getSelectedItems() {
        ArrayList<SelectedItem> selectedItems = new ArrayList<SelectedItem>();
        List<DataItem> resultItems = this.getResultItems();
        for (int i = 0; i < resultItems.size(); ++i) {
            selectedItems.add(new SelectedItem(resultItems.get(i), Role.COLUMN));
        }
        return selectedItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DataItem> getEffectiveResultItems() {
        EffectiveObjectsCache effectiveObjectCache = new EffectiveObjectsCache();
        try {
            List<DataItem> effectiveDataSources = effectiveObjectCache.getEffectiveResultItems(this);
            ArrayList<DataItem> arrayList = new ArrayList<DataItem>(effectiveDataSources);
            return arrayList;
        }
        finally {
            effectiveObjectCache.clear();
        }
    }

    @Override
    public List<DataItem> getEffectiveResultItems(EffectiveObjectsCache effectiveObjectCache) {
        return this.getResultItems();
    }

    @Override
    public List<DataItem> getResultItems(Role arg0) throws MetadataException {
        ArrayList<DataItem> resultItems = new ArrayList<DataItem>();
        if (arg0 == Role.COLUMN) {
            resultItems.addAll(this.getResultItems());
        }
        return resultItems;
    }

    @Override
    public List<SelectedItem> getSelectedItems(Role arg0) throws MetadataException {
        ArrayList<SelectedItem> selectedItems = new ArrayList<SelectedItem>();
        if (arg0 == Role.COLUMN) {
            selectedItems.addAll(this.getSelectedItems());
        }
        return selectedItems;
    }

    @Override
    public int getResultSetIndex(String arg0) {
        return -1;
    }

    @Override
    public void setSolveOrderPrecedence(List<? extends DataItem> solveOrderPrecedence) {
    }

    @Override
    public List<DataItem> getSolveOrderPrecedence() {
        return new ArrayList<DataItem>();
    }

    @Override
    public void setSortCriteria(List<? extends Object> sortCriteria, Role businessSortRole) throws MetadataException, IllegalArgumentException {
    }

    @Override
    @Nonnull
    public List<Object> getSortCriteria(Role businessSortRole) {
        return new ArrayList<Object>();
    }

    @Override
    public void setSortDirection(BusinessQueryActionType arg0, Role arg1) throws MetadataException {
    }

    @Override
    public BusinessQueryActionType getSortDirection(Role arg0) {
        return null;
    }

    @Override
    public List<DataItem> getSortItems() {
        return new ArrayList<DataItem>();
    }

    @Override
    public void setSortOrderPrecedence(List<? extends DataItem> sortOrderPrecedence) throws MetadataException {
    }

    @Override
    public List<DataItem> getSortOrderPrecedence() {
        return new ArrayList<DataItem>();
    }

    public void setSourceXMLStream(InputStream sourceXMLStream) {
        this._sourceXMLStream = sourceXMLStream;
    }

    public InputStream getSourceXMLStream() {
        return this._sourceXMLStream;
    }

    @Override
    public void setTotalLabel(String totalLabel, Role businessTotalRole, String typeOfTotal) {
    }

    @Override
    public void setTotalLocation(BusinessQueryTotalLocationType totalLocation) {
    }

    @Override
    public void setTotalMode(BusinessQueryTotalModeType totalMode) {
    }

    @Override
    public void setAxisValuesCoalesced(boolean coalescedIndicator) {
    }

    @Override
    public StepInterface getStep(int stepNumber, Role role) {
        return null;
    }

    @Override
    public void setSteps(List<StepInterface> steps, Role role) {
    }

    @Override
    public List<StepInterface> getSteps(Role role) {
        return new ArrayList<StepInterface>();
    }

    @Override
    public String getTotalLabel(Role businessTotalRole, String typeOfTotal) {
        return null;
    }

    @Override
    public void setTotalType(String totalingType, Role businessTotalRole) throws MetadataException {
    }

    @Override
    public String getTotalType(Role businessTotalRole) {
        return null;
    }

    @Override
    public BusinessQueryTotalModeType getTotalMode() {
        return null;
    }

    @Override
    public BusinessQueryTotalLocationType getTotalLocation() {
        return null;
    }

    @Override
    public boolean isValid() {
        return this.getReasonsNotValid().isEmpty();
    }

    @Override
    public List<BusinessQueryActionType> getValidActions() {
        return new ArrayList<BusinessQueryActionType>();
    }

    @Override
    public void addListener(PropertyChangeListener arg0) {
    }

    @Override
    public void addResultItem(DataItem dataItem, Role arg1) throws MetadataException {
    }

    @Override
    public void addResultItems(List<? extends DataItem> dataItems, Role arg1) throws MetadataException {
    }

    @Override
    public void addStep(StepInterface step, Role role) {
    }

    @Override
    public void insertResultItemsAt(DataItem dataItem, Role role, int index) throws MetadataException {
    }

    @Override
    public void insertSelectedItemAt(SelectedItem item, int index) throws MetadataException {
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
    }

    @Override
    public void removeListener(PropertyChangeListener arg0) {
    }

    @Override
    public void removeResultItem(DataItem dataItem) throws MetadataException {
    }

    @Override
    public void removeResultItems(List<? extends DataItem> dataItems) throws MetadataException {
    }

    @Override
    public void removeSelectedItem(SelectedItem item) throws MetadataException {
    }

    @Override
    public void removeStep(int arg0, Role role) {
    }

    @Override
    public String retrieveStrategyClassName() {
        return "com.sas.iquery.strategies.sas.report.xml.XMLStrategy";
    }

    @Override
    public Element write(Element parentElement) throws MetadataException {
        if (this._embeddedDataElement == null) {
            Document doc = parentElement.getOwnerDocument();
            this._embeddedDataElement = doc.createElement("EmbeddedData");
            parentElement.appendChild(this._embeddedDataElement);
            if (this._embeddedOLAPData != null) {
                try {
                    this._embeddedOLAPData.write(this._embeddedDataElement);
                }
                catch (ExecutionException e) {
                    throw new MetadataException(IQDataServicesResourceBundle.getMessageFormatter("XMLIntelligentQuery.write.ExecutionException.txt", new Object[0]), (Throwable)e);
                }
            } else if (this._embeddedData != null) {
                this._embeddedData.write(this._embeddedDataElement);
            }
        } else {
            this.importEmbeddedDataElement(parentElement);
        }
        return this._embeddedDataElement;
    }

    @Override
    @Nonnull
    public Map<String, Object> write(@Nonnull Element parentElement, Map<QueryWriteOption, Object> writeOptions) throws MetadataException {
        DataSelectionImpl.validateBusinessQueryWriteOptions(writeOptions);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Element modelElement = this.write(parentElement);
        resultMap.put("MODEL_ELEMENT", modelElement);
        return resultMap;
    }

    private void createEmbeddedData() {
        Element embeddedElement = this.getElement();
        this._embeddedData = new EmbeddedData(embeddedElement);
    }

    private StructureOfData createOLAPStructure() {
        StructureOfData structure = new StructureOfData();
        structure.setIsRelational(false);
        structure.setIsOLAP(true);
        return structure;
    }

    private StructureOfData createRelationalStructure() {
        StructureOfData structure = new StructureOfData();
        structure.setIsOLAP(false);
        structure.setIsRelational(true);
        return structure;
    }

    private void importEmbeddedDataElement(Element parentElement) throws MetadataException {
        if (this._embeddedDataElement != null) {
            Document elementDocument = this._embeddedDataElement.getOwnerDocument();
            Document parentDocument = parentElement.getOwnerDocument();
            if (!parentDocument.equals(elementDocument)) {
                Node newNode = parentDocument.importNode(this._embeddedDataElement, true);
                if (newNode instanceof Element) {
                    this._embeddedDataElement = (Element)newNode;
                    parentElement.appendChild(newNode);
                } else {
                    throw new MetadataException(IQDataServicesResourceBundle.getMessageFormatter("XMLIntelligentQuery.ensureEmbeddedElementCompatible.MetadataException.txt", new Object[0]));
                }
            }
        }
    }

    private void initialize(BusinessQuery businessQuery, ResultSetInterface iqResultSet) throws DataRetrievalException {
        try {
            Date date = iqResultSet.getResultSetDate();
            Object concreteResultSet = iqResultSet.getResultSet();
            if (concreteResultSet instanceof OLAPDataSetInterface) {
                OLAPDataSetInterface olapResultSet = (OLAPDataSetInterface)concreteResultSet;
                this._embeddedOLAPData = new EmbeddedOLAPDataResultSet();
                if (iqResultSet instanceof EmbeddedOLAPDataResultSet) {
                    EmbeddedOLAPDataResultSet embeddedOLAPDataResultSet = (EmbeddedOLAPDataResultSet)iqResultSet;
                    this._embeddedOLAPData.setElement(embeddedOLAPDataResultSet.getElement());
                }
                this._embeddedOLAPData.setResultSet(this.decorateOlapDataSet(olapResultSet, businessQuery));
                this._embeddedOLAPData.setResultSetDate(date);
            } else if (concreteResultSet instanceof ResultSet) {
                ResultSet jdbcResultSet = (ResultSet)concreteResultSet;
                jdbcResultSet = this.decorateSQLResultSet(jdbcResultSet, businessQuery);
                this._embeddedData = new EmbeddedData(jdbcResultSet, businessQuery);
                this._embeddedData.setResultSetDate(date);
            }
        }
        catch (ExecutionException e) {
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("XMLIntelligentQuery.initialize.ExecutionException.txt", new Object[0]), (Throwable)e);
        }
        catch (SQLException e) {
            Throwable t = ChainedException.getRootException((Throwable)e);
            if (t == null) {
                t = e;
            }
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(e.getMessage(), t);
            }
            throw new DataRetrievalException(IQDataServicesResourceBundle.getMessageFormatter("XMLIntelligentQuery.initialize.SQLException.txt", new Object[0]), (Throwable)e);
        }
    }

    private ResultSet decorateSQLResultSet(ResultSet jdbcResultSet, BusinessQuery businessQuery) throws SQLException {
        ResultSet decoratedResultSet = jdbcResultSet;
        if (businessQuery.getQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA)) {
            decoratedResultSet = new NumericDateTimesTabularResultSet(jdbcResultSet);
        }
        return decoratedResultSet;
    }

    private OLAPDataSetInterface decorateOlapDataSet(OLAPDataSetInterface olapDataSet, BusinessQuery businessQuery) throws ExecutionException {
        OLAPDataSetInterface decoratedOlapDataSet = olapDataSet;
        boolean returnUnformatted = businessQuery.getQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA);
        if (returnUnformatted) {
            decoratedOlapDataSet = new UnformattedOlapDataSet(olapDataSet);
        }
        return decoratedOlapDataSet;
    }

    public void setEmbeddedOLAPData(EmbeddedOLAPDataResultSet embeddedOLAPData) {
        this._embeddedOLAPData = embeddedOLAPData;
    }

    @Override
    public <T extends BusinessModelResource> List<T> getQueryResources(Class<T> type, int flags) {
        return new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DataSource> getEffectiveDataSources() throws MetadataException {
        EffectiveObjectsCache effectiveObjectCache = new EffectiveObjectsCache();
        try {
            List<DataSource> effectiveDataSources = effectiveObjectCache.getEffectiveDataSources(this);
            ArrayList<DataSource> arrayList = new ArrayList<DataSource>(effectiveDataSources);
            return arrayList;
        }
        finally {
            effectiveObjectCache.clear();
        }
    }

    @Override
    public List<DataSource> getEffectiveDataSources(EffectiveObjectsCache effectiveObjectsCache) throws MetadataException {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        if (this.getInputStructure().isRelational()) {
            JoinPathGeneratorImpl joinPathGenerator = new JoinPathGeneratorImpl(this);
            joinPathGenerator.generateJoinPath(effectiveObjectsCache);
            List<DataSource> uniqueDataSources = joinPathGenerator.getUniqueDataSources();
            Utils.addButNoDuplicates(dataSources, uniqueDataSources);
            this.addDataSources(dataSources, effectiveObjectsCache.getEffectiveResultItems(this));
            this.addDataSources(dataSources, effectiveObjectsCache.getEffectiveSortOrderPrecedence(this));
            this.addDataSources(dataSources, effectiveObjectsCache.getEffectiveSolveOrderPrecedence(this));
            this.addDataSources(dataSources, effectiveObjectsCache.getEffectiveFilters(this));
            this.addDataSources(dataSources, effectiveObjectsCache.getEffectiveBusinessRules(this));
        }
        return dataSources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Join> getEffectiveJoinPath() throws MetadataException {
        EffectiveObjectsCache effectiveObjectCache = new EffectiveObjectsCache();
        try {
            List<Join> effectiveJoinPath;
            List<Join> list = effectiveJoinPath = this.getEffectiveJoinPath(effectiveObjectCache);
            return list;
        }
        finally {
            effectiveObjectCache.clear();
        }
    }

    @Override
    public List<Join> getEffectiveJoinPath(EffectiveObjectsCache effectiveObjectsCache) throws MetadataException {
        List<Join> joinPath;
        if (this.getInputStructure().isRelational()) {
            JoinPathGeneratorImpl joinPathGenerator = new JoinPathGeneratorImpl(this);
            List<BusinessModelObject> generatedPath = joinPathGenerator.generateJoinPath();
            if (generatedPath.isEmpty()) {
                joinPath = Collections.emptyList();
            } else if (!(generatedPath.get(0) instanceof Join)) {
                joinPath = Collections.emptyList();
            } else {
                joinPath = new ArrayList<Join>(generatedPath.size());
                for (BusinessModelObject bmo : generatedPath) {
                    if (!(bmo instanceof Join)) continue;
                    joinPath.add((Join)bmo);
                }
            }
        } else {
            joinPath = Collections.emptyList();
        }
        return joinPath;
    }

    @Override
    public void setGroups(List<BusinessGroup> group) throws MetadataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<BusinessGroup> getGroups() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<BusinessGroup> getEffectiveGroups() {
        return new ArrayList<BusinessGroup>();
    }

    @Override
    public List<BusinessGroup> getEffectiveGroupsByType(BusinessGroup.Type type) {
        return new ArrayList<BusinessGroup>();
    }

    @Override
    public List<BusinessGroup> getEffectiveGroupsContaining(BusinessModelObject bi, BusinessGroup.Type type) {
        return new ArrayList<BusinessGroup>();
    }

    @Override
    public List<BusinessGroup> getEffectiveGroupsContaining(BusinessModelObject bi) {
        return new ArrayList<BusinessGroup>();
    }

    public List<BusinessGroup> getGroupsContaining(BusinessModelObject bmObject, BusinessGroup.Type type) {
        return new ArrayList<BusinessGroup>();
    }

    private void addDataSources(List<DataSource> dataSources, List bmos) throws MetadataException {
        for (int i = 0; i < bmos.size(); ++i) {
            Object obj = bmos.get(i);
            if (!(obj instanceof BusinessItem)) continue;
            BusinessItem bmi = (BusinessItem)obj;
            List<QualifiedColumn> columns = bmi.getResources(QualifiedColumn.class, 65531);
            for (int j = 0; j < columns.size(); ++j) {
                QualifiedColumn column = columns.get(j);
                DataSourceTable dataSource = column.getDataSource();
                if (dataSources.contains(dataSource)) continue;
                dataSources.add(dataSource);
            }
        }
    }

    @Override
    public void setTotalingType(TotalingType totalingType, Role businessTotalRole) throws MetadataException {
    }

    @Override
    public TotalingType getTotalingType(Role businessTotalRole) {
        return null;
    }
}

