/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.report.xml;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.strategies.sas.report.xml.olap.AbstractDataElement;
import com.sas.iquery.strategies.sas.report.xml.olap.Axes;
import com.sas.iquery.strategies.sas.report.xml.olap.Dimensions;
import com.sas.iquery.strategies.sas.report.xml.olap.ValuesList;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EmbeddedOLAPDataWriteROM {
    private OLAPDataSetInterface _olapDataSetInterface = null;
    private Collection _usedDimensionsSet = new LinkedHashSet();
    private Collection _usedLevelsSet = new LinkedHashSet();
    private Collection _usedMembersSet = new LinkedHashSet();
    private Collection _measureDocElements = new LinkedList();
    private Map<String, DimensionInterface> _membersMap;
    private Map _levelsMap = new LinkedHashMap();
    private String _cubeName;
    private Date _resultSetDate = null;
    private static final Logger _logger = LogManager.getLogger(EmbeddedOLAPDataWriteROM.class);

    public EmbeddedOLAPDataWriteROM(OLAPDataSetInterface olapDataSetInterface) {
        this._olapDataSetInterface = olapDataSetInterface;
    }

    public OLAPDataSetInterface getOLAPDataSet() {
        return this._olapDataSetInterface;
    }

    public void write(Element rootElement) throws ExecutionException {
        try {
            this._membersMap = this.getCubeMetadata();
        }
        catch (OLAPException e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQDataServicesResourceBundle.getStringResource("EmbeddedOLAPDataWriteROM.write.OLAPException.txt"), (Throwable)e);
            }
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("EmbeddedOLAPDataWriteROM.write.OLAPException.txt", new Object[0]), (Throwable)e);
        }
        if (this._resultSetDate != null) {
            Locale xmlLocale = LocaleUtilities.getDefaultPersistenceLocale();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:SSSSZ", xmlLocale);
            String formattedDate = df.format(this._resultSetDate);
            Document doc = rootElement.getOwnerDocument();
            Element dateElement = doc.createElement("Date");
            rootElement.appendChild(dateElement);
            dateElement.setAttribute("value", formattedDate);
        }
        AbstractDataElement.writeSubElement(rootElement, "Axes", Axes.class, this, this._olapDataSetInterface, this._usedDimensionsSet, this._usedLevelsSet, this._usedMembersSet, this._measureDocElements, this._membersMap, this._levelsMap);
        AbstractDataElement.writeSubElement(rootElement, "Dimensions", Dimensions.class, this, this._olapDataSetInterface, this._usedDimensionsSet, this._usedLevelsSet, this._usedMembersSet, this._measureDocElements, this._membersMap, this._levelsMap);
        AbstractDataElement.writeSubElement(rootElement, "ValuesList", ValuesList.class, this, this._olapDataSetInterface, this._usedDimensionsSet, this._usedLevelsSet, this._usedMembersSet, this._measureDocElements, this._membersMap, this._levelsMap);
    }

    private Map<String, DimensionInterface> getCubeMetadata() throws OLAPException {
        if (this._membersMap == null) {
            LinkedHashMap<String, DimensionInterface> membersMap = new LinkedHashMap<String, DimensionInterface>();
            MetadataInterface metadata = this._olapDataSetInterface.getDatabaseMetadata();
            if (metadata == null) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(IQDataServicesResourceBundle.getMessageString("EmbeddedOLAPDataWriteROM.getCubeMetadata.GetDatabaseMetadata.fmt.txt", this._olapDataSetInterface.toString()));
                }
                throw new OLAPException(IQDataServicesResourceBundle.getMessageString("EmbeddedOLAPDataWriteROM.getCubeMetadata.GetDatabaseMetadata.fmt.txt", this._olapDataSetInterface.toString()));
            }
            Filter filter = new Filter();
            filter.setCubeName(this.findCubeName());
            CubeInterface[] cubes = metadata.getCubes(filter);
            if (_logger.isDebugEnabled()) {
                CubeInterface oneCube = cubes[0];
                String cubeInterfaceName = oneCube.getName();
                _logger.debug("Found _cubeName=" + this._cubeName + ", found CubeInterface[0].getName()=" + cubeInterfaceName);
            }
            DimensionInterface[] dimensions = cubes[0].getDimensions();
            for (int i = 0; i < dimensions.length; ++i) {
                DimensionInterface dimension = dimensions[i];
                HierarchyInterface[] hierarchies = dimension.getHierarchies();
                for (int j = 0; j < hierarchies.length; ++j) {
                    LevelInterface[] levels = hierarchies[j].getLevels();
                    for (int k = 0; k < levels.length; ++k) {
                        LevelInterface level = levels[k];
                        membersMap.put(level.getUniqueName(), dimension);
                    }
                }
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("_membersMap:");
                for (Map.Entry entry : membersMap.entrySet()) {
                    String oneKey = (String)entry.getKey();
                    DimensionInterface value = (DimensionInterface)entry.getValue();
                    _logger.debug("\tkey=" + oneKey + ", value=" + value);
                }
            }
            this._membersMap = membersMap;
        }
        return this._membersMap;
    }

    private String findCubeName() throws OLAPException {
        if (this._cubeName == null) {
            this._cubeName = this._olapDataSetInterface.getCubeName();
        }
        return this._cubeName;
    }

    public Date getResultSetDate() {
        return this._resultSetDate;
    }

    public void setResultSetDate(Date date) {
        this._resultSetDate = date;
    }
}

