/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.report.xml;

import com.sas.iquery.execution2.AbstractResultSet;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.IQOlapResultSetMetaData;
import com.sas.iquery.execution2.IQResultSetMetaData;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.strategies.sas.report.xml.EmbeddedOLAPDataWriteROM;
import com.sas.storage.olap.OLAPDataSetInterface;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EmbeddedOLAPDataResultSet
extends AbstractResultSet {
    private Element _element;
    private OLAPDataSetInterface _resultSet;
    private IQOlapResultSetMetaData _iqRsmd;

    @Override
    public Object getResultSet() throws ExecutionException {
        return this._resultSet;
    }

    public void setResultSet(OLAPDataSetInterface resultSet) {
        this._resultSet = resultSet;
    }

    public void setElement(Element element) {
        this._element = element;
    }

    @Override
    public void write(Element parentElement) throws ExecutionException {
        try {
            EmbeddedOLAPDataWriteROM data = null;
            if (this._element == null) {
                data = new EmbeddedOLAPDataWriteROM(this._resultSet);
                data.setResultSetDate(this.getResultSetDate());
                data.write(parentElement);
            } else {
                Document document = parentElement.getOwnerDocument();
                NodeList nodeList = this._element.getChildNodes();
                for (int nodeNumber = 0; nodeNumber < nodeList.getLength(); ++nodeNumber) {
                    Node node = nodeList.item(nodeNumber);
                    Node importNode = document.importNode(node, true);
                    parentElement.appendChild(importNode);
                }
            }
        }
        catch (ExecutionException e) {
            throw new ExecutionException(e, "Exception while writing OLAP data as Embedded XML.");
        }
        super.write(parentElement);
    }

    public Element getElement() {
        return this._element;
    }

    @Override
    public int getType() throws ExecutionException {
        return 3;
    }

    @Override
    public IQResultSetMetaData getIQMetaData() throws ExecutionException {
        Object underlyingObject;
        if (this._iqRsmd == null && (underlyingObject = this.getResultSet()) instanceof BusinessQueryProviderInterface) {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)underlyingObject).getBusinessQuery();
            this._iqRsmd = new IQOlapResultSetMetaData(this._resultSet, businessQuery);
        }
        return this._iqRsmd;
    }

    @Override
    public IQResultSetMetaData getIQMetaData(BusinessQuery businessQuery) throws ExecutionException {
        if (this._iqRsmd == null) {
            Object underlyingObject = this.getResultSet();
            if (underlyingObject instanceof BusinessQueryProviderInterface && businessQuery == null) {
                businessQuery = ((BusinessQueryProviderInterface)underlyingObject).getBusinessQuery();
            }
            this._iqRsmd = new IQOlapResultSetMetaData(this._resultSet, businessQuery);
        }
        return this._iqRsmd;
    }
}

