/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.report.xml;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.strategies.sas.report.xml.EmbeddedDataColumn;
import com.sas.iquery.strategies.sas.report.xml.MaxCellsExceededException;
import com.sas.iquery.util.LocaleUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EmbeddedData
implements com.sas.iquery.generation2.EmbeddedData {
    public static final String NODE_NAME_VARIABLES = "Variables";
    public static final String NODE_NAME_VARIABLE = "Variable";
    public static final String NODE_NAME_VALUESLIST = "ValuesList";
    public static final String NODE_NAME_VALUES = "Values";
    public static final String NODE_NAME_VALUE = "Value";
    public static final String NODE_NAME_DATE = "Date";
    public static final String ATTRIBUTE_NAME_DEPTH = "depth";
    public static final String ATTRIBUTE_NAME_LABEL = "label";
    public static final String ATTRIBUTE_NAME_NAME = "name";
    public static final String ATTRIBUTE_NAME_TYPE = "type";
    public static final String ATTRIBUTE_NAME_DIMENSION = "dimension";
    public static final String ATTRIBUTE_NAME_DATAITEM = "dataitem";
    public static final String ATTRIBUTE_NAME_LEVEL = "level";
    public static final String ATTRIBUTE_NAME_VALUESCOUNT = "valuesCount";
    public static final String ATTRIBUTE_NAME_PARENTMEMBER = "parentMember";
    public static final String ATTRIBUTE_NAME_SASFORMAT = "SASFormat";
    public static final String ATTRIBUTE_NAME_VALUE = "value";
    public static final String ATTRIBUTE_NAME_MISSING = "missing";
    public static final String ATTRIBUTE_NAME_ENCODING = "encoding";
    public static final String SASFORMAT_DATE = "yyyy-MM-dd'T'HH:mm:ss:SSSSZ";
    public static final String ENCODING_VALUE_DEFAULT = "Text";
    public static final String ENCODING_VALUE_DEFAULT2 = "text";
    public static final String TYPE_VALUE_NUMERIC = "Numeric";
    public static final String TYPE_VALUE_STRING = "String";
    public static final String TYPE_VALUE_DEFAULT = "String";
    public static final String ENCODING_UTF8 = "UTF-8";
    public static final String MAXNUMBEROFCELLS_PROPERTY_KEY = "SASQueryServices.EmbeddedData.MaxNumberOfCells";
    protected static final int MAJOR_VERSION = 1;
    protected static final int MINOR_VERSION = 0;
    protected String m_strID;
    protected List m_columns;
    protected List m_dataValues;
    protected Date _resultSetDate = null;
    private Collection wasNullTrueList = new LinkedHashSet();
    private static final Logger _logger = LogManager.getLogger(EmbeddedData.class);

    public EmbeddedData(String embeddedXML) {
        Document document = EmbeddedData._prepareDocument(embeddedXML);
        Element embeddedElement = document.getDocumentElement();
        this._initialize(embeddedElement);
    }

    public EmbeddedData(InputStream stream) {
        Document document = EmbeddedData._prepareDocumentFromStream(stream);
        Element embeddedElement = document.getDocumentElement();
        this._initialize(embeddedElement);
    }

    public EmbeddedData(Element embeddedElement) {
        this._initialize(embeddedElement);
    }

    public EmbeddedData(ResultSet resultSet) throws SQLException {
        this._initialize(resultSet);
    }

    public EmbeddedData(ResultSet resultSet, BusinessQuery query) throws SQLException {
        this._initialize(resultSet, query);
    }

    protected void _initialize(Element embeddedElement) {
        this.m_columns = new ArrayList();
        this.m_dataValues = new Vector();
        if (embeddedElement != null) {
            this._parseXML(embeddedElement);
        }
    }

    protected void _initialize(ResultSet resultSet, BusinessQuery query) throws SQLException {
        this.m_columns = new ArrayList();
        ResultSetMetaData metaData = resultSet.getMetaData();
        int nCols = metaData.getColumnCount();
        List<SelectedItem> selectedItemList = query.getSelectedItems();
        int columnIndex = 1;
        for (int index = 0; index < selectedItemList.size(); ++index) {
            SelectedItem selectedItem = selectedItemList.get(index);
            DataItem resultItem = selectedItem.getItem();
            Role role = selectedItem.getRole();
            if (!Role.isOutputResultRole(query, role)) continue;
            EmbeddedDataColumn column = this.createColumn(metaData, query, resultItem, columnIndex);
            ++columnIndex;
            String resultSetID = resultItem.getResultSetID();
            column.setName(resultSetID);
            String formatName = resultItem.getFormat();
            if (formatName != null) {
                column.setSASFormat(formatName);
            }
            this.m_columns.add(column);
        }
        this.m_dataValues = this.createValuesList(resultSet, nCols);
    }

    protected void _initialize(ResultSet resultSet) throws SQLException {
        this.m_columns = new ArrayList();
        ResultSetMetaData metaData = resultSet.getMetaData();
        int nCols = metaData.getColumnCount();
        for (int index = 1; index <= nCols; ++index) {
            EmbeddedDataColumn column = this.createColumn(metaData, index);
            this.m_columns.add(column);
        }
        this.m_dataValues = this.createValuesList(resultSet, nCols);
    }

    private EmbeddedDataColumn createColumn(ResultSetMetaData metaData, int index) throws SQLException {
        EmbeddedDataColumn column = new EmbeddedDataColumn();
        column.setName(metaData.getColumnName(index));
        column.setLabel(metaData.getColumnLabel(index));
        column.setEncoding(ENCODING_VALUE_DEFAULT2);
        if (EmbeddedData.isSqlNumeric(metaData.getColumnType(index))) {
            column.setType(TYPE_VALUE_NUMERIC);
        } else {
            column.setType("String");
        }
        return column;
    }

    private EmbeddedDataColumn createColumn(ResultSetMetaData metaData, BusinessQuery query, DataItem dataItem, int index) throws SQLException {
        EmbeddedDataColumn column = new EmbeddedDataColumn();
        column.setName(metaData.getColumnName(index));
        column.setLabel(metaData.getColumnLabel(index));
        column.setEncoding(ENCODING_VALUE_DEFAULT2);
        boolean unFormattedValue = query.getQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA);
        if (unFormattedValue && EmbeddedData.isSasNumeric(dataItem)) {
            column.setType(TYPE_VALUE_NUMERIC);
        } else {
            column.setType("String");
        }
        return column;
    }

    private static boolean isSasNumeric(DataItem dataItem) {
        int expressionType = dataItem.getExpression().getExpressionType();
        return expressionType == 2 || expressionType == 4 || expressionType == 5 || expressionType == 6;
    }

    private static boolean isSqlNumeric(int sqlType) {
        switch (sqlType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    private Vector createValuesList(ResultSet resultSet, int numberOfColumns) throws SQLException {
        int maxNumberOfCells = EmbeddedData.getMaximumNumberOfCells();
        int numberOfCells = 0;
        Vector dataValues = new Vector();
        resultSet.beforeFirst();
        while (resultSet.next()) {
            ArrayList<String> valueList = new ArrayList<String>(numberOfColumns);
            for (int columnNumber = 1; columnNumber <= numberOfColumns; ++columnNumber) {
                String strValue = resultSet.getString(columnNumber);
                valueList.add(strValue);
                if (resultSet.wasNull()) {
                    int rowNumber = resultSet.getRow();
                    this.addMissing(rowNumber - 1, columnNumber - 1);
                }
                if (++numberOfCells <= maxNumberOfCells) continue;
                MaxCellsExceededException maxCellsEx = new MaxCellsExceededException(IQDataServicesResourceBundle.getMessageString("EmbeddedData.createValuesList.numberOfCellsExceeded.fmt.txt", maxNumberOfCells));
                SQLException sqlEx = new SQLException();
                sqlEx.initCause(maxCellsEx);
                throw sqlEx;
            }
            dataValues.add(valueList);
        }
        return dataValues;
    }

    public static int getMaximumNumberOfCells() {
        int intProperty = IQSystemProperties.getIntProperty(MAXNUMBEROFCELLS_PROPERTY_KEY, -1);
        if (intProperty == -1) {
            intProperty = IQSystemProperties.getIntProperty("SAS.IQ.EmbeddedData.MaxNumberOfCells", Integer.MAX_VALUE);
        }
        return intProperty;
    }

    public static int setMaximumNumberOfCells(int intProperty) {
        System.setProperty(MAXNUMBEROFCELLS_PROPERTY_KEY, Integer.toString(intProperty));
        System.setProperty("SAS.IQ.EmbeddedData.MaxNumberOfCells", Integer.toString(intProperty));
        return intProperty;
    }

    @Override
    public void setID(String strID) {
        this.m_strID = strID;
    }

    public Date getResultSetDate() {
        return this._resultSetDate;
    }

    public void setResultSetDate(Date date) {
        this._resultSetDate = date;
    }

    @Override
    public String getID() {
        return this.m_strID;
    }

    @Override
    public void write(Element parentElement) {
        Document doc = parentElement.getOwnerDocument();
        Date date = this.getResultSetDate();
        if (date != null) {
            Locale locale = LocaleUtilities.getDefaultPersistenceLocale();
            SimpleDateFormat df = new SimpleDateFormat(SASFORMAT_DATE, locale);
            String formattedDate = df.format(date);
            Element dateElement = doc.createElement(NODE_NAME_DATE);
            parentElement.appendChild(dateElement);
            dateElement.setAttribute(ATTRIBUTE_NAME_VALUE, formattedDate);
        }
        Element variableListElement = doc.createElement(NODE_NAME_VARIABLES);
        parentElement.appendChild(variableListElement);
        for (int index = 0; index < this.m_columns.size(); ++index) {
            EmbeddedDataColumn column = (EmbeddedDataColumn)this.m_columns.get(index);
            Element variableElement = doc.createElement(NODE_NAME_VARIABLE);
            variableListElement.appendChild(variableElement);
            variableElement.setAttribute(ATTRIBUTE_NAME_NAME, column.getName());
            variableElement.setAttribute(ATTRIBUTE_NAME_LABEL, column.getLabel());
            variableElement.setAttribute(ATTRIBUTE_NAME_TYPE, column.getType());
            String encoding = column.getEncoding();
            if (encoding == null || encoding.length() == 0) {
                encoding = ENCODING_VALUE_DEFAULT;
            }
            variableElement.setAttribute(ATTRIBUTE_NAME_ENCODING, encoding);
            String sasFormat = column.getSASFormat();
            if (sasFormat == null || sasFormat.length() <= 0) continue;
            variableElement.setAttribute(ATTRIBUTE_NAME_SASFORMAT, sasFormat);
        }
        Element dataValuesElement = doc.createElement(NODE_NAME_VALUESLIST);
        parentElement.appendChild(dataValuesElement);
        dataValuesElement.setAttribute(ATTRIBUTE_NAME_VALUESCOUNT, Integer.toString(this.m_dataValues.size()));
        for (int rowIndex = 0; rowIndex < this.m_dataValues.size(); ++rowIndex) {
            List values = (List)this.m_dataValues.get(rowIndex);
            Element valueListElement = doc.createElement(NODE_NAME_VALUES);
            dataValuesElement.appendChild(valueListElement);
            for (int columnIndex = 0; columnIndex < values.size(); ++columnIndex) {
                String value = (String)values.get(columnIndex);
                Element valueElement = doc.createElement(NODE_NAME_VALUE);
                if (this.isMissing(rowIndex, columnIndex)) {
                    valueElement.setAttribute(ATTRIBUTE_NAME_MISSING, "");
                }
                valueListElement.appendChild(valueElement);
                if (value == null) continue;
                Text stringValue = doc.createTextNode(value);
                valueElement.appendChild(stringValue);
            }
        }
    }

    private void addMissing(int rowNumber, int columnNumber) {
        String rowColumnKey = Integer.toString(rowNumber) + ":" + Integer.toString(columnNumber);
        if (_logger.isDebugEnabled()) {
            _logger.debug("addMissing(" + rowColumnKey + ")");
        }
        this.wasNullTrueList.add(rowColumnKey);
    }

    boolean isMissing(int rowNumber, int columnNumber) {
        boolean returnValue = false;
        String rowColumnKey = Integer.toString(rowNumber) + ":" + Integer.toString(columnNumber);
        if (this.wasNullTrueList.contains(rowColumnKey)) {
            returnValue = true;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("isMissing(" + rowColumnKey + ") returns " + returnValue);
        }
        return returnValue;
    }

    @Override
    public String getString(int row, int column) {
        List record = (List)this.m_dataValues.get(row);
        String returnValue = (String)record.get(column);
        return returnValue;
    }

    public EmbeddedDataColumn getColumn(int column) {
        return (EmbeddedDataColumn)this.m_columns.get(column);
    }

    @Override
    public String getColumnType(int column) {
        return ((EmbeddedDataColumn)this.m_columns.get(column)).getType();
    }

    @Override
    public String getColumnName(int column) {
        return ((EmbeddedDataColumn)this.m_columns.get(column)).getName();
    }

    @Override
    public String getColumnLabel(int column) {
        return ((EmbeddedDataColumn)this.m_columns.get(column)).getLabel();
    }

    @Override
    public String getColumnSASFormat(int column) {
        return ((EmbeddedDataColumn)this.m_columns.get(column)).getSASFormat();
    }

    @Override
    public int getColumnCount() {
        return this.m_columns.size();
    }

    @Override
    public int getRowCount() {
        return this.m_dataValues.size();
    }

    @Override
    public String toString() {
        StringBuffer returnBuffer = new StringBuffer();
        returnBuffer.append("<Variables>\n");
        for (int index = 0; index < this.m_columns.size(); ++index) {
            String valueLabel;
            EmbeddedDataColumn column;
            block12: {
                column = (EmbeddedDataColumn)this.m_columns.get(index);
                returnBuffer.append("<Variable ");
                returnBuffer.append("name=\"");
                returnBuffer.append(column.getName());
                returnBuffer.append("\" label=\"");
                valueLabel = column.getLabel();
                if (valueLabel != null && (valueLabel.indexOf(60) > -1 || valueLabel.indexOf(62) > -1)) {
                    try {
                        valueLabel = URLEncoder.encode(valueLabel, ENCODING_UTF8);
                    }
                    catch (UnsupportedEncodingException e) {
                        if (!_logger.isEnabled(Level.ERROR)) break block12;
                        _logger.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            returnBuffer.append(valueLabel);
            returnBuffer.append("\" type=\"");
            returnBuffer.append(column.getType());
            returnBuffer.append("\" encoding=\"");
            returnBuffer.append(column.getEncoding());
            returnBuffer.append("\"");
            String sasFormat = column.getSASFormat();
            if (sasFormat != null && sasFormat.length() > 0) {
                returnBuffer.append(" SASFormat=\"");
                returnBuffer.append(sasFormat);
                returnBuffer.append("\"");
            }
            returnBuffer.append("/>\n");
        }
        returnBuffer.append("</Variables>\n");
        returnBuffer.append("<ValuesList>\n");
        for (int rowIndex = 0; rowIndex < this.m_dataValues.size(); ++rowIndex) {
            List values = (List)this.m_dataValues.get(rowIndex);
            returnBuffer.append("<Values>\n");
            for (int columnIndex = 0; columnIndex < values.size(); ++columnIndex) {
                String value;
                block13: {
                    value = (String)values.get(columnIndex);
                    if (this.isMissing(rowIndex, columnIndex)) {
                        returnBuffer.append("<Value missing=\"\">");
                    } else {
                        returnBuffer.append("<Value>");
                    }
                    if (value != null && (value.indexOf(60) > -1 || value.indexOf(62) > -1)) {
                        try {
                            value = URLEncoder.encode(value, ENCODING_UTF8);
                        }
                        catch (UnsupportedEncodingException e) {
                            if (!_logger.isEnabled(Level.ERROR)) break block13;
                            _logger.error(e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
                returnBuffer.append(value);
                returnBuffer.append("</Value>\n");
            }
            returnBuffer.append("</Values>\n");
        }
        returnBuffer.append("</ValuesList>");
        return returnBuffer.toString();
    }

    protected void _parseXML(Element rootElement) {
        int columnsSize;
        Element element;
        NodeList nodeList = rootElement.getElementsByTagName(NODE_NAME_DATE);
        Element dateElement = (Element)nodeList.item(0);
        if (dateElement != null) {
            String formattedDate = dateElement.getAttribute(ATTRIBUTE_NAME_VALUE);
            Locale locale = LocaleUtilities.getDefaultPersistenceLocale();
            SimpleDateFormat df = new SimpleDateFormat(SASFORMAT_DATE, locale);
            Date date = null;
            try {
                date = df.parse(formattedDate);
            }
            catch (ParseException e) {
                _logger.error("Error:  could not parse date information.", (Throwable)e);
            }
            this.setResultSetDate(date);
        }
        if ((element = (Element)(nodeList = rootElement.getElementsByTagName(NODE_NAME_VARIABLES)).item(0)) != null) {
            nodeList = element.getElementsByTagName(NODE_NAME_VARIABLE);
            for (int index = 0; index < nodeList.getLength(); ++index) {
                Element columnElement = (Element)nodeList.item(index);
                NamedNodeMap attributes = columnElement.getAttributes();
                EmbeddedDataColumn column = new EmbeddedDataColumn();
                String columnName = this._getAttribute(ATTRIBUTE_NAME_NAME, attributes, "");
                column.setName(columnName);
                String columnLabel = this._getAttribute(ATTRIBUTE_NAME_LABEL, attributes, columnName);
                column.setLabel(columnLabel);
                String columnEncoding = this._getAttribute(ATTRIBUTE_NAME_ENCODING, attributes, ENCODING_VALUE_DEFAULT);
                column.setEncoding(columnEncoding);
                String columnType = this._getAttribute(ATTRIBUTE_NAME_TYPE, attributes, "String");
                column.setType(columnType);
                String columnSASFormat = this._getAttribute(ATTRIBUTE_NAME_SASFORMAT, attributes, null);
                column.setSASFormat(columnSASFormat);
                this.m_columns.add(column);
            }
        } else {
            int numberOfColumns = this.findNumberOfColumns(rootElement);
            for (int index = 0; index < numberOfColumns; ++index) {
                EmbeddedDataColumn column = new EmbeddedDataColumn();
                String columnName = "col" + index;
                column.setName(columnName);
                String columnLabel = columnName;
                column.setLabel(columnLabel);
                String columnEncoding = ENCODING_VALUE_DEFAULT;
                column.setEncoding(columnEncoding);
                String columnType = "String";
                column.setType(columnType);
                String columnSASFormat = null;
                column.setSASFormat(columnSASFormat);
                this.m_columns.add(column);
            }
        }
        if ((columnsSize = this.m_columns.size()) > 0) {
            nodeList = rootElement.getElementsByTagName(NODE_NAME_VALUESLIST);
            element = (Element)nodeList.item(0);
            NodeList valueListNodes = element.getElementsByTagName(NODE_NAME_VALUES);
            int nodeLength = valueListNodes.getLength();
            for (int rowIndex = 0; rowIndex < nodeLength; ++rowIndex) {
                Element valueListElement = (Element)valueListNodes.item(rowIndex);
                NodeList valueNodes = valueListElement.getElementsByTagName(NODE_NAME_VALUE);
                ArrayList<String> valueList = new ArrayList<String>(columnsSize);
                for (int columnIndex = 0; columnIndex < valueNodes.getLength(); ++columnIndex) {
                    NodeList data;
                    Element valueElement = (Element)valueNodes.item(columnIndex);
                    if (valueElement.hasAttribute(ATTRIBUTE_NAME_MISSING)) {
                        this.addMissing(rowIndex, columnIndex);
                    }
                    if ((data = valueElement.getChildNodes()).item(0) != null) {
                        valueList.add(data.item(0).getNodeValue());
                        continue;
                    }
                    valueList.add("");
                }
                this.m_dataValues.add(valueList);
            }
        }
    }

    public static boolean isValidEmbeddedDataElement(Element embeddedDataElement) {
        NodeList nodeList = embeddedDataElement.getChildNodes();
        boolean hasVariablesTag = false;
        boolean hasValuesListTag = false;
        boolean isEmbeddedValid = false;
        for (int nodeNumber = 0; nodeNumber < nodeList.getLength(); ++nodeNumber) {
            String tagName = nodeList.item(nodeNumber).getNodeName();
            if (tagName.equals(NODE_NAME_VARIABLES)) {
                hasVariablesTag = true;
                continue;
            }
            if (!tagName.equals(NODE_NAME_VALUESLIST)) continue;
            hasValuesListTag = true;
        }
        if (hasValuesListTag & hasVariablesTag) {
            isEmbeddedValid = true;
        }
        return isEmbeddedValid;
    }

    private int findNumberOfColumns(Element rootElement) {
        int returnValue = 0;
        NodeList nodeList = rootElement.getElementsByTagName(NODE_NAME_VALUESLIST);
        Element element = (Element)nodeList.item(0);
        if (element != null && (element = (Element)(nodeList = element.getElementsByTagName(NODE_NAME_VALUES)).item(0)) != null) {
            nodeList = element.getElementsByTagName(NODE_NAME_VALUE);
            returnValue = nodeList.getLength();
        }
        return returnValue;
    }

    protected String _getAttribute(String strAttribute, NamedNodeMap childNodeMap, String defaultValue) {
        String returnValue = defaultValue;
        Node namedItem = childNodeMap.getNamedItem(strAttribute);
        if (namedItem != null) {
            returnValue = namedItem.getNodeValue();
        }
        return returnValue;
    }

    public static Document _prepareDocument(String strXML) {
        Document document;
        block8: {
            document = null;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                InputSource inputSource = new InputSource(new StringReader(strXML));
                document = builder.parse(inputSource);
            }
            catch (IOException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (SAXException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (ParserConfigurationException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (FactoryConfigurationError e) {
                if (!_logger.isEnabled(Level.ERROR)) break block8;
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return document;
    }

    public static Document _prepareDocumentFromStream(InputStream stream) {
        Document document;
        block8: {
            document = null;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                InputSource inputSource = new InputSource(stream);
                document = builder.parse(inputSource);
            }
            catch (IOException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (SAXException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (ParserConfigurationException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (FactoryConfigurationError e) {
                if (!_logger.isEnabled(Level.ERROR)) break block8;
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return document;
    }
}

