/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.Axis;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.ROLAPResultSet;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetInterface;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.util.Util;
import java.util.ArrayList;
import java.util.List;

public class ResultSetMetadata
implements ResultSetMetadataInterface {
    private AxisInterface[] _commonAxes;
    private ArrayList<AxisInterface> axes = new ArrayList(3);
    private int axesCount;
    private ResultSetInterface resultSet;
    private AxisInterface slicerAxis;

    public ResultSetMetadata() throws OLAPException {
        this(null);
    }

    public ResultSetMetadata(AxisInterface[] axes) throws OLAPException {
        if (axes != null) {
            for (AxisInterface axe : axes) {
                this.addAxis(axe);
            }
        }
    }

    public void setSlicerAxis(AxisInterface slicerAxis) throws OLAPException {
        if (slicerAxis.getAxisNumber() == -1) {
            this.slicerAxis = slicerAxis;
        } else {
            ((Axis)this.slicerAxis).setAxisNumber(-1);
        }
        if (slicerAxis instanceof Axis) {
            ((Axis)this.slicerAxis).setResultSetMetadata(this);
        }
    }

    AxisInterface getSlicerAxis() throws OLAPException {
        return this.slicerAxis;
    }

    public void setResultSet(ResultSetInterface resultSet) throws OLAPException {
        if (Util.unequal((Object)this.resultSet, (Object)resultSet)) {
            this.resultSet = resultSet;
            if (resultSet instanceof ROLAPResultSet) {
                ((ROLAPResultSet)this.resultSet).setResultSetMetadata(this);
            }
        }
    }

    public void addAxis(AxisInterface axis) throws OLAPException {
        this._commonAxes = null;
        if (axis == null) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ResultSetMetadata.invalidAxis.txt", new Object[0]);
            IllegalArgumentException e = new IllegalArgumentException(msg.toString());
            e.initCause(new ExecutionException(msg));
            throw e;
        }
        int axisNum = axis.getAxisNumber();
        if (axisNum == -1) {
            this.setSlicerAxis(axis);
        } else {
            if (axisNum < 0 || axisNum > this.axesCount) {
                MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ResultSetMetadata.skipAxis.txt", new Object[0]);
                IllegalArgumentException e = new IllegalArgumentException(msg.toString());
                e.initCause(new ExecutionException(msg));
                throw e;
            }
            if (axisNum < this.axesCount) {
                this.axes.set(axisNum, axis);
            } else if (axisNum == this.axesCount) {
                this.axes.add(axis);
                ++this.axesCount;
            }
            if (axis instanceof Axis) {
                ((Axis)axis).setResultSetMetadata(this);
            }
        }
    }

    public void setAxes(AxisInterface[] axes) throws OLAPException {
        for (AxisInterface axe : axes) {
            this.addAxis(axe);
        }
    }

    public AxisInterface removeAxis(int axisNumber) throws OLAPException {
        this._commonAxes = null;
        if (axisNumber < -1 || axisNumber >= this.axesCount) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ResultSetMetadata.invalidIndex.txt", new Object[0]);
            IllegalArgumentException e = new IllegalArgumentException(msg.toString());
            e.initCause(new ExecutionException(msg));
            throw e;
        }
        if (axisNumber == -1) {
            this.slicerAxis = null;
            return null;
        }
        AxisInterface axis = this.axes.get(axisNumber);
        int cnt = this.axes.size();
        for (int i = axisNumber + 1; i < cnt; ++i) {
            ((Axis)this.axes.get(i)).setAxisNumber(i - 1);
        }
        return this.axes.remove(axisNumber);
    }

    public AxisInterface[] getAxes(int index, int count) throws OLAPException {
        if (index == 0 && count == -1 && this.slicerAxis == null) {
            if (this._commonAxes == null) {
                this._commonAxes = new AxisInterface[]{this.axes.get(0), this.axes.get(1)};
            }
            return this._commonAxes;
        }
        if (index < -1 || index >= this.axesCount && index != 0 || count < -1 || count > this.axesCount + 1) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ResultSetMetadata.invalidIndex.txt", new Object[0]);
            IllegalArgumentException e = new IllegalArgumentException(msg.toString());
            e.initCause(new ExecutionException(msg));
            throw e;
        }
        if (index == -1 && (count == -1 || count == 1)) {
            return new AxisInterface[]{this.slicerAxis};
        }
        if (count != 0) {
            int endIndex = count == -1 ? this.axesCount : index + count;
            List<AxisInterface> values = this.axes.subList(index, endIndex);
            if (!(count != -1 && count != this.axesCount + 1 || this.slicerAxis == null || values.contains(this.slicerAxis))) {
                values.add(this.slicerAxis);
            }
            return values.toArray(new AxisInterface[values.size()]);
        }
        return new AxisInterface[0];
    }

    public AxisInterface getAxis(int index) throws OLAPException {
        if (index < -1 || index >= this.axesCount && index != 0) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ResultSetMetadata.invalidIndex.txt", new Object[0]);
            IllegalArgumentException e = new IllegalArgumentException(msg.toString());
            e.initCause(new ExecutionException(msg));
            throw e;
        }
        if (index == -1) {
            return this.slicerAxis;
        }
        return this.axes.get(index);
    }

    public final ResultSetInterface getResultSet() throws OLAPException {
        return this.resultSet;
    }

    public TupleInterface[] getTuples(int axisIndex, int index, int count) throws OLAPException {
        if (axisIndex < 0 || axisIndex >= this.axesCount) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ResultSetMetadata.invalidIndex.txt", new Object[0]);
            IllegalArgumentException e = new IllegalArgumentException(msg.toString());
            e.initCause(new ExecutionException(msg));
            throw e;
        }
        return this.axes.get(axisIndex).getTuples(index, count);
    }

    public TupleElementInterface[] getElements(int axisIndex, int tupleCoordinate, int index, int count) throws OLAPException {
        if (axisIndex < 0 || axisIndex >= this.axesCount) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ResultSetMetadata.invalidIndex.txt", new Object[0]);
            IllegalArgumentException e = new IllegalArgumentException(msg.toString());
            e.initCause(new ExecutionException(msg));
            throw e;
        }
        return this.axes.get(axisIndex).getTuples(tupleCoordinate, 1)[0].getElements(index, count);
    }

    public void close() throws OLAPException {
        for (AxisInterface axisInterface : this.axes) {
            Axis axis = (Axis)axisInterface;
            axis.close();
        }
    }
}

