/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.util.BasicFileBackedList;
import com.sas.iquery.execution.util.FileBackedListInterface;
import com.sas.iquery.execution.util.SmartFileBackedList;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPOptions;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.ResultSetMetadata;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.ResultSetInterface;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ROLAPResultSet
implements ResultSetInterface {
    public static final String RB_KEY = "ResultSet.";
    private String rolapQuery;
    private List<Object> _cellValues;
    private List<Object> _formattedCellValues;
    private ResultSetMetadataInterface resultSetMetadata;
    private boolean _isDual;
    private static final Logger _logger = LogManager.getLogger(ROLAPResultSet.class);

    public ROLAPResultSet(ResultSetMetadataInterface rsm, boolean isDual) throws OLAPException {
        this._isDual = isDual;
        this.resultSetMetadata = rsm == null ? new ResultSetMetadata() : rsm;
        this._cellValues = new ArrayList<Object>();
        this._formattedCellValues = this._cellValues;
        if (this._isDual) {
            this._formattedCellValues = new ArrayList<Object>();
        }
    }

    public final ResultSetMetadataInterface getResultSetMetadata() throws OLAPException {
        return this.resultSetMetadata;
    }

    public final String getQueryStatement() throws OLAPException {
        return this.rolapQuery;
    }

    public final void setQueryStatement(String queryStatement) throws OLAPException {
        this.rolapQuery = queryStatement;
    }

    public long getCellCount() throws OLAPException {
        AxisInterface[] axes = this.resultSetMetadata.getAxes(0, -1);
        return (long)axes[0].getTupleCount() * (long)axes[1].getTupleCount();
    }

    public Object[] getCells(long startCell, long endCell) throws OLAPException {
        Object[] cells = this.extractCells(startCell, endCell, this._cellValues);
        return cells;
    }

    public String[] getFormattedCells(long startCell, long endCell) throws OLAPException {
        Object[] cells = this.extractCells(startCell, endCell, this._formattedCellValues);
        String[] formattedCells = new String[cells.length];
        for (int i = 0; i < cells.length; ++i) {
            formattedCells[i] = cells[i].toString();
        }
        return formattedCells;
    }

    private Object[] extractCells(long startCell, long endCell, List<Object> cellValues) throws OLAPException {
        long cnt = this.getCellCount();
        if (cnt == 0L) {
            return new Object[0];
        }
        if (endCell == -1L) {
            endCell = cnt - 1L;
        }
        if (startCell < 0L || endCell > cnt - 1L || endCell < startCell) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ResultSet.invalidOrdinal.txt", new Object[0]);
            IllegalArgumentException e = new IllegalArgumentException(msg.toString());
            e.initCause(new ExecutionException(msg));
            throw e;
        }
        long[] returnkeys = this.getCellOrdinals(startCell, endCell);
        for (int i = 0; i < returnkeys.length; ++i) {
            int size = cellValues.size();
            if (returnkeys[i] < (long)size) continue;
            int k = size;
            while ((long)k <= returnkeys[i]) {
                cellValues.add(k, ".");
                ++k;
            }
        }
        return cellValues.subList((int)startCell, (int)endCell + 1).toArray();
    }

    public boolean isReadOnly() throws OLAPException {
        return false;
    }

    public void setResultSetMetadata(ResultSetMetadataInterface rsm) throws OLAPException {
        if (Util.unequal((Object)this.resultSetMetadata, (Object)rsm)) {
            this.resultSetMetadata = rsm;
            if (rsm instanceof ResultSetMetadata) {
                ((ResultSetMetadata)rsm).setResultSet(this);
            }
        }
    }

    public void setFormattedCells(long startCell, long endCell, String[] values) throws OLAPException {
        this.insertCells(startCell, endCell, values, this._formattedCellValues);
    }

    public void setCells(long startCell, long endCell, Object[] values) throws OLAPException {
        this.insertCells(startCell, endCell, values, this._cellValues);
    }

    private void insertCells(long startCell, long endCell, Object[] values, List<Object> cellValues) throws OLAPException {
        if (values != null && values.length > 0) {
            if (endCell < startCell) {
                endCell = values.length - 1;
            }
            if (startCell < 0L || endCell < 0L || startCell > endCell) {
                MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ResultSet.invalidOrdinal.txt", new Object[0]);
                IllegalArgumentException e = new IllegalArgumentException(msg.toString());
                e.initCause(new ExecutionException(msg));
                throw e;
            }
            int k = 0;
            long[] returnkeys = this.getCellOrdinals(startCell, endCell);
            for (int i = 0; i < returnkeys.length; ++i) {
                if (returnkeys[i] < (long)cellValues.size() && k < values.length) {
                    cellValues.set((int)returnkeys[i], values[k++]);
                    continue;
                }
                cellValues.add(values[k++]);
            }
        }
    }

    public void setCell(long cellIdx, Object cellValue) {
        this.inserCell(cellIdx, cellValue, this._cellValues);
    }

    public void setFormattedCell(long cellIdx, Object cellValue) {
        this.inserCell(cellIdx, cellValue, this._formattedCellValues);
    }

    private void inserCell(long cellIdx, Object cellValue, List<Object> cellValues) {
        if (cellIdx == (long)cellValues.size()) {
            cellValues.add(cellValue);
        } else {
            cellValues.set((int)cellIdx, cellValue);
        }
    }

    public void addCells(long startCell, long endCell, Object[] values) throws OLAPException {
        this.setCells(startCell, endCell, values);
    }

    public void removeCells(long startCell, long endCell) throws OLAPException {
        if (this._cellValues == null || this._cellValues.size() == 0) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ResultSet.invalidOrdinal.txt", new Object[0]);
            IllegalArgumentException e = new IllegalArgumentException(msg.toString());
            e.initCause(new ExecutionException(msg));
            throw e;
        }
        if (endCell == -1L) {
            endCell = this.getCellCount() - 1L;
        }
        long[] returnkeys = this.getCellOrdinals(startCell, endCell);
        for (int i = 0; i < returnkeys.length; ++i) {
            this._cellValues.set(Long.valueOf(returnkeys[i]).intValue(), ".");
            this._formattedCellValues.set(Long.valueOf(returnkeys[i]).intValue(), ".");
        }
    }

    public void close() throws OLAPException {
        if (this._cellValues instanceof FileBackedListInterface) {
            try {
                ((FileBackedListInterface)this._cellValues).close();
            }
            catch (IOException e) {
                throw new OLAPException((Throwable)e);
            }
        }
        if (this._isDual && this._formattedCellValues instanceof FileBackedListInterface) {
            try {
                ((FileBackedListInterface)this._formattedCellValues).close();
            }
            catch (IOException e) {
                throw new OLAPException((Throwable)e);
            }
        }
        if (this.resultSetMetadata instanceof ResultSetMetadata) {
            ((ResultSetMetadata)this.resultSetMetadata).close();
        }
    }

    private long[] getCellOrdinals(long startCell, long endCell) throws OLAPException {
        if (this.resultSetMetadata == null) {
            return new long[0];
        }
        int startOrdinal = Long.valueOf(startCell).intValue();
        int endOrdinal = Long.valueOf(endCell).intValue();
        int[] startCoord = OLAPUtil.calculateTupleCoordinates((ResultSetMetadataInterface)this.resultSetMetadata, (int)startOrdinal);
        int[] endCoord = OLAPUtil.calculateTupleCoordinates((ResultSetMetadataInterface)this.resultSetMetadata, (int)endOrdinal);
        int[] currentCoordinates = new int[startCoord.length];
        int nCellsRequested = endOrdinal - startOrdinal + 1;
        for (int i = 1; i < startCoord.length; ++i) {
            if (i == 1) {
                nCellsRequested = 1;
            }
            nCellsRequested *= (endCoord[i] - startCoord[i] + 1) * (endCoord[i - 1] - startCoord[i - 1] + 1);
        }
        long[] returnkeys = new long[nCellsRequested];
        this.calculateOrdinals(startCoord.length - 1, startCoord, endCoord, currentCoordinates, returnkeys, 0);
        return returnkeys;
    }

    private int calculateOrdinals(int axisNumber, int[] startingCoordinates, int[] endingCoordinates, int[] currentCoordinates, long[] returnKeys, int index) throws OLAPException {
        for (int i = startingCoordinates[axisNumber]; i <= endingCoordinates[axisNumber]; ++i) {
            currentCoordinates[axisNumber] = i;
            if (axisNumber == 0) {
                if (index >= returnKeys.length) continue;
                returnKeys[index++] = OLAPUtil.calculateCellOrdinal((ResultSetMetadataInterface)this.resultSetMetadata, (int[])currentCoordinates);
                continue;
            }
            index = this.calculateOrdinals(--axisNumber, startingCoordinates, endingCoordinates, currentCoordinates, returnKeys, index);
            ++axisNumber;
        }
        return index;
    }

    public void pageOut() throws OLAPException {
        _logger.debug("Paging out cell values...");
        ROLAPOptions options = new ROLAPOptions();
        int chunkSize = options.getCellChunkSize();
        int pageOutThreshold = options.getCellPageOutThreshold();
        try {
            BasicFileBackedList fbl = new BasicFileBackedList(chunkSize);
            SmartFileBackedList<Object> newCellValuesList = new SmartFileBackedList<Object>(fbl, pageOutThreshold);
            newCellValuesList.addAll(this._cellValues);
            this._cellValues = newCellValuesList;
            if (this._isDual) {
                BasicFileBackedList fblformatted = new BasicFileBackedList(chunkSize);
                SmartFileBackedList<Object> newFormattedCellValuesList = new SmartFileBackedList<Object>(fblformatted, pageOutThreshold);
                newFormattedCellValuesList.addAll(this._formattedCellValues);
                this._formattedCellValues = newFormattedCellValuesList;
            }
        }
        catch (IOException e) {
            throw new OLAPException((Throwable)e);
        }
    }
}

