/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata;

import com.sas.iquery.execution.util.NamedNode;
import com.sas.iquery.execution.util.ResultColumnDef;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPBuilderInformation;
import com.sas.storage.olap.TupleElementType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ROLAPNamesUtil {
    static final Logger _logger = LogManager.getLogger(ROLAPNamesUtil.class);
    static final char PREFIX_BRACE = '[';
    static final char SUFFIX_BRACE = ']';
    static final String UNIQUE_NAME_DELIM = ".";
    static final String AGGREGATE_TUPLE_NAME_PREFIX = "";
    static final String PREFIX_AMP = "&";
    static final String SUBTOTAL_TUPLE_NAME_PREFIX = "&S";
    static final String TOTAL_TUPLE_NAME_PREFIX = "&T";
    static final String HIERARCHY_PREFIX = "H_";
    static final String DIMENSION_PREFIX = "D_";
    static final String MEASURES_LEVEL_NAME = "MeasuresLevel";
    static final String MEASURES_DIM_NAME = "Measures";
    static final String MEASURES_HIER_NAME = "Measures";
    static final String ALL_LEVEL_LABEL_PREFIX = "All ";
    static final String ALL_LEVEL_PREFIX = "All L_";
    static final String MEMBER_LEVEL_LABEL_PREFIX = "";
    static final String MEMBER_LEVEL_PREFIX = "All H_";
    static final String ALL_MEMBER_LABEL_PREFIX = "";
    static final String ALL_MEMBER_PREFIX = "All H_";

    static String getTupleUniqueName(boolean isGrouped, NamedNode namedNode, String allMemberUniqueName, String tupleName) {
        return ROLAPNamesUtil.getMemberUniqueName(isGrouped, namedNode, allMemberUniqueName, tupleName);
    }

    static String getTupleName(NamedNode namedNode) {
        return ROLAPNamesUtil.getMemberName(namedNode);
    }

    static String getMemberUniqueName(boolean isGrouped, NamedNode node, String allMemberUniqueName, String name) {
        String tupleUniqueName;
        if (isGrouped) {
            NamedNode parentNode = node.getParent();
            tupleUniqueName = ROLAPNamesUtil.getMemberUniqueName(allMemberUniqueName, parentNode, name);
        } else {
            tupleUniqueName = ROLAPNamesUtil.getMemberUniqueName(allMemberUniqueName, name);
        }
        return tupleUniqueName;
    }

    public static String getDimensionName(String columnName) {
        return DIMENSION_PREFIX + columnName;
    }

    static String getDimensionUniqueName(String dimensionName) {
        return ROLAPNamesUtil.formatUniqueName(dimensionName);
    }

    static String getHierarchyName(String columnName) {
        return HIERARCHY_PREFIX + columnName;
    }

    static String getHierarchyUniqueName(String dimensionName, String hierarchyName) {
        return ROLAPNamesUtil.formatUniqueName(dimensionName, hierarchyName);
    }

    static String getAllLevelName(String columnName) {
        return ALL_LEVEL_PREFIX + columnName;
    }

    static String getAllLevelUniqueName(String hierarchyName, String levelName) {
        return ROLAPNamesUtil.formatUniqueName(hierarchyName, levelName);
    }

    static String getAllMemberName(String columnName) {
        return "All H_" + columnName;
    }

    public static String getAllMemberUniqueName(String rsid) {
        String hierarchyName = ROLAPNamesUtil.getHierarchyName(rsid);
        String allMemberName = ROLAPNamesUtil.getAllMemberName(rsid);
        return ROLAPNamesUtil.getMemberUniqueName(hierarchyName, allMemberName);
    }

    static String getMemberLevelName(String columnName) {
        return "All H_" + columnName;
    }

    static String getMemberLevelUniqueName(String hierarchyName, String levelName) {
        return ROLAPNamesUtil.formatUniqueName(hierarchyName, levelName);
    }

    static String getMeasuresLevelUniqueName(String hierarchyName, String levelName) {
        return ROLAPNamesUtil.formatUniqueName(hierarchyName, levelName);
    }

    static String getMeasureUniqueName(String memberParent, String memberName) {
        return ROLAPNamesUtil.formatUniqueName(memberParent, memberName);
    }

    static String getTupleLabel(NamedNode namedNode) {
        return namedNode.getLabel();
    }

    static String getMemberName(NamedNode namedNode) {
        TupleElementType type = namedNode.getType();
        String nodeName = namedNode.getName();
        String totalNamePrefix = ROLAPNamesUtil.getTotalNamePrefix(type);
        String memberName = totalNamePrefix + ROLAPNamesUtil.escapeAmp(nodeName);
        return memberName;
    }

    static String getMemberUniqueName(String memberParent, String memberName) {
        return ROLAPNamesUtil.formatUniqueName(memberParent, memberName);
    }

    public static String getMemberUniqueName(String rootMemberName, NamedNode parentNode, String memberName) {
        String result;
        if (parentNode == null) {
            result = ROLAPNamesUtil.getMemberUniqueName(rootMemberName, memberName);
        } else {
            String parentUniqueMemberName;
            NamedNode parentsParent = parentNode.getParent();
            if (parentsParent == null) {
                parentUniqueMemberName = rootMemberName;
            } else {
                String parentsMemberName = ROLAPNamesUtil.getMemberName(parentNode);
                parentUniqueMemberName = ROLAPNamesUtil.getMemberUniqueName(rootMemberName, parentsParent, parentsMemberName);
            }
            result = ROLAPNamesUtil.getMemberUniqueName(parentUniqueMemberName, memberName);
        }
        return result;
    }

    static String getParentMemberUniqueName(NamedNode namedNode, String allMemberUniqueName) {
        String parentMemberUniqueName;
        NamedNode parentNode = namedNode.getParent();
        if (parentNode != null) {
            String parentsMemberName = ROLAPNamesUtil.getMemberName(parentNode);
            parentMemberUniqueName = ROLAPNamesUtil.getMemberUniqueName(allMemberUniqueName, parentNode.getParent(), parentsMemberName);
        } else {
            parentMemberUniqueName = allMemberUniqueName;
        }
        return parentMemberUniqueName;
    }

    static String formatUniqueName(String ... names) {
        String delim = "";
        StringBuffer buffer = new StringBuffer();
        for (String name : names) {
            if (name != null && name.length() > 0 && name.charAt(name.length() - 1) == ']') {
                buffer.append(delim).append(name);
            } else {
                buffer.append(delim).append('[').append(name).append(']');
            }
            delim = UNIQUE_NAME_DELIM;
        }
        return buffer.toString();
    }

    static String escapeAmp(String elementName) {
        String subStituted = elementName;
        if (elementName != null && elementName.startsWith(PREFIX_AMP)) {
            subStituted = " " + elementName;
        }
        return subStituted;
    }

    static String getTotalNamePrefix(TupleElementType type) {
        if (TupleElementType.TOTAL.equals(type)) {
            return TOTAL_TUPLE_NAME_PREFIX;
        }
        if (TupleElementType.SUBTOTAL.equals(type)) {
            return SUBTOTAL_TUPLE_NAME_PREFIX;
        }
        return "";
    }

    static String getDimensionLabel(ROLAPBuilderInformation.AxisInformation axisInfo, NamedNode namedNode, String columnName, ResultColumnDef resultColumnDef, String dimensionName) {
        return dimensionName;
    }

    static String getHierarchyLabel(ROLAPBuilderInformation.AxisInformation axisInfo, NamedNode namedNode, String columnName, ResultColumnDef resultColumnDef, String hierarchyName) {
        return hierarchyName;
    }

    static String getAllLevelLabel(ROLAPBuilderInformation.AxisInformation axisInfo, NamedNode namedNode, String columnName, ResultColumnDef resultColumnDef, String allLevelName) {
        return ROLAPNamesUtil.formatLabel(ALL_LEVEL_LABEL_PREFIX, resultColumnDef, axisInfo, columnName, namedNode, allLevelName);
    }

    static String getAllMemberLabel(ROLAPBuilderInformation.AxisInformation axisInfo, NamedNode namedNode, String columnName, ResultColumnDef resultColumnDef, String allMemberName) {
        return ROLAPNamesUtil.formatLabel("", resultColumnDef, axisInfo, columnName, namedNode, allMemberName);
    }

    static String getMemberLevelLabel(ROLAPBuilderInformation.AxisInformation axisInfo, NamedNode namedNode, String columnName, ResultColumnDef resultColumnDef) {
        return ROLAPNamesUtil.formatLabel("", resultColumnDef, axisInfo, columnName, namedNode, columnName);
    }

    public static String getMemberLabel(NamedNode namedNode) {
        return namedNode.getLabel();
    }

    static String getMeasuresDimensionLabel(String dimensionName) {
        return dimensionName;
    }

    static String getMeasuresHierarchyLabel(String hierarchyName) {
        return hierarchyName;
    }

    public static String getMeasuresLevelLabel(String measuresLevelName) {
        return measuresLevelName;
    }

    static String getMeasureLabel(ROLAPBuilderInformation.AxisInformation axisInfo, NamedNode namedNode, String columnName, ResultColumnDef resultColumnDef, String measureName) {
        return ROLAPNamesUtil.formatLabel(null, resultColumnDef, axisInfo, columnName, namedNode, measureName);
    }

    static String formatLabel(String prefix, ResultColumnDef resultColumnDef, ROLAPBuilderInformation.AxisInformation axisInfo, String columnName, NamedNode node, String defaultLabel) {
        String label = null;
        if (resultColumnDef != null) {
            label = resultColumnDef.getLabel();
        }
        if (label == null) {
            label = axisInfo.getROLAPBuilderInformation().getDataItemLabel(columnName);
            if (label == null) {
                label = node.getLabel();
                if (label == null) {
                    label = defaultLabel;
                } else if (prefix != null) {
                    label = prefix + label;
                }
            } else if (prefix != null) {
                label = prefix + label;
            }
        } else if (prefix != null) {
            label = prefix + label;
        }
        return label;
    }
}

