/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata;

import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MeasureInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.SchemaInterface;

final class MetadataFilterApiCompliant {
    MetadataFilterApiCompliant() {
    }

    static boolean isCompatible(SchemaInterface schema, Filter filter) throws OLAPException {
        Filter checkFilter = schema.getFilter();
        boolean matches = MetadataFilterApiCompliant.matchCategoryName(filter, checkFilter) && MetadataFilterApiCompliant.matchSchemaName(filter, checkFilter);
        return matches;
    }

    static boolean isCompatible(CubeInterface cube, Filter filter) throws OLAPException {
        Filter checkFilter = cube.getFilter();
        boolean matches = MetadataFilterApiCompliant.matchCategoryName(filter, checkFilter) && MetadataFilterApiCompliant.matchSchemaName(filter, checkFilter) && MetadataFilterApiCompliant.matchCubeName(filter, checkFilter);
        return matches;
    }

    static boolean isCompatible(DimensionInterface dimension, Filter filter) throws OLAPException {
        Filter checkFilter = dimension.getFilter();
        boolean matches = MetadataFilterApiCompliant.matchCategoryName(filter, checkFilter) && MetadataFilterApiCompliant.matchSchemaName(filter, checkFilter) && MetadataFilterApiCompliant.matchCubeName(filter, checkFilter) && MetadataFilterApiCompliant.matchDimensionName(filter, checkFilter) && MetadataFilterApiCompliant.matchUniqueDimensionName(filter, checkFilter);
        return matches;
    }

    boolean isCompatible(HierarchyInterface hierarchy, Filter filter) throws OLAPException {
        Filter checkFilter = hierarchy.getFilter();
        boolean matches = MetadataFilterApiCompliant.matchCategoryName(filter, checkFilter) && MetadataFilterApiCompliant.matchSchemaName(filter, checkFilter) && MetadataFilterApiCompliant.matchCubeName(filter, checkFilter) && MetadataFilterApiCompliant.matchUniqueDimensionName(filter, checkFilter) && MetadataFilterApiCompliant.matchHierarchyName(filter, checkFilter) && MetadataFilterApiCompliant.matchUniqueHierarchyName(filter, checkFilter);
        return matches;
    }

    static boolean isCompatible(LevelInterface level, Filter filter) throws OLAPException {
        Filter checkFilter = level.getFilter();
        return MetadataFilterApiCompliant.matchCategoryName(filter, checkFilter) && MetadataFilterApiCompliant.matchSchemaName(filter, checkFilter) && MetadataFilterApiCompliant.matchCubeName(filter, checkFilter) && MetadataFilterApiCompliant.matchUniqueDimensionName(filter, checkFilter) && MetadataFilterApiCompliant.matchUniqueHierarchyName(filter, checkFilter) && MetadataFilterApiCompliant.matchLevelName(filter, checkFilter) && MetadataFilterApiCompliant.matchUniqueLevelName(filter, checkFilter);
    }

    static boolean isCompatible(MemberInterface member, Filter filter) throws OLAPException {
        Filter checkFilter = member.getFilter();
        boolean matches = MetadataFilterApiCompliant.matchMemberName(filter, checkFilter) && MetadataFilterApiCompliant.matchUniqueMemberName(filter, checkFilter) && MetadataFilterApiCompliant.matchMemberLabel(filter, checkFilter) && MetadataFilterApiCompliant.matchMemberType(filter, checkFilter);
        return matches;
    }

    static boolean isCompatible(MeasureInterface measure, Filter filter) throws OLAPException {
        Filter checkFilter = measure.getFilter();
        boolean matches = MetadataFilterApiCompliant.matchCategoryName(filter, checkFilter) && MetadataFilterApiCompliant.matchSchemaName(filter, checkFilter) && MetadataFilterApiCompliant.matchCubeName(filter, checkFilter) && MetadataFilterApiCompliant.matchMeasureName(filter, checkFilter) && MetadataFilterApiCompliant.matchUniqueMeasureName(filter, checkFilter);
        return matches;
    }

    static boolean matchCategoryName(Filter findFilter, Filter checkFilter) {
        boolean matchCategoryName = true;
        String findCatalogName = findFilter.getCatalogName();
        if (findCatalogName != null && findCatalogName.trim().length() > 0 && checkFilter != null) {
            String checkValue = checkFilter.getCatalogName();
            matchCategoryName = checkValue == null || findCatalogName.equalsIgnoreCase(checkValue);
        }
        return matchCategoryName;
    }

    static boolean matchSchemaName(Filter findFilter, Filter checkFilter) {
        boolean matchSchemaName = true;
        String findSchemaName = findFilter.getSchemaName();
        if (findSchemaName != null && findSchemaName.trim().length() > 0 && checkFilter != null) {
            String checkValue = checkFilter.getSchemaName();
            matchSchemaName = checkValue == null || findSchemaName.equalsIgnoreCase(checkValue);
        }
        return matchSchemaName;
    }

    static boolean matchCubeName(Filter findFilter, Filter checkFilter) {
        boolean matchCubeName = true;
        String findCubeName = findFilter.getCubeName();
        if (findCubeName != null && findCubeName.trim().length() > 0 && checkFilter != null) {
            String checkValue = checkFilter.getCubeName();
            matchCubeName = checkValue == null || findCubeName.equalsIgnoreCase(checkValue);
        }
        return matchCubeName;
    }

    static boolean matchDimensionName(Filter findFilter, Filter checkFilter) {
        boolean matchDimensionName = true;
        String findDimensionName = findFilter.getDimensionName();
        if (findDimensionName != null && findDimensionName.trim().length() > 0 && checkFilter != null) {
            String checkValue = checkFilter.getDimensionName();
            matchDimensionName = checkValue == null || findDimensionName.equalsIgnoreCase(checkValue);
        }
        return matchDimensionName;
    }

    static boolean matchUniqueDimensionName(Filter findFilter, Filter checkFilter) {
        boolean matchUniqueDimensionName = true;
        String findUniqueDimensionName = findFilter.getUniqueDimensionName();
        if (findUniqueDimensionName != null && findUniqueDimensionName.trim().length() > 0 && checkFilter != null) {
            String checkValue = checkFilter.getUniqueDimensionName();
            matchUniqueDimensionName = checkValue == null || findUniqueDimensionName.equalsIgnoreCase(checkValue);
        }
        return matchUniqueDimensionName;
    }

    static boolean matchHierarchyName(Filter findFilter, Filter checkFilter) {
        boolean matchHierarchyName = true;
        String findHierarchyName = findFilter.getHierarchyName();
        if (findHierarchyName != null && findHierarchyName.trim().length() > 0 && checkFilter != null) {
            String checkValue = checkFilter.getHierarchyName();
            matchHierarchyName = checkValue == null || findHierarchyName.equalsIgnoreCase(checkValue);
        }
        return matchHierarchyName;
    }

    static boolean matchUniqueHierarchyName(Filter findFilter, Filter checkFilter) {
        boolean matchUniqueHierarchyName = true;
        String findUniqueHierarchyName = findFilter.getUniqueHierarchyName();
        if (findUniqueHierarchyName != null && findUniqueHierarchyName.trim().length() > 0 && checkFilter != null) {
            String checkValue = checkFilter.getUniqueHierarchyName();
            matchUniqueHierarchyName = checkValue == null || findUniqueHierarchyName.equalsIgnoreCase(checkValue);
        }
        return matchUniqueHierarchyName;
    }

    static boolean matchLevelName(Filter findFilter, Filter checkFilter) {
        boolean matchLevelName = true;
        String findLevelName = findFilter.getLevelName();
        if (findLevelName != null && findLevelName.trim().length() > 0 && checkFilter != null) {
            String checkValue = checkFilter.getLevelName();
            matchLevelName = checkValue == null || findLevelName.equalsIgnoreCase(checkValue);
        }
        return matchLevelName;
    }

    static boolean matchUniqueLevelName(Filter findFilter, Filter checkFilter) {
        boolean matchUniqueLevelName = true;
        String findUniqueLevelName = findFilter.getUniqueLevelName();
        if (findUniqueLevelName != null && findUniqueLevelName.trim().length() > 0 && checkFilter != null) {
            String checkValue = checkFilter.getUniqueLevelName();
            matchUniqueLevelName = checkValue == null || findUniqueLevelName.equalsIgnoreCase(checkValue);
        }
        return matchUniqueLevelName;
    }

    static boolean matchMeasureName(Filter findFilter, Filter checkFilter) {
        boolean matchMeasureName = true;
        String findMeasureName = findFilter.getMeasureName();
        if (findMeasureName != null && findMeasureName.trim().length() > 0 && checkFilter != null) {
            String checkValue = checkFilter.getMeasureName();
            matchMeasureName = checkValue == null || findMeasureName.equalsIgnoreCase(checkValue);
        }
        return matchMeasureName;
    }

    static boolean matchUniqueMeasureName(Filter findFilter, Filter checkFilter) {
        boolean matchUniqueMeasureName = true;
        String findUniqueMeasureName = findFilter.getUniqueMeasureName();
        if (findUniqueMeasureName != null && findUniqueMeasureName.trim().length() > 0 && checkFilter != null) {
            String checkValue = checkFilter.getUniqueMeasureName();
            matchUniqueMeasureName = checkValue == null || findUniqueMeasureName.equalsIgnoreCase(checkValue);
        }
        return matchUniqueMeasureName;
    }

    static boolean matchLevelDepth(Filter findFilter, Filter checkFilter) {
        boolean matchLevelDepth = true;
        int findLevelDepth = findFilter.getLevelNumber();
        if (findLevelDepth != -1 && checkFilter != null) {
            int checkValue = checkFilter.getLevelNumber();
            matchLevelDepth = findLevelDepth == -1 || findLevelDepth == checkValue;
        }
        return matchLevelDepth;
    }

    static boolean matchMemberName(Filter findFilter, Filter checkFilter) {
        boolean matchMemberName = true;
        String findMemberName = findFilter.getMemberName();
        if (findMemberName != null && findMemberName.trim().length() > 0 && checkFilter != null) {
            String checkValue = checkFilter.getMemberName();
            matchMemberName = checkValue == null || findMemberName.equalsIgnoreCase(checkValue);
        }
        return matchMemberName;
    }

    static boolean matchUniqueMemberName(Filter findFilter, Filter checkFilter) {
        boolean matchUniqueMemberName = true;
        String findUniqueMemberName = findFilter.getUniqueMemberName();
        if (findUniqueMemberName != null && findUniqueMemberName.trim().length() > 0 && checkFilter != null) {
            String checkValue = checkFilter.getUniqueMemberName();
            matchUniqueMemberName = checkValue == null || findUniqueMemberName.equalsIgnoreCase(checkValue);
        }
        return matchUniqueMemberName;
    }

    static boolean matchMemberLabel(Filter findFilter, Filter checkFilter) {
        boolean matchMemberLabel = true;
        String findMemberLabel = findFilter.getMemberLabel();
        if (findMemberLabel != null && findMemberLabel.trim().length() > 0 && checkFilter != null) {
            String checkValue = checkFilter.getMemberLabel();
            matchMemberLabel = checkValue == null || findMemberLabel.equalsIgnoreCase(checkValue);
        }
        return matchMemberLabel;
    }

    static boolean matchMemberType(Filter findFilter, Filter checkFilter) {
        boolean matchMemberType = true;
        int findMemberType = findFilter.getMemberType();
        if (findMemberType != 0 && checkFilter != null) {
            int checkValue = checkFilter.getMemberType();
            matchMemberType = findMemberType == 0 || findMemberType == checkValue;
        }
        return matchMemberType;
    }
}

