/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata;

import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.MetadataMappingKeyUtil;
import com.sas.storage.olap.CubeInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MeasureInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.SchemaInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MetadataCache {
    private Map<String, SchemaInterface> _schemasMap = new LinkedHashMap<String, SchemaInterface>();
    private Map<String, CubeInterface> _cubesMap = new LinkedHashMap<String, CubeInterface>();
    private Map<String, DimensionInterface> _dimensionsMap = new LinkedHashMap<String, DimensionInterface>();
    private Map<String, HierarchyInterface> _hierarchiesMap = new LinkedHashMap<String, HierarchyInterface>();
    private Map<String, LevelInterface> _levelsMap = new LinkedHashMap<String, LevelInterface>();
    private Map<String, MemberInterface> _membersMap = new LinkedHashMap<String, MemberInterface>();
    private Map<String, MeasureInterface> _measuresMap = new LinkedHashMap<String, MeasureInterface>();
    private Map<LevelInterface, List<MemberInterface>> _levelMembers = new LinkedHashMap<LevelInterface, List<MemberInterface>>();
    private Map<MemberInterface, List<MemberInterface>> _memberMembers = new LinkedHashMap<MemberInterface, List<MemberInterface>>();

    public Collection<SchemaInterface> getSchemas() {
        return this._schemasMap.values();
    }

    public Collection<CubeInterface> getCubes() {
        return this._cubesMap.values();
    }

    public Collection<DimensionInterface> getDimensions() {
        return this._dimensionsMap.values();
    }

    public Collection<HierarchyInterface> getHierarchies() {
        return this._hierarchiesMap.values();
    }

    public Collection<LevelInterface> getLevels() {
        return this._levelsMap.values();
    }

    public Collection<MemberInterface> getMembers() {
        return this._membersMap.values();
    }

    public Collection<MeasureInterface> getMeasures() {
        return this._measuresMap.values();
    }

    public SchemaInterface getSchema(String catalogName, String schemaName) {
        String key = MetadataMappingKeyUtil.makeSchemasMapKey(catalogName, schemaName);
        return this._schemasMap.get(key);
    }

    public CubeInterface getCube(String catalogName, String schemaName, String cubeName) {
        String key = MetadataMappingKeyUtil.makeCubesMapKey(catalogName, schemaName, cubeName);
        return this._cubesMap.get(key);
    }

    public DimensionInterface getDimension(String catalogName, String schemaName, String cubeName, String uniqueDimensionName) {
        String key = MetadataMappingKeyUtil.makeDimensionsMapKey(catalogName, schemaName, cubeName, uniqueDimensionName);
        return this._dimensionsMap.get(key);
    }

    public HierarchyInterface getHierarchy(String catalogName, String schemaName, String cubeName, String uniqueHierarchyName) {
        String key = MetadataMappingKeyUtil.makeHierarchiesMapKey(catalogName, schemaName, cubeName, uniqueHierarchyName);
        return this._hierarchiesMap.get(key);
    }

    public LevelInterface getLevel(String catalogName, String schemaName, String cubeName, String uniqueDimensionName, String uniqueLevelName) {
        String key = MetadataMappingKeyUtil.makeLevelsMapKey(catalogName, schemaName, cubeName, uniqueDimensionName, uniqueLevelName);
        return this._levelsMap.get(key);
    }

    public MemberInterface getMember(String catalogName, String schemaName, String cubeName, String uniqueDimensionName, String uniqueMemberName) {
        String key = MetadataMappingKeyUtil.makeMembersMapKey(catalogName, schemaName, cubeName, uniqueDimensionName, uniqueMemberName);
        return this._membersMap.get(key);
    }

    public MeasureInterface getMeasure(String catalogName, String schemaName, String cubeName, String measureName) {
        String key = MetadataMappingKeyUtil.makeMeasuresMapKey(catalogName, schemaName, cubeName, measureName);
        return this._measuresMap.get(key);
    }

    public void add(SchemaInterface value) throws OLAPException {
        Filter filter = value.getFilter();
        String key = MetadataMappingKeyUtil.makeSchemasMapKey(filter.getCatalogName(), filter.getSchemaName());
        SchemaInterface oldValue = this._schemasMap.get(key);
        if (oldValue != null && oldValue != value) {
            throw new IllegalArgumentException("There is already a schema '" + oldValue.getName() + "' cached for " + key);
        }
        this._schemasMap.put(key, value);
    }

    public void add(CubeInterface value) throws OLAPException {
        Filter filter = value.getFilter();
        String key = MetadataMappingKeyUtil.makeCubesMapKey(filter.getCatalogName(), filter.getSchemaName(), filter.getCubeName());
        CubeInterface oldValue = this._cubesMap.get(key);
        if (oldValue != null && oldValue != value) {
            throw new IllegalArgumentException("There is already a cube '" + oldValue.getUniqueName() + "' cached for " + key);
        }
        this._cubesMap.put(key, value);
    }

    public void add(DimensionInterface value) throws OLAPException {
        Filter filter = value.getFilter();
        String key = MetadataMappingKeyUtil.makeDimensionsMapKey(filter.getCatalogName(), filter.getSchemaName(), filter.getCubeName(), filter.getUniqueDimensionName());
        DimensionInterface oldValue = this._dimensionsMap.get(key);
        if (oldValue != null && oldValue != value) {
            throw new OLAPException("There is already a dimension '" + oldValue.getUniqueName() + "' cached for " + key);
        }
        this._dimensionsMap.put(key, value);
    }

    public void add(HierarchyInterface value) throws OLAPException {
        Filter filter = value.getFilter();
        String key = MetadataMappingKeyUtil.makeHierarchiesMapKey(filter.getCatalogName(), filter.getSchemaName(), filter.getCubeName(), filter.getUniqueHierarchyName());
        HierarchyInterface oldValue = this._hierarchiesMap.get(key);
        if (oldValue != null && oldValue != value) {
            throw new IllegalArgumentException("There is already a hierarchy '" + oldValue.getUniqueName() + "' cached for " + key);
        }
        this._hierarchiesMap.put(key, value);
    }

    public void add(LevelInterface value) throws OLAPException {
        Filter filter = value.getFilter();
        String key = MetadataMappingKeyUtil.makeLevelsMapKey(filter.getCatalogName(), filter.getSchemaName(), filter.getCubeName(), filter.getUniqueDimensionName(), filter.getUniqueLevelName());
        LevelInterface oldValue = this._levelsMap.get(key);
        if (oldValue != null && oldValue != value) {
            throw new IllegalArgumentException("There is already a level '" + oldValue.getUniqueName() + "' cached for " + key);
        }
        this._levelsMap.put(key, value);
    }

    public void add(MemberInterface value) throws OLAPException {
        Filter filter = value.getFilter();
        String key = MetadataMappingKeyUtil.makeMembersMapKey(filter.getCatalogName(), filter.getSchemaName(), filter.getCubeName(), filter.getUniqueDimensionName(), filter.getUniqueMemberName());
        MemberInterface oldValue = this._membersMap.get(key);
        if (oldValue != null && oldValue != value) {
            throw new IllegalArgumentException("There is already a member '" + oldValue.getUniqueName() + "' cached for " + key);
        }
        this._membersMap.put(key, value);
    }

    public void add(MeasureInterface value) throws OLAPException {
        Filter filter = value.getFilter();
        String key = MetadataMappingKeyUtil.makeMeasuresMapKey(filter.getCatalogName(), filter.getSchemaName(), filter.getCubeName(), filter.getMeasureName());
        MeasureInterface oldValue = this._measuresMap.get(key);
        if (oldValue != null && oldValue != value) {
            throw new IllegalArgumentException("There is already a measure '" + oldValue.getUniqueName() + "' cached for " + key);
        }
        this._measuresMap.put(key, value);
    }

    public List<MemberInterface> getLevelMembers(LevelInterface level) {
        return this._levelMembers.get(level);
    }

    public List<MemberInterface> getMemberMembers(MemberInterface member) {
        return this._memberMembers.get(member);
    }

    public void addLevelMember(LevelInterface level, MemberInterface member) {
        List<MemberInterface> members = this._levelMembers.get(level);
        if (members == null) {
            members = new ArrayList<MemberInterface>();
            this._levelMembers.put(level, members);
        }
        members.add(member);
    }

    public void addMemberMember(MemberInterface parent, MemberInterface child) {
        List<MemberInterface> members = this._memberMembers.get(parent);
        if (members == null) {
            members = new ArrayList<MemberInterface>();
            this._memberMembers.put(parent, members);
        }
        members.add(child);
    }
}

