/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.AbstractMetadataEntity;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.PropertyInterface;
import java.util.Date;

public class Member
extends AbstractMetadataEntity
implements MemberInterface {
    private String _uniqueLevelName;
    private int _levelDepth;
    private int _childCount;
    private String _uniqueDimensionName;
    private String _uniqueHierarchyName;
    private String _parentMemberName;
    private MemberInterface _parentMember;
    private int _type = 0;

    public Member(MetadataInterface metadata, String catalogName, String schemaName, String cubeName, String uniqueDimensionName, String uniqueHierarchyName, String uniqueLevelName, int levelDepth, String memberUniqueName, String memberName, String memberLabel, String memberDescription, int memberType, String parentMemberName, int childCount, Date mintDate) throws OLAPException {
        super(metadata, catalogName, schemaName, cubeName, memberUniqueName, memberName, memberLabel, memberDescription, mintDate, false);
        this._uniqueDimensionName = uniqueDimensionName;
        this._uniqueHierarchyName = uniqueHierarchyName;
        this._uniqueLevelName = uniqueLevelName;
        this._levelDepth = levelDepth;
        this._type = memberType;
        this._parentMemberName = parentMemberName;
        this._childCount = childCount;
    }

    public LevelInterface getLevel() throws OLAPException {
        MetadataInterface metadata = this._getMetadata();
        Filter inFilter = super.newFilter(true);
        inFilter.setUniqueDimensionName(this._uniqueDimensionName == null ? "" : this._uniqueDimensionName);
        inFilter.setUniqueHierarchyName(this._uniqueHierarchyName == null ? "" : this._uniqueHierarchyName);
        inFilter.setUniqueLevelName(this._uniqueLevelName == null ? "" : this._uniqueLevelName);
        LevelInterface level = metadata.getLevel(inFilter);
        return level;
    }

    public int getChildCount() throws OLAPException {
        if (this._childCount != -1) {
            return this._childCount;
        }
        return this.getChildren().length;
    }

    public MemberInterface[] getChildren() throws OLAPException {
        MetadataInterface metadata = this._getMetadata();
        Filter inFilter = super.newFilter(true);
        inFilter.setUniqueMemberName(this.getUniqueName());
        inFilter.setTreeOperator(Filter.CHILDREN_TREE_OPERATOR);
        return metadata.getMembers(inFilter, 0, -1);
    }

    public int getType() throws OLAPException {
        return this._type;
    }

    public PropertyInterface[] getProperties() throws OLAPException {
        String reason = IQDataServicesResourceBundle.getStringResource("Member.any.unsupportedOperation.txt");
        UnsupportedOperationException un = new UnsupportedOperationException("getProperties()");
        throw new OLAPException((Throwable)un, reason);
    }

    public MemberInterface getParentMember() throws OLAPException {
        if (this._parentMember == null && this._parentMemberName != null && this._parentMemberName.length() > 0) {
            MetadataInterface metadata = this._getMetadata();
            Filter inFilter = super.newFilter(false);
            inFilter.setUniqueMemberName(this._parentMemberName);
            MemberInterface[] members = metadata.getMembers(inFilter, 0, -1);
            if (members.length == 1) {
                this._parentMember = members[0];
            }
            if (this._parentMember == null) {
                throw new OLAPException("One result expected for '" + this._parentMemberName + "'.  But the member filter returned " + members.length + " results");
            }
        }
        return this._parentMember;
    }

    @Override
    public synchronized Filter newFilter(boolean includeCatlogAndSchema) throws OLAPException {
        Filter filter = super.newFilter(includeCatlogAndSchema);
        filter.setUniqueDimensionName(this._uniqueDimensionName == null ? "" : this._uniqueDimensionName);
        filter.setUniqueHierarchyName(this._uniqueHierarchyName == null ? "" : this._uniqueHierarchyName);
        filter.setUniqueLevelName(this._uniqueLevelName == null ? "" : this._uniqueLevelName);
        filter.setLevelName(this._uniqueLevelName == null ? "" : this._uniqueLevelName);
        filter.setLevelNumber(this._levelDepth != -1 ? this._levelDepth : (this.getLevel() == null ? -1 : this.getLevel().getDepth()));
        filter.setMemberName(this.getName());
        filter.setMemberLabel(this.getLabel());
        filter.setUniqueMemberName(this.getUniqueName());
        filter.setMemberType(this._type);
        return filter;
    }

    public DimensionInterface getDimension() throws OLAPException {
        MetadataInterface metadata = this._getMetadata();
        Filter inFilter = super.newFilter(true);
        inFilter.setUniqueDimensionName(this._uniqueDimensionName == null ? "" : this._uniqueDimensionName);
        DimensionInterface dimension = metadata.getDimension(inFilter);
        return dimension;
    }
}

