/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata;

import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.AbstractMetadataEntity;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.Metadata;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import java.util.Date;

public class Hierarchy
extends AbstractMetadataEntity
implements HierarchyInterface {
    private String _uniqueDimensionName;
    private DimensionInterface _dimension;
    private String _defaultMemberName;
    private MemberInterface _defaultMember;
    private String _topMemberName;
    private MemberInterface _topMember;
    private int _structure;
    private int _memberCount;
    private MemberInterface[] _topMembers;
    private LevelInterface[] _levels;

    public Hierarchy(Metadata metadata, String catalogName, String schemaName, String cubeName, String uniqueDimensionName, String hierarchyUniqueName, String hierarchyName, String hierarchyLabel, String hierarchyDescription, int structure, int memberCount, String defaultMemberName, String topMemberName, Date mintDate) {
        super(metadata, catalogName, schemaName, cubeName, hierarchyUniqueName, hierarchyName, hierarchyLabel, hierarchyDescription, mintDate, false);
        this._uniqueDimensionName = uniqueDimensionName;
        this._structure = structure;
        this._memberCount = memberCount;
        this._defaultMemberName = defaultMemberName;
        this._topMemberName = topMemberName;
    }

    public MemberInterface[] getMembers() throws OLAPException {
        MetadataInterface metadata = this._getMetadata();
        Filter inFilter = super.newFilter(true);
        inFilter.setUniqueHierarchyName(this.getUniqueName());
        inFilter.setUniqueDimensionName(this._uniqueDimensionName == null ? "" : this._uniqueDimensionName);
        MemberInterface[] members = metadata.getMembers(inFilter, 0, -1);
        return members;
    }

    public int getMemberCount() throws OLAPException {
        if (this._memberCount != -1) {
            return this._memberCount;
        }
        return this.getMembers().length;
    }

    public DimensionInterface getDimension() throws OLAPException {
        if (this._dimension == null) {
            MetadataInterface metadata = this._getMetadata();
            Filter inFilter = super.newFilter(false);
            inFilter.setUniqueHierarchyName(this.getUniqueName());
            inFilter.setUniqueDimensionName(this._uniqueDimensionName);
            this._dimension = metadata.getDimension(inFilter);
        }
        return this._dimension;
    }

    public LevelInterface[] getLevels() throws OLAPException {
        if (this._levels == null) {
            MetadataInterface metadata = this._getMetadata();
            Filter inFilter = super.newFilter(false);
            inFilter.setUniqueHierarchyName(this.getUniqueName());
            inFilter.setUniqueDimensionName(this._uniqueDimensionName == null ? "" : this._uniqueDimensionName);
            this._levels = metadata.getLevels(inFilter);
        }
        return this._levels;
    }

    @Override
    public Filter newFilter(boolean includeCatlogAndSchema) throws OLAPException {
        Filter filter = super.newFilter(includeCatlogAndSchema);
        filter.setUniqueDimensionName(this._uniqueDimensionName == null ? "" : this._uniqueDimensionName);
        filter.setHierarchyName(this.getName());
        filter.setUniqueHierarchyName(this.getUniqueName());
        return filter;
    }

    public int getStructure() throws OLAPException {
        return this._structure;
    }

    public MemberInterface getDefaultMember() throws OLAPException {
        if (this._defaultMember == null) {
            MetadataInterface metadata = this._getMetadata();
            Filter inFilter = super.newFilter(false);
            inFilter.setUniqueHierarchyName(this.getUniqueName());
            inFilter.setUniqueDimensionName(this._uniqueDimensionName == null ? "" : this._uniqueDimensionName);
            inFilter.setUniqueMemberName(this._defaultMemberName);
            inFilter.setMemberType(0);
            MemberInterface[] members = metadata.getMembers(inFilter, 0, -1);
            if (members.length == 1) {
                this._defaultMember = members[0];
            }
        }
        return this._defaultMember;
    }

    public MemberInterface getTopMember() throws OLAPException {
        if (this._topMember == null) {
            MetadataInterface metadata = this._getMetadata();
            Filter inFilter = super.newFilter(false);
            inFilter.setUniqueHierarchyName(this.getUniqueName());
            inFilter.setUniqueDimensionName(this._uniqueDimensionName == null ? "" : this._uniqueDimensionName);
            inFilter.setUniqueMemberName(this._topMemberName);
            inFilter.setMemberType(0);
            MemberInterface[] members = metadata.getMembers(inFilter, 0, -1);
            if (members.length == 1) {
                this._topMember = members[0];
            }
        }
        return this._topMember;
    }

    public MemberInterface[] getTopMembers() throws OLAPException {
        if (this._topMembers == null) {
            LevelInterface[] levels;
            for (LevelInterface level : levels = this.getLevels()) {
                DimensionInterface dimension;
                if (level == null || level.getDepth() != 0 || (dimension = this.getDimension()) == null || dimension.getType() == 2) continue;
                this._topMembers = level.getMembers();
                break;
            }
            if (this._topMembers == null) {
                this._topMembers = new MemberInterface[0];
            }
        }
        return this._topMembers;
    }
}

