/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata;

import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.AbstractMetadataEntity;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import java.util.Date;

public class Dimension
extends AbstractMetadataEntity
implements DimensionInterface {
    private String _defaultHierName;
    private int _type;
    private int _memberCount = -1;
    private HierarchyInterface _defaultHierarchy;

    public Dimension(MetadataInterface metadata, String catalogName, String schemaName, String cubeName, String dimensionUniqueName, String dimensionName, String dimensionLabel, String dimensionDescription, int dimensionType, String defaultHierName, int memberCount, Date mintDate) throws OLAPException {
        super(metadata, catalogName, schemaName, cubeName, dimensionUniqueName, dimensionName, dimensionLabel, dimensionDescription, mintDate, false);
        this._type = dimensionType;
        this._memberCount = memberCount;
        this._defaultHierName = defaultHierName;
    }

    public MemberInterface[] getMembers() throws OLAPException {
        MetadataInterface metadata = this._getMetadata();
        Filter inFilter = super.getFilter();
        inFilter.setUniqueDimensionName(this.getUniqueName());
        return metadata.getMembers(inFilter, 0, -1);
    }

    public HierarchyInterface[] getHierarchies() throws OLAPException {
        MetadataInterface metadata = this._getMetadata();
        return metadata.getHierarchies(this.getFilter());
    }

    public int getType() throws OLAPException {
        return this._type;
    }

    public int getMemberCount() throws OLAPException {
        if (this._memberCount == -1) {
            return this.getMembers().length;
        }
        return this._memberCount;
    }

    @Override
    public Filter newFilter(boolean includeCatlogAndSchema) throws OLAPException {
        Filter filter = super.newFilter(includeCatlogAndSchema);
        filter.setDimensionName(this.getName());
        filter.setUniqueDimensionName(this.getUniqueName());
        return filter;
    }

    public HierarchyInterface getDefaultHierarchy() throws OLAPException {
        if (this._defaultHierarchy == null) {
            MetadataInterface metadata = this._getMetadata();
            Filter inFilter = this.getFilter();
            inFilter.setUniqueHierarchyName(this._defaultHierName);
            this._defaultHierarchy = metadata.getHierarchy(inFilter);
        }
        return this._defaultHierarchy;
    }
}

