/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap.composite;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLColumnAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.sas.SQLSASSelect;
import com.sas.iquery.strategies.sas.oma.summaryrolap.composite.SQLSASCASEColumn;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.List;

public class SQLSASROLAPSelect
extends SQLSASSelect {
    @Override
    protected void applyDistinct(StringBuffer sql) {
    }

    @Override
    protected void addSelectedItemsToColumnList(List<SelectedItem> selectedItems) throws GenerationException {
        for (int index = 0; index < selectedItems.size(); ++index) {
            SelectedItem selectedItem = selectedItems.get(index);
            DataItem item = selectedItem.getItem();
            this.checkValidRolapItem(item);
            if (this.skipSelectedItem(selectedItem)) continue;
            if (this.isCountFunctionOnItem(item)) {
                SQLColumnAbstract caseColumn = this._generateCaseColumn(item);
                this.addToColumnList(caseColumn, true);
                continue;
            }
            SQLColumnAbstract sqlColumn = this._generateSelectColumn(item);
            this.addToColumnList(sqlColumn, true);
        }
    }

    protected SQLColumnAbstract _generateCaseColumn(DataItem item) throws GenerationException {
        SQLSASCASEColumn caseColumn = new SQLSASCASEColumn();
        caseColumn.setJoinGenerator(this.m_joinGenerator);
        caseColumn.setSQLFactory(this.getSQLFactory());
        caseColumn.setDataSelection(this._dataSelection);
        caseColumn.setDataSelectionProcessor(this.getDataSelectionProcessor());
        caseColumn.setItem(item);
        ((SQLComponentAbstract)caseColumn).prepareSQL();
        return caseColumn;
    }

    private boolean isCountFunctionOnItem(DataItem item) throws GenerationException {
        boolean isCountFunctionOnItem = false;
        int expressionType = item.getExpression().getExpressionType();
        DataItemActionType usage = item.getUsage();
        if (expressionType == 3 && usage == DataItemActionType.USAGE_AGGREGATE) {
            String oldItemFunctionID;
            ServerProperties serverProperties = null;
            try {
                serverProperties = this._dataSelection.getServerProperties();
            }
            catch (MetadataException e) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("SQLSASROLAPSelect.isCountFunctionOnItem.MetadataException.txt", new Object[0]);
                throw new GenerationException(formatter, (Throwable)e);
            }
            String countFunctionID = serverProperties.getFunctionByNameID(FunctionNameID.COUNT).getID();
            String freqFunctionID = serverProperties.getFunctionByNameID(FunctionNameID.FREQ).getID();
            String nFunctionID = serverProperties.getFunctionByNameID(FunctionNameID.N).getID();
            Function oldItemFunction = item.getAggregationType();
            if (oldItemFunction != null && (countFunctionID.equals(oldItemFunctionID = oldItemFunction.getID()) || freqFunctionID.equals(oldItemFunctionID) || nFunctionID.equals(oldItemFunctionID))) {
                isCountFunctionOnItem = true;
            }
        }
        return isCountFunctionOnItem;
    }

    private void checkValidRolapItem(DataItem dataItem) throws GenerationException {
        DataItemActionType usage = dataItem.getUsage();
        if (!usage.equals(DataItemActionType.USAGE_AGGREGATE) && !usage.equals(DataItemActionType.USAGE_CATEGORY)) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("SQLSASROLAPSelect.checkValidRolapItem.wrongUsage.fmt.txt", usage.toString());
            throw new GenerationException(formatter);
        }
    }

    public String toString() {
        return this.writeSQL();
    }
}

