/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap.builder;

import com.sas.iquery.builder.DisabledTotalsBuilder;
import com.sas.iquery.builder.IQBuilderFactory;
import com.sas.iquery.execution.util.NamedNode;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.TotalingType;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPBuilderInformation;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ROLAPUtil {
    public static final String EMPTY_GRAND_TOTAL_LABEL = "";
    private static final Logger _logger = LogManager.getLogger(ROLAPUtil.class);

    public static void printTuples(List<TupleInterface> tuples) throws OLAPException {
        for (TupleInterface tuple : tuples) {
            ROLAPUtil.printTuple(tuple);
        }
    }

    public static void printTuple(TupleInterface tuple) throws OLAPException {
        if (_logger.isDebugEnabled()) {
            String str = "Tuple: depth=" + tuple.getTupleDepth() + ", index=" + tuple.getTupleIndex() + " { ";
            TupleElementInterface[] elements = tuple.getElements(0, tuple.getTupleDepth());
            for (int i = 0; i < elements.length; ++i) {
                TupleElementInterface element = elements[i];
                if (i > 0) {
                    str = str + ", ";
                }
                str = str + element.getName();
            }
            str = str + " }";
            _logger.debug(str);
        }
    }

    public static boolean isAbsentColumn(int c, int type, int totalCols) {
        int columnBit = 1;
        return ((columnBit <<= totalCols - c) & type) == 0;
    }

    public static int calculateTypeValue(int[] columnIndices, int classCount) {
        int type = 0;
        for (int i = 0; i < columnIndices.length; ++i) {
            int invColIdx = classCount - columnIndices[i];
            int bits = 1 << invColIdx;
            type |= bits;
        }
        return type;
    }

    public static boolean isMeasureLeafNode(NamedNode node, ROLAPBuilderInformation.AxisInformation axisInfo) {
        return axisInfo.getMeasureCount() > 0 && !node.hasChildren();
    }

    public static void useTotalLabels(String[] categoryValues, String[] categoryLabels, TupleElementType[] elementTypes, int categoryCount, int totalType, ROLAPBuilderInformation.AxisInformation axisInfo) {
        List<DataItem> categoryItems = axisInfo.getCategoryDataItems();
        if (categoryCount < 1) {
            return;
        }
        if (ROLAPUtil.isTotalValue(categoryValues[0], totalType, categoryItems.get(0), axisInfo)) {
            categoryValues[0] = axisInfo.getGrandTotalLabel();
            categoryLabels[0] = axisInfo.getGrandTotalLabel();
            elementTypes[0] = TupleElementType.TOTAL;
        } else {
            elementTypes[0] = TupleElementType.UNSPECIFIED;
        }
        for (int i = 1; i < categoryCount; ++i) {
            if (ROLAPUtil.isTotalValue(categoryValues[i], totalType, categoryItems.get(i), axisInfo)) {
                if (axisInfo.hasGrandTotals() && !axisInfo.hasSubTotals()) {
                    categoryValues[i] = EMPTY_GRAND_TOTAL_LABEL;
                    categoryLabels[i] = EMPTY_GRAND_TOTAL_LABEL;
                    elementTypes[i] = TupleElementType.SUBTOTAL;
                    continue;
                }
                categoryValues[i] = axisInfo.getSubTotalLabel();
                categoryLabels[i] = axisInfo.getSubTotalLabel();
                elementTypes[i] = TupleElementType.SUBTOTAL;
                continue;
            }
            elementTypes[i] = TupleElementType.UNSPECIFIED;
        }
    }

    static boolean isTotalValue(String categoryValue, int totalType, DataItem category, ROLAPBuilderInformation.AxisInformation axis) {
        if (categoryValue == null) {
            return false;
        }
        ROLAPBuilderInformation rbi = axis.getROLAPBuilderInformation();
        int typeMask = rbi.calculateTotalTypeMask(category);
        return (totalType & typeMask) == 0;
    }

    public static String makeGrandTotalMask(int[] indices, int categoryCount) {
        char[] grandTotalMask = new char[categoryCount];
        Arrays.fill(grandTotalMask, '.');
        for (int i = 0; i < indices.length; ++i) {
            int j = indices[i];
            grandTotalMask[j - 1] = 48;
        }
        return String.valueOf(grandTotalMask);
    }

    public static String makeDetailMask(int[] categoryIndices, int categoryCount) {
        char[] detailMask = new char[categoryCount];
        Arrays.fill(detailMask, '.');
        for (int i = 0; i < categoryIndices.length; ++i) {
            int j = categoryIndices[i];
            detailMask[j - 1] = 49;
        }
        return String.valueOf(detailMask);
    }

    public static List<String> makeSubtotalMasks(int[] categoryIndices, int categoryCount) {
        ArrayList<String> masks = new ArrayList<String>();
        char[] maskBits = new char[categoryCount];
        Arrays.fill(maskBits, '.');
        for (int i = categoryIndices.length; i > 1; --i) {
            for (int j = categoryIndices.length; j > 0; --j) {
                maskBits[categoryIndices[j - 1] - 1] = j >= i ? 48 : 49;
            }
            masks.add(String.valueOf(maskBits));
        }
        return masks;
    }

    public static boolean checkForDisabledTotals(DataSelection ds) {
        DisabledTotalsBuilder builder = IQBuilderFactory.newDisabledTotalsBuilder(ds);
        Set<DataItem> stsDisabled = builder.getDisabledItemsForType(TotalingType.SUBTOTAL);
        Set<DataItem> gtsDisabled = builder.getDisabledItemsForType(TotalingType.AXISTOTAL);
        Set<DataItem> allDisabled = builder.getDisabledItemsForType(TotalingType.ALLTOTAL);
        boolean hasDisabledTotals = !stsDisabled.isEmpty() || !gtsDisabled.isEmpty() || !allDisabled.isEmpty();
        return hasDisabledTotals;
    }
}

