/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.strategies.sas.oma.ExpandedProcSummaryStatement;
import com.sas.iquery.strategies.sas.oma.FractionOfTotalUtilImpl;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.ProcDataSets;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import com.sas.iquery.strategies.sas.oma.summaryrolap.AggregatedFilterStep;
import com.sas.iquery.strategies.sas.oma.summaryrolap.FractionOfTotalStep;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ProcSummaryROLAPStatement;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPBuilderInformation;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPFilterAndRankExaminer;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPStepGenerationUtil;
import com.sas.iquery.strategies.sas.oma.summaryrolap.RolapDataSelectionProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class VisualTotalSubStep {
    public static final String VISUALTOTALS_VIA_UPDATE_DEFAULT = "false";
    private static boolean _genVisualTotalsViaUpdate = Boolean.valueOf(System.getProperty(IQSystemProperties.VISUALTOTALS_VIA_UPDATE, "false"));

    public static boolean isVisualTotalsViaUpdate() {
        return _genVisualTotalsViaUpdate;
    }

    public static void setVisualTotalsViaUpdate(boolean visualTotalsViaUpdate) {
        _genVisualTotalsViaUpdate = visualTotalsViaUpdate;
    }

    public static void addCode(List<SQLComponentAbstract> code, RolapDataSelectionProcessor dsProcessor, ROLAPBuilderInformation rolapInfo, Collection measureItems, String updateTableName, String vtTempTable, String note, boolean ignoreDisabledTotals) throws GenerationException {
        ArrayList<SQLComponentAbstract> vtCalcCode = new ArrayList<SQLComponentAbstract>();
        ArrayList<SQLComponentAbstract> vtUpdateCode = new ArrayList<SQLComponentAbstract>();
        StringBuffer reasons = null;
        if (IQSystemProperties.isVerboseProcCommentsEnabled(AggregatedFilterStep.class)) {
            reasons = new StringBuffer();
        }
        VisualTotalSubStep.addCode(vtCalcCode, vtUpdateCode, reasons, dsProcessor, rolapInfo, updateTableName, updateTableName, new ArrayList<DataItem>(measureItems), vtTempTable, ignoreDisabledTotals);
        VisualTotalSubStep.addVtCode(code, updateTableName, reasons, vtCalcCode, vtUpdateCode, note);
    }

    public static void addVtCode(List<SQLComponentAbstract> code, String aggrFilteredSummaryTable, StringBuffer reasons, List<SQLComponentAbstract> vtCalcCode, List<SQLComponentAbstract> vtUpdateCode, String note) {
        if (vtCalcCode.size() > 0) {
            SQLStatementFactory.addText(code, "\n/* start: calculate visual totals" + note + (reasons != null ? reasons.toString() : "") + " */");
            code.addAll(vtCalcCode);
            SQLStatementFactory.addText(code, "\n/* end: calculate visual totals" + note + " */\n");
        }
        if (vtUpdateCode.size() > 0) {
            SQLStatementFactory.addText(code, "\n/* start: update visual totals in " + aggrFilteredSummaryTable + note + " */\n");
            if (VisualTotalSubStep.isVisualTotalsViaUpdate()) {
                SQLStatementFactory.addText(code, "/* using data step update by _type_ and class vars */\n");
            } else {
                SQLStatementFactory.addText(code, "/* using data step merge with drop/keep */\n");
            }
            code.addAll(vtUpdateCode);
            SQLStatementFactory.addText(code, "\n/* end: update visual totals" + note + " */\n");
        }
    }

    public static void addCode(List<SQLComponentAbstract> vtCalcCode, List<SQLComponentAbstract> vtUpdateCode, StringBuffer reasons, RolapDataSelectionProcessor dsProcessor, ROLAPBuilderInformation rolapInfo, String inputTableName, String outputTableName, Collection<DataItem> measureItems, String tempTableName, boolean ignoreDisabledTotals) throws GenerationException {
        List<String> measureIds;
        if (!ignoreDisabledTotals) {
            LinkedHashSet<DataItem> onlyATs = new LinkedHashSet<DataItem>();
            LinkedHashSet<DataItem> onlySTs = new LinkedHashSet<DataItem>();
            LinkedHashSet<DataItem> onlyXTs = new LinkedHashSet<DataItem>();
            LinkedHashSet<DataItem> onlyCells = new LinkedHashSet<DataItem>();
            LinkedHashSet<DataItem> outputVars = new LinkedHashSet<DataItem>(measureItems.size());
            DataSelection dataSelection = dsProcessor.getDataSelection();
            boolean hasDisabledTotals = ExpandedProcSummaryStatement.split(false, false, false, dataSelection, measureItems, onlyATs, onlySTs, onlyXTs, onlyCells, outputVars);
            measureIds = hasDisabledTotals ? VisualTotalSubStep.getVisualTotalMeasureIds(dsProcessor, onlyATs, reasons) : VisualTotalSubStep.getVisualTotalMeasureIds(dsProcessor, measureItems, reasons);
        } else {
            measureIds = VisualTotalSubStep.getVisualTotalMeasureIds(dsProcessor, measureItems, reasons);
        }
        if (measureIds.size() > 0) {
            VisualTotalSubStep.addCode(vtCalcCode, vtUpdateCode, dsProcessor, rolapInfo, inputTableName, outputTableName, tempTableName, measureIds);
        }
    }

    private static void addCode(List<SQLComponentAbstract> vtCalcCode, List<SQLComponentAbstract> vtUpdateCode, RolapDataSelectionProcessor dsProcessor, ROLAPBuilderInformation rolapInfo, String inputTableName, String outputTableName, String tempTableName, List<String> measureIds) throws GenerationException {
        int type = rolapInfo.getTotalTypeValueMax();
        boolean useUpdate = VisualTotalSubStep.isVisualTotalsViaUpdate();
        String[] categoryIds = rolapInfo.getCategoryIds();
        ArrayList<String> classIds = new ArrayList<String>();
        for (int i = 0; i < categoryIds.length; ++i) {
            String rsid = categoryIds[i];
            if (rsid == null || rsid.length() <= 0) continue;
            classIds.add(rsid);
        }
        if (!classIds.isEmpty()) {
            ArrayList<String> varIds = new ArrayList<String>();
            for (String rsid : measureIds) {
                if (rsid == null || rsid.length() <= 0) continue;
                varIds.add(rsid);
            }
            if (!varIds.isEmpty()) {
                boolean hasEmbeddedTotalsToUpdate = VisualTotalSubStep.hasEmbeddedTotals(dsProcessor);
                if (hasEmbeddedTotalsToUpdate) {
                    StringBuffer classListText = new StringBuffer();
                    int lineLen = 0;
                    for (String string : classIds) {
                        String identifier = dsProcessor.generateDataStepVar(string);
                        if (classListText.length() > 0) {
                            if (lineLen + identifier.length() + 1 > 80) {
                                classListText.append("\n\t");
                                lineLen = 1;
                            }
                            ++lineLen;
                            classListText.append(' ');
                        }
                        classListText.append(identifier);
                        lineLen += identifier.length();
                    }
                    lineLen = 0;
                    StringBuffer varListText = new StringBuffer();
                    for (String rsid : varIds) {
                        String identifier = dsProcessor.generateDataStepVar(rsid);
                        if (varListText.length() > 0) {
                            if (lineLen + identifier.length() + 1 > 80) {
                                varListText.append("\n\t");
                                lineLen = 1;
                            }
                            ++lineLen;
                            varListText.append(' ');
                        }
                        varListText.append(identifier);
                        lineLen += identifier.length();
                    }
                    StringBuffer stringBuffer = VisualTotalSubStep.generateVtCalcCode(inputTableName, type, tempTableName, useUpdate, classIds.size(), classListText, varListText);
                    SQLStatementFactory.addText(vtCalcCode, stringBuffer);
                    StringBuffer updateCode = VisualTotalSubStep.generateVtUpdateCode(dsProcessor, rolapInfo, inputTableName, outputTableName, tempTableName, useUpdate, classListText, varListText);
                    SQLStatementFactory.addText(vtUpdateCode, updateCode);
                    SQLStatementFactory.addProcDeleteDataByName(vtUpdateCode, dsProcessor, tempTableName);
                } else if (!inputTableName.equals(outputTableName)) {
                    ProcDataSets.generateRename(inputTableName, outputTableName);
                }
            }
        }
    }

    private static StringBuffer generateVtCalcCode(String inputTableName, int type, String tempTableName, boolean useUpdate, int numClasses, StringBuffer classListText, StringBuffer varListText) {
        StringBuffer calcCode = new StringBuffer();
        calcCode.append("\nPROC SUMMARY data=").append(inputTableName).append("(where=(_type_ = ").append(type).append(")) missing;\n");
        calcCode.append("  class ").append(classListText).append(";\n");
        calcCode.append("  var   ").append(varListText).append(";\n");
        if (useUpdate) {
            calcCode.append("  ways 0 to ").append(numClasses - 1).append(";\n");
        }
        calcCode.append("  output out=").append(tempTableName).append("(drop=_freq_) sum=;\n");
        calcCode.append("run;");
        return calcCode;
    }

    private static StringBuffer generateVtUpdateCode(RolapDataSelectionProcessor dsProcessor, ROLAPBuilderInformation rolapInfo, String inputTableName, String outputTableName, String tempTableName, boolean useUpdate, StringBuffer classListText, StringBuffer varListText) throws GenerationException {
        StringBuffer updateCode = new StringBuffer();
        updateCode.append("\nData ").append(inputTableName).append(";\n");
        if (useUpdate) {
            updateCode.append("  update ").append(outputTableName).append(" ").append(tempTableName).append(";\n");
            updateCode.append("    by  _type_  ").append(classListText).append(";\n");
        } else {
            List<String> retainColumnOrder = ROLAPStepGenerationUtil.getResultColumnsList(dsProcessor, rolapInfo);
            updateCode.append("  retain ");
            Iterator<String> iter = retainColumnOrder.iterator();
            while (iter.hasNext()) {
                String rsid = iter.next();
                String identifier = dsProcessor.generateDataStepVar(rsid);
                updateCode.append(identifier);
                if (!iter.hasNext()) continue;
                updateCode.append("\n\t");
            }
            updateCode.append(";\n");
            updateCode.append("  set ").append(outputTableName).append("\n");
            updateCode.append("    (drop= ").append(varListText).append(");\n");
            updateCode.append("  set ").append(tempTableName).append("\n");
            updateCode.append("    (keep= ").append(varListText).append(");\n");
        }
        updateCode.append("run;\n");
        return updateCode;
    }

    private static List<String> getVisualTotalMeasureIds(RolapDataSelectionProcessor dsProcessor, Collection<? extends DataItem> measureItems, StringBuffer reasons) throws GenerationException {
        DataSelection dataSelection = dsProcessor.getDataSelection();
        ArrayList<String> measureIds = new ArrayList<String>();
        for (DataItem dataItem : measureItems) {
            FunctionNameID funcNameId;
            String rsid = dataItem.getResultSetID();
            Function aggType = dataItem.getAggregationType();
            boolean isFoT = FractionOfTotalUtilImpl.isFractionOfTotalItem(dataItem);
            if (isFoT) {
                Role numeratorRole = FractionOfTotalUtilImpl.getNumeratorRoleInQuery(dataSelection, dataItem);
                if (numeratorRole == null) {
                    DataItem numeratorItem = FractionOfTotalUtilImpl.getFractionOfTotalNumerator(dataItem);
                    boolean isNeeded = dsProcessor.isNeededForPostProcess(dataSelection, numeratorItem, numeratorRole);
                    if (isNeeded) {
                        String numRsid;
                        aggType = numeratorItem.getAggregationType();
                        rsid = numRsid = FractionOfTotalStep.getFractionOfTotalNumeratorId(rsid, dsProcessor, dataSelection, dataItem);
                    }
                } else {
                    aggType = null;
                }
            }
            boolean isVisualTotal = false;
            if (aggType != null && (funcNameId = aggType.getFunctionNameID()) != null && funcNameId.equals(FunctionNameID.INTERNAL_AGGREGATION_ADDITIVE)) {
                isVisualTotal = true;
            }
            if (isVisualTotal) {
                if (measureIds.contains(rsid)) continue;
                measureIds.add(rsid);
                if (reasons == null) continue;
                reasons.append("\n *    calculating ").append(rsid).append(" : Item is a visual total.");
                continue;
            }
            if (reasons == null) continue;
            reasons.append("\n *    ignoring ").append(rsid).append(" : Item is not a visual total.");
        }
        return measureIds;
    }

    private static boolean hasEmbeddedTotals(RolapDataSelectionProcessor dsProcessor) throws GenerationException {
        ROLAPFilterAndRankExaminer leafFilterExaminer;
        Map<String, Map<ExpressionInterface, String>> dataItemLeavesMap;
        ROLAPBuilderInformation leafRolapInfo;
        DataSelection leafDataItemsDS = dsProcessor.getLeafDataItemsDataSelection();
        boolean hasEmbeddedTotalsToUpdate = !ProcSummaryROLAPStatement.useNWay(leafDataItemsDS, leafRolapInfo = new ROLAPBuilderInformation(leafDataItemsDS, dataItemLeavesMap = dsProcessor.getDataItemLeavesMap()), leafFilterExaminer = new ROLAPFilterAndRankExaminer(leafDataItemsDS));
        return hasEmbeddedTotalsToUpdate;
    }
}

