/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap;

import com.sas.iquery.builder.DisabledTotalsBuilder;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.RootDataItem;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.TotalingType;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.DataItemRankFilter;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.iqtextparser.FormatterFactory;
import com.sas.iquery.metadata.expr.iqtextparser.ParsedNode;
import com.sas.iquery.metadata.expr.iqtextparser.ParsedNodeUtil;
import com.sas.iquery.metadata.expr.iqtextparser.ParserUtil;
import com.sas.iquery.metadata.impl.ObjectUtilities;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.strategies.sas.oma.CloneDataSelectionFactory;
import com.sas.iquery.strategies.sas.oma.ExpandedProcSummaryStatement;
import com.sas.iquery.strategies.sas.oma.FractionOfTotalUtilImpl;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.join.JoinGenerationInterface;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.FractionOfGrandTotalStep;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RolapDataSelectionProcessor
extends DataSelectionProcessorAbstract {
    private static final String OPTIMIZE_ROLAP_LEAVES = "SASQueryServices.OptimizeRolapLeaves";
    private static final String OPTIMIZE_ROLAP_LEAVES_DEFAULT = "true";
    private static final Logger _logger = LogManager.getLogger(RolapDataSelectionProcessor.class);
    private DataSelection _leafDataItemsDataSelection;
    private Map<String, Map<ExpressionInterface, String>> _aliasMap = new LinkedHashMap<String, Map<ExpressionInterface, String>>();
    private JoinGenerationInterface _joinGenerator;
    int _indent = 0;

    private boolean isOptimizeRolapLeavesEnabled() {
        boolean enabled = Boolean.valueOf(System.getProperty(OPTIMIZE_ROLAP_LEAVES, OPTIMIZE_ROLAP_LEAVES_DEFAULT));
        return enabled;
    }

    public RolapDataSelectionProcessor(DataSelection dataSelection) {
        super(dataSelection);
    }

    @Override
    public void populate() throws GenerationException {
        super.populate();
        this.populateLeafDataItemsDataSelection(this._dataSelection);
    }

    public DataSelection populateLeafDataItemsDataSelection(DataSelection dataSelection) throws GenerationException {
        DataSelection leafDS = this.populateClonedDataSelection(dataSelection);
        try {
            leafDS.setID(dataSelection.getID() + "_LEAFDS");
            Map<String, Map<ExpressionInterface, String>> aliasMap = this.mapDataItemLeaves(leafDS, dataSelection);
            this.setDataItemLeavesMap(aliasMap);
        }
        catch (MetadataException e1) {
            throw new GenerationException(e1);
        }
        this.setLeafDataItemsDataSelection(leafDS);
        return leafDS;
    }

    @Override
    public Collection<DataSelection> populateMultipleDataSelections(DataSelection dataSelection) {
        return new ArrayList<DataSelection>();
    }

    public Map<String, Map<ExpressionInterface, String>> mapDataItemLeaves(DataSelection leafDS, DataSelection dataSelection) throws MetadataException, GenerationException {
        int newRaseLeafCounter = 0;
        LinkedHashMap<String, Map<ExpressionInterface, String>> dataSelectionAliasMaps = new LinkedHashMap<String, Map<ExpressionInterface, String>>();
        ArrayList<DataItem> keepItems = new ArrayList<DataItem>();
        ArrayList<DataItem> dropItems = new ArrayList<DataItem>();
        List<SelectedItem> selectedLeafItems = leafDS.getSelectedItems();
        for (SelectedItem selectedItem : selectedLeafItems) {
            DataItem leafDsResultItem = selectedItem.getItem();
            Role role = leafDS.getResultItemRole(leafDsResultItem);
            if (role == null) {
                role = Role.BACKGROUND;
            }
            String resultSetID = leafDsResultItem.getResultSetID();
            newRaseLeafCounter = this.extractDataItemLeaves(role, resultSetID, newRaseLeafCounter, leafDS, leafDsResultItem, dataSelection, dataSelectionAliasMaps, keepItems, dropItems);
        }
        leafDS.removeResultItems(dropItems);
        if (_logger.isDebugEnabled()) {
            _logger.debug("\nFinal selected items for LeafDS: " + leafDS);
            List<SelectedItem> selectedFinalLeafItems = leafDS.getSelectedItems();
            for (SelectedItem si : selectedFinalLeafItems) {
                _logger.debug(this.toString(si));
            }
            _logger.debug("\nFinal selected items for DataSelection: " + dataSelection);
            List<SelectedItem> list = dataSelection.getSelectedItems();
            for (SelectedItem si : list) {
                _logger.debug(this.toString(si));
                DataItem item = si.getItem();
                Role role = si.getRole();
                String rsid = item.getResultSetID();
                if (dataSelectionAliasMaps.containsKey(rsid)) {
                    Map aliasMap = (Map)dataSelectionAliasMaps.get(rsid);
                    if (aliasMap != null) {
                        _logger.debug("        write expression using aliases to read from leaves:");
                        Set keySet = aliasMap.keySet();
                        for (ExpressionInterface key : keySet) {
                            String value = (String)aliasMap.get(key);
                            _logger.debug("          read: " + key + " (" + key.getClass().getSimpleName() + ") data from [" + value + "]");
                        }
                        continue;
                    }
                    _logger.debug("        do not use aliases for this item.");
                    continue;
                }
                if (Role.isInactiveRole(dataSelection, role)) continue;
                _logger.debug("        fully write expression.");
            }
        }
        return dataSelectionAliasMaps;
    }

    private int extractDataItemLeaves(Role role, String resultSetID, int newRaseLeafCounter, DataSelection leafDS, DataItem leafDsResultItem, DataSelection originalDS, Map<String, Map<ExpressionInterface, String>> originalDsAliasMaps, List<DataItem> keepItems, List<DataItem> dropItems) throws GenerationException, MetadataException, InvalidIDException {
        boolean isDebug = _logger.isDebugEnabled();
        if (isDebug) {
            _logger.debug(this.indent() + "\nextractDataItemLeaves() Processing: " + resultSetID + ", role=" + role);
        }
        Map<ExpressionInterface, String> originalDsResultItemAliases = this.newItemAliasMap(originalDsAliasMaps, resultSetID);
        Collection<DataItem> leafDsResultItemLeaves = RolapDataSelectionProcessor.extractDataItemLeaves(leafDsResultItem);
        DataItem originalDsResultItem = this.getItemFromOriginalDS(originalDS, leafDS, leafDsResultItem);
        boolean hasLeaves = !leafDsResultItemLeaves.isEmpty();
        boolean hasEmbeddedAggrs = false;
        if (isDebug) {
            _logger.debug(this.indent() + " Leaves:");
            for (DataItem item : leafDsResultItemLeaves) {
                String string = GenerationUtil.toString(item);
                _logger.debug(this.indent() + "  " + string);
            }
        }
        if (hasLeaves) {
            for (DataItem leafDsResultItemLeaf : leafDsResultItemLeaves) {
                int numberFound;
                DataItem originalDsResultItemLeaf = this.getItemFromOriginalDS(originalDS, leafDS, leafDsResultItemLeaf);
                if (isDebug) {
                    _logger.debug(this.indent() + " Refactor Leaf: " + GenerationUtil.toString(leafDsResultItemLeaf));
                }
                boolean leafHadEmbeddedAggrs = (numberFound = this.refactorItem(role, resultSetID, newRaseLeafCounter, false, leafDS, leafDsResultItem, leafDsResultItemLeaf, leafDsResultItemLeaves, originalDS, originalDsResultItem, originalDsResultItemLeaf, originalDsResultItemAliases, originalDsAliasMaps, keepItems)) > 0;
                newRaseLeafCounter += numberFound;
                if (leafHadEmbeddedAggrs) {
                    hasEmbeddedAggrs = true;
                    continue;
                }
                String currentReplacement = originalDsResultItemAliases.get(originalDsResultItemLeaf);
                boolean createLeaf = this.isMeasure(originalDS, originalDsResultItemLeaf) && currentReplacement == null;
                if (!createLeaf) continue;
                String replacementText = this.reuseTextForLeafRef(role, leafDS, leafDsResultItem, leafDsResultItemLeaf, originalDS, originalDsResultItem, originalDsAliasMaps, keepItems);
                if (replacementText == null) {
                    DataItem extraResultItem = this.createReplacementLeafRef("LEAF_", role, leafDS, leafDsResultItem, leafDsResultItemLeaf);
                    keepItems.add(extraResultItem);
                    String replacementRsid = extraResultItem.getResultSetID();
                    replacementText = this.generateColumnIdentifier(replacementRsid);
                }
                originalDsResultItemAliases.put(originalDsResultItemLeaf, replacementText);
            }
        }
        if (!leafDsResultItemLeaves.contains(leafDsResultItem)) {
            int numberFound;
            boolean mainHadEmbeddedAggrs;
            if (_logger.isDebugEnabled()) {
                _logger.debug(this.indent() + " Refactor Main: " + GenerationUtil.toString(leafDsResultItem));
                _logger.debug(this.indent() + "   leaves (" + leafDsResultItemLeaves.size() + ") = " + leafDsResultItemLeaves);
            }
            boolean bl = mainHadEmbeddedAggrs = (numberFound = this.refactorItem(role, resultSetID, newRaseLeafCounter, true, leafDS, leafDsResultItem, leafDsResultItem, leafDsResultItemLeaves, originalDS, originalDsResultItem, originalDsResultItem, originalDsResultItemAliases, originalDsAliasMaps, keepItems)) > 0;
            if (mainHadEmbeddedAggrs) {
                hasEmbeddedAggrs = true;
            }
            newRaseLeafCounter += numberFound;
        } else if (_logger.isDebugEnabled()) {
            _logger.debug(this.indent() + " *** Main had itself as a leaf");
        }
        if (hasLeaves || hasEmbeddedAggrs) {
            dropItems.add(leafDsResultItem);
        } else {
            boolean isMeasure;
            List<QualifiedColumn> qcs;
            boolean isFotTotalItem;
            if (ObjectUtilities.isAggregationDefinedInExpression(leafDsResultItem) && !(isFotTotalItem = FractionOfTotalUtilImpl.isFractionOfTotalItem(leafDsResultItem)) && !(qcs = leafDsResultItem.getResources(QualifiedColumn.class, 65535)).isEmpty() && (isMeasure = this.isMeasure(originalDS, originalDsResultItem))) {
                _logger.debug("The measure '" + leafDsResultItem.getLabel() + "' (" + leafDsResultItem.getResultSetID() + ") uses columns that are not aggregations or grouped in the query. The expression '" + StringExpressionUtil.getInstance().getReadableText(leafDsResultItem.getExpression()) + "' uses columns " + new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_LONG, qcs.toArray()));
            }
            keepItems.add(leafDsResultItem);
        }
        return newRaseLeafCounter;
    }

    public static Collection<DataItem> extractDataItemLeaves(DataItem item) throws GenerationException {
        ArrayList<DataItem> rolapDataItemLeaves = new ArrayList<DataItem>();
        List<DataItem> leafDataItems = item.getLeafDataItems();
        if (item.getUsage().equals(DataItemActionType.USAGE_AGGREGATE) && leafDataItems.size() > 0 && RolapDataSelectionProcessor.isPostAggregationCalculated(item)) {
            Utils.addButNoDuplicates(rolapDataItemLeaves, leafDataItems);
        }
        return rolapDataItemLeaves;
    }

    private DataItem createReplacementLeafRef(String prefix, Role role, DataSelection leafDS, DataItem leafDsResultItem, DataItem leafDsResultItemLeaf) throws MetadataException {
        DataItemReference leafDsResultItemLeafRef = leafDS.newDataItemReference(leafDsResultItemLeaf);
        String dirRsid = prefix + leafDsResultItemLeafRef.getResultSetID();
        leafDsResultItemLeafRef.setIntraModelID(dirRsid);
        leafDsResultItemLeafRef.setResultSetID(dirRsid);
        this.transferAttributes(leafDS, leafDsResultItem, leafDsResultItemLeafRef);
        this.transferDisabledTotals(leafDS, leafDsResultItem, leafDsResultItemLeafRef);
        leafDS.addBusinessItem(leafDsResultItemLeafRef);
        leafDS.addResultItem(leafDsResultItemLeafRef, role);
        leafDsResultItemLeafRef.setUsage(DataItemActionType.USAGE_AGGREGATE);
        return leafDsResultItemLeafRef;
    }

    private void transferAttributes(DataSelection ds, DataItem from, DataItem to) throws MetadataException {
        DataItemActionType sortDirection;
        List<String[]> sortCriterias;
        List<StepInterface> oldSteps = from.getSteps();
        if (oldSteps != null) {
            to.setSteps(oldSteps);
        }
        if ((sortCriterias = from.getSortCriteria()) != null && sortCriterias.size() > 0) {
            to.setSortCriteria(sortCriterias);
        }
        if ((sortDirection = from.getSortDirection()) != null) {
            to.setSortDirection(sortDirection);
        }
    }

    private int refactorItem(Role role, String resultSetID, int counterStartNum, boolean isTopItem, DataSelection leafDS, DataItem leafDsResultItem, DataItem leafDsResultItemLeaf, Collection<DataItem> leafDsResultItemLeaves, DataSelection originalDS, DataItem originalDsResultItem, DataItem originalDsResultItemLeaf, Map<ExpressionInterface, String> originalDsResultItemAliases, Map<String, Map<ExpressionInterface, String>> originalDsAliasMaps, List<DataItem> keepItems) throws MetadataException, GenerationException, InvalidIDException {
        boolean isLeaf;
        ++this._indent;
        boolean bl = isLeaf = !leafDsResultItemLeaf.getResultSetID().equals(resultSetID);
        if (isLeaf == isTopItem && _logger.isDebugEnabled()) {
            _logger.debug("*** Selected item RSID='" + resultSetID + "', processing data item with RSID='" + leafDsResultItemLeaf.getResultSetID() + "', isTopItem=" + isTopItem + ", isLeaf=" + isLeaf);
        }
        int numberFound = 0;
        if (ObjectUtilities.isAggregationDefinedInExpression(leafDsResultItemLeaf)) {
            boolean isFotTotalItem = FractionOfTotalUtilImpl.isFractionOfTotalItem(originalDsResultItemLeaf);
            if (!isFotTotalItem) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug(this.indent() + " agg in expression (and not Fot)");
                }
                String dataItemRSID = leafDsResultItemLeaf.getResultSetID();
                if (_logger.isDebugEnabled()) {
                    _logger.debug(this.indent() + " parse " + dataItemRSID + " as " + (isLeaf ? "leaf" : "top"));
                }
                ExpressionInterface originalDSItemExpr = originalDsResultItemLeaf.getExpression();
                Map<ExpressionInterface, String> originalDsLeafItemAliases = null;
                if (isLeaf) {
                    originalDsLeafItemAliases = this.newItemAliasMap(originalDsAliasMaps, dataItemRSID);
                }
                if (_logger.isDebugEnabled()) {
                    _logger.debug(this.indent() + " originalDsLeafItemAliases=" + originalDsLeafItemAliases);
                    _logger.debug(this.indent() + " originalDsResultItemAliases=" + originalDsResultItemAliases);
                }
                String originalExprText = StringExpressionUtil.getInstance().getText(originalDSItemExpr, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, originalDS);
                if (_logger.isDebugEnabled()) {
                    _logger.debug(this.indent() + GenerationUtil.toString(originalDsResultItemLeaf));
                    _logger.debug(this.indent() + "  expression: " + originalExprText);
                }
                LinkedHashMap<ParsedNode, ParsedNode> pnAggFunctions = new LinkedHashMap<ParsedNode, ParsedNode>();
                ParsedNode pnAggrTree = null;
                try {
                    ParsedNode node = ParserUtil.parsePredicate(originalExprText, false, true, false, false);
                    if (_logger.isDebugEnabled()) {
                        _logger.debug(this.indent() + "  start: " + node);
                    }
                    node = this.refactorNode(node, leafDsResultItemLeaves, originalDS, originalDsResultItemAliases);
                    if (_logger.isDebugEnabled()) {
                        _logger.debug(this.indent() + "  refactored: " + node);
                    }
                    String leafNameStem = "_AGGR_";
                    pnAggrTree = ParserUtil.refactorAggParents(node, leafNameStem + "{0}", counterStartNum, pnAggFunctions);
                    if (_logger.isDebugEnabled()) {
                        _logger.debug(this.indent() + " end = " + pnAggrTree);
                    }
                    if (pnAggFunctions.size() > 0) {
                        ++this._indent;
                        Set keySet = pnAggFunctions.keySet();
                        Iterator iterator = keySet.iterator();
                        while (iterator.hasNext()) {
                            ParsedNode parsedNode;
                            ParsedNode pnMarker = parsedNode = (ParsedNode)iterator.next();
                            ParsedNode pnPlaceholder = (ParsedNode)pnAggFunctions.get(pnMarker);
                            String nodeName = (String)pnMarker.getKeywords()[0];
                            ExpressionInterface funcExpr = ParserUtil.newExpressionInterface(pnMarker, leafDS, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE);
                            if (funcExpr instanceof FunctionCall) {
                                List<ExpressionInterface> arguments;
                                ExpressionInterface expression;
                                Function aggregationType = ((FunctionCall)funcExpr).getFunction();
                                String replaceWithText = this.reuseTextForExpr(DataItemActionType.USAGE_AGGREGATE, aggregationType, expression = (arguments = ((FunctionCall)funcExpr).getArguments()).get(0), leafDS, leafDsResultItem, originalDS, originalDsResultItem, originalDsAliasMaps, keepItems);
                                if (replaceWithText != null) {
                                    pnMarker.getKeywords()[0] = replaceWithText;
                                    pnPlaceholder.getKeywords()[0] = replaceWithText;
                                    continue;
                                }
                                String dirRsid = resultSetID + nodeName;
                                String testIdentifier = this.generateColumnIdentifier(dirRsid);
                                if (testIdentifier.compareTo(dirRsid) != 0) {
                                    dirRsid = "LEAF" + nodeName;
                                }
                                DataItem aggLeafRef = this.createReplacementAggrRef("DI" + nodeName, dirRsid, role, leafDS, leafDsResultItem, leafDsResultItemLeaf, aggregationType, expression);
                                String aggLeafRefRsid = aggLeafRef.getResultSetID();
                                pnMarker.getKeywords()[0] = aggLeafRefRsid;
                                pnPlaceholder.getKeywords()[0] = aggLeafRefRsid;
                                originalDsResultItemAliases.put(aggLeafRef, null);
                                keepItems.add(aggLeafRef);
                                continue;
                            }
                            if (funcExpr != null) {
                                throw new GenerationException(RolapDataSelectionProcessor.getMessageFormatter("RolapDataSelectionProcessor.refactorFoundInvalidFunction.fmt.txt", new Object[]{funcExpr}));
                            }
                            throw new GenerationException(RolapDataSelectionProcessor.getMessageFormatter("RolapDataSelectionProcessor.refactorNoValidFunction.fmt.txt", new Object[]{FormatterFactory.newRetextualizer().format(pnMarker, "", "", false)}));
                        }
                        --this._indent;
                        String aggrTreeText = pnAggrTree.toString();
                        if (isLeaf) {
                            originalDsLeafItemAliases.put(originalDSItemExpr, aggrTreeText);
                            originalDsResultItemAliases.put(originalDsResultItemLeaf, aggrTreeText);
                        } else {
                            originalDsResultItemAliases.put(originalDSItemExpr, aggrTreeText);
                        }
                    } else if (isLeaf) {
                        originalDsLeafItemAliases.put(originalDSItemExpr, null);
                    }
                }
                catch (Exception e) {
                    throw new GenerationException(e);
                }
                numberFound = pnAggFunctions.size();
            }
        } else if (_logger.isDebugEnabled()) {
            _logger.debug(this.indent() + " no agg in expression");
        }
        --this._indent;
        return numberFound;
    }

    private ParsedNode refactorNode(ParsedNode node, Collection<DataItem> leafDsResultItemLeaves, DataSelection originalDS, Map<ExpressionInterface, String> originalDsResultItemAliases) throws CloneNotSupportedException, MetadataException, GenerationException {
        ++this._indent;
        ParsedNode clone = (ParsedNode)node.clone();
        Map<ParsedNode, ParsedNode> resourceRefs = ParsedNodeUtil.getResourceReferences(clone);
        if (_logger.isDebugEnabled()) {
            _logger.debug(this.indent() + " resource refs: " + resourceRefs);
        }
        if (resourceRefs.size() > 0) {
            Set<Map.Entry<ParsedNode, ParsedNode>> entrySet = resourceRefs.entrySet();
            block0: for (Map.Entry<ParsedNode, ParsedNode> entry : entrySet) {
                DataItem originalDsResultItemLeaf;
                boolean isFotTotalItem;
                ParsedNode resNode = entry.getKey();
                ParsedNode resParent = entry.getValue();
                if (_logger.isDebugEnabled()) {
                    _logger.debug(this.indent() + " node: " + resNode + ", parent: " + resParent);
                }
                ExpressionInterface expr = ParserUtil.newExpressionInterface(resNode, originalDS, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE);
                if (_logger.isDebugEnabled()) {
                    _logger.debug(this.indent() + " expr: " + expr + " (" + expr.getClass().getSimpleName() + ")");
                }
                if (!(expr instanceof DataItem)) continue;
                if (_logger.isDebugEnabled()) {
                    _logger.debug(this.indent() + "       " + GenerationUtil.toString((DataItem)expr));
                }
                if (isFotTotalItem = FractionOfTotalUtilImpl.isFractionOfTotalItem(originalDsResultItemLeaf = (DataItem)expr)) continue;
                if (resParent == null) {
                    clone = this.replace(clone, -1, leafDsResultItemLeaves, originalDS, originalDsResultItemLeaf, originalDsResultItemAliases);
                    continue;
                }
                ParsedNode[] siblings = resParent.getChildren();
                if (siblings == null) continue;
                for (int i = 0; i < siblings.length; ++i) {
                    ParsedNode sibling = siblings[i];
                    if (sibling != resNode) continue;
                    siblings[i] = this.replace(sibling, i, leafDsResultItemLeaves, originalDS, originalDsResultItemLeaf, originalDsResultItemAliases);
                    continue block0;
                }
            }
        }
        --this._indent;
        return clone;
    }

    private ParsedNode replace(ParsedNode node, int i, Collection<DataItem> leafDsResultItemLeaves, DataSelection originalDS, DataItem originalDsResultItemLeaf, Map<ExpressionInterface, String> originalDsResultItemAliases) throws InvalidIDException, MetadataException, GenerationException, CloneNotSupportedException {
        ++this._indent;
        ParsedNode replaceChild = null;
        String replaceWith = originalDsResultItemAliases.get(originalDsResultItemLeaf);
        if (_logger.isDebugEnabled()) {
            _logger.debug(this.indent() + " replace with found = [" + replaceWith + "]");
        }
        if (replaceWith != null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug(this.indent() + " --- use existing entry in originalDsResultItemAliases ---");
                _logger.debug(this.indent() + " for [" + (i == -1 ? "top:" : "sib:" + i + ":") + node + "]");
                _logger.debug(this.indent() + " matched originalDsResultItemAliases key: " + originalDsResultItemLeaf.getIdentityString() + ", rsid=" + originalDsResultItemLeaf.getResultSetID() + ", isCalculated=" + originalDsResultItemLeaf.isCalculatedItem());
            }
            String text = "(" + replaceWith + ")";
            if (_logger.isDebugEnabled()) {
                _logger.debug(this.indent() + " replace with text: " + replaceWith);
            }
            replaceChild = ParserUtil.createPlaceHolderAndMarker(node, text, 0, null);
        }
        if (replaceChild == null) {
            boolean usePutInReference;
            boolean isAggr;
            if (_logger.isDebugEnabled()) {
                _logger.debug(this.indent() + " --- create new entry for item ---");
            }
            ExpressionInterface newExpression = originalDsResultItemLeaf.getExpression();
            String text = StringExpressionUtil.getInstance().getText(newExpression, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, originalDS);
            boolean bl = isAggr = originalDsResultItemLeaf.getUsage() == DataItemActionType.USAGE_AGGREGATE;
            if (isAggr) {
                text = GenerationUtil.generateAnalysisFunction(originalDsResultItemLeaf, text);
            }
            if (usePutInReference = GenerationUtil.useFormattedValueForReference(originalDsResultItemLeaf)) {
                boolean useFormat;
                String format = GenerationUtil.generateFormat(originalDsResultItemLeaf);
                boolean bl2 = useFormat = format != null && format.trim().length() > 0;
                if (useFormat) {
                    text = GenerationUtil.generatePut(null, text, format, false, false);
                }
            } else {
                Function aggr = originalDsResultItemLeaf.getAggregationType();
                if (!isAggr || aggr == null || aggr.getFunctionNameID() == FunctionNameID.INTERNAL_AGGREGATION || aggr.getFunctionNameID() == FunctionNameID.INTERNAL_AGGREGATION_ADDITIVE) {
                    text = "(" + text + ")";
                }
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug(this.indent() + " " + GenerationUtil.toString(originalDsResultItemLeaf));
                _logger.debug(this.indent() + "  expression: " + text);
            }
            ParsedNode newNode = ParserUtil.parsePredicate(text, false, true, false, false);
            if (_logger.isDebugEnabled()) {
                _logger.debug(this.indent() + "  start: " + newNode);
            }
            newNode = this.refactorNode(newNode, leafDsResultItemLeaves, originalDS, originalDsResultItemAliases);
            if (_logger.isDebugEnabled()) {
                _logger.debug(this.indent() + "  refactored: " + newNode);
            }
            replaceChild = newNode;
        }
        --this._indent;
        return replaceChild;
    }

    String indent() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._indent; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }

    private DataItem getItemFromOriginalDS(DataSelection originalDS, DataSelection leafDS, DataItem dataItem) throws InvalidIDException, MetadataException {
        String leafId = dataItem.getID();
        if (dataItem.getBusinessModel() == leafDS) {
            leafId = originalDS.getID() + "." + dataItem.getIntraModelID();
        }
        DataItem originalDSItem = (DataItem)originalDS.getBusinessItemByID(leafId);
        return originalDSItem;
    }

    public DataItem getItemFromOriginalDS(DataSelection originalDS, DataItem dataItem) throws InvalidIDException, MetadataException {
        return this.getItemFromOriginalDS(originalDS, this._leafDataItemsDataSelection, dataItem);
    }

    public void setJoinGenerator(JoinGenerationInterface joinGenerator) {
        this._joinGenerator = joinGenerator;
    }

    public JoinGenerationInterface getJoinGenerator() {
        if (this._joinGenerator == null) {
            throw new IllegalStateException("Probably shouldn't be asked to return a join generator before one has been set.The join generator should probably be set after generating a FROM clause.");
        }
        return this._joinGenerator;
    }

    public static boolean isPostAggregationCalculated(DataItem measure) {
        boolean result = false;
        boolean isCalculatedItem = measure.isCalculatedItem();
        if (isCalculatedItem) {
            boolean aggDefinedInExpression = ObjectUtilities.isAggregationDefinedInExpression(measure);
            if (aggDefinedInExpression) {
                result = true;
            } else {
                boolean hasLeafDataItems;
                boolean bl = hasLeafDataItems = !measure.getLeafDataItems().equals(Collections.singletonList(measure));
                if (hasLeafDataItems) {
                    result = true;
                }
            }
        }
        return result;
    }

    public boolean isUsedByRankResultItem(DataItem itemToCheck) {
        boolean returnBool = false;
        List<SelectedItem> selectedItems = this._dataSelection.getSelectedItems();
        Iterator<SelectedItem> selectedIt = selectedItems.iterator();
        while (selectedIt.hasNext() && !returnBool) {
            SelectedItem selectedItem = selectedIt.next();
            DataItem item = selectedItem.getItem();
            List<StepInterface> steps = item.getSteps();
            Iterator<StepInterface> iter = steps.iterator();
            while (iter.hasNext() && !returnBool) {
                StepInterface element = iter.next();
                if (!(element instanceof DataItemRankFilter)) continue;
                DataItemRankFilter rankFilter = (DataItemRankFilter)element;
                returnBool = rankFilter.getRankQualifiers().contains(itemToCheck);
            }
        }
        return returnBool;
    }

    protected void setLeafDataItemsDataSelection(DataSelection leafDataItemsDataSelection) {
        this._leafDataItemsDataSelection = leafDataItemsDataSelection;
    }

    public DataSelection getLeafDataItemsDataSelection() {
        return this._leafDataItemsDataSelection;
    }

    protected void setDataItemLeavesMap(Map<String, Map<ExpressionInterface, String>> aliasMap) {
        this._aliasMap = aliasMap;
    }

    public Map<String, Map<ExpressionInterface, String>> getDataItemLeavesMap() {
        return this._aliasMap;
    }

    @Override
    public void dispose() {
        if (this._leafDataItemsDataSelection != null) {
            CloneDataSelectionFactory.removeOldClonesOfRelational(this._leafDataItemsDataSelection);
            this._leafDataItemsDataSelection = null;
        }
        super.dispose();
    }

    @Override
    public boolean isNeededForPostProcess(DataSelection dataSelection, DataItem item, Role role) throws GenerationException {
        boolean isFotTotalItem = FractionOfTotalUtilImpl.isFractionOfTotalItem(item);
        if (isFotTotalItem) {
            boolean isInactiveItem;
            DataItem numeratorItem = FractionOfTotalUtilImpl.getFractionOfTotalNumerator(item);
            Role numeratorRole = FractionOfTotalUtilImpl.getNumeratorRoleInQuery(dataSelection, item);
            if (numeratorRole != null) {
                boolean useNumeratorItemInstead = FractionOfGrandTotalStep.useNumeratorAliasForInputVar(this, dataSelection, item, numeratorItem);
                if (useNumeratorItemInstead) {
                    return false;
                }
            } else {
                Map<String, Map<ExpressionInterface, String>> dsLeavesMap = this.getDataItemLeavesMap();
                DataItem originalNumeratorItem = null;
                try {
                    originalNumeratorItem = this.getItemFromOriginalDS(this._dataSelection, this._leafDataItemsDataSelection, numeratorItem);
                }
                catch (MetadataException e) {
                    if (_logger.isEnabled(Level.WARN)) {
                        _logger.warn(e.getLocalizedMessage(), (Throwable)e);
                    }
                    return false;
                }
                String resultSetID = originalNumeratorItem.getResultSetID();
                Map<ExpressionInterface, String> aliases = dsLeavesMap.get(resultSetID);
                if (aliases != null && aliases.size() > 0) {
                    return false;
                }
            }
            boolean bl = isInactiveItem = role == Role.BACKGROUND || Role.isInactiveRole(this._dataSelection, role);
            if (isInactiveItem) {
                return false;
            }
        }
        return true;
    }

    private boolean isMeasure(DataSelection dataSelection, DataItem originalItem) throws MetadataException {
        Role role;
        boolean isMeasure = false;
        if (originalItem.getUsage() == DataItemActionType.USAGE_AGGREGATE) {
            isMeasure = true;
            List<DataItem> resources = originalItem.getResources(DataItem.class, 65535);
            Iterator<DataItem> iterator = resources.iterator();
            while (isMeasure && iterator.hasNext()) {
                DataItem resource = iterator.next();
                isMeasure = this.isMeasure(dataSelection, resource);
            }
        } else if (originalItem.getUsage() == DataItemActionType.USAGE_CATEGORY && ((role = dataSelection.getResultItemRole(originalItem)) == null || Role.isInactiveRole(dataSelection, role))) {
            isMeasure = !this.isGroupByCategory(dataSelection, originalItem);
        }
        return isMeasure;
    }

    private boolean isGroupByCategory(DataSelection dataSelection, DataItem originalDSLeafItem) throws MetadataException {
        String originalExprText = StringExpressionUtil.getInstance().getText(originalDSLeafItem.getExpression(), ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, dataSelection);
        ParsedNode origExprNode = ParserUtil.parsePredicate(originalExprText, false, true, false, false);
        String origReText = origExprNode.toString();
        List<SelectedItem> selectedItems = dataSelection.getSelectedItems();
        for (SelectedItem selectedItem : selectedItems) {
            DataItem dataItem = selectedItem.getItem();
            Role role = selectedItem.getRole();
            if (role == null || Role.isInactiveRole(dataSelection, role) || dataItem.getUsage() != DataItemActionType.USAGE_CATEGORY) continue;
            String selectedItemText = StringExpressionUtil.getInstance().getText(dataItem.getExpression(), ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, dataSelection);
            ParsedNode selectedExprNode = ParserUtil.parsePredicate(selectedItemText, false, true, false, false);
            String selectedReText = selectedExprNode.toString();
            if (origReText.trim().compareTo(selectedReText.trim()) != 0) continue;
            return true;
        }
        return false;
    }

    private String reuseTextForLeafRef(Role role, DataSelection leafDS, DataItem leafDsResultItem, DataItem leafDsResultItemLeaf, DataSelection originalDS, DataItem originalDsResultItem, Map<String, Map<ExpressionInterface, String>> originalDsAliasMaps, List<DataItem> keepItems) throws MetadataException, GenerationException {
        boolean enabled = this.isOptimizeRolapLeavesEnabled();
        if (enabled) {
            Map<DataItem, Set<TotalingType>> leafDsDisabledTotals;
            DataItemActionType leafUsage = leafDsResultItemLeaf.getUsage();
            if (leafUsage != DataItemActionType.USAGE_AGGREGATE) {
                return null;
            }
            Map<DataItem, Set<TotalingType>> origDsDisabledTotals = this.getFilteredDisabledTotals(originalDS);
            if (!this.checkOrigItemDisabledTotalsForReuse(origDsDisabledTotals, originalDsResultItem, leafDsDisabledTotals = this.getFilteredDisabledTotals(leafDS), leafDsResultItem)) {
                return null;
            }
            String leafExprText = StringExpressionUtil.getInstance().getText(leafDsResultItemLeaf.getExpression(), ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, leafDS);
            for (DataItem keepItem : keepItems) {
                if (keepItem.getUsage() != DataItemActionType.USAGE_AGGREGATE || leafDsResultItemLeaf.getAggregationType() != keepItem.getAggregationType()) continue;
                ExpressionInterface keepExpression = keepItem.getExpression();
                String itemExprText = StringExpressionUtil.getInstance().getText(keepExpression, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, leafDS);
                if (leafExprText.compareTo(itemExprText) != 0) continue;
                DataItemActionType keepSort = keepItem.getSortDirection();
                DataItemActionType oldSort = leafDsResultItem.getSortDirection();
                if ((oldSort != null || keepSort != null) && (oldSort == null || keepSort == null || !oldSort.equals(keepSort))) continue;
                List<String[]> keepCriteras = keepItem.getSortCriteria();
                List<String[]> oldCriterias = leafDsResultItem.getSortCriteria();
                if ((oldCriterias != null || keepCriteras != null) && (oldCriterias == null || keepCriteras == null || !oldCriterias.equals(keepCriteras))) continue;
                List<StepInterface> keepSteps = keepItem.getSteps();
                List<StepInterface> oldSteps = leafDsResultItem.getSteps();
                if ((oldSteps != null || keepSteps != null) && (oldSteps == null || keepSteps == null || !oldSteps.equals(keepSteps))) continue;
                String keepFormat = ExpandedProcSummaryStatement.getSqlExtractFormat(keepItem);
                String oldFormat = ExpandedProcSummaryStatement.getSqlExtractFormat(leafDsResultItem);
                if ((oldFormat != null || keepFormat != null) && (oldFormat == null || keepFormat == null || !oldFormat.trim().equalsIgnoreCase(keepFormat.trim())) || !this.checkKeepItemDisabledTotalsForReuse(origDsDisabledTotals, originalDsResultItem, leafDsDisabledTotals, keepItem)) continue;
                String text = this.generateColumnIdentifier(keepItem.getResultSetID());
                return text;
            }
        }
        return null;
    }

    private String reuseTextForExpr(DataItemActionType usageAggregate, Function aggregationType, ExpressionInterface expression, DataSelection leafDS, DataItem leafDsResultItem, DataSelection originalDS, DataItem originalDsResultItem, Map<String, Map<ExpressionInterface, String>> originalDsAliasMaps, List<DataItem> keepItems) throws MetadataException, GenerationException {
        boolean enabled = this.isOptimizeRolapLeavesEnabled();
        if (enabled) {
            Map<DataItem, Set<TotalingType>> leafDsDisabledTotals;
            Map<DataItem, Set<TotalingType>> origDsDisabledTotals = this.getFilteredDisabledTotals(originalDS);
            if (!this.checkOrigItemDisabledTotalsForReuse(origDsDisabledTotals, originalDsResultItem, leafDsDisabledTotals = this.getFilteredDisabledTotals(leafDS), leafDsResultItem)) {
                return null;
            }
            String leafExprText = StringExpressionUtil.getInstance().getText(expression, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, leafDS);
            for (DataItem keepItem : keepItems) {
                String itemExprText;
                if (keepItem.getUsage() != DataItemActionType.USAGE_AGGREGATE || aggregationType != keepItem.getAggregationType() || leafExprText.compareTo(itemExprText = StringExpressionUtil.getInstance().getText(keepItem.getExpression(), ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, leafDS)) != 0 || !this.checkKeepItemDisabledTotalsForReuse(origDsDisabledTotals, originalDsResultItem, leafDsDisabledTotals, keepItem)) continue;
                String text = this.generateColumnIdentifier(keepItem.getResultSetID());
                return text;
            }
        }
        return null;
    }

    private boolean checkOrigItemDisabledTotalsForReuse(Map<DataItem, Set<TotalingType>> origDsDisabledTotals, DataItem origDsItem, Map<DataItem, Set<TotalingType>> leafDsDisabledTotals, DataItem leafDsResultItem) throws GenerationException {
        boolean canOptimize = false;
        if (this.canOptimizeUsingDisabledTotals(origDsDisabledTotals, origDsItem) && this.checkDisabledTotalingForReuse(leafDsDisabledTotals, leafDsResultItem, origDsDisabledTotals, origDsItem)) {
            canOptimize = true;
        }
        return canOptimize;
    }

    private boolean checkKeepItemDisabledTotalsForReuse(Map<DataItem, Set<TotalingType>> origDsDisabledTotals, DataItem origDsItem, Map<DataItem, Set<TotalingType>> leafDsDisabledTotals, DataItem leafDsKeepItem) throws GenerationException {
        boolean canOptimize = false;
        if (this.canOptimizeUsingDisabledTotals(leafDsDisabledTotals, leafDsKeepItem) && this.checkDisabledTotalingForReuse(leafDsDisabledTotals, leafDsKeepItem, origDsDisabledTotals, origDsItem)) {
            canOptimize = true;
        }
        return canOptimize;
    }

    private boolean canOptimizeUsingDisabledTotals(Map<DataItem, Set<TotalingType>> origDsDisabledTotals, DataItem originalDsResultItem) throws GenerationException {
        boolean origIsFot;
        Set<TotalingType> origDisabledTotals = origDsDisabledTotals.get(originalDsResultItem);
        boolean origEmpty = origDisabledTotals == null || origDisabledTotals.isEmpty();
        boolean canUse = true;
        if (!origEmpty && (origIsFot = FractionOfTotalUtilImpl.isFractionOfTotalItem(originalDsResultItem))) {
            canUse = false;
        }
        return canUse;
    }

    private boolean checkDisabledTotalingForReuse(Map<DataItem, Set<TotalingType>> leafDsDisabledTotals, DataItem useItem, Map<DataItem, Set<TotalingType>> origDsDisabledTotals, DataItem originalDsResultItem) {
        Set<TotalingType> origDisabledTotals = origDsDisabledTotals.get(originalDsResultItem);
        boolean origEmpty = origDisabledTotals == null || origDisabledTotals.isEmpty();
        Set<TotalingType> useDisabledTotals = leafDsDisabledTotals.get(useItem);
        boolean useEmpty = useDisabledTotals == null || useDisabledTotals.isEmpty();
        boolean canUse2 = false;
        if (origEmpty && useEmpty) {
            canUse2 = true;
        } else {
            boolean totalsMatch = origDisabledTotals.equals(useDisabledTotals);
            if (totalsMatch) {
                canUse2 = true;
            }
        }
        return canUse2;
    }

    private DataItem createReplacementAggrRef(String diRsid, String dirRsid, Role role, DataSelection leafDS, DataItem leafDsResultItem, DataItem leafDsLeafDataItem, Function aggregationType, ExpressionInterface expression) throws MetadataException, InvalidIDException {
        RootDataItem leafDsResultItemAggrLeaf = leafDS.newDataItem();
        leafDsResultItemAggrLeaf.setIntraModelID(diRsid);
        leafDsResultItemAggrLeaf.setResultSetID(diRsid);
        leafDsResultItemAggrLeaf.setLabel(null);
        leafDsResultItemAggrLeaf.setExpression(expression);
        leafDsResultItemAggrLeaf.setUsage(DataItemActionType.USAGE_AGGREGATE);
        leafDsResultItemAggrLeaf.setAggregationTypeSupported(aggregationType, true);
        leafDsResultItemAggrLeaf.setAggregationType(aggregationType);
        leafDS.addBusinessItem(leafDsResultItemAggrLeaf);
        DataItemReference leafDsResultItemAggrRef = leafDS.newDataItemReference(leafDsResultItemAggrLeaf);
        leafDsResultItemAggrRef.setIntraModelID(dirRsid);
        leafDsResultItemAggrRef.setResultSetID(dirRsid);
        leafDS.addBusinessItem(leafDsResultItemAggrRef);
        leafDS.addResultItem(leafDsResultItemAggrRef, role);
        this.transferAttributes(leafDS, leafDsLeafDataItem, leafDsResultItemAggrRef);
        this.transferDisabledTotals(leafDS, leafDsResultItem, leafDsResultItemAggrRef);
        return leafDsResultItemAggrRef;
    }

    private void transferDisabledTotals(DataSelection ds, DataItem from, DataItem to) throws MetadataException {
        Map<DataItem, Set<TotalingType>> fromDsDisabledTotals = DisabledTotalsBuilder.getDisabledTotalingByItem(ds, true);
        Set<TotalingType> fromItemDisabledTotals = fromDsDisabledTotals.get(from);
        if (fromItemDisabledTotals != null) {
            DisabledTotalsBuilder.clearTotaling(ds, null, to);
            for (TotalingType totalingType : fromItemDisabledTotals) {
                DisabledTotalsBuilder.disableTotaling(ds, totalingType, to);
            }
        }
    }

    private Map<DataItem, Set<TotalingType>> getFilteredDisabledTotals(DataSelection ds) {
        Map<DataItem, Set<TotalingType>> origDsDisabledTotals = DisabledTotalsBuilder.getDisabledTotalingByItem(ds, true);
        for (Set<TotalingType> dts : origDsDisabledTotals.values()) {
            if (dts == null) continue;
            dts.removeAll(Collections.singleton(TotalingType.TOTAL_NONE));
        }
        return origDsDisabledTotals;
    }

    private Map<ExpressionInterface, String> newItemAliasMap(Map<String, Map<ExpressionInterface, String>> aliasMaps, String resultSetID) {
        Map<ExpressionInterface, String> aliasMap = aliasMaps.get(resultSetID);
        if (aliasMap == null) {
            aliasMap = new LinkedHashMap<ExpressionInterface, String>();
            aliasMaps.put(resultSetID, aliasMap);
        }
        return aliasMap;
    }

    private String toString(SelectedItem si) {
        return "  role=" + si.getRole() + ", " + GenerationUtil.toString(si.getItem());
    }
}

