/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryRankFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemRankFilter;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import com.sas.iquery.strategies.sas.oma.summaryrolap.AggregationSubStep;
import com.sas.iquery.strategies.sas.oma.summaryrolap.AxisTupleCriteria;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPBuilderInformation;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPFilterAndRankExaminer;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPStepGenerationUtil;
import com.sas.iquery.strategies.sas.oma.summaryrolap.RolapDataSelectionProcessor;
import com.sas.iquery.strategies.sas.oma.summaryrolap.VisualTotalSubStep;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class RankingStep {
    private static final boolean allowTsSqlForRankByCountWithoutTies = false;
    private static final boolean allowTsSqlForPercentOfTotalsCalc = false;
    private static final boolean allowTsSqlForRankByPercent = false;
    private static final boolean allowTsSqlForRankFiltering = false;

    public static void addCode(List<SQLComponentAbstract> code, RolapDataSelectionProcessor dsProcessor, String detailTable, String summaryFinalTable, String tempTableStem) throws GenerationException, MetadataException {
        String filteredTable = tempTableStem + "FILTERED";
        String rankingSummaryTable = tempTableStem + "RANKING_SUMMARY";
        String tempRankingSummaryTable = tempTableStem + "RANKING_TMP";
        String rankedSummaryTable = tempTableStem + "RANKED";
        String filteredSummaryTable = tempTableStem + "FILTERED";
        String totalTable = tempTableStem + "TOTAL";
        String vtTempTables = tempTableStem + "rs_vt";
        DataSelection dataSelection = dsProcessor.getDataSelection();
        ROLAPFilterAndRankExaminer filterExaminer = new ROLAPFilterAndRankExaminer(dataSelection);
        ROLAPBuilderInformation rolapInfo = new ROLAPBuilderInformation(dataSelection);
        RankingStep.addSubtotalRankFilter(code, dsProcessor, filterExaminer, rolapInfo, detailTable, filteredTable, rankingSummaryTable, rankedSummaryTable, tempRankingSummaryTable, vtTempTables, totalTable);
        RankingStep.addRowColumnRankFilter(code, dsProcessor, filterExaminer, rolapInfo, detailTable, tempRankingSummaryTable, rankingSummaryTable, rankedSummaryTable, filteredSummaryTable, vtTempTables, totalTable);
    }

    private static void addSubtotalRankFilter(List<SQLComponentAbstract> code, RolapDataSelectionProcessor dsProcessor, ROLAPFilterAndRankExaminer filterExaminer, ROLAPBuilderInformation rolapInfo, String detailTable, String filteredTable, String rankingSummaryTable, String rankedSummaryTable, String tempRankingSummaryTable, String vtTempTables, String totalTable) throws GenerationException, MetadataException {
        DataItemRankFilter subtotalRankFilter = filterExaminer.getSubtotalRankFilter();
        DataItem category = filterExaminer.getSubtotalRankCategory(null);
        if (category != null && subtotalRankFilter != null) {
            boolean ignoreDisabledTotals = true;
            AggregationSubStep.addCode(code, dsProcessor, detailTable, tempRankingSummaryTable, rankingSummaryTable, ignoreDisabledTotals);
            DataItem rankMeasure = filterExaminer.getMeasureInRank();
            boolean isRankDescending = filterExaminer.isSortDescending();
            int summaryType = ROLAPStepGenerationUtil.getSumOfTotalTypeForCategories(Collections.singletonList(category), rolapInfo);
            if (summaryType != rolapInfo.getMaxTotalTypes()) {
                VisualTotalSubStep.addCode(code, dsProcessor, rolapInfo, Collections.singletonList(rankMeasure), rankingSummaryTable, vtTempTables, " for ranking by subtotals", true);
            }
            if (subtotalRankFilter.getRankType() == 0) {
                int count = subtotalRankFilter.getValue();
                if (subtotalRankFilter.isIncludeTies()) {
                    StringBuffer procRank = RankingStep.generateProcRankCountWithTies(dsProcessor, rankingSummaryTable, rankedSummaryTable, rankMeasure, isRankDescending, summaryType, null, null, count);
                    SQLStatementFactory.addText(code, procRank);
                    SQLStatementFactory.addNewLine(code);
                } else {
                    String options = "outobs=" + count;
                    SQLStatementFactory.addStartProcSql(code, dsProcessor, false, options);
                    SQLStatementFactory.addStartSqlStatement(code, dsProcessor);
                    SQLStatementFactory.addCreateTableAs(code, dsProcessor, rankedSummaryTable);
                    StringBuffer sql = RankingStep.generateProcSqlCountWithoutTies(dsProcessor, rankingSummaryTable, rankedSummaryTable, rankMeasure, isRankDescending, summaryType, null, null, count);
                    SQLStatementFactory.addText(code, sql);
                    SQLStatementFactory.addEndSqlStatement(code, dsProcessor);
                    SQLStatementFactory.addEndProcSql(code, dsProcessor);
                    SQLStatementFactory.addNewLine(code);
                }
            } else if (subtotalRankFilter.getRankType() == 1) {
                SQLStatementFactory.addStartProcSql(code, dsProcessor, false, null);
                SQLStatementFactory.addStartSqlStatement(code, dsProcessor);
                SQLStatementFactory.addCreateTableAs(code, dsProcessor, totalTable);
                StringBuffer sql = RankingStep.generateTotalsQuery(dsProcessor, rankingSummaryTable, rankMeasure, 0, null, null);
                SQLStatementFactory.addText(code, sql);
                SQLStatementFactory.addEndSqlStatement(code, dsProcessor);
                SQLStatementFactory.addNewLine(code);
                SQLStatementFactory.addStartSqlStatement(code, dsProcessor);
                SQLStatementFactory.addCreateTableAs(code, dsProcessor, tempRankingSummaryTable);
                StringBuffer sql2 = RankingStep.generatePercentageTotalsQuery(dsProcessor, rankingSummaryTable, totalTable, isRankDescending, summaryType, null, null, rankMeasure);
                SQLStatementFactory.addText(code, sql2);
                SQLStatementFactory.addEndSqlStatement(code, dsProcessor);
                SQLStatementFactory.addEndProcSql(code, dsProcessor);
                SQLStatementFactory.addNewLine(code);
                double value = (double)subtotalRankFilter.getValue() / 100.0;
                StringBuffer dataStep = RankingStep.generateFilterByPercentDataStep(rankedSummaryTable, tempRankingSummaryTable, value);
                SQLStatementFactory.addText(code, dataStep);
                SQLStatementFactory.addNewLine(code);
            } else {
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("RankingStep.UnsupportedRank.txt", new Object[0]);
                throw new GenerationException(mft);
            }
            SQLStatementFactory.addProcDeleteDataByName(code, dsProcessor, rankingSummaryTable);
            SQLStatementFactory.addStartProcSql(code, dsProcessor, false, null);
            SQLStatementFactory.addStartSqlStatement(code, dsProcessor);
            SQLStatementFactory.addCreateTableAs(code, dsProcessor, filteredTable);
            StringBuffer sql3 = RankingStep.generateFilteredDataQuery(dsProcessor, detailTable, rankedSummaryTable, Collections.singletonList(category));
            SQLStatementFactory.addText(code, sql3);
            SQLStatementFactory.addEndSqlStatement(code, dsProcessor);
            SQLStatementFactory.addNewLine(code);
            SQLStatementFactory.addDropViewByName(code, dsProcessor, detailTable);
            SQLStatementFactory.addNewLine(code);
            SQLStatementFactory.addStartSqlStatement(code, dsProcessor);
            SQLStatementFactory.addCreateViewAs(code, dsProcessor, detailTable);
            SQLStatementFactory.addText(code, "  select * from " + filteredTable);
            SQLStatementFactory.addEndSqlStatement(code, dsProcessor);
            SQLStatementFactory.addEndProcSql(code, dsProcessor);
        }
    }

    private static void addRowColumnRankFilter(List<SQLComponentAbstract> code, RolapDataSelectionProcessor dsProcessor, ROLAPFilterAndRankExaminer filterExaminer, ROLAPBuilderInformation rolapInfo, String detailTable, String tempRankingSummaryTable, String rankingSummaryTable, String rankedSummaryTable, String filteredSummaryTable, String vtTempRankingSummaryTable, String totalTable) throws GenerationException, MetadataException {
        BusinessQueryRankFilter tupleRank = filterExaminer.getRowColumnRankFilter();
        if (tupleRank != null) {
            StringBuffer sql;
            boolean ignoreDisabledTotals = true;
            AggregationSubStep.addCode(code, dsProcessor, detailTable, tempRankingSummaryTable, rankingSummaryTable, ignoreDisabledTotals);
            DataItem rankMeasure = filterExaminer.getMeasureInRank();
            boolean isRankDescending = filterExaminer.isSortDescending();
            AxisTupleCriteria axisTupleCriteria = new AxisTupleCriteria(rolapInfo, tupleRank.getRankQualifiers());
            int type = axisTupleCriteria.makeRowColumnType();
            List<DataItem> catWithNonTotalValue = axisTupleCriteria.getCategoriesWithNonTotalValueCriteria();
            List<String> nonTotalCriteriaValues = axisTupleCriteria.getNonTotalCriteriaValues();
            ArrayList<DataItem> whereTupleCats = new ArrayList<DataItem>();
            ArrayList<String> whereTupleValues = new ArrayList<String>();
            if (type == 3 && catWithNonTotalValue.size() == 0) {
                List checkOtherQual = tupleRank.getRankQualifiers();
                List<DataItem> hiddenOnTheSameAxis = rolapInfo.getHiddenCategoryItems();
                if (checkOtherQual.size() > 1 && hiddenOnTheSameAxis.size() > 0) {
                    ArrayList<DataItem> hiddenOnTheSameAxisExceptTotals = new ArrayList<DataItem>();
                    for (DataItem category : hiddenOnTheSameAxis) {
                        String resultSetId = category.getResultSetID();
                        for (String criteria : nonTotalCriteriaValues) {
                            String resultsetIDFromCriteria = criteria.substring(3, criteria.indexOf("]"));
                            if (!resultSetId.equals(resultsetIDFromCriteria)) continue;
                            hiddenOnTheSameAxisExceptTotals.add(category);
                        }
                    }
                    ROLAPStepGenerationUtil.getTupleCriteria(hiddenOnTheSameAxisExceptTotals, nonTotalCriteriaValues, whereTupleCats, whereTupleValues);
                } else {
                    ROLAPStepGenerationUtil.getTupleCriteria(catWithNonTotalValue, nonTotalCriteriaValues, whereTupleCats, whereTupleValues);
                }
            } else {
                ROLAPStepGenerationUtil.getTupleCriteria(catWithNonTotalValue, nonTotalCriteriaValues, whereTupleCats, whereTupleValues);
            }
            if (type != rolapInfo.getMaxTotalTypes()) {
                VisualTotalSubStep.addCode(code, dsProcessor, rolapInfo, Collections.singletonList(rankMeasure), rankingSummaryTable, vtTempRankingSummaryTable, "for ranking by row/column totals", true);
            }
            SQLStatementFactory.addNewLine(code);
            if ("Count".equals(tupleRank.getRankType())) {
                int count = tupleRank.getValue();
                if (tupleRank.isIncludeTies()) {
                    StringBuffer procRank = RankingStep.generateProcRankCountWithTies(dsProcessor, rankingSummaryTable, rankedSummaryTable, rankMeasure, isRankDescending, type, whereTupleCats, whereTupleValues, count);
                    SQLStatementFactory.addText(code, procRank);
                } else {
                    String options = "outobs=" + count;
                    SQLStatementFactory.addStartProcSql(code, dsProcessor, false, options);
                    SQLStatementFactory.addStartSqlStatement(code, dsProcessor);
                    SQLStatementFactory.addCreateTableAs(code, dsProcessor, rankedSummaryTable);
                    sql = RankingStep.generateProcSqlCountWithoutTies(dsProcessor, rankingSummaryTable, rankedSummaryTable, rankMeasure, isRankDescending, type, whereTupleCats, whereTupleValues, count);
                    SQLStatementFactory.addText(code, sql);
                    SQLStatementFactory.addEndSqlStatement(code, dsProcessor);
                    SQLStatementFactory.addEndProcSql(code, dsProcessor);
                }
            } else if ("Percent".equals(tupleRank.getRankType())) {
                List<DataItem> categories = axisTupleCriteria.getCategoriesWithNonTotalValueCriteria();
                int summaryType = ROLAPStepGenerationUtil.getSumOfTotalTypeForCategories(categories, rolapInfo);
                SQLStatementFactory.addStartProcSql(code, dsProcessor, false, null);
                SQLStatementFactory.addStartSqlStatement(code, dsProcessor);
                SQLStatementFactory.addCreateTableAs(code, dsProcessor, totalTable);
                sql = RankingStep.generateTotalsQuery(dsProcessor, rankingSummaryTable, rankMeasure, summaryType, whereTupleCats, whereTupleValues);
                SQLStatementFactory.addText(code, sql);
                SQLStatementFactory.addEndSqlStatement(code, dsProcessor);
                SQLStatementFactory.addNewLine(code);
                SQLStatementFactory.addStartSqlStatement(code, dsProcessor);
                SQLStatementFactory.addCreateTableAs(code, dsProcessor, tempRankingSummaryTable);
                StringBuffer sql2 = RankingStep.generatePercentageTotalsQuery(dsProcessor, rankingSummaryTable, totalTable, isRankDescending, type, whereTupleCats, whereTupleValues, rankMeasure);
                SQLStatementFactory.addText(code, sql2);
                SQLStatementFactory.addEndSqlStatement(code, dsProcessor);
                SQLStatementFactory.addEndProcSql(code, dsProcessor);
                double value = (double)tupleRank.getValue() / 100.0;
                StringBuffer dataStep = RankingStep.generateFilterByPercentDataStep(rankedSummaryTable, tempRankingSummaryTable, value);
                SQLStatementFactory.addText(code, dataStep);
            } else {
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("RankingStep.UnsupportedRank.txt", new Object[0]);
                throw new GenerationException(mft);
            }
            SQLStatementFactory.addNewLine(code);
            List<Object> categoriesOnTheOtherAxis = new ArrayList();
            DataSelection ds = rolapInfo.getDataSelection();
            Role rankMeasureRole = ds.getResultItemRole(rankMeasure);
            if (rankMeasureRole == Role.COLUMN || rankMeasureRole == Role.ROW) {
                Role opposingRole = ROLAPBuilderInformation.getOpposingRole(rankMeasureRole);
                categoriesOnTheOtherAxis = rolapInfo.getCategoriesOnAxis(opposingRole);
            }
            if (categoriesOnTheOtherAxis.isEmpty()) {
                Iterator<DataItem> measures = rolapInfo.getMeasureItems().iterator();
                while (measures.hasNext() && categoriesOnTheOtherAxis.isEmpty()) {
                    Role meaureRole;
                    DataItem measure = measures.next();
                    if (measure == rankMeasure || (meaureRole = ds.getResultItemRole(measure)) != Role.COLUMN && meaureRole != Role.ROW) continue;
                    Role opposingRole = ROLAPBuilderInformation.getOpposingRole(meaureRole);
                    categoriesOnTheOtherAxis = rolapInfo.getCategoriesOnAxis(opposingRole);
                }
                if (categoriesOnTheOtherAxis.isEmpty()) {
                    Role[] roles = new Role[]{Role.ROW, Role.COLUMN};
                    for (int i = 0; i < roles.length && categoriesOnTheOtherAxis.isEmpty(); ++i) {
                        Role checkRole = roles[i];
                        List<StepInterface> steps = ds.getSteps(checkRole);
                        if (!steps.contains(tupleRank)) continue;
                        Role opposingRole = ROLAPBuilderInformation.getOpposingRole(checkRole);
                        categoriesOnTheOtherAxis = rolapInfo.getCategoriesOnAxis(opposingRole);
                    }
                }
            }
            if (categoriesOnTheOtherAxis.size() == 0) {
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("AggregatedFilterStep.generateFilteredData.NoFilteredCategoriesList.txt", new Object[0]);
                throw new GenerationException(mft);
            }
            SQLStatementFactory.addStartProcSql(code, dsProcessor, false, null);
            SQLStatementFactory.addStartSqlStatement(code, dsProcessor);
            SQLStatementFactory.addCreateTableAs(code, dsProcessor, filteredSummaryTable);
            StringBuffer sql3 = RankingStep.generateFilteredDataQuery(dsProcessor, detailTable, rankedSummaryTable, categoriesOnTheOtherAxis);
            SQLStatementFactory.addText(code, sql3);
            SQLStatementFactory.addEndSqlStatement(code, dsProcessor);
            SQLStatementFactory.addNewLine(code);
            if (tupleRank.isIncludeTies()) {
                SQLStatementFactory.addDropViewByName(code, dsProcessor, tempRankingSummaryTable);
                SQLStatementFactory.addNewLine(code);
            }
            SQLStatementFactory.addDropTableByName(code, dsProcessor, rankingSummaryTable);
            SQLStatementFactory.addNewLine(code);
            SQLStatementFactory.addDropViewByName(code, dsProcessor, detailTable);
            SQLStatementFactory.addStartSqlStatement(code, dsProcessor);
            SQLStatementFactory.addCreateViewAs(code, dsProcessor, detailTable);
            SQLStatementFactory.addText(code, "  select * from " + filteredSummaryTable);
            SQLStatementFactory.addEndSqlStatement(code, dsProcessor);
            SQLStatementFactory.addEndProcSql(code, dsProcessor);
        }
    }

    private static StringBuffer generateFilteredDataQuery(RolapDataSelectionProcessor dsProcessor, String detailTable, String rankedSummaryTable, List<DataItem> categoryList) throws GenerationException {
        StringBuffer sql = new StringBuffer();
        sql.append("  select data.*\n");
        sql.append("    from ").append(detailTable).append(" data\n");
        sql.append("    inner join ").append(rankedSummaryTable).append(" filter\n");
        sql.append("       on ");
        int i = 0;
        Iterator<DataItem> iter = categoryList.iterator();
        while (iter.hasNext()) {
            boolean useFormat;
            if (i > 0) {
                sql.append("\n     and ");
            }
            DataItem categoryWithFilter = iter.next();
            String categoryAlias = dsProcessor.generateColumnIdentifier(categoryWithFilter.getResultSetID());
            String format = GenerationUtil.generateFormat(categoryWithFilter);
            boolean bl = useFormat = format != null && format.trim().length() > 0 && !format.equals("$.");
            if (useFormat) {
                String putSqlLeft = GenerationUtil.generatePut(dsProcessor, "data." + categoryAlias, format);
                String putSqlRight = GenerationUtil.generatePut(dsProcessor, "filter." + categoryAlias, format);
                sql.append(putSqlLeft).append("=");
                sql.append(putSqlRight).append(" ");
            } else {
                sql.append("data.").append(categoryAlias).append("=");
                sql.append("filter.").append(categoryAlias).append(" ");
            }
            ++i;
        }
        return sql;
    }

    private static StringBuffer generatePercentageTotalsQuery(DataSelectionProcessorAbstract dsProcessor, String rankingSummaryTable, String totalTable, boolean isRankDescending, int type, List<DataItem> whereTupleCats, List<String> whereTupleValues, DataItem rankMeasure) throws GenerationException {
        String measureId = dsProcessor.generateColumnIdentifier(rankMeasure.getResultSetID());
        StringBuffer sql = new StringBuffer();
        sql.append("  select cmp.*,\n");
        sql.append("         cmp.").append(measureId).append("/gt.").append(measureId).append(" as pct\n");
        sql.append("    from ").append(rankingSummaryTable).append(" cmp, ").append(totalTable).append(" gt\n");
        sql.append("   where _type_=").append(type);
        ROLAPStepGenerationUtil.appendSqlTupleFilters(sql, dsProcessor, whereTupleCats, whereTupleValues);
        sql.append("\n   order by ").append(measureId);
        if (isRankDescending) {
            sql.append(" desc");
        }
        return sql;
    }

    private static StringBuffer generateFilterByPercentDataStep(String rankedSummaryTable, String tempRankingSummaryTable, double value) {
        StringBuffer dataStep = new StringBuffer();
        dataStep.append("\ndata ").append(rankedSummaryTable).append(";");
        dataStep.append("\nset ").append(tempRankingSummaryTable).append(";");
        dataStep.append("\n\tcummulativepct + pct;");
        dataStep.append("\n\tif(cummulativepct >= ").append(value).append(") then");
        dataStep.append("\n\t\tdo;");
        dataStep.append("\n\t\t\toutput;");
        dataStep.append("\n\t\t\tstop;");
        dataStep.append("\n\t\tend;");
        dataStep.append("\n\toutput;");
        dataStep.append("\nrun;\n");
        return dataStep;
    }

    private static StringBuffer generateProcRankCountWithTies(DataSelectionProcessorAbstract dsProcessor, String rankingSummaryTable, String rankedSummaryTable, DataItem rankMeasure, boolean isRankDescending, int type, List<DataItem> whereTupleCats, List<String> whereTupleValues, int count) throws GenerationException {
        String resultSetID = rankMeasure.getResultSetID();
        String measureId = dsProcessor.generateDataStepVar(resultSetID);
        StringBuffer procRank = new StringBuffer();
        procRank.append("\nPROC RANK");
        if (isRankDescending) {
            procRank.append(" DESCENDING");
        }
        procRank.append(" data=").append(rankingSummaryTable);
        procRank.append("\n\t(where=(_type_=").append(type);
        ROLAPStepGenerationUtil.appendProcRankTupleFilters(procRank, dsProcessor, whereTupleCats, whereTupleValues);
        procRank.append("))");
        procRank.append("\n\tout=").append(rankedSummaryTable);
        procRank.append("\n\t(where=(DII_R<=").append(count).append(")) ties=low;");
        procRank.append("\n\tvar ").append(measureId).append(";");
        procRank.append("\n\tranks DII_R;");
        procRank.append("\nrun;\n");
        return procRank;
    }

    private static StringBuffer generateProcSqlCountWithoutTies(RolapDataSelectionProcessor dsProcessor, String rankingSummaryTable, String rankedSummaryTable, DataItem rankMeasure, boolean isRankDescending, int type, List<DataItem> whereTupleCats, List<String> whereTupleValues, int count) throws GenerationException {
        String measureId = dsProcessor.generateColumnIdentifier(rankMeasure.getResultSetID());
        StringBuffer sql = new StringBuffer();
        sql.append("  select *\n");
        sql.append("    from ").append(rankingSummaryTable).append("\n");
        sql.append("   where _type_=").append(type);
        ROLAPStepGenerationUtil.appendSqlTupleFilters(sql, dsProcessor, whereTupleCats, whereTupleValues);
        sql.append("\n   order by ").append(measureId);
        if (isRankDescending) {
            sql.append(" desc");
        }
        return sql;
    }

    private static StringBuffer generateTotalsQuery(RolapDataSelectionProcessor dsProcessor, String rankingSummaryTable, DataItem rankMeasure, int type, List<DataItem> whereTupleCats, List<String> whereTupleValues) throws GenerationException {
        String identifier = dsProcessor.generateColumnIdentifier(rankMeasure.getResultSetID());
        StringBuffer sql = new StringBuffer();
        sql.append("  select ").append(identifier).append("\n");
        sql.append("    from ").append(rankingSummaryTable).append("\n");
        sql.append("   where _type_=").append(type);
        ROLAPStepGenerationUtil.appendSqlTupleFilters(sql, dsProcessor, whereTupleCats, whereTupleValues);
        return sql;
    }
}

