/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPBuilderInformation;
import com.sas.iquery.strategies.sas.oma.summaryrolap.RolapDataSelectionProcessor;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Immutable
public class ROLAPStepGenerationUtil {
    private static final Logger _logger = LogManager.getLogger(ROLAPStepGenerationUtil.class);

    static int getSumOfTotalTypeForCategories(List<? extends DataItem> filteredCategoriesList, ROLAPBuilderInformation rolapInfo) throws GenerationException {
        int type = 0;
        for (DataItem dataItem : filteredCategoriesList) {
            type += rolapInfo.getTotalTypeValueForCategory(dataItem);
        }
        return type;
    }

    static void getTupleCriteria(List<? extends DataItem> categoriesOnTheSameAxis, List<String> axisTupleCriteria, List<DataItem> outputCats, List<String> outputValues) throws GenerationException {
        Iterator<String> iterator = axisTupleCriteria.iterator();
        while (iterator.hasNext()) {
            String value;
            String diUnicName;
            String string;
            String tupleElementUniqueName = string = iterator.next();
            DataItem itemFound = null;
            try {
                int indexOf = tupleElementUniqueName.indexOf("]");
                diUnicName = tupleElementUniqueName.substring(3, indexOf);
            }
            catch (IndexOutOfBoundsException e) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("AggregatedFilterStep.generateCategoryEqualValue.TupleSyntaxError.fmt.txt", new Object[0]);
                _logger.error((Object)formatter);
                throw new GenerationException(formatter, (Throwable)e);
            }
            Iterator<? extends DataItem> iter1 = categoriesOnTheSameAxis.iterator();
            while (itemFound == null && iter1.hasNext()) {
                DataItem category = iter1.next();
                if (!diUnicName.equals(category.getResultSetID())) continue;
                itemFound = category;
            }
            if (itemFound == null) {
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("AggregatedFilterStep.generateCategoryEqualValue.NoCategoryValue.txt", new Object[0]);
                throw new GenerationException(mft);
            }
            try {
                int lastIndexOf = tupleElementUniqueName.lastIndexOf("[");
                int lastIndexOf2 = tupleElementUniqueName.lastIndexOf("]");
                value = tupleElementUniqueName.substring(lastIndexOf + 1, lastIndexOf2);
            }
            catch (IndexOutOfBoundsException e) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("AggregatedFilterStep.generateCategoryEqualValue.TupleSyntaxError.fmt.txt", new Object[0]);
                _logger.error((Object)formatter);
                throw new GenerationException(formatter, (Throwable)e);
            }
            outputCats.add(itemFound);
            outputValues.add(value);
        }
    }

    static String createTotalReplacementString(RolapDataSelectionProcessor dsProcessor, DataItem di, ROLAPBuilderInformation rbi) throws GenerationException {
        StringBuffer replacementValueString = new StringBuffer();
        String identifier = dsProcessor.generateDataStepVar(di.getResultSetID());
        replacementValueString.append("\nif missing(" + identifier + ") and ");
        replacementValueString.append(ROLAPStepGenerationUtil.generateExcludedTypeIn(di, rbi));
        replacementValueString.append(" then ");
        return replacementValueString.toString();
    }

    static String generateExcludedTypeIn(DataItem di, ROLAPBuilderInformation rbi) {
        StringBuffer replacementValueString = new StringBuffer();
        replacementValueString.append("_type_ in (");
        int typeMask = rbi.calculateTotalTypeMask(di);
        int maxTotalTypes = rbi.getMaxTotalTypes();
        boolean excluded = true;
        boolean inTotal = false;
        boolean foundValue = false;
        for (int i = 0; i <= maxTotalTypes; ++i) {
            inTotal = false;
            if ((i & typeMask) > 0) {
                inTotal = true;
            }
            if ((!inTotal || excluded) && (inTotal || !excluded)) continue;
            if (foundValue) {
                replacementValueString.append(",");
            }
            replacementValueString.append(i);
            foundValue = true;
        }
        replacementValueString.append(")");
        return replacementValueString.toString();
    }

    public static List<String> getResultColumnsList(RolapDataSelectionProcessor dsProcessor, ROLAPBuilderInformation rolapInfo) throws GenerationException {
        ArrayList<String> columns = new ArrayList<String>();
        List<DataItem> categories = rolapInfo.getCategoryItems();
        for (int i = 0; i < categories.size(); ++i) {
            DataItem category = categories.get(i);
            columns.add(category.getResultSetID());
        }
        columns.add("_TYPE_");
        List<DataItem> measures = rolapInfo.getMeasureItems();
        for (DataItem measure : measures) {
            columns.add(measure.getResultSetID());
        }
        return columns;
    }

    static void appendSqlTupleFilters(StringBuffer sql, DataSelectionProcessorAbstract dsProcessor, List<? extends DataItem> whereTupleCats, List<String> whereTupleValues) throws GenerationException {
        if (whereTupleCats != null) {
            for (int i = 0; i < whereTupleCats.size(); ++i) {
                boolean useFormat;
                DataItem itemFound = whereTupleCats.get(i);
                String value = whereTupleValues.get(i);
                sql.append("\n     and ");
                String categoryAlias = dsProcessor.generateColumnIdentifier(itemFound.getResultSetID());
                String format = GenerationUtil.generateFormat(itemFound);
                boolean bl = useFormat = format != null && format.trim().length() > 0 && !format.equals("$.");
                if (useFormat) {
                    String putSql = GenerationUtil.generatePut(dsProcessor, categoryAlias, format);
                    sql.append(putSql);
                } else {
                    sql.append(categoryAlias);
                }
                sql.append("=");
                sql.append(GenerationUtil.generateQuotedLiteral(value));
                sql.append(" ");
            }
        }
    }

    static void appendProcRankTupleFilters(StringBuffer procRank, DataSelectionProcessorAbstract dsProcessor, List<? extends DataItem> whereTupleCats, List<String> whereTupleValues) throws GenerationException {
        if (whereTupleCats != null) {
            for (int i = 0; i < whereTupleCats.size(); ++i) {
                boolean useFormat;
                DataItem itemFound = whereTupleCats.get(i);
                String value = whereTupleValues.get(i);
                procRank.append("\n     and ");
                String categoryAlias = dsProcessor.generateDataStepVar(itemFound.getResultSetID());
                String format = GenerationUtil.generateFormat(itemFound);
                boolean bl = useFormat = format != null && format.trim().length() > 0 && !format.equals("$.");
                if (useFormat) {
                    procRank.append(GenerationUtil.generateDataStepPut(categoryAlias, format));
                } else {
                    procRank.append(categoryAlias);
                }
                procRank.append("=");
                procRank.append(GenerationUtil.generateQuotedLiteral(value));
                procRank.append(" ");
            }
        }
    }
}

