/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap;

public class ROLAPOptions {
    public static final int DEFAULT_PAGE_OUT_CELLS_CHUNK_SIZE = 1000;
    public static final int DEFAULT_PAGE_OUT_CELLS_THRESHOLD = 5000;
    public static final int DEFAULT_PAGE_OUT_TUPLES_CHUNK_SIZE = 150;
    public static final int DEFAULT_PAGE_OUT_TUPLES_THRESHOLD = 500;
    public static final String MAX_CELL_COUNT_PROPERTY_NAME = "com.sas.iquery.dataservices.ProcSummaryROLAPBuilder.MAX_CELL_COUNT";
    public static final String MAX_TUPLE_COUNT_PROPERTY_NAME = "com.sas.iquery.dataservices.ProcSummaryROLAPBuilder.MAX_TUPLE_COUNT";
    public static final String PAGE_OUT_CELLS_CHUNK_SIZE_PROPERTY_NAME = "com.sas.iquery.rolap.PAGE_OUT_CELLS_CHUNK_SIZE";
    public static final String PAGE_OUT_CELLS_THRESHOLD_PROPERTY_NAME = "com.sas.iquery.rolap.PAGE_OUT_CELLS_THRESHOLD";
    public static final String PAGE_OUT_TUPLES_CHUNK_SIZE_PROPERTY_NAME = "com.sas.iquery.rolap.PAGE_OUT_TUPLES_CHUNK_SIZE";
    public static final String PAGE_OUT_TUPLES_THRESHOLD_PROPERTY_NAME = "com.sas.iquery.rolap.PAGE_OUT_TUPLES_THRESHOLD";
    public static final int UNLIMITED_MAXIMUM = 0;
    private int _cellChunkSize;
    private int _cellPageOutThreshold;
    private int _maxCellCount;
    private int _maxTupleCount;
    private int _tupleChunkSize;
    private int _tuplePageOutThreshold;

    public ROLAPOptions() {
        this.setDefaults();
    }

    private void setDefaults() {
        this._maxTupleCount = this.getSystemPropertyIntValue(MAX_TUPLE_COUNT_PROPERTY_NAME, 0);
        this._maxCellCount = this.getSystemPropertyIntValue(MAX_CELL_COUNT_PROPERTY_NAME, 0);
        this._tupleChunkSize = this.getSystemPropertyIntValue(PAGE_OUT_TUPLES_CHUNK_SIZE_PROPERTY_NAME, 150);
        this._tuplePageOutThreshold = this.getSystemPropertyIntValue(PAGE_OUT_TUPLES_THRESHOLD_PROPERTY_NAME, 500);
        this._cellChunkSize = this.getSystemPropertyIntValue(PAGE_OUT_CELLS_CHUNK_SIZE_PROPERTY_NAME, 1000);
        this._cellPageOutThreshold = this.getSystemPropertyIntValue(PAGE_OUT_CELLS_THRESHOLD_PROPERTY_NAME, 5000);
    }

    private int getSystemPropertyIntValue(String propertyName, int defaultValue) {
        Integer propertyValue = Integer.getInteger(propertyName, defaultValue);
        int intValue = propertyValue;
        if (intValue < 1) {
            intValue = Integer.MAX_VALUE;
        }
        return intValue;
    }

    public int getCellChunkSize() {
        return this._cellChunkSize;
    }

    public int getCellPageOutThreshold() {
        return this._cellPageOutThreshold;
    }

    public int getMaxCellCount() {
        return this._maxCellCount;
    }

    public int getMaxTupleCount() {
        return this._maxTupleCount;
    }

    public int getTupleChunkSize() {
        return this._tupleChunkSize;
    }

    public int getTuplePageOutThreshold() {
        return this._tuplePageOutThreshold;
    }

    public void setCellChunkSize(int chunkSize) {
        this._cellChunkSize = chunkSize;
    }

    public void setCellPageOutThreshold(int pageOutThreshold) {
        this._cellPageOutThreshold = pageOutThreshold;
    }

    public void setMaxCellCount(int maxCellCount) {
        this._maxCellCount = maxCellCount;
    }

    public void setMaxTupleCount(int maxTupleCount) {
        this._maxTupleCount = maxTupleCount;
    }

    public void setTupleChunkSize(int chunkSize) {
        this._tupleChunkSize = chunkSize;
    }

    public void setTuplePageOutThreshold(int pageOutThreshold) {
        this._tuplePageOutThreshold = pageOutThreshold;
    }
}

