/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryRankFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemRankFilter;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.olap.DataBasedFilterExpression;
import com.sas.iquery.strategies.sas.oma.relational.composite.sas.SQLSASFilterExaminer;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPBuilderInformation;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class ROLAPFilterAndRankExaminer {
    private ArrayList _preAggregationCategoryFilters;
    private ArrayList _postAggregationSubtotalFilters;
    private ArrayList _postAggregationRowColumnFilters;
    private DataItem _measureInRank;
    private boolean _isSortDescending;
    private DataItem _subTotalRankCategory;
    private DataItemRankFilter _subTotalRank;
    private BusinessQueryRankFilter _rowColumnRank;
    private DataSelection _dataSelection = null;
    private Map _dataItemLeavesMap = null;

    public ROLAPFilterAndRankExaminer(DataSelection ds) throws GenerationException {
        this(ds, null);
    }

    public ROLAPFilterAndRankExaminer(DataSelection ds, Map dataItemLeavesMap) throws GenerationException {
        if (ds == null) {
            throw new NullPointerException(IQDataServicesResourceBundle.getStringResource("ROLAPFilterAndRankExaminer.examineFilters.DataSelectionNull.txt"));
        }
        this._dataItemLeavesMap = dataItemLeavesMap;
        this._dataSelection = ds;
        this._preAggregationCategoryFilters = new ArrayList();
        this._postAggregationSubtotalFilters = new ArrayList();
        this._postAggregationRowColumnFilters = new ArrayList();
        this._rowColumnRank = null;
        this._subTotalRankCategory = null;
        this._subTotalRank = null;
        this._measureInRank = null;
        this._isSortDescending = false;
        this.examineFiltersAndRanks();
    }

    public List<FilterItem> getPreAggregationFilters() {
        return this._preAggregationCategoryFilters;
    }

    public List<FilterItem> getPostAggregationSubtotalFilters() {
        return this._postAggregationSubtotalFilters;
    }

    public List getPostAggregationRowColumnFilters() {
        return this._postAggregationRowColumnFilters;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataItem getSubtotalRankCategory(Role role) throws GenerationException {
        DataItem category = null;
        if (role == null) return this._subTotalRankCategory;
        if (this._subTotalRankCategory == null) return this._subTotalRankCategory;
        try {
            if (!this._dataSelection.getResultItemRole(this._subTotalRankCategory).equals(role)) return category;
            return this._subTotalRankCategory;
        }
        catch (MetadataException e) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("ROLAPFilterAndRankExaminer.UnableToRetrieveRole.txt", new Object[0]);
            throw new GenerationException(mft);
        }
    }

    public DataItemRankFilter getSubtotalRankFilter() {
        return this._subTotalRank;
    }

    public BusinessQueryRankFilter getRowColumnRankFilter() {
        return this._rowColumnRank;
    }

    private void examineFiltersAndRanks() throws GenerationException {
        List<FilterItem> filters = this._dataSelection.getEffectiveFilters();
        for (FilterItem filterItem : filters) {
            if (filterItem == null) continue;
            ExpressionInterface expression = filterItem.getExpression();
            if (expression instanceof DataBasedFilterExpression) {
                this._postAggregationSubtotalFilters.add(filterItem);
                continue;
            }
            String havingOrWhere = SQLSASFilterExaminer.examineFilterExpression(this._dataSelection, expression);
            if (havingOrWhere.equals("WHERE")) {
                this._preAggregationCategoryFilters.add(filterItem);
                continue;
            }
            this._postAggregationSubtotalFilters.add(filterItem);
        }
        List<StepInterface> steps = this._dataSelection.getSteps(Role.ROW);
        steps.addAll(this._dataSelection.getSteps(Role.COLUMN));
        for (StepInterface step : steps) {
            if (step instanceof BusinessQueryDataBasedFilter) {
                BusinessQueryDataBasedFilter tupleFilter = (BusinessQueryDataBasedFilter)step;
                this._postAggregationRowColumnFilters.add(tupleFilter);
            }
            if (!(step instanceof BusinessQueryRankFilter)) continue;
            if (this._rowColumnRank != null || this._subTotalRank != null) {
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("ROLAPFilterAndRankExaminer.examineFilters.OnlyOneRankSupported.txt", new Object[0]);
                throw new GenerationException(mft);
            }
            this._rowColumnRank = (BusinessQueryRankFilter)step;
            List diRepresentationList = this._rowColumnRank.getRankQualifiers();
            for (ExpressionInterface member : diRepresentationList) {
                if (!(member instanceof DataItem)) continue;
                if (this._measureInRank != null) {
                    MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("ROLAPFilterAndRankExaminer.examineFiltersAndRanks.RankShouldHave1Measure.txt", new Object[0]);
                    throw new GenerationException(mft);
                }
                this._measureInRank = (DataItem)member;
                if (!this._rowColumnRank.getRankOrder().equals("Top")) continue;
                this._isSortDescending = true;
            }
            if (this._measureInRank != null) continue;
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("ROLAPFilterAndRankExaminer.examineFiltersAndRanks.RankShouldHave1Measure.txt", new Object[0]);
            throw new GenerationException(mft);
        }
        ROLAPBuilderInformation rOLAPBuilderInformation = new ROLAPBuilderInformation(this._dataSelection, this._dataItemLeavesMap);
        List<DataItem> categories = rOLAPBuilderInformation.getCategoryItems();
        for (DataItem category : categories) {
            List<StepInterface> rankSteps = category.getSteps();
            for (StepInterface step : rankSteps) {
                if (!(step instanceof DataItemRankFilter)) continue;
                if (this._subTotalRank != null || this._rowColumnRank != null) {
                    MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("ROLAPFilterAndRankExaminer.examineFilters.OnlyOneRankSupported.txt", new Object[0]);
                    throw new GenerationException(mft);
                }
                this._subTotalRank = (DataItemRankFilter)step;
                this._subTotalRankCategory = category;
                List<ExpressionInterface> measureList = this._subTotalRank.getRankQualifiers();
                if (measureList.size() != 1 || !(measureList.get(0) instanceof DataItem)) {
                    MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("ROLAPFilterAndRankExaminer.examineFiltersAndRanks.FilterShouldHave1Measure.txt", new Object[0]);
                    throw new GenerationException(mft);
                }
                this._measureInRank = (DataItem)measureList.get(0);
                if (this._subTotalRank.getRankOrder() != 0) continue;
                this._isSortDescending = true;
            }
        }
    }

    public boolean hasPostAggregatedSubtotalFilters() {
        return !this.getPostAggregationSubtotalFilters().isEmpty();
    }

    public boolean hasPostAggregatedRowColumnFilters() {
        return !this.getPostAggregationRowColumnFilters().isEmpty();
    }

    public List getCategoriesFromSubtotalFilters() {
        LinkedHashSet<DataItem> categories = new LinkedHashSet<DataItem>();
        for (FilterItem filter : this._postAggregationSubtotalFilters) {
            if (filter == null) continue;
            List<DataBasedFilterExpression> dbfes = filter.getResources(DataBasedFilterExpression.class, 1);
            for (DataBasedFilterExpression dbfe : dbfes) {
                DataItem category = (DataItem)dbfe.getWhatToFilter();
                categories.add(category);
            }
        }
        ArrayList result = new ArrayList(categories);
        return result;
    }

    public DataItem getMeasureInRank() throws GenerationException {
        return this.getMeasureInRank(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataItem getMeasureInRank(Role role) throws GenerationException {
        DataItem measure = null;
        if (role == null) return this._measureInRank;
        if (this._measureInRank == null) return this._measureInRank;
        try {
            if (!this._dataSelection.getResultItemRole(this._measureInRank).equals(role)) return measure;
            return this._measureInRank;
        }
        catch (MetadataException e) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("ROLAPFilterAndRankExaminer.UnableToRetrieveRole.txt", new Object[0]);
            throw new GenerationException(mft);
        }
    }

    public boolean isSortDescending() {
        return this._isSortDescending;
    }

    public boolean hasSubTotalRank(Role role) throws GenerationException {
        return this.getSubtotalRankCategory(role) != null;
    }

    public boolean hasRowColumnRank(Role axisRole) throws GenerationException {
        Role rankMeasureRole = axisRole.equals(Role.COLUMN) ? Role.ROW : Role.COLUMN;
        boolean hasRCRank = this._rowColumnRank != null && this.getMeasureInRank(rankMeasureRole) != null;
        return hasRCRank;
    }

    public boolean hasRank(Role axisRole) throws GenerationException {
        return this.hasSubTotalRank(axisRole) || this.hasRowColumnRank(axisRole);
    }
}

