/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap;

import com.sas.iquery.execution.ConnectionResources;
import com.sas.iquery.execution.instructions.AbstractExecutionInstruction;
import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution.instructions.StpNames;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.MultiDimResultSet;
import com.sas.iquery.execution2.ResultSetUpdateInterface;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.CancelQuerySupport;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ProcSummaryROLAPBuilder;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPBuilderInformation;
import com.sas.services.connection.ConnectionInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import java.util.Locale;

public class ROLAPBuilderInstruction
extends AbstractExecutionInstruction {
    private ROLAPBuilderInformation _rolapInfo;
    private DataSelection _dataSelection;
    private String _summaryTableFinalName;
    private String[] _tupleTableNames;
    private String _outputTablePattern;

    public ROLAPBuilderInstruction(String summaryTableFinalName, String[] tupleTableNames, String outputTablePattern, DataSelection dataSelection, ROLAPBuilderInformation rolapInfo) throws MetadataException, ExecutionException, GenerationException {
        this._summaryTableFinalName = summaryTableFinalName;
        this._outputTablePattern = outputTablePattern;
        this._tupleTableNames = tupleTableNames;
        this._dataSelection = dataSelection;
        this._rolapInfo = rolapInfo;
    }

    @Override
    public void execute() throws ExecutionException {
        ExecutionContext context = this.getExecutionContext();
        ProcSummaryROLAPBuilder summaryROLAPBuilder = new ProcSummaryROLAPBuilder();
        OLAPDataSetInterface olapDataSet = summaryROLAPBuilder.buildOLAPDataSet(context, this._rolapInfo, this._summaryTableFinalName, this._tupleTableNames, this._outputTablePattern);
        MultiDimResultSet mdrs = new MultiDimResultSet(olapDataSet);
        context.setResult(mdrs);
        Locale effectiveComputationLocale = GenerationUtil.getEffectiveComputationalLocale(this._dataSelection, context);
        if (mdrs instanceof ResultSetUpdateInterface) {
            mdrs.setComputationalLocale(effectiveComputationLocale);
            StpNames stpNames = context.getStpNames();
            mdrs.setStpNames(stpNames);
        }
        ConnectionInterface connection = context.getConnection();
        CancelQuerySupport.unRegisterConnection(connection);
        ConnectionResources.close(connection);
    }

    @Override
    public String getText() throws GenerationException, MetadataException {
        return "/* " + this._rolapInfo.toString() + " */";
    }
}

