/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.instructions.SubmitInstructionFactory;
import com.sas.iquery.execution.util.ArrayUtils;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModelResourceReferencer;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.strategies.sas.oma.summaryrolap.MaxCellsExceededException;
import com.sas.iquery.strategies.sas.oma.summaryrolap.MaxTuplesExceededException;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPOptions;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ROLAPBuilderInformation {
    private final Map<String, String> _dataItemLabels = new HashMap<String, String>();
    private final DataSelection _dataSelection;
    private final Map<Integer, AxisInformation> _axesInfo = new LinkedHashMap<Integer, AxisInformation>();
    private final List<DataItem> _categoryItems = new ArrayList<DataItem>();
    private final List<DataItem> _measureItems = new ArrayList<DataItem>();
    private int[] _tupleCounts = new int[]{0, 0};
    private int _maxTupleCount;
    private long _maxCellCount;
    final List<DataItem> _hiddenCategoryItemsList = new ArrayList<DataItem>();
    final List<Integer> _hiddenCategoryIndicesList = new ArrayList<Integer>();
    final List<DataItem> _backgroundItemsList = new ArrayList<DataItem>();
    List<DataItem> _expectedResultSetItems = null;
    private final Map<String, Map<ExpressionInterface, String>> _dataItemLeavesMap;
    private final List<DataItem> _toBeDropped = new ArrayList<DataItem>();

    private Map<String, Map<ExpressionInterface, String>> getDataItemLeavesMap() {
        return this._dataItemLeavesMap;
    }

    public List<DataItem> getColumnsToBeDropped() {
        return this._toBeDropped;
    }

    public ROLAPBuilderInformation(DataSelection dataSelection) throws GenerationException {
        this(dataSelection, null);
    }

    public ROLAPBuilderInformation(DataSelection dataSelection, Map<String, Map<ExpressionInterface, String>> dataItemLeavesMap) throws GenerationException {
        this._dataItemLeavesMap = dataItemLeavesMap;
        try {
            this._dataSelection = dataSelection;
            this.initialise();
            this.checkIsValid();
        }
        catch (MetadataException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ROLAPBuilderInformation.RolapBuilderInformation.unableToConstruct.txt", new Object[0]);
            throw new GenerationException(formatter, (Throwable)e);
        }
        catch (ExecutionException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ROLAPBuilderInformation.RolapBuilderInformation.unableToConstruct.txt", new Object[0]);
            throw new GenerationException(formatter, (Throwable)e);
        }
        ROLAPOptions rolapOptions = new ROLAPOptions();
        this._maxTupleCount = rolapOptions.getMaxTupleCount();
        this._maxCellCount = rolapOptions.getMaxCellCount();
    }

    private void checkIsValid() throws ExecutionException {
        for (Map.Entry<Integer, AxisInformation> entry : this._axesInfo.entrySet()) {
            AxisInformation axisInfo = entry.getValue();
            if (axisInfo.getCategoryCount() + axisInfo.getMeasureCount() != 0) continue;
            throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("ROLAPBuilderInformation.checkIsValid.noMeasures.fmt.txt", entry.getKey()));
        }
    }

    public List<Integer> getAxesIndices() {
        return new ArrayList<Integer>(this._axesInfo.keySet());
    }

    private void initialise() throws MetadataException, ExecutionException {
        this._axesInfo.clear();
        this._axesInfo.put(0, new AxisInformation(0));
        this._axesInfo.put(1, new AxisInformation(1));
        List<String> referencedRsids = this.getReferencedRsids();
        ArrayList<DataItem> trailingMeasures = new ArrayList<DataItem>();
        List<SelectedItem> selectedItems = this._dataSelection.getSelectedItems();
        for (SelectedItem selectedItem : selectedItems) {
            DataItem item = selectedItem.getItem();
            DataItemActionType usage = item.getUsage();
            Role itemRole = selectedItem.getRole();
            String rsid = item.getResultSetID();
            boolean isInactive = itemRole == Role.BACKGROUND || Role.isInactiveRole(this._dataSelection, itemRole);
            boolean isMeasure = usage.equals(DataItemActionType.USAGE_AGGREGATE);
            boolean isCategory = usage.equals(DataItemActionType.USAGE_CATEGORY);
            boolean isReferenced = referencedRsids.contains(rsid);
            if (isInactive && !isReferenced) {
                this._backgroundItemsList.add(item);
            } else if (isMeasure) {
                if (isInactive) {
                    trailingMeasures.add(item);
                } else {
                    this._measureItems.add(item);
                }
            } else if (isCategory) {
                this._categoryItems.add(item);
            } else {
                throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("ROLAPBuilderInformation.initialise.wrongUsage.fmt.txt", usage));
            }
            this._dataItemLabels.put(item.getResultSetID(), item.getLabel());
        }
        this._measureItems.addAll(trailingMeasures);
        this._toBeDropped.addAll(trailingMeasures);
        this.initialiseIndices();
    }

    private void initialiseIndices() throws MetadataException, ExecutionException {
        ArrayList<DataItem> columnCategoryItemsList = new ArrayList<DataItem>();
        ArrayList<Integer> columnCategoryIndicesList = new ArrayList<Integer>();
        HashMap<String, Integer> columnCategoryIndexMap = new HashMap<String, Integer>();
        ArrayList<DataItem> rowCategoryItemsList = new ArrayList<DataItem>();
        ArrayList<Integer> rowCategoryIndicesList = new ArrayList<Integer>();
        HashMap<String, Integer> rowCategoryIndexMap = new HashMap<String, Integer>();
        ArrayList<DataItem> columnMeasureItemsList = new ArrayList<DataItem>();
        ArrayList<Integer> columnMeasureIndicesList = new ArrayList<Integer>();
        ArrayList<DataItem> rowMeasureItemsList = new ArrayList<DataItem>();
        ArrayList<Integer> rowMeasureIndicesList = new ArrayList<Integer>();
        this._expectedResultSetItems = new ArrayList<DataItem>();
        int expectedResultSetColumn = 1;
        for (DataItem item : this._categoryItems) {
            Role itemRole = this._dataSelection.getResultItemRole(item);
            if (itemRole == Role.COLUMN) {
                columnCategoryItemsList.add(item);
                columnCategoryIndicesList.add(expectedResultSetColumn);
                columnCategoryIndexMap.put(item.getResultSetID(), expectedResultSetColumn);
            } else if (itemRole == Role.ROW) {
                rowCategoryItemsList.add(item);
                rowCategoryIndicesList.add(expectedResultSetColumn);
                rowCategoryIndexMap.put(item.getResultSetID(), expectedResultSetColumn);
            } else if (itemRole == Role.HIDDEN || itemRole == Role.BACKGROUND) {
                this._hiddenCategoryItemsList.add(item);
                this._hiddenCategoryIndicesList.add(expectedResultSetColumn);
            } else {
                throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("ROLAPBuilderInformation.initialiseIndices.unsupportedCategoryRole.fmt.txt", itemRole));
            }
            ++expectedResultSetColumn;
            this._expectedResultSetItems.add(item);
        }
        ++expectedResultSetColumn;
        this._expectedResultSetItems.add(null);
        for (DataItem item : this._measureItems) {
            boolean toBeDropped = this._toBeDropped.contains(item);
            if (toBeDropped) continue;
            Role itemRole = this._dataSelection.getResultItemRole(item);
            if (itemRole == Role.COLUMN) {
                columnMeasureItemsList.add(item);
                columnMeasureIndicesList.add(expectedResultSetColumn);
            } else if (itemRole == Role.ROW) {
                rowMeasureItemsList.add(item);
                rowMeasureIndicesList.add(expectedResultSetColumn);
            } else if (itemRole != Role.HIDDEN && itemRole != Role.BACKGROUND) {
                throw new ExecutionException(IQDataServicesResourceBundle.getMessageFormatter("ROLAPBuilderInformation.initialiseIndices.unsupportedMeasureRole.fmt.txt", itemRole));
            }
            ++expectedResultSetColumn;
            this._expectedResultSetItems.add(item);
        }
        this._axesInfo.get(0).setCategoryItems(columnCategoryItemsList, columnCategoryIndicesList, columnCategoryIndexMap);
        this._axesInfo.get(0).setMeasureItems(columnMeasureItemsList, columnMeasureIndicesList);
        this._axesInfo.get(1).setCategoryItems(rowCategoryItemsList, rowCategoryIndicesList, rowCategoryIndexMap);
        this._axesInfo.get(1).setMeasureItems(rowMeasureItemsList, rowMeasureIndicesList);
    }

    protected List<DataItem> getHiddenCategoryItems() {
        return Collections.unmodifiableList(this._hiddenCategoryItemsList);
    }

    protected List<Integer> getHiddenCategoryIndices() {
        return Collections.unmodifiableList(this._hiddenCategoryIndicesList);
    }

    public AxisInformation getAxisInformation(int axisIndex) {
        return this._axesInfo.get(axisIndex);
    }

    public AxisInformation getAxisInformation(Role axisRole) {
        return this.getAxisInformation(Role.COLUMN.equals(axisRole) ? 0 : 1);
    }

    public int getCategoryCount() {
        return this._categoryItems.size();
    }

    public int getMeasureCount() {
        return this._measureItems.size();
    }

    public String[] getMeasureIds() {
        DataItem item;
        int j;
        ArrayList<DataItem> returnedItems = new ArrayList<DataItem>();
        int[] indices = this.getMeasureIndices();
        for (int i = 0; i < indices.length; ++i) {
            j = indices[i] - 1;
            item = this._expectedResultSetItems.get(j);
            returnedItems.add(item);
        }
        String[] measureIds = new String[returnedItems.size()];
        for (j = 0; j < returnedItems.size(); ++j) {
            item = (DataItem)returnedItems.get(j);
            measureIds[j] = item.getResultSetID();
        }
        return measureIds;
    }

    public String[] getCategoryIds() {
        String[] categoryIds = new String[this._categoryItems.size()];
        int i = 0;
        for (DataItem item : this._categoryItems) {
            categoryIds[i++] = item.getResultSetID();
        }
        return categoryIds;
    }

    public DataSelection getDataSelection() {
        return this._dataSelection;
    }

    public int[] getMeasureIndices() {
        return ArrayUtils.concatenate(this._axesInfo.get(0).getMeasureIndices(), this._axesInfo.get(1).getMeasureIndices());
    }

    public String getDataItemLabel(String resultSetId) {
        return this._dataItemLabels.get(resultSetId);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._axesInfo.get(0));
        sb.append("\n");
        sb.append(this._axesInfo.get(1));
        sb.append("\n)");
        return sb.toString();
    }

    public List<DataItem> getMeasureItems() {
        return Collections.unmodifiableList(this._measureItems);
    }

    public List<DataItem> getCategoryItems() {
        return Collections.unmodifiableList(this._categoryItems);
    }

    public int getTotalTypeValueForCategory(DataItem category) throws GenerationException {
        int numberOfCategories = this._categoryItems.size();
        int index = this._categoryItems.indexOf(category);
        if (index == -1) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ROLAPBuilderInformation.getTotalTypeValueForCategory.NoCategory.txt", new Object[0]);
            throw new GenerationException(formatter);
        }
        int type = 1 << numberOfCategories - 1 - index;
        return type;
    }

    public int getTotalTypeValueMax() {
        int numberOfCategories = this._categoryItems.size();
        int type = (1 << numberOfCategories) - 1;
        return type;
    }

    public static int calculateTypeValue(int[] columnIndices, int classCount) {
        int type = 0;
        for (int i = 0; i < columnIndices.length; ++i) {
            int invColIdx = classCount - columnIndices[i];
            int bits = 1 << invColIdx;
            type |= bits;
        }
        return type;
    }

    public List<Integer> getTotalTypesForCategory(DataItem item) {
        int typeMask = this.calculateTotalTypeMask(item);
        List<Integer> includeTypeList = this.generateIncludeExcludeList(typeMask, true);
        return includeTypeList;
    }

    public List<Integer> getExcludedTotalTypesForCategory(DataItem item) {
        int typeMask = this.calculateTotalTypeMask(item);
        List<Integer> excludeTypeList = this.generateIncludeExcludeList(typeMask, false);
        return excludeTypeList;
    }

    public int calculateTotalTypeMask(DataItem category) {
        int categoryCount = this.getCategoryCount();
        int totalTypeMask = 1;
        List<DataItem> categoryList = this.getCategoryItems();
        int index = categoryCount - categoryList.indexOf(category);
        return totalTypeMask <<= index - 1;
    }

    public int getMaxTotalTypes() {
        int categoryCount = this.getCategoryCount();
        int maxTotalTypes = -1;
        return maxTotalTypes >>>= 32 - categoryCount;
    }

    protected List<Integer> generateIncludeExcludeList(int totalTypeMask, boolean includeList) {
        int maxTotalTypes = this.getMaxTotalTypes();
        ArrayList<Integer> list = new ArrayList<Integer>();
        boolean excluded = !includeList;
        boolean inTotal = false;
        for (int i = 0; i <= maxTotalTypes; ++i) {
            inTotal = false;
            if ((i & totalTypeMask) > 0) {
                inTotal = true;
            }
            if ((!inTotal || excluded) && (inTotal || !excluded)) continue;
            list.add(i);
        }
        return list;
    }

    public String getCategoryFromTupleElement(String tupleElementString, List<DataItem> categoriesOnTheSameAxis) throws GenerationException {
        String diUnicName = tupleElementString.substring(3, tupleElementString.indexOf("]"));
        String value = null;
        for (DataItem category : categoriesOnTheSameAxis) {
            if (!diUnicName.equals(category.getResultSetID())) continue;
            value = tupleElementString.substring(tupleElementString.lastIndexOf("[") + 1, tupleElementString.lastIndexOf("]"));
            break;
        }
        if (value == null) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("AggregatedFilterStep.generateCategoryEqualValue.NoCategoryValue.txt", new Object[0]);
            throw new GenerationException(formatter);
        }
        return value;
    }

    public List<DataItem> getPartialCategoryHierarchyAbove(DataItem category) throws GenerationException {
        int categoryIndex = this._categoryItems.indexOf(category);
        if (categoryIndex == -1) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ROLAPBuilderInformation.getPartialCategoryHierarchy.NoCategory.txt", new Object[0]);
            throw new GenerationException(formatter);
        }
        ArrayList<DataItem> listOfCategoryHierarchy = new ArrayList<DataItem>();
        try {
            Role categoryRole = this._dataSelection.getResultItemRole(category);
            for (int i = 0; i < categoryIndex; ++i) {
                DataItem item = this._categoryItems.get(i);
                Role itemRole = this._dataSelection.getResultItemRole(item);
                if (itemRole != categoryRole) continue;
                listOfCategoryHierarchy.add(item);
            }
        }
        catch (MetadataException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ROLAPBuilderInformation.UnableToRetrieveRole.txt", new Object[0]);
            throw new GenerationException(formatter);
        }
        listOfCategoryHierarchy.add(category);
        return listOfCategoryHierarchy;
    }

    public List<DataItem> getCategoriesOnTheOtherAxis(DataItem dataItem) throws GenerationException {
        Role newRole;
        Role dataItemRole;
        try {
            dataItemRole = this._dataSelection.getResultItemRole(dataItem);
        }
        catch (MetadataException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ROLAPBuilderInformation.UnableToRetrieveRole.txt", new Object[0]);
            throw new GenerationException(formatter);
        }
        try {
            newRole = ROLAPBuilderInformation.getOpposingRole(dataItemRole);
        }
        catch (IllegalArgumentException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ROLAPBuilderInformation.getCategoriesOnTheOtherAxis.UnacceptedRole.txt", new Object[0]);
            throw new GenerationException(formatter, (Throwable)e);
        }
        List<DataItem> listOfCategoriesOnOtherAxis = this.getCategoriesOnAxis(newRole);
        return listOfCategoriesOnOtherAxis;
    }

    public List<DataItem> getCategoriesOnTheSameAxis(DataItem dataItem) throws GenerationException {
        Role dataItemRole;
        try {
            dataItemRole = this._dataSelection.getResultItemRole(dataItem);
        }
        catch (MetadataException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ROLAPBuilderInformation.UnableToRetrieveRole.txt", new Object[0]);
            throw new GenerationException(formatter);
        }
        if (dataItemRole == null || dataItemRole != Role.COLUMN && dataItemRole != Role.ROW) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ROLAPBuilderInformation.getCategoriesOnTheOtherAxis.UnacceptedRole.txt", new Object[0]);
            throw new GenerationException(formatter);
        }
        List<DataItem> listOfCategoriesOnTheSameAxis = this.getCategoriesOnAxis(dataItemRole);
        return listOfCategoriesOnTheSameAxis;
    }

    public List<DataItem> getCategoriesOnAxis(Role matchRole) throws GenerationException {
        ArrayList<DataItem> listOfCategoriesOnAxis = new ArrayList<DataItem>();
        for (DataItem item : this._categoryItems) {
            Role itemRole = null;
            try {
                itemRole = this._dataSelection.getResultItemRole(item);
            }
            catch (MetadataException e) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ROLAPBuilderInformation.UnableToRetrieveRole.txt", new Object[0]);
                throw new GenerationException(formatter, (Throwable)e);
            }
            if (itemRole != matchRole) continue;
            listOfCategoriesOnAxis.add(item);
        }
        return listOfCategoriesOnAxis;
    }

    public boolean isDual() {
        return SubmitInstructionFactory.isDualResultSetEnabled(this.getDataSelection()) || this.getDataSelection().getQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA);
    }

    public static Role getOpposingRole(Role axisRole) {
        if (Role.COLUMN.equals(axisRole)) {
            return Role.ROW;
        }
        if (Role.ROW.equals(axisRole)) {
            return Role.COLUMN;
        }
        if (Role.HIDDEN.equals(axisRole)) {
            return Role.HIDDEN;
        }
        if (Role.BACKGROUND.equals(axisRole)) {
            return Role.BACKGROUND;
        }
        MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ROLAPBuilderInformation.getOpposingRole.fmt.txt", axisRole);
        IllegalArgumentException e = new IllegalArgumentException(msg.toString());
        e.initCause(new ExecutionException(msg));
        throw e;
    }

    private List<String> getReferencedRsids() throws MetadataException {
        ArrayList<BusinessModelResourceReferencer> items = new ArrayList<BusinessModelResourceReferencer>();
        items.addAll(this._dataSelection.getResultItems(Role.ROW));
        items.addAll(this._dataSelection.getResultItems(Role.COLUMN));
        items.addAll(this._dataSelection.getResultItems(Role.HIDDEN));
        items.addAll(this._dataSelection.getEffectiveFilters());
        items.addAll(this._dataSelection.getSteps(Role.ROW));
        items.addAll(this._dataSelection.getSteps(Role.COLUMN));
        items.addAll(this._dataSelection.getEffectiveSortOrderPrecedence());
        ArrayList<DataItem> itemsReferenced = new ArrayList<DataItem>();
        boolean dirty = true;
        while (dirty) {
            dirty = false;
            for (Object e : items) {
                if (e instanceof DataItem) {
                    DataItem item = (DataItem)e;
                    if (itemsReferenced.contains(item)) continue;
                    itemsReferenced.add(item);
                    dirty = true;
                    continue;
                }
                if (!(e instanceof BusinessModelResourceReferencer)) continue;
                BusinessModelResourceReferencer bmrr = (BusinessModelResourceReferencer)e;
                List<DataItem> list = bmrr.getResources(DataItem.class, 65531);
                if (e instanceof DataItemReference) {
                    list.removeAll(Collections.singletonList(((DataItemReference)e).getBaseDataItem()));
                }
                for (int i = 0; i < list.size(); ++i) {
                    DataItem reference = list.get(i);
                    if (itemsReferenced.contains(reference)) continue;
                    itemsReferenced.add(reference);
                    dirty = true;
                }
            }
            if (!dirty) continue;
            items = new ArrayList(itemsReferenced);
        }
        ArrayList<DataItem> finalItems = new ArrayList<DataItem>();
        while (!items.isEmpty()) {
            ArrayList<DataItem> arrayList = new ArrayList<DataItem>();
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                int i;
                DataItem item;
                Object e = iter.next();
                iter.remove();
                if (!(e instanceof DataItem) || finalItems.contains(item = (DataItem)e)) continue;
                finalItems.add(item);
                ExpressionInterface expr = item.getExpression();
                if (expr != null) {
                    List<DataItem> references = expr.getResources(DataItem.class, 65529);
                    for (i = 0; i < references.size(); ++i) {
                        DataItem reference = references.get(i);
                        if (itemsReferenced.contains(reference)) continue;
                        arrayList.add(reference);
                    }
                }
                List<StepInterface> steps = item.getSteps();
                for (i = 0; i < steps.size(); ++i) {
                    StepInterface step = steps.get(i);
                    List<DataItem> references2 = step.getResources(DataItem.class, 65529);
                    for (int j = 0; j < references2.size(); ++j) {
                        DataItem reference2 = references2.get(j);
                        if (itemsReferenced.contains(reference2)) continue;
                        arrayList.add(reference2);
                    }
                }
            }
            if (arrayList.isEmpty()) continue;
            items = arrayList;
        }
        items = finalItems;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object e : items) {
            DataItem item;
            String itemRSID;
            if (!(e instanceof DataItem) || (itemRSID = (item = (DataItem)e).getResultSetID()) == null || arrayList.contains(itemRSID)) continue;
            arrayList.add(itemRSID);
        }
        Map<String, Map<ExpressionInterface, String>> leaves = this.getDataItemLeavesMap();
        if (leaves != null) {
            for (Map.Entry<String, Map<ExpressionInterface, String>> entry : leaves.entrySet()) {
                String leaveRSID = entry.getKey();
                Map<ExpressionInterface, String> aliasMap = entry.getValue();
                if (aliasMap == null || aliasMap.size() <= 0) continue;
                if (!arrayList.contains(leaveRSID)) {
                    arrayList.add(leaveRSID);
                }
                for (Map.Entry<ExpressionInterface, String> aliasEntry : aliasMap.entrySet()) {
                    String extraDataItemRSID;
                    ExpressionInterface key = aliasEntry.getKey();
                    if (!(key instanceof DataItem)) continue;
                    DataItem origDataItem = (DataItem)key;
                    String origDiRsid = origDataItem.getResultSetID();
                    if (!arrayList.contains(origDiRsid)) {
                        arrayList.add(origDiRsid);
                    }
                    if (arrayList.contains(extraDataItemRSID = aliasEntry.getValue())) continue;
                    arrayList.add(extraDataItemRSID);
                }
            }
        }
        return arrayList;
    }

    public int getMeasureInsertionIndex(int axisIndex) throws ExecutionException {
        int firstMeasureIndex = -1;
        try {
            List<SelectedItem> selectedItems = axisIndex == 0 ? this._dataSelection.getSelectedItems(Role.COLUMN) : (axisIndex == 1 ? this._dataSelection.getSelectedItems(Role.ROW) : Collections.emptyList());
            int index = 0;
            for (SelectedItem item : selectedItems) {
                if (item.getItem().getUsage() == DataItemActionType.USAGE_AGGREGATE) {
                    firstMeasureIndex = index;
                    break;
                }
                ++index;
            }
        }
        catch (MetadataException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("ROLAPBuilderInformation.getMeasureInsertionIndex.SelectedValues.txt", new Object[0]);
            throw new ExecutionException(formatter, (Throwable)e);
        }
        return firstMeasureIndex;
    }

    public class AxisInformation {
        private static final String MEASURES_HEADER_NAME = "Measure";
        private int _axisIndex;
        private List<DataItem> _categoryItems = new ArrayList<DataItem>();
        private int[] _categoryIndices;
        private String[] _categoryIds;
        private Map<String, Integer> _categoryIndexMap = null;
        private List<DataItem> _measureItems = new ArrayList<DataItem>();
        private int[] _measureIndices;
        private String[] _measureIds;
        private String[] _measureLabels;
        private final List<String> _dimensionsNames = new ArrayList<String>();
        private final List<String> _hierarchiesNames = new ArrayList<String>();
        private final List<String> _uniqueLevelNames = new ArrayList<String>();

        public AxisInformation(int axisIndex) {
            this._axisIndex = axisIndex;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\naxisIndex=");
            sb.append(this._axisIndex);
            sb.append("\ncategoryIds=");
            sb.append(Arrays.toString(this._categoryIds));
            sb.append("\ncategoryIndices=");
            sb.append(Arrays.toString(this._categoryIndices));
            sb.append("\nmeasureIds=");
            sb.append(Arrays.toString(this._measureIds));
            sb.append("\nmeasureIndices=");
            sb.append(Arrays.toString(this._measureIndices));
            sb.append("\ndimensionNames=");
            sb.append(String.valueOf(this._dimensionsNames));
            sb.append("\nhierarchyNames=");
            sb.append(String.valueOf(this._hierarchiesNames));
            sb.append("\nuniqueLevelNames=");
            sb.append(String.valueOf(this._uniqueLevelNames));
            sb.append("\ntotalsType=");
            sb.append(this.getTotalType(ROLAPBuilderInformation.this.getDataSelection()));
            sb.append("\n)");
            return sb.toString();
        }

        public void setCategoryItems(List<DataItem> categoryItemsList, List<Integer> categoryIndicesList, Map<String, Integer> categoryIndexMap) {
            this._categoryItems = categoryItemsList;
            this._categoryIndices = ArrayUtils.makeIntArray(categoryIndicesList);
            ArrayList<String> categoryIdsList = new ArrayList<String>();
            for (DataItem item : this._categoryItems) {
                categoryIdsList.add(item.getResultSetID());
            }
            this._categoryIds = categoryIdsList.toArray(new String[0]);
            this._categoryIndexMap = categoryIndexMap;
        }

        public void setMeasureItems(List<DataItem> measureItemsList, List<Integer> measureIndicesList) {
            this._measureItems = measureItemsList;
            this._measureIndices = ArrayUtils.makeIntArray(measureIndicesList);
            ArrayList<String> measureLabelsList = new ArrayList<String>();
            ArrayList<String> measureIdsList = new ArrayList<String>();
            for (DataItem item : this._measureItems) {
                measureLabelsList.add(item.getLabel());
                measureIdsList.add(item.getResultSetID());
            }
            this._measureLabels = measureLabelsList.toArray(new String[0]);
            this._measureIds = measureIdsList.toArray(new String[0]);
        }

        public int getAxisIndex() {
            return this._axisIndex;
        }

        public List<DataItem> getMeasureDataItems() {
            return Collections.unmodifiableList(this._measureItems);
        }

        public List<DataItem> getCategoryDataItems() {
            return Collections.unmodifiableList(this._categoryItems);
        }

        public int[] getMeasureIndices() {
            return this._measureIndices;
        }

        public String[] getMeasureIds() {
            return this._measureIds;
        }

        public int[] getCategoryIndices() {
            return this._categoryIndices;
        }

        public int getCategoryIndex(DataItem di) {
            Integer index = this._categoryIndexMap.get(di.getResultSetID());
            return index;
        }

        public String[] getCategoryIds() {
            return this._categoryIds;
        }

        public int getCategoryCount() {
            return this.getCategoryDataItems().size();
        }

        public int getMeasureCount() {
            return this.getMeasureDataItems().size();
        }

        public String[] getMeasureLabels() {
            return this._measureLabels;
        }

        public boolean hasTotals() {
            return !this.axisHasTotalType(ROLAPBuilderInformation.this._dataSelection, BusinessQuery.TOTAL_NONE);
        }

        public boolean hasSubTotals() {
            return this.axisHasTotalType(ROLAPBuilderInformation.this._dataSelection, BusinessQuery.SUBTOTAL) || this.hasAllTotals();
        }

        public boolean hasGrandTotals() {
            return this.axisHasTotalType(ROLAPBuilderInformation.this._dataSelection, BusinessQuery.GRANDTOTAL) || this.axisHasTotalType(ROLAPBuilderInformation.this._dataSelection, BusinessQuery.AXISTOTAL) || this.hasAllTotals();
        }

        public boolean hasAllTotals() {
            return this.axisHasTotalType(ROLAPBuilderInformation.this._dataSelection, BusinessQuery.ALLTOTAL);
        }

        private boolean axisHasTotalType(DataSelection dataSelection, String totalType) {
            return this.getTotalType(dataSelection).equals(totalType);
        }

        public void addDimensionName(String name) {
            this._dimensionsNames.add(name);
        }

        public void addHierarchyName(String name) {
            this._hierarchiesNames.add(name);
        }

        public void addUniqueLevelName(String name) {
            this._uniqueLevelNames.add(name);
        }

        public String[] getDimensionsNames() {
            return this._dimensionsNames.toArray(new String[0]);
        }

        public String[] getHierarchiesNames() {
            return this._hierarchiesNames.toArray(new String[0]);
        }

        public String[] getUniqueLevelNames() {
            return this._uniqueLevelNames.toArray(new String[0]);
        }

        public String getElementId(int i) throws ExecutionException {
            int catCount = this.getCategoryCount();
            int measureInsertionIndex = ROLAPBuilderInformation.this.getMeasureInsertionIndex(this._axisIndex);
            if (measureInsertionIndex == -1) {
                if (i < catCount) {
                    return this.getCategoryIds()[i];
                }
                return this.getMeasureIds()[i - catCount];
            }
            if (i < measureInsertionIndex) {
                return this.getCategoryIds()[i];
            }
            if (i <= catCount && i != measureInsertionIndex) {
                return this.getCategoryIds()[i - 1];
            }
            throw new IllegalArgumentException();
        }

        public boolean isElementIndexMeasure(int i) throws ExecutionException {
            return i == ROLAPBuilderInformation.this.getMeasureInsertionIndex(this._axisIndex);
        }

        public String[] getAxisHeaders() throws ExecutionException {
            List<DataItem> categoryItems = this.getCategoryDataItems();
            int elementCount = categoryItems.size();
            int measureCount = this.getMeasureIds().length;
            if (measureCount > 0) {
                ++elementCount;
            }
            String[] axisHeaders = new String[elementCount];
            int measureInsertionIndex = this.getROLAPBuilderInformation().getMeasureInsertionIndex(this.getAxisIndex());
            Iterator<DataItem> categoryItemsIt = categoryItems.iterator();
            for (int i = 0; i < elementCount; ++i) {
                if (i == measureInsertionIndex) {
                    axisHeaders[i] = MEASURES_HEADER_NAME;
                    continue;
                }
                if (!categoryItemsIt.hasNext()) continue;
                DataItem item = categoryItemsIt.next();
                axisHeaders[i] = item.getLabel();
            }
            return axisHeaders;
        }

        public ROLAPBuilderInformation getROLAPBuilderInformation() {
            return ROLAPBuilderInformation.this;
        }

        public String getGrandTotalLabel() {
            return this.getTotalLabel(ROLAPBuilderInformation.this._dataSelection, BusinessQuery.GRANDTOTAL);
        }

        public String getSubTotalLabel() {
            return this.getTotalLabel(ROLAPBuilderInformation.this._dataSelection, BusinessQuery.SUBTOTAL);
        }

        private String getTotalLabel(DataSelection dataSelection, String typeOfTotal) {
            Role currentAxisRole = this.getAxisRole();
            return dataSelection.getTotalLabel(currentAxisRole, typeOfTotal);
        }

        public Role getTotalsRole() {
            return this.getAxisRole();
        }

        private String getTotalType(DataSelection dataSelection) {
            Role currentAxisRole = this.getTotalsRole();
            return dataSelection.getTotalType(currentAxisRole);
        }

        public Role getAxisRole() {
            if (this._axisIndex == 0) {
                return Role.COLUMN;
            }
            if (this._axisIndex == 1) {
                return Role.ROW;
            }
            return null;
        }

        public void updateTupleCount(int newTuples) throws MaxTuplesExceededException, MaxCellsExceededException {
            int[] nArray = ROLAPBuilderInformation.this._tupleCounts;
            int n = this._axisIndex;
            nArray[n] = nArray[n] + newTuples;
            if (ROLAPBuilderInformation.this._tupleCounts[0] + ROLAPBuilderInformation.this._tupleCounts[1] > ROLAPBuilderInformation.this._maxTupleCount) {
                throw new MaxTuplesExceededException(IQDataServicesResourceBundle.getMessageFormatter("ProcSummaryROLAPBuilder.buildAxisTupleElementNames.tooManyTuples.fmt.txt", ROLAPBuilderInformation.this._maxTupleCount));
            }
            if ((long)ROLAPBuilderInformation.this._tupleCounts[0] * (long)ROLAPBuilderInformation.this._tupleCounts[1] > ROLAPBuilderInformation.this._maxCellCount) {
                throw new MaxCellsExceededException(IQDataServicesResourceBundle.getMessageFormatter("ProcSummaryROLAPBuilder.buildAxisTupleElementNames.tooManyCells.fmt.txt", ROLAPBuilderInformation.this._maxCellCount));
            }
        }
    }
}

