/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryRankFilter;
import com.sas.iquery.strategies.sas.oma.ExpandedProcSummaryStatement;
import com.sas.iquery.strategies.sas.oma.FractionOfTotalUtilImpl;
import com.sas.iquery.strategies.sas.oma.summaryrolap.AbstractROLAPSASStatement;
import com.sas.iquery.strategies.sas.oma.summaryrolap.AxisTupleCriteria;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPBuilderInformation;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPFilterAndRankExaminer;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPStepGenerationUtil;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class ProcSummaryROLAPStatement
extends AbstractROLAPSASStatement {
    private String _summaryTableName;
    private ROLAPFilterAndRankExaminer _filterExaminer;
    private List<DataItem> _filteredMeasureItems = null;
    private boolean _ignoreDisabledTotals = false;
    protected static final String USE_NWAY_DEFAULT = "true";

    public ProcSummaryROLAPStatement(DataSelection dataSelection, ROLAPBuilderInformation rolapInfo, String baseTableName, String summaryTableName, ROLAPFilterAndRankExaminer filterExaminer) throws GenerationException {
        super(dataSelection, baseTableName, rolapInfo);
        this._summaryTableName = summaryTableName;
        this._filterExaminer = filterExaminer;
    }

    public boolean isIgnoreDisabledTotals() {
        return this._ignoreDisabledTotals;
    }

    public void setIgnoreDisabledTotals(boolean ignoreDisabledTotals) {
        this._ignoreDisabledTotals = ignoreDisabledTotals;
    }

    public void setSummaryTableName(String summaryTableName) {
        this._summaryTableName = summaryTableName;
    }

    public String getSummaryTableName() {
        return this._summaryTableName;
    }

    @Override
    public void prepareSQL() throws GenerationException {
        if (IQSystemProperties.isVerboseProcCommentsEnabled(this)) {
            this._stringBuff.append("/* using " + this.getClass().getName() + ": data selection = " + this._dataSelection.getIdentityString() + " */");
        }
        this._stringBuff.append(this.generateProcSummary());
    }

    public boolean isColumnOrderPreserved() throws GenerationException {
        List<DataItem> filteredMeasureItems = this.getFilteredMeasureItems();
        return ExpandedProcSummaryStatement.isColumnOrderPreserved(filteredMeasureItems);
    }

    private String generateProcSummary() throws GenerationException {
        List<DataItem> categoryItems = this.getCategoryItems();
        List<DataItem> filteredMeasureItems = this.getFilteredMeasureItems();
        if (categoryItems.isEmpty() || filteredMeasureItems.isEmpty()) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("ROLAPBuilderInformation.checkIsValid.atLeastOneMeasure.txt", new Object[0]);
            throw new GenerationException(mft);
        }
        boolean isAsync = IQSystemProperties.isSasSubmitAsync();
        boolean makeProcUseNway = ProcSummaryROLAPStatement.useNWay(this._dataSelection, this._rolapInfo, this._filterExaminer);
        ArrayList<DataItem> allCategories = new ArrayList<DataItem>(categoryItems);
        ExpandedProcSummaryStatement procSummary = new ExpandedProcSummaryStatement(this._dataSelection, this._baseTableName, true, makeProcUseNway, allCategories, filteredMeasureItems, this._summaryTableName, false, true, true, !isAsync, false, this._rolapInfo, false, this.isIgnoreDisabledTotals(), true);
        procSummary.setSQLFactory(this.getSQLFactory());
        procSummary.setDataSelectionProcessor(this.getDataSelectionProcessor());
        procSummary.prepareSQL();
        return procSummary.writeSQL();
    }

    static boolean useNWay(DataSelection dataSelection, ROLAPBuilderInformation rolapInfo, ROLAPFilterAndRankExaminer filterExaminer) throws GenerationException {
        List<DataItem> totalingCategories = ProcSummaryROLAPStatement.getTotalingCategories(dataSelection, rolapInfo);
        boolean isUseNway = Boolean.valueOf(System.getProperty("SASQueryServices.useNWAY", USE_NWAY_DEFAULT));
        boolean makeProcUseNway = false;
        if (isUseNway) {
            makeProcUseNway = ProcSummaryROLAPStatement.useNWay(dataSelection, rolapInfo, filterExaminer, totalingCategories);
        }
        return makeProcUseNway;
    }

    protected boolean skipItem(DataItem item) throws GenerationException {
        boolean isFotTotalItem = FractionOfTotalUtilImpl.isFractionOfTotalItem(item);
        if (isFotTotalItem) {
            try {
                Role role = this._dataSelection.getResultItemRole(item);
                boolean isNeededForPostProcess = this.getDataSelectionProcessor().isNeededForPostProcess(this._dataSelection, item, role);
                return !isNeededForPostProcess;
            }
            catch (MetadataException e) {
                throw new GenerationException(e);
            }
        }
        return false;
    }

    protected static boolean useNWay(DataSelection dataSelection, ROLAPBuilderInformation rolapInfo, ROLAPFilterAndRankExaminer filterExaminer, List<? extends DataItem> totalingCategories) throws GenerationException {
        List<DataItem> categories = rolapInfo.getCategoryItems();
        for (int c = 0; c < categories.size(); ++c) {
            Role role;
            DataItem category = categories.get(c);
            try {
                role = dataSelection.getResultItemRole(category);
            }
            catch (MetadataException e) {
                throw new GenerationException(e);
            }
            if (role != null && Role.isOutputResultRole(dataSelection, role)) continue;
            return false;
        }
        if (filterExaminer.hasPostAggregatedSubtotalFilters()) {
            return false;
        }
        int maxType = rolapInfo.getMaxTotalTypes();
        List postAggRCFilters = filterExaminer.getPostAggregationRowColumnFilters();
        for (int i = 0; i < postAggRCFilters.size(); ++i) {
            BusinessQueryDataBasedFilter bqdbf = (BusinessQueryDataBasedFilter)postAggRCFilters.get(i);
            try {
                AxisTupleCriteria axisTupleCriteria = new AxisTupleCriteria(rolapInfo, bqdbf.getLeftExpression());
                int type = axisTupleCriteria.makeRowColumnType();
                if (type >= maxType) continue;
                return false;
            }
            catch (MetadataException e) {
                throw new GenerationException(e);
            }
        }
        DataItem subTotalRankCategory = filterExaminer.getSubtotalRankCategory(null);
        if (subTotalRankCategory != null) {
            return false;
        }
        if (filterExaminer.getRowColumnRankFilter() != null) {
            BusinessQueryRankFilter tupleRank = filterExaminer.getRowColumnRankFilter();
            List rcRankQualifiers = filterExaminer.getRowColumnRankFilter().getRankQualifiers();
            try {
                AxisTupleCriteria axisTupleCriteria = new AxisTupleCriteria(rolapInfo, rcRankQualifiers);
                int type = 0;
                if ("Percent".equals(tupleRank.getRankType())) {
                    type = ROLAPStepGenerationUtil.getSumOfTotalTypeForCategories(axisTupleCriteria.getCategoriesWithNonTotalValueCriteria(), rolapInfo);
                } else if ("Count".equals(tupleRank.getRankType())) {
                    type = axisTupleCriteria.makeRowColumnType();
                }
                if (type < maxType) {
                    return false;
                }
            }
            catch (MetadataException e) {
                throw new GenerationException(e);
            }
        }
        List<SelectedItem> selectedItems = dataSelection.getSelectedItems();
        for (SelectedItem selectedItem : selectedItems) {
            DataItem resultItem = selectedItem.getItem();
            boolean isFotTotalItem = FractionOfTotalUtilImpl.isFractionOfTotalItem(resultItem);
            if (!isFotTotalItem) continue;
            return false;
        }
        return totalingCategories == null || totalingCategories.size() <= 0;
    }

    private static List<DataItem> getTotalingCategories(DataSelection dataSelection, ROLAPBuilderInformation rolapInfo) {
        boolean hasRowTotalsSort;
        boolean hasColTotalsSort;
        LinkedHashSet<DataItem> totalingForClasses = new LinkedHashSet<DataItem>();
        ROLAPBuilderInformation.AxisInformation columnAxisInfo = rolapInfo.getAxisInformation(0);
        ROLAPBuilderInformation.AxisInformation rowAxisInfo = rolapInfo.getAxisInformation(1);
        List<DataItem> colCategories = columnAxisInfo.getCategoryDataItems();
        List<DataItem> rowCategories = rowAxisInfo.getCategoryDataItems();
        boolean hasAllTotalsCol = columnAxisInfo.hasAllTotals();
        boolean hasSubTotalsCol = columnAxisInfo.hasSubTotals();
        boolean hasGrandTotalsCol = columnAxisInfo.hasGrandTotals();
        boolean hasTotalsCol = columnAxisInfo.hasTotals();
        BusinessQueryActionType colSortDir = dataSelection.getSortDirection(Role.COLUMN);
        boolean bl = hasColTotalsSort = colSortDir == BusinessQueryActionType.SORT_HIERARCHICAL_ASCENDING || colSortDir == BusinessQueryActionType.SORT_HIERARCHICAL_DESCENDING;
        if (hasAllTotalsCol || hasSubTotalsCol || hasGrandTotalsCol || hasTotalsCol || hasColTotalsSort) {
            totalingForClasses.addAll(colCategories);
        }
        boolean hasAllTotalsRow = rowAxisInfo.hasAllTotals();
        boolean hasSubTotalsRow = rowAxisInfo.hasSubTotals();
        boolean hasGrandTotalsRow = rowAxisInfo.hasGrandTotals();
        boolean hasTotalsRow = rowAxisInfo.hasTotals();
        BusinessQueryActionType rowSortDir = dataSelection.getSortDirection(Role.ROW);
        boolean bl2 = hasRowTotalsSort = rowSortDir == BusinessQueryActionType.SORT_HIERARCHICAL_ASCENDING || rowSortDir == BusinessQueryActionType.SORT_HIERARCHICAL_DESCENDING;
        if (hasAllTotalsRow || hasSubTotalsRow || hasGrandTotalsRow || hasTotalsRow || hasRowTotalsSort) {
            totalingForClasses.addAll(rowCategories);
        }
        return new ArrayList<DataItem>(totalingForClasses);
    }

    protected List<DataItem> getFilteredMeasureItems() throws GenerationException {
        if (this._filteredMeasureItems == null) {
            ArrayList<DataItem> measures = new ArrayList<DataItem>();
            List<DataItem> measureItems = this.getMeasureItems();
            for (DataItem dataItem : measureItems) {
                if (this.skipItem(dataItem)) continue;
                measures.add(dataItem);
            }
            this._filteredMeasureItems = measures;
        }
        return this._filteredMeasureItems;
    }

    public String toString() {
        return this.writeSQL();
    }
}

