/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.strategies.sas.oma.summaryrolap.SummaryROLAPGeneration;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataSelectionValidationUtil {
    private static final Logger _logger = LogManager.getLogger(DataSelectionValidationUtil.class);
    private static final Logger _rolapLogger = LogManager.getLogger(SummaryROLAPGeneration.class);

    public static void checkValid(DataSelection dataSelection) throws GenerationException {
        if (!dataSelection.isValid()) {
            List<Reason> reasons = dataSelection.getReasonsNotValid();
            if (_rolapLogger.isEnabled(Level.ERROR)) {
                Locale viewerLocale = LocaleUtilities.getDefaultViewerLocale(dataSelection);
                for (Reason reason : reasons) {
                    String reasonMessage = reason.getReasonString(viewerLocale);
                    _rolapLogger.error(reasonMessage);
                }
            }
            MessageFormatter baseMessage = IQDataServicesResourceBundle.getMessageFormatter("SQLGeneration.checkValid.invalid.txt", new Object[0]);
            MessageFormatter reasonListFormatter = Reason.getMessageFormatter(baseMessage, reasons, false);
            GenerationException e = new GenerationException(reasonListFormatter, reasons);
            throw e;
        }
    }
}

