/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLFromAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLWhereAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.sas.SQLSASFrom;
import com.sas.iquery.strategies.sas.oma.relational.join.JoinGenerationInterface;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.CommentStatement;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPFilterAndRankExaminer;
import com.sas.iquery.strategies.sas.oma.summaryrolap.RolapDataSelectionProcessor;
import com.sas.iquery.strategies.sas.oma.summaryrolap.composite.SQLSASROLAPSelect;
import com.sas.iquery.strategies.sas.oma.summaryrolap.composite.SQLSASROLAPViewFactory;
import com.sas.iquery.strategies.sas.oma.summaryrolap.composite.SQLSASROLAPWhere;
import java.util.List;
import java.util.Map;

public class DataExtractionStep {
    public static void addCode(List<SQLComponentAbstract> code, RolapDataSelectionProcessor dsProcessor, String detailTable) throws GenerationException {
        SQLFromAbstract sqlFrom = DataExtractionStep.generateFrom(dsProcessor);
        JoinGenerationInterface joinGenerator = sqlFrom.getJoinGenerator();
        dsProcessor.setJoinGenerator(joinGenerator);
        SQLSASROLAPSelect sqlSelect = DataExtractionStep.generateSelect(dsProcessor, joinGenerator);
        DataSelection leafDataItemsDS = dsProcessor.getLeafDataItemsDataSelection();
        Map<String, Map<ExpressionInterface, String>> dataItemLeavesMap = dsProcessor.getDataItemLeavesMap();
        ROLAPFilterAndRankExaminer filterExaminer = new ROLAPFilterAndRankExaminer(leafDataItemsDS, dataItemLeavesMap);
        List<FilterItem> whereFilters = filterExaminer.getPreAggregationFilters();
        SQLWhereAbstract sqlWhere = DataExtractionStep.generateWhere(dsProcessor, whereFilters, joinGenerator);
        if (IQSystemProperties.isVerboseProcCommentsEnabled(DataExtractionStep.class)) {
            code.add(DataExtractionStep.generateComment(dsProcessor, leafDataItemsDS, dataItemLeavesMap));
        }
        SQLStatementFactory.addStartProcSql(code, dsProcessor, true, null);
        SQLStatementFactory.addStartSqlStatement(code, dsProcessor);
        SQLStatementFactory.addCreateViewAs(code, dsProcessor, detailTable);
        code.add(sqlSelect);
        code.add(sqlFrom);
        code.add(sqlWhere);
        SQLStatementFactory.addEndSqlStatement(code, dsProcessor);
        SQLStatementFactory.addEndProcSql(code, dsProcessor);
    }

    private static CommentStatement generateComment(RolapDataSelectionProcessor dsProcessor, DataSelection leafDataItemsDS, Map<String, Map<ExpressionInterface, String>> dataItemLeavesMap) {
        CommentStatement commentBlock = new CommentStatement("DataExtractionStep");
        commentBlock.commentOnDataSelection(dsProcessor.getDataSelection());
        commentBlock.getComments().append("\n --- Leaf DataSelection ---");
        commentBlock.commentOnDataSelection(leafDataItemsDS);
        commentBlock.getComments().append("\n --- Leaves Map ---");
        for (Map.Entry<String, Map<ExpressionInterface, String>> entry : dataItemLeavesMap.entrySet()) {
            String key = entry.getKey();
            Map<ExpressionInterface, String> value = entry.getValue();
            commentBlock.getComments().append("\n  entry: ");
            commentBlock.getComments().append("\n    key " + key + " (" + key.getClass().getName() + ")");
            commentBlock.getComments().append("\n    value " + value + (value == null ? "" : " (" + value.getClass().getName() + ")"));
            for (Map.Entry<ExpressionInterface, String> entry2 : value.entrySet()) {
                ExpressionInterface key2 = entry2.getKey();
                String value2 = entry2.getValue();
                commentBlock.getComments().append("\n      entry: ");
                commentBlock.getComments().append("\n        key " + key2 + " (" + key2.getClass().getName() + ")");
                commentBlock.getComments().append("\n        value " + value2 + (value2 == null ? "" : " (" + value2.getClass().getName() + ")"));
            }
        }
        return commentBlock;
    }

    private static SQLSASROLAPSelect generateSelect(RolapDataSelectionProcessor dsProcessor, JoinGenerationInterface joinGenerator) throws GenerationException {
        DataSelection leafDataItemsDataSelection = dsProcessor.getLeafDataItemsDataSelection();
        SQLSASROLAPViewFactory factory = new SQLSASROLAPViewFactory(leafDataItemsDataSelection);
        SQLSASROLAPSelect sqlSelect = new SQLSASROLAPSelect();
        sqlSelect.setSQLFactory(factory);
        sqlSelect.setDataSelectionProcessor(dsProcessor);
        sqlSelect.setDataSelection(leafDataItemsDataSelection);
        sqlSelect.setJoinGenerator(joinGenerator);
        sqlSelect.prepareSQL();
        return sqlSelect;
    }

    private static SQLFromAbstract generateFrom(RolapDataSelectionProcessor dsProcessor) throws GenerationException {
        DataSelection leafDataItemsDataSelection = dsProcessor.getLeafDataItemsDataSelection();
        SQLSASFrom sqlFrom = new SQLSASFrom();
        sqlFrom.setSQLFactory(new SQLSASROLAPViewFactory(leafDataItemsDataSelection));
        sqlFrom.setDataSelectionProcessor(dsProcessor);
        sqlFrom.setDataSelection(leafDataItemsDataSelection);
        ((SQLComponentAbstract)sqlFrom).prepareSQL();
        return sqlFrom;
    }

    private static SQLWhereAbstract generateWhere(RolapDataSelectionProcessor dsProcessor, List<FilterItem> whereFilters, JoinGenerationInterface joinGenerator) throws GenerationException {
        DataSelection leafDataItemsDataSelection = dsProcessor.getLeafDataItemsDataSelection();
        SQLSASROLAPWhere sqlWhere = new SQLSASROLAPWhere();
        sqlWhere.setSQLFactory(new SQLSASROLAPViewFactory(leafDataItemsDataSelection));
        sqlWhere.setDataSelectionProcessor(dsProcessor);
        sqlWhere.setDataSelection(leafDataItemsDataSelection);
        sqlWhere.setFilterList(whereFilters);
        sqlWhere.setJoinGenerator(joinGenerator);
        ((SQLComponentAbstract)sqlWhere).prepareSQL();
        return sqlWhere;
    }
}

