/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.BusinessQueryTotalLocationType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryRankFilter;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import com.sas.iquery.strategies.sas.oma.summaryrolap.AxisTupleCriteria;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPBuilderInformation;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPFilterAndRankExaminer;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPStepGenerationUtil;
import com.sas.iquery.strategies.sas.oma.summaryrolap.RolapDataSelectionProcessor;
import com.sas.iquery.strategies.sas.oma.summaryrolap.builder.ROLAPUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class AxisBuildingAndSortingStep {
    private static final String SUBTOTAL_COLUMN_PREFIX = "_subTotal_";
    private static final String ISDETAIL_COLUMN_PREFIX = "_isDetail_";
    private static final String FORMATTED_COLUMN_PREFIX = "_formatted_";

    public static void addCode(List<SQLComponentAbstract> code, RolapDataSelectionProcessor dsProcessor, String summaryFinalTable, String axisTablesStem, String[] tupleTableNames) throws GenerationException {
        try {
            AxisBuildingAndSortingStep.addAxisTuples(code, dsProcessor, Role.COLUMN, summaryFinalTable, axisTablesStem, tupleTableNames);
            AxisBuildingAndSortingStep.addAxisTuples(code, dsProcessor, Role.ROW, summaryFinalTable, axisTablesStem, tupleTableNames);
        }
        catch (MetadataException e) {
            throw new GenerationException(e);
        }
    }

    private static void addAxisTuples(List<SQLComponentAbstract> code, RolapDataSelectionProcessor dsProcessor, Role currentAxisRole, String inputTable, String axisTablesStem, String[] axisTableNames) throws GenerationException, MetadataException {
        String axisTupleTableName;
        LinkedHashSet<String> dropPrefixes = new LinkedHashSet<String>();
        AxisSortingInfo sortingInfo = new AxisSortingInfo(dsProcessor, currentAxisRole);
        if (!sortingInfo.isSortApplicable()) {
            return;
        }
        int axisIndex = sortingInfo.getAxisIndex();
        SQLStatementFactory.addText(code, "\n\n/**** Build axis " + axisIndex + " tuples ****/\n");
        int fileNameIndex = axisIndex < 0 ? axisTableNames.length + axisIndex : axisIndex;
        axisTableNames[fileNameIndex] = axisTupleTableName = axisTablesStem + fileNameIndex + "Tuples";
        StringBuffer dataStep = new StringBuffer();
        dataStep.append("\ndata ").append(axisTupleTableName).append(";\n");
        dataStep.append("\tset ").append(inputTable).append(";\n");
        AxisBuildingAndSortingStep.appendOpposingAxisTypeCriteria(dataStep, sortingInfo);
        AxisBuildingAndSortingStep.appendOpposingAxisCriteria(dataStep, dsProcessor, sortingInfo);
        dataStep.append("\n");
        AxisBuildingAndSortingStep.appendDropOpposingCategories(dataStep, dsProcessor, sortingInfo);
        dataStep.append("\n");
        AxisBuildingAndSortingStep.appendFormatCategories(dataStep, dsProcessor, sortingInfo, dropPrefixes);
        AxisBuildingAndSortingStep.appendIsDetailInfo(dataStep, dsProcessor, sortingInfo);
        AxisBuildingAndSortingStep.appendDropHidden(dataStep, dsProcessor);
        dataStep.append("\n");
        dataStep.append("run;\n\n");
        SQLStatementFactory.addText(code, dataStep);
        if (sortingInfo.isPureCategorySort()) {
            String sortByCode = AxisBuildingAndSortingStep.generateSortingByCode(dsProcessor, sortingInfo, dropPrefixes);
            AxisBuildingAndSortingStep.addProcSortStatement(code, axisTupleTableName, sortByCode, dropPrefixes, false);
            AxisBuildingAndSortingStep.addCategoryAndTotalFilter(code, dsProcessor, sortingInfo, axisTupleTableName, sortByCode, dropPrefixes, true);
        } else {
            String sortByCode = AxisBuildingAndSortingStep.generateHierarchySortByCode(dsProcessor, sortingInfo, dropPrefixes);
            AxisBuildingAndSortingStep.addProcSortStatement(code, axisTupleTableName, sortByCode, dropPrefixes, false);
            AxisBuildingAndSortingStep.addCategoryAndTotalFilter(code, dsProcessor, sortingInfo, axisTupleTableName, sortByCode, dropPrefixes, false);
            String sortingByCode = AxisBuildingAndSortingStep.generateSortingByCode(dsProcessor, sortingInfo, dropPrefixes);
            AxisBuildingAndSortingStep.addProcSortStatement(code, axisTupleTableName, sortingByCode, dropPrefixes, true);
        }
    }

    private static void addCategoryAndTotalFilter(List<SQLComponentAbstract> code, RolapDataSelectionProcessor dsProcessor, AxisSortingInfo sortingInfo, String axisTupleTableName, String sortByCode, Collection<String> dropPrefixes, boolean dropNow) throws GenerationException {
        String firstTupleValueFilter = AxisBuildingAndSortingStep.generateFirstTupleValueFilter(dsProcessor, sortingInfo, dropPrefixes);
        String subtotalColumns = AxisBuildingAndSortingStep.generateSubtotalColumns(dsProcessor, sortingInfo, dropPrefixes);
        String outputDataSetOptions = dropNow ? AxisBuildingAndSortingStep.generateDropPrefixOption(dropPrefixes) : "";
        SQLStatementFactory.addText(code, "/* keep only rows which are to be shown as tuples */\ndata " + axisTupleTableName + outputDataSetOptions + ";\n\tset " + axisTupleTableName + ";\n\tby " + sortByCode + ";\n" + firstTupleValueFilter + "\n" + subtotalColumns + "\n\t/* filter out totals which should not be shown */\n" + AxisBuildingAndSortingStep.generateTotalFilter(sortingInfo) + "run;\n\n");
    }

    private static void addProcSortStatement(List<SQLComponentAbstract> code, String axisTupleTableName, String sortByCode, Collection<String> dropPrefixes, boolean dropNow) {
        String outputDataSetOptions = dropNow ? AxisBuildingAndSortingStep.generateDropPrefixOption(dropPrefixes) : "";
        SQLStatementFactory.addText(code, "/* use sort to create hierarchies */\nproc sort data=" + axisTupleTableName + " out=" + axisTupleTableName + outputDataSetOptions + ";\n\tby " + sortByCode + ";\nquit;\n\n");
    }

    private static String generateDropPrefixOption(Collection<String> dropPrefixes) {
        StringBuffer outputOptions = new StringBuffer();
        if (dropPrefixes != null && dropPrefixes.size() > 0) {
            LinkedHashSet<String> dropOrder = new LinkedHashSet<String>();
            if (dropPrefixes.contains(ISDETAIL_COLUMN_PREFIX)) {
                dropOrder.add(ISDETAIL_COLUMN_PREFIX);
            }
            if (dropPrefixes.contains(SUBTOTAL_COLUMN_PREFIX)) {
                dropOrder.add(SUBTOTAL_COLUMN_PREFIX);
            }
            if (dropPrefixes.contains(FORMATTED_COLUMN_PREFIX)) {
                dropOrder.add(FORMATTED_COLUMN_PREFIX);
            }
            dropOrder.addAll(dropPrefixes);
            outputOptions.append("(drop=");
            String seperator = "";
            for (String prefix : dropOrder) {
                outputOptions.append(seperator).append(prefix).append(':');
                seperator = " ";
            }
            outputOptions.append(')');
        }
        return outputOptions.toString();
    }

    private static String generateFirstTupleValueFilter(RolapDataSelectionProcessor dsProcessor, AxisSortingInfo sortingInfo, Collection<String> dropPrefixes) throws GenerationException {
        List<DataItem> categories = sortingInfo.getCurrentAxisInformation().getCategoryDataItems();
        if (categories.isEmpty()) {
            return "";
        }
        DataItem lastCategory = categories.get(categories.size() - 1);
        StringBuffer code = new StringBuffer();
        code.append("\n\tif first.");
        AxisBuildingAndSortingStep.appendCategorySortingReference(code, dsProcessor, lastCategory, dropPrefixes);
        code.append(";");
        return code.toString();
    }

    private static void appendCategorySortingReference(StringBuffer dataStep, RolapDataSelectionProcessor dsProcessor, DataItem category, Collection<String> dropPrefixes) throws GenerationException {
        String resultSetID = category.getResultSetID();
        if (AxisBuildingAndSortingStep.requiresFormattedSort(category)) {
            dataStep.append(dsProcessor.generateDataStepVar(FORMATTED_COLUMN_PREFIX + resultSetID));
            dropPrefixes.add(FORMATTED_COLUMN_PREFIX);
        } else {
            dataStep.append(dsProcessor.generateDataStepVar(resultSetID));
        }
    }

    private static String generateSortingByCode(RolapDataSelectionProcessor dsProcessor, AxisSortingInfo sortingInfo, Collection<String> dropPrefixes) throws GenerationException {
        boolean totalsAtEnd = AxisBuildingAndSortingStep.areTotalsAtBottomAndRightSide(dsProcessor);
        StringBuffer code = new StringBuffer();
        List<DataItem> categories = sortingInfo.getCurrentAxisInformation().getCategoryDataItems();
        Iterator<DataItem> iter = categories.iterator();
        while (iter.hasNext()) {
            DataItem category = iter.next();
            code.append("\n ");
            AxisBuildingAndSortingStep.appendSortDetailsVsTotals(code, dsProcessor, category, totalsAtEnd, dropPrefixes);
            code.append(" ");
            if (iter.hasNext()) {
                if (sortingInfo.isOuterCategorySort()) {
                    AxisBuildingAndSortingStep.appendCategoryItemSortCriteria(code, dsProcessor, category, dropPrefixes);
                    continue;
                }
                AxisBuildingAndSortingStep.appendSortByMeasureSubtotal(code, dsProcessor, category, sortingInfo, dropPrefixes);
                continue;
            }
            if (sortingInfo.isInnerMostCategoryMeasureSorted()) {
                AxisBuildingAndSortingStep.appendSortByMeasure(code, dsProcessor, sortingInfo);
                continue;
            }
            AxisBuildingAndSortingStep.appendCategoryItemSortCriteria(code, dsProcessor, category, dropPrefixes);
        }
        return code.toString();
    }

    private static String generateSubtotalColumns(RolapDataSelectionProcessor dsProcessor, AxisSortingInfo sortingInfo, Collection<String> dropPrefixes) throws GenerationException {
        if (!sortingInfo.hasMeasureSort()) {
            return "";
        }
        StringBuffer code = new StringBuffer();
        List<DataItem> dataItems = sortingInfo.getCurrentAxisInformation().getCategoryDataItems();
        List<DataItem> categoriesExceptLast = dataItems.subList(0, dataItems.size() - 1);
        for (DataItem category : categoriesExceptLast) {
            String subTotalColumnName = dsProcessor.generateDataStepVar(SUBTOTAL_COLUMN_PREFIX + category.getResultSetID());
            dropPrefixes.add(SUBTOTAL_COLUMN_PREFIX);
            code.append("\tretain ");
            code.append(subTotalColumnName);
            code.append(";\n\n");
            code.append("\tif first.");
            AxisBuildingAndSortingStep.appendCategorySortingReference(code, dsProcessor, category, dropPrefixes);
            code.append(" then ");
            code.append(subTotalColumnName);
            code.append(" = ");
            code.append(dsProcessor.generateDataStepVar(sortingInfo.getSortingMeasure().getResultSetID()));
            code.append(";\n\n");
        }
        return code.toString();
    }

    private static String generateHierarchySortByCode(RolapDataSelectionProcessor dsProcessor, AxisSortingInfo sortingInfo, Collection<String> dropPrefixes) throws GenerationException {
        StringBuffer code = new StringBuffer();
        List<DataItem> categories = sortingInfo.getCurrentAxisInformation().getCategoryDataItems();
        for (DataItem category : categories) {
            code.append(" _isDetail_");
            code.append(dsProcessor.generateDataStepVar(category.getResultSetID()));
            code.append(" ");
            AxisBuildingAndSortingStep.appendCategorySortingReference(code, dsProcessor, category, dropPrefixes);
        }
        if (sortingInfo.hasMeasureSort()) {
            code.append(" \n descending ");
            code.append(dsProcessor.generateDataStepVar(sortingInfo.getSortingMeasure().getResultSetID()));
        }
        return code.toString();
    }

    private static void appendOpposingAxisTypeCriteria(StringBuffer dataStep, AxisSortingInfo sortingInfo) throws MetadataException, GenerationException {
        dataStep.append("\n\tif _TYPE_ = '").append(AxisBuildingAndSortingStep.makeOpposingTypeMask(sortingInfo)).append("'b;\n");
    }

    private static void appendIsDetailInfo(StringBuffer dataStep, RolapDataSelectionProcessor dsProcessor, AxisSortingInfo sortingInfo) throws GenerationException {
        ROLAPBuilderInformation.AxisInformation axisInfo = sortingInfo.getCurrentAxisInformation();
        List<DataItem> categoriesOnAxis = axisInfo.getCategoryDataItems();
        if (categoriesOnAxis.isEmpty()) {
            return;
        }
        dataStep.append("\t/*Generate information about the current row - is it a detail value or a subtotal*/\n");
        dataStep.append("\tlength DEFAULT=3;\n");
        Iterator<DataItem> iterator = categoriesOnAxis.iterator();
        while (iterator.hasNext()) {
            DataItem dataItem;
            DataItem category = dataItem = iterator.next();
            dataStep.append("\t");
            dataStep.append(dsProcessor.generateDataStepVar(ISDETAIL_COLUMN_PREFIX + category.getResultSetID()));
            dataStep.append("= (_TYPE_ ='");
            String mask = AxisBuildingAndSortingStep.generateSingleCategoryTypeBitMask(axisInfo.getCategoryIndex(category), axisInfo.getROLAPBuilderInformation().getCategoryCount());
            dataStep.append(mask);
            dataStep.append("'b);\n");
        }
    }

    private static String generateSingleCategoryTypeBitMask(int categoryIndex, int categoryCount) {
        char[] chars = new char[categoryCount];
        for (int i = 0; i < categoryCount; ++i) {
            chars[i] = i == categoryIndex - 1 ? 49 : 46;
        }
        return new String(chars);
    }

    private static void appendDropOpposingCategories(StringBuffer dataStep, RolapDataSelectionProcessor dsProcessor, AxisSortingInfo sortingInfo) throws GenerationException {
        List<DataItem> opposingCategories = sortingInfo.getOpposingAxisInformation().getCategoryDataItems();
        if (opposingCategories.isEmpty()) {
            return;
        }
        dataStep.append("\t/*only keep the categories on the axis we are sorting on*/\n");
        dataStep.append("\tdrop");
        for (DataItem dataItem : opposingCategories) {
            String id = dsProcessor.generateDataStepVar(dataItem.getResultSetID());
            dataStep.append(" ");
            dataStep.append(id);
        }
        dataStep.append(";\n");
    }

    private static void appendDropHidden(StringBuffer dataStep, RolapDataSelectionProcessor dsProcessor) throws GenerationException {
        DataSelection dataSelDrop = dsProcessor.getDataSelection();
        List<SelectedItem> selectedItemsToCheck = dataSelDrop.getSelectedItems();
        int oneDropStat = 0;
        for (int index = 0; index < selectedItemsToCheck.size(); ++index) {
            SelectedItem selectedItem = selectedItemsToCheck.get(index);
            Role role = selectedItem.getRole();
            DataItem resultItemToCheck = selectedItem.getItem();
            boolean isOutputResultItem = Role.isOutputResultRole(dataSelDrop, role);
            boolean isUsedByRankResultItem = dsProcessor.isUsedByRankResultItem(resultItemToCheck);
            if (isOutputResultItem || isUsedByRankResultItem) continue;
            if (oneDropStat == 0) {
                dataStep.append("   /*drop dataItems that are hidden but used above to perform a join or filter.  They can be used but not seen*/\n");
                dataStep.append("   drop");
                ++oneDropStat;
            }
            String id = dsProcessor.generateDataStepVar(resultItemToCheck.getResultSetID());
            dataStep.append(" ");
            dataStep.append(id);
        }
        if (oneDropStat > 0) {
            dataStep.append(";\n");
        }
    }

    private static void appendFormatCategories(StringBuffer dataStep, RolapDataSelectionProcessor dsProcessor, AxisSortingInfo sortingInfo, Collection<String> dropPrefixes) throws GenerationException {
        boolean written = false;
        List<DataItem> categories = sortingInfo.getCurrentAxisInformation().getCategoryDataItems();
        for (DataItem dataItem : categories) {
            boolean useFormat;
            DataItem category = dataItem;
            if (!AxisBuildingAndSortingStep.requiresFormattedSort(category)) continue;
            if (!written) {
                dataStep.append("\t/* format categories which are to be sorted on formatted value */\n");
                written = true;
            }
            dataStep.append("\t");
            AxisBuildingAndSortingStep.appendCategorySortingReference(dataStep, dsProcessor, category, dropPrefixes);
            String format = GenerationUtil.generateFormat(category);
            String id = dsProcessor.generateDataStepVar(category.getResultSetID());
            dataStep.append(" = ");
            boolean bl = useFormat = format != null && format.trim().length() > 0 && !"$.".equals(format);
            if (!useFormat) {
                dataStep.append(id);
            } else {
                dataStep.append(GenerationUtil.generateDataStepPut(id, format));
            }
            dataStep.append(";\n");
        }
        if (written) {
            dataStep.append("\n");
        }
    }

    private static boolean requiresFormattedSort(DataItem category) throws GenerationException {
        return GenerationUtil.useFormattedValueForSorting(category) && GenerationUtil.isFormatCompatibleWithType(category);
    }

    private static void appendOpposingAxisCriteria(StringBuffer dataStep, RolapDataSelectionProcessor dsProcessor, AxisSortingInfo sortingInfo) throws GenerationException {
        List sortingCriteriaValues = sortingInfo.getNonTotalSortCriteriaValues();
        if (!sortingInfo.hasMeasureSort() || sortingInfo.getNonTotalSortCriteriaValues().isEmpty()) {
            return;
        }
        dataStep.append("\n\t/* identify a specific column and put missings for values which are really results of empty crossings */\n");
        dataStep.append("\tif not(");
        List<DataItem> categoryList = sortingInfo.getOpposingAxisInformation().getCategoryDataItems();
        ROLAPBuilderInformation rolapInfo = sortingInfo.getRolapBuilderInformation();
        DataSelection ds = rolapInfo.getDataSelection();
        ROLAPFilterAndRankExaminer filterExaminer = new ROLAPFilterAndRankExaminer(ds);
        BusinessQueryRankFilter tupleRank = filterExaminer.getRowColumnRankFilter();
        ArrayList<DataItem> whereTupleCats = new ArrayList<DataItem>();
        ArrayList<String> whereTupleValues = new ArrayList<String>();
        if (categoryList.size() == 0 && tupleRank != null) {
            List checkOtherQual = tupleRank.getRankQualifiers();
            List<DataItem> hiddenOnTheSameAxis = rolapInfo.getHiddenCategoryItems();
            if (checkOtherQual.size() > 1 && hiddenOnTheSameAxis.size() > 0) {
                ArrayList<DataItem> hiddenCategoryList = new ArrayList<DataItem>();
                Iterator<DataItem> iterator = hiddenOnTheSameAxis.iterator();
                while (iterator.hasNext()) {
                    DataItem dataItem;
                    DataItem category = dataItem = iterator.next();
                    hiddenCategoryList.add(category);
                }
                ROLAPStepGenerationUtil.getTupleCriteria(hiddenCategoryList, sortingCriteriaValues, whereTupleCats, whereTupleValues);
            } else {
                ROLAPStepGenerationUtil.getTupleCriteria(categoryList, sortingCriteriaValues, whereTupleCats, whereTupleValues);
            }
        } else {
            ROLAPStepGenerationUtil.getTupleCriteria(categoryList, sortingCriteriaValues, whereTupleCats, whereTupleValues);
        }
        for (int i = 0; i < whereTupleCats.size(); ++i) {
            boolean useFormat;
            if (i > 0) {
                dataStep.append("AND\n\t       ");
            }
            DataItem itemFound = (DataItem)whereTupleCats.get(i);
            String categoryAlias = dsProcessor.generateDataStepVar(itemFound.getResultSetID());
            String format = GenerationUtil.generateFormat(itemFound);
            boolean bl = useFormat = format != null && format.trim().length() > 0 && !format.equals("$.");
            if (useFormat) {
                dataStep.append(GenerationUtil.generateDataStepPut(categoryAlias, format));
            } else {
                dataStep.append(categoryAlias);
            }
            dataStep.append("=");
            dataStep.append(GenerationUtil.generateQuotedLiteral((String)whereTupleValues.get(i)));
            dataStep.append(" ");
        }
        String measureId = dsProcessor.generateDataStepVar(sortingInfo.getSortingMeasure().getResultSetID());
        dataStep.append(")").append(whereTupleCats.size() > 1 ? "\n\t " : "").append(" then ").append(measureId).append("=.;\n");
    }

    private static String makeOpposingTypeMask(AxisSortingInfo sortingInfo) throws MetadataException, GenerationException {
        DataSelection dataSelection = sortingInfo.getDataSelection();
        List nonTotalSortCategories = sortingInfo.getNonTotalSortCategories();
        List<DataItem> hiddenCategories = sortingInfo.getRolapBuilderInformation().getHiddenCategoryItems();
        StringBuffer typeMask = new StringBuffer();
        List<DataItem> categories = sortingInfo.getRolapBuilderInformation().getCategoryItems();
        Iterator<DataItem> iterator = categories.iterator();
        while (iterator.hasNext()) {
            DataItem dataItem;
            DataItem category = dataItem = iterator.next();
            Role categoryRole = dataSelection.getResultItemRole(category);
            boolean isOutputResultItem = Role.isOutputResultRole(dataSelection, categoryRole);
            if (!sortingInfo.getAxisRole().equals(categoryRole)) {
                if (sortingInfo.isPureCategorySort() || nonTotalSortCategories.contains(category)) {
                    if (isOutputResultItem && !hiddenCategories.contains(category)) {
                        typeMask.append('1');
                        continue;
                    }
                    typeMask.append('0');
                    continue;
                }
                typeMask.append('0');
                continue;
            }
            typeMask.append('.');
        }
        return typeMask.toString();
    }

    private static String generateTotalFilter(AxisSortingInfo sortingInfo) {
        ROLAPBuilderInformation.AxisInformation currentAxisInfo = sortingInfo.getCurrentAxisInformation();
        int categoryCount = sortingInfo.getRolapBuilderInformation().getCategoryCount();
        int[] categoryIndices = currentAxisInfo.getCategoryIndices();
        ArrayList<String> masks = new ArrayList<String>();
        masks.add(ROLAPUtil.makeDetailMask(categoryIndices, categoryCount));
        if (currentAxisInfo.hasSubTotals()) {
            masks.addAll(ROLAPUtil.makeSubtotalMasks(categoryIndices, categoryCount));
        }
        if (currentAxisInfo.hasGrandTotals()) {
            masks.add(ROLAPUtil.makeGrandTotalMask(categoryIndices, categoryCount));
        }
        StringBuffer code = new StringBuffer();
        code.append("\tif ");
        Iterator iter = masks.iterator();
        while (iter.hasNext()) {
            String mask = (String)iter.next();
            code.append("_type_ = '");
            code.append(mask);
            code.append("'b");
            if (!iter.hasNext()) continue;
            code.append(" or ");
        }
        code.append(";\n");
        return code.toString();
    }

    private static boolean areTotalsAtBottomAndRightSide(RolapDataSelectionProcessor dsProcessor) {
        BusinessQueryTotalLocationType totalLocation = dsProcessor.getActualDataSelection().getTotalLocation();
        boolean totalsAtEnd = true;
        if (totalLocation == BusinessQueryTotalLocationType.TOTAL_TOTAL_ROW_TOP_COLUMN_LEFT) {
            totalsAtEnd = false;
        }
        return totalsAtEnd;
    }

    private static void appendSortDetailsVsTotals(StringBuffer code, RolapDataSelectionProcessor dsProcessor, DataItem category, boolean totalsAtEnd, Collection<String> dropPrefixes) throws GenerationException {
        String categoryId = category.getResultSetID();
        String isDetailColumnName = dsProcessor.generateDataStepVar(ISDETAIL_COLUMN_PREFIX + categoryId);
        dropPrefixes.add(ISDETAIL_COLUMN_PREFIX);
        if (totalsAtEnd) {
            code.append("descending ");
        }
        code.append(isDetailColumnName);
    }

    private static void appendCategoryItemSortCriteria(StringBuffer code, RolapDataSelectionProcessor dsProcessor, DataItem category, Collection<String> dropPrefixes) throws GenerationException {
        if (category.getSortDirection().equals(DataItemActionType.SORT_DESCENDING)) {
            code.append("descending ");
        }
        AxisBuildingAndSortingStep.appendCategorySortingReference(code, dsProcessor, category, dropPrefixes);
    }

    private static void appendSortByMeasureSubtotal(StringBuffer code, RolapDataSelectionProcessor dsProcessor, DataItem category, AxisSortingInfo sortingInfo, Collection<String> dropPrefixes) throws GenerationException {
        String categoryId = category.getResultSetID();
        if (sortingInfo.isMeasureSortDescending()) {
            code.append("descending ");
        }
        String subTotalColumnName = dsProcessor.generateDataStepVar(SUBTOTAL_COLUMN_PREFIX + categoryId);
        dropPrefixes.add(SUBTOTAL_COLUMN_PREFIX);
        code.append(subTotalColumnName);
    }

    private static void appendSortByMeasure(StringBuffer code, RolapDataSelectionProcessor dsProcessor, AxisSortingInfo sortingInfo) throws GenerationException {
        DataItem measure = sortingInfo.getSortingMeasure();
        if (sortingInfo.isMeasureSortDescending()) {
            code.append("descending ");
        }
        String measureId = measure.getResultSetID();
        String measureColumnName = dsProcessor.generateDataStepVar(measureId);
        code.append(measureColumnName);
    }

    private static class AxisSortingInfo {
        private AxisTupleCriteria _sortCriteria;
        private DataSelection _dataSelection;
        private Role _axisRole;
        private boolean _hasExplicitMeasureSort;
        private ROLAPFilterAndRankExaminer _filterExaminer;
        private ROLAPBuilderInformation _rolapBuilderInformation;

        private AxisSortingInfo(RolapDataSelectionProcessor dsProcessor, Role axisRole) throws MetadataException, GenerationException {
            this._dataSelection = dsProcessor.getDataSelection();
            this._axisRole = axisRole;
            this._rolapBuilderInformation = new ROLAPBuilderInformation(this._dataSelection);
            this._filterExaminer = new ROLAPFilterAndRankExaminer(this._dataSelection);
            this.initializeMeasureSortInfo(axisRole);
        }

        private void initializeMeasureSortInfo(Role axisRole) throws GenerationException, MetadataException {
            List<Object> explicitSortCriteria = this._dataSelection.getSortCriteria(axisRole);
            if (explicitSortCriteria.isEmpty()) {
                this._hasExplicitMeasureSort = false;
            } else {
                this._sortCriteria = new AxisTupleCriteria(this._rolapBuilderInformation, explicitSortCriteria);
                this._hasExplicitMeasureSort = true;
            }
            if (this._filterExaminer.hasRank(axisRole) && !this.hasExplicitSort()) {
                if (this._filterExaminer.getRowColumnRankFilter() != null) {
                    List rankQualifiers = this._filterExaminer.getRowColumnRankFilter().getRankQualifiers();
                    this._sortCriteria = new AxisTupleCriteria(this._rolapBuilderInformation, rankQualifiers);
                } else if (this._filterExaminer.getSubtotalRankFilter() != null) {
                    this._sortCriteria = new AxisTupleCriteria(this._rolapBuilderInformation, Collections.singletonList(this._filterExaminer.getMeasureInRank()));
                }
            }
        }

        private List<DataItem> getNonTotalSortCategories() throws MetadataException, GenerationException {
            return this._sortCriteria == null ? Collections.emptyList() : this._sortCriteria.getCategoriesWithNonTotalValueCriteria();
        }

        private boolean isPureCategorySort() {
            return !this.isInnerMostCategoryMeasureSorted() && this.isOuterCategorySort();
        }

        private boolean isInnerMostCategoryMeasureSorted() {
            boolean measureSort = false;
            if (this.hasMeasureSort()) {
                boolean measureSortPrecedence;
                List<DataItem> categories = this.getCurrentAxisInformation().getCategoryDataItems();
                DataItem innerMostCategory = categories.isEmpty() ? null : categories.get(categories.size() - 1);
                measureSort = AxisSortingInfo.hasExplicitSortOrder(innerMostCategory) ? (measureSortPrecedence = this._dataSelection.getQueryProperty(BusinessQueryProperty.BUSINESS_QUERY_OLAP_SORT_PRECEDENCE)) : true;
            }
            return measureSort;
        }

        private static boolean hasExplicitSortOrder(DataItem category) {
            return !category.getSortDirection().equals(DataItemActionType.SORT_NONE);
        }

        private ROLAPBuilderInformation getRolapBuilderInformation() {
            return this._rolapBuilderInformation;
        }

        private ROLAPBuilderInformation.AxisInformation getCurrentAxisInformation() {
            return this._rolapBuilderInformation.getAxisInformation(this.getAxisIndex());
        }

        private ROLAPBuilderInformation.AxisInformation getOpposingAxisInformation() {
            int opposingAxisIndex = this._axisRole.equals(Role.COLUMN) ? 1 : 0;
            return this._rolapBuilderInformation.getAxisInformation(opposingAxisIndex);
        }

        private Role getAxisRole() {
            return this._axisRole;
        }

        private DataSelection getDataSelection() {
            return this._dataSelection;
        }

        private boolean isSortApplicable() {
            ROLAPBuilderInformation.AxisInformation axisInfo = this._rolapBuilderInformation.getAxisInformation(this.getAxisIndex());
            return axisInfo.getCategoryCount() > 0;
        }

        private int getAxisIndex() {
            return this._axisRole.equals(Role.COLUMN) ? 0 : 1;
        }

        private boolean hasExplicitCategorySort() {
            List<DataItem> categories = this.getCurrentAxisInformation().getCategoryDataItems();
            for (DataItem dataItem : categories) {
                DataItem category = dataItem;
                boolean hasExplicitSort = !category.getSortDirection().equals(DataItemActionType.SORT_NONE);
                if (!hasExplicitSort) continue;
                return true;
            }
            return false;
        }

        private boolean hasExplicitMeasureSort() {
            return this._hasExplicitMeasureSort;
        }

        private boolean hasExplicitSort() {
            return this.hasExplicitMeasureSort() || this.hasExplicitCategorySort();
        }

        private DataItem getSortingMeasure() {
            if (this._sortCriteria == null) {
                return null;
            }
            return this._sortCriteria.getMeasure();
        }

        private boolean hasMeasureSort() {
            return this.getSortingMeasure() != null;
        }

        private boolean isMeasureSortDescending() {
            boolean returnValue = false;
            if (this.hasExplicitMeasureSort()) {
                if (this._dataSelection.getSortDirection(this._axisRole).equals(BusinessQueryActionType.SORT_HIERARCHICAL_DESCENDING)) {
                    returnValue = true;
                }
            } else {
                returnValue = this._filterExaminer.isSortDescending();
            }
            return returnValue;
        }

        private List<String> getNonTotalSortCriteriaValues() {
            return this._sortCriteria == null ? Collections.emptyList() : this._sortCriteria.getNonTotalCriteriaValues();
        }

        private boolean isOuterCategorySort() {
            boolean measureSortPrecedence = this._dataSelection.getQueryProperty(BusinessQueryProperty.BUSINESS_QUERY_OLAP_SORT_PRECEDENCE);
            boolean performCategorySort = true;
            if (this.hasExplicitCategorySort()) {
                if (this.hasExplicitMeasureSort() && measureSortPrecedence) {
                    performCategorySort = false;
                }
            } else if (this.hasMeasureSort()) {
                performCategorySort = false;
            }
            return performCategorySort;
        }
    }
}

