/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.strategies.sas.oma.ExpandedProcSummaryStatement;
import com.sas.iquery.strategies.sas.oma.FractionOfTotalUtilImpl;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLColumnAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.ProcSQLDecorator;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ProcSummaryROLAPStatement;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPBuilderInformation;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPFilterAndRankExaminer;
import com.sas.iquery.strategies.sas.oma.summaryrolap.RolapDataSelectionProcessor;
import com.sas.iquery.strategies.sas.oma.summaryrolap.composite.SQLSASROLAPExpression;
import com.sas.iquery.strategies.sas.oma.summaryrolap.composite.SQLSASROLAPViewFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AggregationSubStep {
    public static void addCode(List<SQLComponentAbstract> compositeList, RolapDataSelectionProcessor dsProcessor, String detailTable, String tempSummaryTable, String finalSummaryTable, boolean ignoreDisabledTotals) throws GenerationException, MetadataException {
        DataSelection dataSelection = dsProcessor.getDataSelection();
        ROLAPBuilderInformation rolapInfo = new ROLAPBuilderInformation(dataSelection);
        List<DataItem> categoryItems = rolapInfo.getCategoryItems();
        List<DataItem> measureItems = rolapInfo.getMeasureItems();
        Map<String, Map<ExpressionInterface, String>> dataItemLeavesMap = dsProcessor.getDataItemLeavesMap();
        ArrayList<SQLColumnAbstract> sqlColumns = new ArrayList<SQLColumnAbstract>();
        boolean tempTableNeeded = false;
        ArrayList<DataItem> consolidationMeasures = new ArrayList<DataItem>();
        for (DataItem item : measureItems) {
            if (FractionOfTotalUtilImpl.isFractionOfTotalItem(item)) {
                Role role = dataSelection.getResultItemRole(item);
                boolean isNeededForPostProcess = dsProcessor.isNeededForPostProcess(dataSelection, item, role);
                if (isNeededForPostProcess) {
                    consolidationMeasures.add(item);
                    continue;
                }
                tempTableNeeded = true;
                continue;
            }
            consolidationMeasures.add(item);
        }
        DataSelection leafDataItemsDS = dsProcessor.getLeafDataItemsDataSelection();
        ROLAPBuilderInformation leafRolapInfo = new ROLAPBuilderInformation(leafDataItemsDS, dataItemLeavesMap);
        ROLAPFilterAndRankExaminer leafFilterExaminer = new ROLAPFilterAndRankExaminer(leafDataItemsDS);
        ProcSummaryROLAPStatement summary = new ProcSummaryROLAPStatement(leafDataItemsDS, leafRolapInfo, detailTable, tempSummaryTable, leafFilterExaminer);
        if (!tempTableNeeded) {
            boolean isColumnOrderPreserved;
            for (DataItem dataItem : consolidationMeasures) {
                DataItem item = dataItem;
                Function fn = item.getAggregationType();
                boolean procSummaryKeepingFormat = ExpandedProcSummaryStatement.isKeepingFormat(fn);
                if (!procSummaryKeepingFormat) {
                    tempTableNeeded = true;
                    break;
                }
                if (!item.isCalculatedItem() && !RolapDataSelectionProcessor.isPostAggregationCalculated(item)) continue;
                tempTableNeeded = true;
                break;
            }
            if (!tempTableNeeded && !(isColumnOrderPreserved = summary.isColumnOrderPreserved())) {
                tempTableNeeded = true;
            }
        }
        if (!tempTableNeeded) {
            summary.setSummaryTableName(finalSummaryTable);
        }
        summary.setDataSelectionProcessor(dsProcessor);
        summary.setSQLFactory(new SQLSASROLAPViewFactory(leafDataItemsDS));
        summary.setIgnoreDisabledTotals(ignoreDisabledTotals);
        summary.prepareSQL();
        compositeList.add(summary);
        SQLStatementFactory.addNewLine(compositeList);
        if (tempTableNeeded) {
            SQLStatementFactory.addStartProcSql(compositeList, dsProcessor, true, null);
            SQLStatementFactory.addStartSqlStatement(compositeList, dsProcessor);
            SQLStatementFactory.addCreateTableAs(compositeList, dsProcessor, finalSummaryTable);
            StringBuffer sql = AggregationSubStep.generateConsolodationQuery(dsProcessor, dataSelection, tempSummaryTable, categoryItems, dataItemLeavesMap, consolidationMeasures, sqlColumns);
            SQLStatementFactory.addText(compositeList, sql);
            SQLStatementFactory.addEndSqlStatement(compositeList, dsProcessor);
            SQLStatementFactory.addDropTableByName(compositeList, dsProcessor, tempSummaryTable);
            SQLStatementFactory.addEndProcSql(compositeList, dsProcessor);
        }
        if (dsProcessor.isTSSQL()) {
            ProcSQLDecorator tsSqlFixup = new ProcSQLDecorator(dataSelection, finalSummaryTable);
            tsSqlFixup.setSQLColumns(sqlColumns);
            tsSqlFixup.setDataSelectionProcessor(dsProcessor);
            tsSqlFixup.setSQLFactory(null);
            tsSqlFixup.prepareSQL();
            compositeList.add(tsSqlFixup);
        }
    }

    private static StringBuffer generateConsolodationQuery(RolapDataSelectionProcessor dsProcessor, DataSelection dataSelection, String tempSummaryTable, List<DataItem> categoryItems, Map<String, Map<ExpressionInterface, String>> dataItemLeavesMap, List<DataItem> consolidationMeasures, List<SQLColumnAbstract> sqlColumns) throws GenerationException {
        String identifier;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT");
        for (DataItem categoryItem : categoryItems) {
            String rsid = categoryItem.getResultSetID();
            identifier = dsProcessor.generateColumnIdentifier(rsid);
            sql.append("\n\t" + identifier + ",");
            sqlColumns.add(ProcSQLDecorator.newSQLDecoratorColumn(categoryItem));
        }
        sql.append("\n\t_TYPE_");
        SQLSASROLAPExpression expression = new SQLSASROLAPExpression();
        expression.setDataSelectionProcessor(dsProcessor);
        expression.setDataSelection(dataSelection);
        expression.setJoinGenerator(dsProcessor.getJoinGenerator());
        expression.setSQLFactory(new SQLSASROLAPViewFactory(dataSelection));
        Iterator<DataItem> iter = consolidationMeasures.iterator();
        while (iter.hasNext()) {
            DataItem measure = iter.next();
            sql.append(",\n\t");
            sqlColumns.add(ProcSQLDecorator.newSQLDecoratorColumn(measure));
            if (RolapDataSelectionProcessor.isPostAggregationCalculated(measure)) {
                Map<ExpressionInterface, String> aliasMap = dataItemLeavesMap.get(measure.getResultSetID());
                String column = expression.generateExpressionSQL(measure, 1, aliasMap);
                sql.append(column);
            } else {
                String format;
                String itemFormat;
                Function aggregationType;
                boolean procSummaryKeepingFormat;
                identifier = dsProcessor.generateColumnIdentifier(measure.getResultSetID());
                sql.append(identifier);
                if (!dsProcessor.isTSSQL() && !(procSummaryKeepingFormat = ExpandedProcSummaryStatement.isKeepingFormat(aggregationType = measure.getAggregationType())) && (itemFormat = measure.getFormat()) != null && itemFormat.trim().length() > 0 && (format = GenerationUtil.getSqlOutputFormat(measure)) != null && format.trim().length() > 0) {
                    sql.append(" Format=" + format);
                }
            }
            if (iter.hasNext()) continue;
            sql.append(" ");
        }
        sql.append("\nFROM " + tempSummaryTable);
        return sql;
    }
}

