/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryDataBasedFilter;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.NonCalculatedValue;
import com.sas.iquery.metadata.expr.olap.DataBasedFilterExpression;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import com.sas.iquery.strategies.sas.oma.summaryrolap.AggregationSubStep;
import com.sas.iquery.strategies.sas.oma.summaryrolap.AxisTupleCriteria;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPBuilderInformation;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPFilterAndRankExaminer;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPStepGenerationUtil;
import com.sas.iquery.strategies.sas.oma.summaryrolap.RolapDataSelectionProcessor;
import com.sas.iquery.strategies.sas.oma.summaryrolap.VisualTotalSubStep;
import com.sas.iquery.strategies.sas.oma.summaryrolap.composite.SQLSASROLAPExpression;
import com.sas.iquery.strategies.sas.oma.summaryrolap.composite.SQLSASROLAPViewFactory;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class AggregatedFilterStep {
    static final boolean allowTsSqlInAggregatedFilterStep = true;

    public static void addCode(List<SQLComponentAbstract> code, RolapDataSelectionProcessor dsProcessor, String detailTable, String tempTableStem) throws GenerationException, MetadataException {
        String aggrFilteredSummaryTable = tempTableStem + "AGGR_FILTERED_SUMMARY";
        String tempSummaryTable = tempTableStem + "AGGR_TMP";
        String filterTempTables = tempTableStem + "FILTERED";
        String catCombineTables = tempTableStem + "CAT_COMB";
        String catTupleTables = tempTableStem + "CAT_COMB_TUPLE";
        String vtTempTable = tempTableStem + "AGGR_vt";
        DataSelection dataSelection = dsProcessor.getDataSelection();
        ROLAPFilterAndRankExaminer filterExaminer = new ROLAPFilterAndRankExaminer(dataSelection);
        boolean hasPostAggregatedSubtotalFilters = filterExaminer.hasPostAggregatedSubtotalFilters();
        boolean hasPostAggregatedRowColumnFilters = filterExaminer.hasPostAggregatedRowColumnFilters();
        if (hasPostAggregatedSubtotalFilters || hasPostAggregatedRowColumnFilters) {
            boolean ignoreDisabledTotals;
            ROLAPBuilderInformation rolapInfo = new ROLAPBuilderInformation(dataSelection);
            if (hasPostAggregatedSubtotalFilters) {
                ignoreDisabledTotals = true;
                AggregationSubStep.addCode(code, dsProcessor, detailTable, tempSummaryTable, aggrFilteredSummaryTable, ignoreDisabledTotals);
                int tableIndex = 1;
                List filteredCategories = filterExaminer.getCategoriesFromSubtotalFilters();
                List<FilterItem> postAggregationCategoryFilters = filterExaminer.getPostAggregationSubtotalFilters();
                LinkedHashSet measureItems = new LinkedHashSet();
                ArrayList<SQLComponentAbstract> codeSegments = new ArrayList<SQLComponentAbstract>();
                Iterator iter = filteredCategories.iterator();
                while (iter.hasNext()) {
                    DataItem category;
                    List<DataItem> categoryHierarchy;
                    if (tableIndex > 1) {
                        SQLStatementFactory.addNewLine(codeSegments);
                    }
                    if ((categoryHierarchy = rolapInfo.getPartialCategoryHierarchyAbove(category = (DataItem)iter.next())).isEmpty()) {
                        MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("AggregatedFilterStep.generateFilteredData.NoFilteredCategoriesList.txt", new Object[0]);
                        throw new GenerationException(formatter);
                    }
                    int type = ROLAPStepGenerationUtil.getSumOfTotalTypeForCategories(categoryHierarchy, rolapInfo);
                    if (type != rolapInfo.getMaxTotalTypes()) {
                        AggregatedFilterStep.gatherMeasures(measureItems, postAggregationCategoryFilters, category);
                    }
                    String catCombineTableN = catCombineTables + tableIndex;
                    SQLStatementFactory.addStartSqlStatement(codeSegments, dsProcessor);
                    SQLStatementFactory.addCreateTableAs(codeSegments, dsProcessor, catCombineTableN);
                    StringBuffer generateDistinctCategoryQuery = AggregatedFilterStep.generateDistinctCategoryQuery(dsProcessor, aggrFilteredSummaryTable, category, categoryHierarchy, type, postAggregationCategoryFilters);
                    SQLStatementFactory.addText(codeSegments, generateDistinctCategoryQuery);
                    SQLStatementFactory.addEndSqlStatement(codeSegments, dsProcessor);
                    String filteredTableN = filterTempTables + tableIndex;
                    SQLStatementFactory.addNewLine(codeSegments);
                    SQLStatementFactory.addStartSqlStatement(codeSegments, dsProcessor);
                    SQLStatementFactory.addCreateTableAs(codeSegments, dsProcessor, filteredTableN);
                    StringBuffer generateFilteredDataQuery = AggregatedFilterStep.generateFilteredDataQuery(dsProcessor, detailTable, categoryHierarchy, catCombineTableN);
                    SQLStatementFactory.addText(codeSegments, generateFilteredDataQuery);
                    SQLStatementFactory.addEndSqlStatement(codeSegments, dsProcessor);
                    String filteredViewN = filterTempTables + tableIndex;
                    SQLStatementFactory.addDropViewByName(codeSegments, dsProcessor, detailTable);
                    SQLStatementFactory.addNewLine(codeSegments);
                    SQLStatementFactory.addStartSqlStatement(codeSegments, dsProcessor);
                    SQLStatementFactory.addCreateViewAs(codeSegments, dsProcessor, detailTable);
                    SQLStatementFactory.addText(codeSegments, "  select * from " + filteredViewN);
                    SQLStatementFactory.addEndSqlStatement(codeSegments, dsProcessor);
                    if (tableIndex > 1) {
                        String prevFilteredViewN = filterTempTables + (tableIndex - 1);
                        SQLStatementFactory.addDropTableByName(codeSegments, dsProcessor, prevFilteredViewN);
                    }
                    ++tableIndex;
                }
                VisualTotalSubStep.addCode(code, dsProcessor, rolapInfo, measureItems, aggrFilteredSummaryTable, vtTempTable, " for filtering by subtotals", true);
                if (codeSegments.size() > 0) {
                    SQLStatementFactory.addNewLine(code);
                    SQLStatementFactory.addStartProcSql(code, dsProcessor, true, null);
                    code.addAll(codeSegments);
                    SQLStatementFactory.addEndProcSql(code, dsProcessor);
                }
            }
            if (hasPostAggregatedRowColumnFilters) {
                ignoreDisabledTotals = true;
                AggregationSubStep.addCode(code, dsProcessor, detailTable, tempSummaryTable, aggrFilteredSummaryTable, ignoreDisabledTotals);
                ArrayList<SQLComponentAbstract> vtCalcCode = new ArrayList<SQLComponentAbstract>();
                ArrayList<SQLComponentAbstract> vtUpdateCode = new ArrayList<SQLComponentAbstract>();
                StringBuffer reasons = null;
                if (IQSystemProperties.isVerboseProcCommentsEnabled(AggregatedFilterStep.class)) {
                    reasons = new StringBuffer();
                }
                ArrayList<SQLComponentAbstract> codeSegments = new ArrayList<SQLComponentAbstract>();
                int tableIndex = 1;
                List postAggregationTupleFilters = filterExaminer.getPostAggregationRowColumnFilters();
                for (BusinessQueryDataBasedFilter filter : postAggregationTupleFilters) {
                    int type;
                    AxisTupleCriteria axisTupleCriteria = new AxisTupleCriteria(rolapInfo, filter.getLeftExpression());
                    DataItem filterMeasure = axisTupleCriteria.getMeasure();
                    List<Object> categoriesOnTheOtherAxis = new ArrayList();
                    DataSelection ds = rolapInfo.getDataSelection();
                    Role filterMeasureRole = ds.getResultItemRole(filterMeasure);
                    if (filterMeasureRole == Role.COLUMN || filterMeasureRole == Role.ROW) {
                        Role opposingRole = ROLAPBuilderInformation.getOpposingRole(filterMeasureRole);
                        categoriesOnTheOtherAxis = rolapInfo.getCategoriesOnAxis(opposingRole);
                    }
                    if (categoriesOnTheOtherAxis.isEmpty()) {
                        Iterator<DataItem> measures = rolapInfo.getMeasureItems().iterator();
                        while (measures.hasNext() && categoriesOnTheOtherAxis.isEmpty()) {
                            Role meaureRole;
                            DataItem measure = measures.next();
                            if (measure == filterMeasure || (meaureRole = ds.getResultItemRole(measure)) != Role.COLUMN && meaureRole != Role.ROW) continue;
                            Role opposingRole = ROLAPBuilderInformation.getOpposingRole(meaureRole);
                            categoriesOnTheOtherAxis = rolapInfo.getCategoriesOnAxis(opposingRole);
                        }
                        if (categoriesOnTheOtherAxis.isEmpty()) {
                            Role[] roles = new Role[]{Role.ROW, Role.COLUMN};
                            for (int i = 0; i < roles.length && categoriesOnTheOtherAxis.isEmpty(); ++i) {
                                Role checkRole = roles[i];
                                List<StepInterface> steps = ds.getSteps(checkRole);
                                if (!steps.contains(filter)) continue;
                                Role opposingRole = ROLAPBuilderInformation.getOpposingRole(checkRole);
                                categoriesOnTheOtherAxis = rolapInfo.getCategoriesOnAxis(opposingRole);
                            }
                        }
                    }
                    if (categoriesOnTheOtherAxis.isEmpty()) {
                        MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("AggregatedFilterStep.generateFilteredData.NoFilteredCategoriesList.txt", new Object[0]);
                        throw new GenerationException(formatter);
                    }
                    List<ExpressionInterface> filterList = filter.getLeftExpression();
                    int measureIndex = AxisTupleCriteria.findMeasure(filterList);
                    DataItem measure = null;
                    if (measureIndex >= 0) {
                        measure = (DataItem)filterList.get(measureIndex);
                        if (reasons != null) {
                            reasons.append("\n *   Tuple Filter: ").append(filter);
                        }
                        VisualTotalSubStep.addCode(vtCalcCode, vtUpdateCode, reasons, dsProcessor, rolapInfo, aggrFilteredSummaryTable, aggrFilteredSummaryTable, Collections.singletonList(measure), vtTempTable + tableIndex, true);
                    }
                    String catTupleTempTableN = catTupleTables + tableIndex;
                    SQLStatementFactory.addStartSqlStatement(codeSegments, dsProcessor);
                    SQLStatementFactory.addCreateTableAs(codeSegments, dsProcessor, catTupleTempTableN);
                    try {
                        type = axisTupleCriteria.makeRowColumnType();
                    }
                    catch (MetadataException e) {
                        throw new GenerationException(e);
                    }
                    StringBuffer distinctCategoryRowQuery = AggregatedFilterStep.generateDistinctCategoryRowQuery(dsProcessor, aggrFilteredSummaryTable, filter, axisTupleCriteria, type, categoriesOnTheOtherAxis);
                    SQLStatementFactory.addText(codeSegments, distinctCategoryRowQuery);
                    SQLStatementFactory.addEndSqlStatement(codeSegments, dsProcessor);
                    String filteredViewN = filterTempTables + tableIndex;
                    SQLStatementFactory.addStartSqlStatement(codeSegments, dsProcessor);
                    SQLStatementFactory.addCreateTableAs(codeSegments, dsProcessor, filteredViewN);
                    StringBuffer filteredDataQuery = AggregatedFilterStep.generateFilteredDataQuery(dsProcessor, detailTable, categoriesOnTheOtherAxis, catTupleTempTableN);
                    SQLStatementFactory.addText(codeSegments, filteredDataQuery);
                    SQLStatementFactory.addEndSqlStatement(codeSegments, dsProcessor);
                    SQLStatementFactory.addDropViewByName(codeSegments, dsProcessor, detailTable);
                    SQLStatementFactory.addNewLine(codeSegments);
                    SQLStatementFactory.addStartSqlStatement(codeSegments, dsProcessor);
                    SQLStatementFactory.addCreateViewAs(codeSegments, dsProcessor, detailTable);
                    SQLStatementFactory.addText(codeSegments, "  select * from " + filteredViewN);
                    SQLStatementFactory.addEndSqlStatement(codeSegments, dsProcessor);
                    if (tableIndex > 1) {
                        String prevFilteredViewN = filterTempTables + (tableIndex - 1);
                        SQLStatementFactory.addDropTableByName(codeSegments, dsProcessor, prevFilteredViewN);
                    }
                    ++tableIndex;
                }
                VisualTotalSubStep.addVtCode(code, aggrFilteredSummaryTable, reasons, vtCalcCode, vtUpdateCode, " for filtering by row/column totals");
                if (codeSegments.size() > 0) {
                    SQLStatementFactory.addNewLine(code);
                    SQLStatementFactory.addStartProcSql(code, dsProcessor, true, null);
                    code.addAll(codeSegments);
                    SQLStatementFactory.addEndProcSql(code, dsProcessor);
                }
            }
        }
    }

    private static void gatherMeasures(Set<? super DataItem> measureItems, List<FilterItem> postAggregationCategoryFilters, DataItem category) {
        for (FilterItem filterItem : postAggregationCategoryFilters) {
            if (filterItem == null) continue;
            List<DataBasedFilterExpression> dbfes = filterItem.getResources(DataBasedFilterExpression.class, 1);
            for (DataBasedFilterExpression dbfe : dbfes) {
                ExpressionInterface categoryInFilter = dbfe.getWhatToFilter();
                if (!category.equals(categoryInFilter)) continue;
                List<ExpressionInterface> filterCriteria = dbfe.getLeftExpression();
                int measureIndex = filterCriteria == null ? -1 : AxisTupleCriteria.findMeasure(filterCriteria);
                DataItem measureForFilter = null;
                if (measureIndex >= 0) {
                    measureForFilter = (DataItem)filterCriteria.get(measureIndex);
                }
                if (measureForFilter == null) continue;
                measureItems.add(measureForFilter);
            }
        }
    }

    private static StringBuffer generateDistinctCategoryQuery(RolapDataSelectionProcessor dsProcessor, String finalSummaryTable, DataItem category, List<DataItem> categoryHierarchy, int type, List<FilterItem> postAggregationCategoryFilters) throws GenerationException {
        StringBuffer sql = new StringBuffer();
        sql.append("  select distinct ");
        Iterator<BusinessItem> iter = categoryHierarchy.iterator();
        while (iter.hasNext()) {
            DataItem item = iter.next();
            String strAlias = dsProcessor.generateColumnIdentifier(item.getResultSetID());
            sql.append(strAlias);
            if (iter.hasNext()) {
                sql.append(",\n      ");
                continue;
            }
            sql.append("\n");
        }
        sql.append("    from ").append(finalSummaryTable).append("\n");
        sql.append("   where _type_=").append(type);
        for (FilterItem filter : postAggregationCategoryFilters) {
            List<DataBasedFilterExpression> dbfes = filter.getResources(DataBasedFilterExpression.class, 1);
            for (DataBasedFilterExpression dbfe : dbfes) {
                ExpressionInterface categoryInFilter = dbfe.getWhatToFilter();
                ComparisonOperator operator = dbfe.getComparisonOperator();
                if (!category.equals(categoryInFilter)) continue;
                sql.append("\n     and ");
                List<ExpressionInterface> filterCriteria = dbfe.getLeftExpression();
                int measureIndex = filterCriteria == null ? -1 : AxisTupleCriteria.findMeasure(filterCriteria);
                DataItem measureForFilter = null;
                if (measureIndex >= 0) {
                    measureForFilter = (DataItem)filterCriteria.get(measureIndex);
                }
                if (measureForFilter == null) {
                    throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("AggregatedFilterStep.generateFilterCodeForCategory.ExpectedDataItem.fmt.txt", filterCriteria));
                }
                List<ExpressionInterface> filterValues = dbfe.getRightExpression();
                if (filterValues == null || filterValues.size() != 1 || !(filterValues.get(0) instanceof ExpressionInterface)) {
                    throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("AggregatedFilterStep.generateFilterCodeForCategory.ExpectedStringOrConstant.fmt.txt", filterValues));
                }
                ExpressionInterface value = filterValues.get(0);
                HashMap<ExpressionInterface, String> aliasMap = new HashMap<ExpressionInterface, String>();
                SQLSASROLAPExpression expression = new SQLSASROLAPExpression();
                expression.setDataSelectionProcessor(dsProcessor);
                expression.setDataSelection(dsProcessor.getDataSelection());
                expression.setJoinGenerator(dsProcessor.getJoinGenerator());
                expression.setSQLFactory(new SQLSASROLAPViewFactory(dsProcessor.getDataSelection()));
                String sqlExpr = expression.generateExpressionSQL(value, 3, aliasMap);
                sql.append(dsProcessor.generateColumnIdentifier(measureForFilter.getResultSetID()));
                sql.append(operator.toString());
                sql.append(sqlExpr);
                sql.append(' ');
            }
        }
        return sql;
    }

    private static StringBuffer generateFilteredDataQuery(RolapDataSelectionProcessor dsProcessor, String detailTable, List<DataItem> categoriesOnTheOtherAxis, String catTupleTempTableN) throws GenerationException {
        StringBuffer sql = new StringBuffer();
        sql.append("  select data.*\n");
        sql.append("    from ").append(detailTable).append(" data\n");
        sql.append("   inner join ").append(catTupleTempTableN).append(" filter\n");
        sql.append("      on ");
        int i1 = 0;
        Iterator<DataItem> iter = categoriesOnTheOtherAxis.iterator();
        while (iter.hasNext()) {
            boolean useFormat;
            if (i1 > 0) {
                sql.append("\n     and ");
            }
            DataItem categoryWithFilter = iter.next();
            String categoryAlias = dsProcessor.generateColumnIdentifier(categoryWithFilter.getResultSetID());
            String format = GenerationUtil.generateFormat(categoryWithFilter);
            boolean bl = useFormat = format != null && format.trim().length() > 0 && !format.equals("$.");
            if (useFormat) {
                String putSqlLeft = GenerationUtil.generatePut(dsProcessor, "data." + categoryAlias, format);
                String putSqlRight = GenerationUtil.generatePut(dsProcessor, "filter." + categoryAlias, format);
                sql.append(putSqlLeft).append("=");
                sql.append(putSqlRight);
            } else {
                sql.append("data.").append(categoryAlias).append("=");
                sql.append("filter.").append(categoryAlias);
            }
            ++i1;
        }
        return sql;
    }

    private static StringBuffer generateDistinctCategoryRowQuery(RolapDataSelectionProcessor dsProcessor, String finalSummaryTable, BusinessQueryDataBasedFilter filter, AxisTupleCriteria axisTupleCriteria, int type, List<DataItem> categoriesOnTheOtherAxis) throws GenerationException {
        List<DataItem> categoriesOnCriteriaAxis;
        StringBuffer sql = new StringBuffer();
        sql.append("  select distinct ");
        Iterator<DataItem> iter = categoriesOnTheOtherAxis.iterator();
        while (iter.hasNext()) {
            DataItem category = iter.next();
            String strAlias = dsProcessor.generateColumnIdentifier(category.getResultSetID());
            sql.append(strAlias);
            if (iter.hasNext()) {
                sql.append(",\n\t");
                continue;
            }
            sql.append("\n");
        }
        sql.append("    from ").append(finalSummaryTable).append("\n");
        sql.append("   where _type_=").append(type);
        List<ExpressionInterface> filterList = filter.getLeftExpression();
        int measureIndex1 = AxisTupleCriteria.findMeasure(filterList);
        DataItem measure = null;
        if (measureIndex1 >= 0) {
            measure = (DataItem)filterList.get(measureIndex1);
        }
        List<String> tupleValueCriteria = axisTupleCriteria.getNonTotalCriteriaValues();
        try {
            categoriesOnCriteriaAxis = axisTupleCriteria.getCategoriesWithNonTotalValueCriteria();
        }
        catch (MetadataException e) {
            throw new GenerationException(e);
        }
        ArrayList<DataItem> outputCats = new ArrayList<DataItem>();
        ArrayList<String> outputValues = new ArrayList<String>();
        ROLAPStepGenerationUtil.getTupleCriteria(categoriesOnCriteriaAxis, tupleValueCriteria, outputCats, outputValues);
        ROLAPStepGenerationUtil.appendSqlTupleFilters(sql, dsProcessor, outputCats, outputValues);
        sql.append("\n     and ");
        NonCalculatedValue value = filter.getRightExpression().get(0);
        HashMap<ExpressionInterface, String> aliasMap = new HashMap<ExpressionInterface, String>();
        SQLSASROLAPExpression expression = new SQLSASROLAPExpression();
        expression.setDataSelectionProcessor(dsProcessor);
        expression.setDataSelection(dsProcessor.getDataSelection());
        expression.setJoinGenerator(dsProcessor.getJoinGenerator());
        expression.setSQLFactory(new SQLSASROLAPViewFactory(dsProcessor.getDataSelection()));
        String sqlText = expression.generateExpressionSQL((ExpressionInterface)((Object)value), 3, aliasMap);
        sql.append(dsProcessor.generateColumnIdentifier(measure.getResultSetID()));
        sql.append(filter.getOperator().toString());
        sql.append(sqlText);
        return sql;
    }
}

